/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.application;

import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.ServerTable;
import com.prosysopc.ua.stack.core.ApplicationDescription;
import com.prosysopc.ua.stack.core.SignedSoftwareCertificate;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.transport.https.HttpsSettings;
import com.prosysopc.ua.stack.transport.security.CertificateValidator;
import com.prosysopc.ua.stack.transport.security.KeyPair;
import com.prosysopc.ua.stack.transport.tcp.io.OpcTcpSettings;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import com.prosysopc.ua.stack.utils.StackUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Application {
    private static final Logger logger = LoggerFactory.getLogger(Application.class);
    ApplicationDescription N = new ApplicationDescription();
    List<KeyPair> op = new CopyOnWriteArrayList<KeyPair>();
    List<SignedSoftwareCertificate> oq = new CopyOnWriteArrayList<SignedSoftwareCertificate>();
    List<Locale> ji = new CopyOnWriteArrayList<Locale>();
    HttpsSettings eo = new HttpsSettings();
    OpcTcpSettings or = new OpcTcpSettings();
    private EncoderContext hB = new EncoderContext(new NamespaceTable(), new ServerTable(), StackUtils.getDefaultSerializer());

    public Application() {
        String string = "";
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.N.setApplicationUri("urn:" + string + ":" + UUID.randomUUID());
        this.getOpctcpSettings().setCertificateValidator(CertificateValidator.ALLOW_ALL);
        this.getHttpsSettings().setCertificateValidator(CertificateValidator.ALLOW_ALL);
    }

    public void addApplicationInstanceCertificate(KeyPair keyPair) {
        if (keyPair == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.op.add(keyPair);
    }

    public void addLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.ji.add(locale);
    }

    public void addSoftwareCertificate(SignedSoftwareCertificate signedSoftwareCertificate) {
        if (signedSoftwareCertificate == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.oq.add(signedSoftwareCertificate);
    }

    public ApplicationDescription getApplicationDescription() {
        return this.N;
    }

    public KeyPair getApplicationInstanceCertificate() {
        int n2 = this.op.size() - 1;
        if (n2 < 0) {
            return null;
        }
        return this.op.get(n2);
    }

    public KeyPair getApplicationInstanceCertificate(byte[] byArray) {
        logger.debug("getApplicationInstanceCertificate: expected={}", (Object)CryptoUtil.toHex(byArray));
        if (byArray != null) {
            int n2 = 0;
            for (KeyPair keyPair : this.op) {
                byte[] byArray2 = keyPair.getCertificate().getEncodedThumbprint();
                logger.debug("getApplicationInstanceCertificate: cert[{}]={}", (Object)n2++, (Object)CryptoUtil.toHex(byArray2));
                if (!Arrays.equals(byArray2, byArray)) continue;
                return keyPair;
            }
        }
        return null;
    }

    public KeyPair[] getApplicationInstanceCertificates() {
        return this.op.toArray(new KeyPair[this.op.size()]);
    }

    public String getApplicationUri() {
        return this.N.getApplicationUri();
    }

    public EncoderContext getEncoderContext() {
        return this.hB;
    }

    public HttpsSettings getHttpsSettings() {
        return this.eo;
    }

    public String[] getLocaleIds() {
        ArrayList<String> arrayList = new ArrayList<String>(this.ji.size());
        for (Locale locale : this.ji) {
            arrayList.add(LocalizedText.toLocaleId(locale));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Locale[] getLocales() {
        return this.ji.toArray(new Locale[0]);
    }

    public OpcTcpSettings getOpctcpSettings() {
        return this.or;
    }

    public String getProductUri() {
        return this.N.getProductUri();
    }

    public SignedSoftwareCertificate[] getSoftwareCertificates() {
        return this.oq.toArray(new SignedSoftwareCertificate[this.oq.size()]);
    }

    public void removeApplicationInstanceCertificate(KeyPair keyPair) {
        this.op.remove(keyPair);
    }

    public void removeApplicationInstanceCertificates() {
        this.op.clear();
    }

    public void removeLocale(Locale locale) {
        this.ji.remove(locale);
    }

    public void setApplicationName(LocalizedText localizedText) {
        this.N.setApplicationName(localizedText);
    }

    public void setApplicationUri(String string) {
        this.N.setApplicationUri(string);
    }

    public void setHttpsSettings(HttpsSettings httpsSettings) {
        this.eo = httpsSettings;
    }

    public void setOpctcpSettings(OpcTcpSettings opcTcpSettings) {
        this.or = opcTcpSettings;
    }

    public void setProductUri(String string) {
        this.N.setProductUri(string);
    }
}

