/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.nodes;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.nodes.UaReferenceType;
import com.prosysopc.ua.server.nodes.ServerNode;
import com.prosysopc.ua.server.nodes.UaExternalNode;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.core.Identifiers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UaServerReference
extends UaReference {
    private static Logger logger = LoggerFactory.getLogger(UaServerReference.class);
    private UaNode oj;
    private final NodeId referenceTypeId;
    private Boolean ok = null;
    private UaNode og = null;
    private UaNode oh = null;

    public static UaServerReference getReferenceInstance(NodeId nodeId, UaNode uaNode, UaNode uaNode2) {
        UaServerReference uaServerReference = UaServerReference.a(nodeId, uaNode, uaNode2);
        if (uaServerReference != null) {
            return uaServerReference;
        }
        return new UaServerReference(nodeId, uaNode, uaNode2);
    }

    public static UaServerReference getReferenceInstance(UaReferenceType uaReferenceType, UaNode uaNode, UaNode uaNode2) {
        UaServerReference uaServerReference = UaServerReference.a(uaReferenceType.getNodeId(), uaNode, uaNode2);
        if (uaServerReference != null) {
            return uaServerReference;
        }
        return new UaServerReference(uaReferenceType, uaNode, uaNode2);
    }

    private static UaServerReference a(NodeId nodeId, UaNode uaNode, UaNode uaNode2) {
        if (nodeId == null) {
            throw new NullPointerException("referenceTypeId");
        }
        if (uaNode == null) {
            throw new NullPointerException("sourceNode");
        }
        if (uaNode2 == null) {
            throw new NullPointerException("targetNode");
        }
        if (UaServerReference.b(nodeId, uaNode, uaNode2)) {
            return null;
        }
        UaReference[] uaReferenceArray = uaNode.getReferences(nodeId, false);
        if (uaReferenceArray != null) {
            for (UaReference uaReference : uaReferenceArray) {
                if (!uaReference.getTargetId().equals(uaNode2.getNodeId())) continue;
                return (UaServerReference)uaReference;
            }
        }
        return null;
    }

    private static boolean b(NodeId nodeId, UaNode uaNode, UaNode uaNode2) {
        if (Identifiers.HasProperty.equals(nodeId)) {
            return false;
        }
        if (!(uaNode instanceof ServerNode) || !(uaNode2 instanceof ServerNode)) {
            return false;
        }
        UaServerReference uaServerReference = new UaServerReference(nodeId, uaNode, uaNode2);
        ServerNode serverNode = (ServerNode)uaNode;
        return serverNode.oe && !serverNode.getReferenceList().contains(uaServerReference);
    }

    public UaServerReference(NodeId nodeId, UaNode uaNode, UaNode uaNode2) {
        if (nodeId == null) {
            throw new NullPointerException("referenceTypeId");
        }
        this.referenceTypeId = nodeId;
        this.o(uaNode2);
        this.n(uaNode);
    }

    public UaServerReference(UaReferenceType uaReferenceType, UaNode uaNode, UaNode uaNode2) {
        this(uaReferenceType.getNodeId(), uaNode, uaNode2);
        this.oj = uaReferenceType;
    }

    @Override
    public void delete() {
        this.og.deleteReference(this);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UaServerReference uaServerReference = (UaServerReference)object;
        if (this.oh == null ? uaServerReference.oh != null : this.oh != uaServerReference.oh) {
            return false;
        }
        if (this.og == null ? uaServerReference.og != null : this.og != uaServerReference.og) {
            return false;
        }
        return !(this.referenceTypeId == null ? uaServerReference.referenceTypeId != null : !this.referenceTypeId.equals(uaServerReference.referenceTypeId));
    }

    @Override
    public boolean getIsInverse(NodeId nodeId) {
        boolean bl;
        if (this.isSymmetric()) {
            return false;
        }
        boolean bl2 = bl = !this.og.getNodeId().equals(nodeId);
        if (bl && !this.oh.getNodeId().equals(nodeId)) {
            throw new IllegalArgumentException("getIsInverse: node is neither targetNode nor sourceNode");
        }
        return bl;
    }

    @Override
    public boolean getIsInverse(UaNode uaNode) {
        boolean bl;
        if (this.isSymmetric()) {
            return false;
        }
        boolean bl2 = bl = !this.og.getNodeId().equals(uaNode.getNodeId());
        if (bl && !this.oh.getNodeId().equals(uaNode.getNodeId())) {
            throw new IllegalArgumentException(String.format("getIsInverse: node (%s) is neither targetNode (%s) nor sourceNode (%s); referenceType=%s", uaNode.getNodeId(), this.getTargetId(), this.getSourceId(), this.getReferenceType().getBrowseName()));
        }
        return bl;
    }

    @Override
    public UaReferenceType getReferenceType() {
        if (this.oj == null) {
            try {
                ServerNode serverNode = null;
                if (this.og instanceof ServerNode) {
                    serverNode = (ServerNode)this.og;
                } else if (this.oh instanceof ServerNode) {
                    serverNode = (ServerNode)this.oh;
                }
                if (serverNode != null) {
                    this.oj = serverNode.getNodeManager().getNode(this.referenceTypeId);
                }
            }
            catch (StatusException statusException) {
                logger.debug("ReferenceType " + this.referenceTypeId + " could not be found");
                return null;
            }
        }
        if (this.oj instanceof UaReferenceType) {
            return (UaReferenceType)this.oj;
        }
        return null;
    }

    @Override
    public NodeId getReferenceTypeId() {
        return this.referenceTypeId;
    }

    @Override
    public ExpandedNodeId getSourceId() {
        return new ExpandedNodeId(this.og.getNodeId());
    }

    @Override
    public UaNode getSourceNode() {
        return this.og;
    }

    @Override
    public ExpandedNodeId getTargetId() {
        return new ExpandedNodeId(this.oh.getNodeId());
    }

    @Override
    public UaNode getTargetNode() {
        return this.oh;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.referenceTypeId == null ? 0 : this.referenceTypeId.hashCode());
        n3 = 31 * n3 + (this.oh == null ? 0 : this.oh.getNodeId().hashCode());
        n3 = 31 * n3 + (this.og == null ? 0 : this.og.getNodeId().hashCode());
        return n3;
    }

    public boolean isSymmetric() {
        this.ez();
        return this.ok != null && this.ok != false;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("");
        UaReferenceType uaReferenceType = this.getReferenceType();
        if (uaReferenceType != null) {
            stringBuilder.append(" ReferenceType=");
            stringBuilder.append(uaReferenceType.getBrowseName());
        }
        if (!(this.og instanceof UaExternalNode)) {
            stringBuilder.append(" SourceNode=");
            stringBuilder.append(this.og.getBrowseName());
        }
        if (!(this.oh instanceof UaExternalNode)) {
            stringBuilder.append(" TargetNode=");
            stringBuilder.append(this.oh.getBrowseName());
        }
        return super.toString() + stringBuilder.toString();
    }

    private void ez() {
        UaReferenceType uaReferenceType;
        if (this.ok == null && (uaReferenceType = this.getReferenceType()) != null) {
            this.ok = uaReferenceType.getSymmetric() != false ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
    }

    private void n(UaNode uaNode) {
        if (uaNode == null) {
            throw new NullPointerException("sourceNode");
        }
        this.og = uaNode;
    }

    private void o(UaNode uaNode) {
        if (uaNode == null) {
            throw new NullPointerException("targetNode");
        }
        this.oh = uaNode;
    }
}

