/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.nodes;

import com.prosysopc.ua.nodes.UaInstance;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.server.ModellingRule;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.nodes.BaseNode;
import com.prosysopc.ua.server.nodes.PlainMethod;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.Identifiers;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UaInstanceNode
extends BaseNode
implements UaInstance {
    private static final Logger logger = LoggerFactory.getLogger(UaInstanceNode.class);
    private volatile UaReference oi = null;

    public UaInstanceNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
        this.init();
    }

    public UaInstanceNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, String string, Locale locale) {
        super(nodeManagerUaNode, nodeId, string, locale);
        this.init();
    }

    public UaReference addModellingRule(ModellingRule modellingRule) {
        return this.addReference(modellingRule.getNodeId(), Identifiers.HasModellingRule, false);
    }

    @Override
    public UaType getTypeDefinition() {
        if (this.oi != null) {
            return (UaType)this.oi.getTargetNode();
        }
        return null;
    }

    @Override
    public ExpandedNodeId getTypeDefinitionId() {
        UaType uaType;
        ExpandedNodeId expandedNodeId = this.getDefaultTypeDefinition();
        if (this.supportsTypeDefinitionNode() && (uaType = this.getTypeDefinition()) != null) {
            expandedNodeId = new ExpandedNodeId(uaType.getNodeId());
        }
        return expandedNodeId;
    }

    @Override
    public boolean hasTypeDefinition() {
        return this.oi != null;
    }

    @Override
    public void setTypeDefinition(UaType uaType) {
        this.addReference((UaNode)uaType, Identifiers.HasTypeDefinition, false);
    }

    @Override
    public void setTypeDefinitionId(ExpandedNodeId expandedNodeId) {
        try {
            this.setTypeDefinitionId(this.nodeManager.getNamespaceTable().toNodeId(expandedNodeId));
        }
        catch (ServiceResultException serviceResultException) {
            throw new RuntimeException(serviceResultException);
        }
    }

    @Override
    public final void setTypeDefinitionId(NodeId nodeId) {
        if (this.supportsTypeDefinitionNode() && nodeId != null && !nodeId.isNullNodeId()) {
            this.setTypeDefinition((UaType)this.nodeManager.getNodeOrExternal(nodeId));
        } else {
            this.aL();
            this.oi = null;
        }
    }

    @Override
    public String toString() {
        if (!this.hasTypeDefinition()) {
            return super.toString();
        }
        return super.toString() + "; Type={" + this.getTypeDefinition() + "}";
    }

    private void init() {
        this.setTypeDefinitionId(this.getDefaultTypeDefinition());
    }

    private void aL() {
        if (this.oi != null) {
            this.deleteReference(this.oi);
            this.oi = null;
        }
    }

    @Override
    protected boolean beforeAddReference(UaReference uaReference) {
        if (uaReference.getReferenceTypeId().equals(Identifiers.HasTypeDefinition) && !uaReference.getIsInverse(this)) {
            if (!uaReference.equals(this.oi)) {
                if (this.oi != null) {
                    this.deleteReference(this.oi);
                }
                this.oi = uaReference;
            } else {
                return false;
            }
        }
        return super.beforeAddReference(uaReference);
    }

    protected abstract ExpandedNodeId getDefaultTypeDefinition();

    protected UaMethod registerOverridePlainMethod(String string) {
        UaType uaType = this.getTypeDefinition();
        String string2 = uaType == null ? "null" : uaType.getBrowseName().toString();
        logger.debug("createPlainMethod: name={} typeDefinition={}", (Object)string, (Object)string2);
        QualifiedName qualifiedName = UaInstanceNode.getStandardBrowseName(string);
        UaMethod uaMethod = null;
        if (uaType != null) {
            uaMethod = (UaMethod)uaType.getComponent(qualifiedName);
        }
        if (uaMethod == null) {
            logger.warn("Method {} not found from the type {}", (Object)string, (Object)string2);
            uaMethod = new PlainMethod(this.nodeManager, this.createNodeId(this, string), qualifiedName, UaInstanceNode.getStandardDisplayText(string));
        }
        return uaMethod;
    }

    protected boolean supportsTypeDefinitionNode() {
        return true;
    }
}

