/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.nodes;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.nodes.UaVariableNode;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.utils.ObjectUtils;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainVariable<T>
extends UaVariableNode {
    private static final StatusCode nP = new StatusCode(StatusCodes.Bad_WaitingForInitialData);
    private static Logger logger = LoggerFactory.getLogger(PlainVariable.class);
    private volatile T nV;
    private volatile DateTime nW;
    private volatile UnsignedShort nX = UnsignedShort.ZERO;
    private volatile DateTime nQ = INITIALIZATION_TIME;
    private volatile StatusCode status = nP;

    public PlainVariable(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    public PlainVariable(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, String string, Locale locale) {
        super(nodeManagerUaNode, nodeId, string, locale);
    }

    public final T getCurrentValue() {
        return this.nV;
    }

    public DateTime getServerTimestamp() {
        return this.nW;
    }

    public DateTime getSourceTimestamp() {
        return this.nQ;
    }

    @Override
    public StatusCode getStatus() {
        return this.status;
    }

    @Override
    public DataValue getValue() {
        DataValue dataValue = this.nV == null ? new DataValue(this.status) : new DataValue(new Variant(this.nV), this.status);
        dataValue.setServerTimestamp(this.nW);
        dataValue.setSourceTimestamp(this.nQ);
        dataValue.setSourcePicoseconds(this.nX);
        return dataValue;
    }

    public Class<?> getValueClass() {
        return this.nV.getClass();
    }

    public boolean setCurrentValue(T t) {
        return this.setCurrentValue(t, DateTime.currentTime());
    }

    public boolean setCurrentValue(T t, DateTime dateTime) {
        return this.setCurrentValue(t, StatusCode.GOOD, dateTime, null);
    }

    public boolean setCurrentValue(T t, StatusCode statusCode, DateTime dateTime, UnsignedShort unsignedShort) {
        boolean bl = !ObjectUtils.objectEquals(t, this.getCurrentValue());
        try {
            this.updateValue(t, statusCode, dateTime, unsignedShort);
            if (bl) {
                if (NodeId.isNull(this.getDataTypeId())) {
                    Structure[] structureArray;
                    Class<Structure[]> clazz;
                    DataValue dataValue;
                    if (t instanceof Structure) {
                        this.setDataTypeId(this.nodeManager.getNamespaceTable().toNodeId(((Structure)t).getTypeId()));
                    } else if (t.getClass().isArray() && !(dataValue = this.getValue()).isNull() && (clazz = dataValue.getValue().getCompositeClass()).isAssignableFrom(Structure[].class) && (structureArray = (Structure[])dataValue.getValue().getValue()).length > 0) {
                        this.setDataTypeId(this.nodeManager.getNamespaceTable().toNodeId(structureArray[0].getTypeId()));
                    }
                }
                if (this.getValueRank() == -2) {
                    if (t.getClass().isArray()) {
                        this.setArrayDimensions(new UnsignedInteger[]{UnsignedInteger.ZERO});
                        this.setValueRank(0);
                    } else {
                        this.setValueRank(-1);
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return bl;
    }

    @Override
    public void setStatus(StatusCode statusCode) {
        this.status = statusCode;
    }

    @Override
    protected void doSetValue(DataValue dataValue) throws StatusException {
        if (dataValue == null) {
            this.nV = null;
            this.nQ = null;
            this.nW = DateTime.currentTime();
        } else {
            this.nV = dataValue.isNull() ? null : dataValue.getValue().getValue();
            this.status = dataValue.getStatusCode();
            this.nQ = dataValue.getSourceTimestamp();
            this.nX = dataValue.getSourcePicoseconds();
            this.nW = dataValue.getServerTimestamp();
            if (this.nW == null) {
                this.nW = DateTime.currentTime();
            }
        }
    }

    @Override
    protected void updateValue(Object object, StatusCode statusCode, DateTime dateTime, UnsignedShort unsignedShort) throws StatusException {
        super.updateValue(object, statusCode, dateTime, unsignedShort);
    }
}

