/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.instantiation;

import com.prosysopc.ua.UaBrowsePath;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UaQualifiedName;
import com.prosysopc.ua.nodes.UaInstance;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.server.ModellingRule;
import com.prosysopc.ua.server.instantiation.DefaultInstantiationStrategy;
import com.prosysopc.ua.server.instantiation.InstanceDeclaration;
import com.prosysopc.ua.server.instantiation.InstantiationStrategy;
import com.prosysopc.ua.server.instantiation.UaNodeBuilderConfiguration;
import com.prosysopc.ua.stack.common.NamespaceTable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeDefinitionBasedNodeBuilderConfiguration
implements UaNodeBuilderConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(TypeDefinitionBasedNodeBuilderConfiguration.class);
    private final InstantiationStrategy nz;
    private final Map<UaBrowsePath, InstantiationStrategy> nA;
    private final Map<UaQualifiedName, InstantiationStrategy> nB;
    private final boolean nC;

    public static Builder builder() {
        return new Builder(new DefaultInstantiationStrategy(DefaultInstantiationStrategy.MethodInstantiationLogic.SHARED));
    }

    public static Builder builder(InstantiationStrategy instantiationStrategy) {
        return new Builder(instantiationStrategy);
    }

    public static Builder builder(DefaultInstantiationStrategy.MethodInstantiationLogic methodInstantiationLogic) {
        return new Builder(new DefaultInstantiationStrategy(methodInstantiationLogic));
    }

    private TypeDefinitionBasedNodeBuilderConfiguration(InstantiationStrategy instantiationStrategy, Map<UaBrowsePath, InstantiationStrategy> map, Map<UaQualifiedName, InstantiationStrategy> map2, boolean bl) {
        this.nz = instantiationStrategy;
        this.nA = map;
        this.nB = map2;
        this.nC = bl;
    }

    @Override
    public InstantiationStrategy getInstantiationStrategy(UaNodeBuilderConfiguration.InstantiationStrategySearchParameters instantiationStrategySearchParameters) {
        try {
            if (instantiationStrategySearchParameters.getHierarchy().length == 0) {
                return this.nz;
            }
            InstanceDeclaration[] instanceDeclarationArray = instantiationStrategySearchParameters.getHierarchy();
            UaNode uaNode = instanceDeclarationArray[instanceDeclarationArray.length - 1].getNode();
            logger.debug("Searching using TypeDefinition of node with id: {}, name:{}", (Object)uaNode.getNodeId(), (Object)uaNode.getBrowseName());
            if (uaNode instanceof UaInstance || uaNode instanceof UaType) {
                Object object;
                UaType uaType;
                InstantiationStrategy instantiationStrategy = null;
                NamespaceTable namespaceTable = uaType.getAddressSpace().getNamespaceTable();
                UaQualifiedName uaQualifiedName = UaQualifiedName.from(instantiationStrategySearchParameters.getInstanceDeclaration().getNode().getBrowseName(), namespaceTable);
                for (uaType = uaNode instanceof UaType ? (UaType)uaNode : ((UaInstance)uaNode).getTypeDefinition(); uaType != null && instantiationStrategy == null; uaType = uaType.getSuperType()) {
                    object = UaNodeId.fromLocal(uaType.getNodeId(), namespaceTable);
                    UaBrowsePath uaBrowsePath = UaBrowsePath.from((UaNodeId)object, uaQualifiedName);
                    instantiationStrategy = this.nA.get(uaBrowsePath);
                    if (instantiationStrategy != null) {
                        logger.debug("Found td/id: {}/{}, found: {}", new Object[]{uaType.getBrowseName(), uaQualifiedName.toQualifiedName(namespaceTable), instantiationStrategy});
                        continue;
                    }
                    logger.debug("Not found in/td/id: {}/({})/{}, searching again using super type of the typedefinition", new Object[]{uaNode.getBrowseName(), uaType.getBrowseName(), uaQualifiedName.toQualifiedName(namespaceTable)});
                }
                if (instantiationStrategy == null) {
                    object = UaQualifiedName.from(instantiationStrategySearchParameters.getInstanceDeclaration().getNode().getBrowseName(), namespaceTable);
                    instantiationStrategy = this.nB.get(object);
                }
                if (instantiationStrategy == null && ModellingRule.Mandatory == instantiationStrategySearchParameters.getInstanceDeclaration().getModellingRule()) {
                    instantiationStrategy = this.nz;
                }
                logger.debug("Returning strategy:{}", instantiationStrategy);
                if (instantiationStrategy != null) {
                    return instantiationStrategy;
                }
            }
            if (ModellingRule.Mandatory == instantiationStrategySearchParameters.getInstanceDeclaration().getModellingRule()) {
                return this.nz;
            }
            if (this.nC && !ModellingRule.MandatoryPlaceholder.equals(instantiationStrategySearchParameters.getInstanceDeclaration().getModellingRule()) && !ModellingRule.OptionalPlaceholder.equals(instantiationStrategySearchParameters.getInstanceDeclaration().getModellingRule())) {
                return this.nz;
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            logger.error("Error while searching InstantiationStrategy", (Throwable)runtimeException);
            throw runtimeException;
        }
    }

    public static class Builder {
        private final InstantiationStrategy nD;
        private final Map<UaBrowsePath, InstantiationStrategy> nE;
        private final Map<UaQualifiedName, InstantiationStrategy> nF;
        private boolean nC;

        private Builder(InstantiationStrategy instantiationStrategy) {
            this.nD = instantiationStrategy;
            this.nE = new HashMap<UaBrowsePath, InstantiationStrategy>();
            this.nF = new HashMap<UaQualifiedName, InstantiationStrategy>();
            this.nC = false;
        }

        public Builder addOptional(Collection<UaBrowsePath> collection) {
            this.addOptional(collection.toArray(new UaBrowsePath[collection.size()]));
            return this;
        }

        public Builder addOptional(UaBrowsePath ... uaBrowsePathArray) {
            if (uaBrowsePathArray != null) {
                for (UaBrowsePath uaBrowsePath : uaBrowsePathArray) {
                    this.nE.put(uaBrowsePath, this.nD);
                }
            }
            return this;
        }

        public Builder addOptional(UaQualifiedName uaQualifiedName) {
            this.nF.put(uaQualifiedName, this.nD);
            return this;
        }

        public TypeDefinitionBasedNodeBuilderConfiguration build() {
            HashMap<UaBrowsePath, InstantiationStrategy> hashMap = new HashMap<UaBrowsePath, InstantiationStrategy>();
            hashMap.putAll(this.nE);
            HashMap<UaQualifiedName, InstantiationStrategy> hashMap2 = new HashMap<UaQualifiedName, InstantiationStrategy>();
            hashMap2.putAll(this.nF);
            return new TypeDefinitionBasedNodeBuilderConfiguration(this.nD, hashMap, hashMap2, this.nC);
        }

        public Builder setInstantiateAllOptionals(boolean bl) {
            this.nC = bl;
            return this;
        }

        public Builder setInstantiationStrategy(UaBrowsePath uaBrowsePath, InstantiationStrategy instantiationStrategy) {
            this.nE.put(uaBrowsePath, instantiationStrategy);
            return this;
        }
    }
}

