/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.instantiation;

import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.instantiation.InstantiationParameters;
import com.prosysopc.ua.server.instantiation.InstantiationStrategy;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.types.opcua.server.TwoStateVariableTypeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwoStateVariableInstantiationStrategy
implements InstantiationStrategy {
    private static final Logger logger = LoggerFactory.getLogger(TwoStateVariableInstantiationStrategy.class);
    private final Boolean nw;
    private final String nx;
    private final String ny;

    public TwoStateVariableInstantiationStrategy(String string, String string2, boolean bl) {
        this.ny = string;
        this.nx = string2;
        this.nw = bl;
    }

    @Override
    public UaNode createInstance(InstantiationParameters instantiationParameters) {
        logger.debug("Creating TwoStateVariable");
        UaNode uaNode = instantiationParameters.getInstanceDeclaration().getNode();
        TwoStateVariableTypeNode twoStateVariableTypeNode = instantiationParameters.getNodeManager().createInstance(TwoStateVariableTypeNode.class, instantiationParameters.getNodeId(), uaNode.getBrowseName(), uaNode.getDisplayName());
        twoStateVariableTypeNode.setTrueState(this.ny, LocalizedText.NO_LOCALE);
        twoStateVariableTypeNode.setFalseState(this.nx, LocalizedText.NO_LOCALE);
        twoStateVariableTypeNode.setId(this.nw);
        return twoStateVariableTypeNode;
    }

    @Override
    public boolean createsCompleteHierarchy() {
        return true;
    }
}

