/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.ApplicationIdentity;
import com.prosysopc.ua.ModelException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.UaAddress;
import com.prosysopc.ua.UaApplication;
import com.prosysopc.ua.client.ServerConnectionException;
import com.prosysopc.ua.client.UaClient;
import com.prosysopc.ua.nodes.UaInstance;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaNodeFactoryException;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.nodes.UaValueNode;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.server.AttributeServiceHandler;
import com.prosysopc.ua.server.DiagnosticsManager;
import com.prosysopc.ua.server.NodeManagementServiceHandler;
import com.prosysopc.ua.server.NodeManager;
import com.prosysopc.ua.server.NodeManagerRoot;
import com.prosysopc.ua.server.NodeManagerTable;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.PubSubConfigurator;
import com.prosysopc.ua.server.ServerCodegenModel;
import com.prosysopc.ua.server.ServerCodegenModelProvider;
import com.prosysopc.ua.server.ServerUserIdentity;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.ServiceHandler;
import com.prosysopc.ua.server.Session;
import com.prosysopc.ua.server.SessionManager;
import com.prosysopc.ua.server.SessionManagerAdapter;
import com.prosysopc.ua.server.SessionManagerListener;
import com.prosysopc.ua.server.SessionServiceHandler;
import com.prosysopc.ua.server.SubscriptionManager;
import com.prosysopc.ua.server.SubscriptionServiceHandler;
import com.prosysopc.ua.server.UaServerException;
import com.prosysopc.ua.server.UaServerListener;
import com.prosysopc.ua.server.UserValidator;
import com.prosysopc.ua.server.io.IoManagerListener;
import com.prosysopc.ua.stack.application.Application;
import com.prosysopc.ua.stack.application.Server;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.ServiceFaultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.AccessLevelType;
import com.prosysopc.ua.stack.core.ApplicationDescription;
import com.prosysopc.ua.stack.core.AttributeWriteMask;
import com.prosysopc.ua.stack.core.EndpointConfiguration;
import com.prosysopc.ua.stack.core.EndpointDescription;
import com.prosysopc.ua.stack.core.FindServersRequest;
import com.prosysopc.ua.stack.core.FindServersResponse;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.MdnsDiscoveryConfiguration;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.NodeAttributes;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.stack.core.RegisterServer2Request;
import com.prosysopc.ua.stack.core.RegisterServerRequest;
import com.prosysopc.ua.stack.core.RegisteredServer;
import com.prosysopc.ua.stack.core.ResponseHeader;
import com.prosysopc.ua.stack.core.ServerCapability;
import com.prosysopc.ua.stack.core.ServerState;
import com.prosysopc.ua.stack.core.SignedSoftwareCertificate;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.TimestampsToReturn;
import com.prosysopc.ua.stack.core.UserIdentityToken;
import com.prosysopc.ua.stack.core.UserTokenPolicy;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.transport.Endpoint;
import com.prosysopc.ua.stack.transport.UriUtil;
import com.prosysopc.ua.stack.transport.endpoint.EndpointServiceRequest;
import com.prosysopc.ua.stack.transport.https.HttpsServer;
import com.prosysopc.ua.stack.transport.https.HttpsSettings;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.HttpsSecurityPolicy;
import com.prosysopc.ua.stack.transport.security.KeyPair;
import com.prosysopc.ua.stack.transport.security.SecurityMode;
import com.prosysopc.ua.stack.transport.tcp.nio.OpcTcpServer;
import com.prosysopc.ua.stack.utils.EndpointUtil;
import com.prosysopc.ua.stack.utils.NumericRange;
import com.prosysopc.ua.types.gds.server.GdsServerInformationModel;
import com.prosysopc.ua.types.opcua.SessionSecurityDiagnosticsType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.BaseVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.BuildInfoTypeNode;
import com.prosysopc.ua.types.opcua.server.FolderTypeNode;
import com.prosysopc.ua.types.opcua.server.ServerInformationModel;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class UaServer
extends UaApplication {
    private static final int lS = 3600;
    static Logger logger = LoggerFactory.getLogger(UaServer.class);
    private SecurityMode lT = SecurityMode.BASIC128RSA15_SIGN_ENCRYPT;
    private Set<InetAddress> lU = null;
    private final Map<UaApplication.Protocol, Set<InetAddress>> lV = new HashMap<UaApplication.Protocol, Set<InetAddress>>();
    private boolean lW = true;
    private final AtomicReference<DiscoveryServer> lX = new AtomicReference<Object>(null);
    private UaAddress lY = null;
    private long lZ = 10L;
    private boolean ma = true;
    private EndpointConfiguration em = Endpoint.createDefaultEndpointConfiguration();
    private List<EndpointDescription> mb;
    private boolean mc = true;
    private volatile boolean md = true;
    private final Set<String> me = new HashSet<String>();
    private HttpsSettings eo = new HttpsSettings();
    private int mf = 10;
    private boolean initialized = false;
    private final Map<UaApplication.Protocol, Integer> mg = new TreeMap<UaApplication.Protocol, Integer>();
    private final Set<com.prosysopc.ua.server.a> mh = new CopyOnWriteArraySet<com.prosysopc.ua.server.a>();
    private volatile boolean running;
    private final Server server = Server.createServerApplication();
    private String serverName = "";
    private final Map<UaApplication.Protocol, String> mi = new TreeMap<UaApplication.Protocol, String>();
    private boolean mj;
    private boolean mk = true;
    private boolean ml = true;
    private boolean mm = false;
    private final List<UserTokenPolicy> userTokenPolicies = new ArrayList<UserTokenPolicy>();
    private UserValidator mn;
    protected ApplicationIdentity applicationIdentity;
    protected ServiceHandler attributeServiceHandler;
    protected Set<String> discoveryUris;
    protected Set<String> httpsUris;
    protected UaServerListener listener;
    protected NodeManagerRoot nodeManagerRoot;
    protected NodeManagerTable nodeManagerTable;
    protected NodeManagerUaServer nodeManagerUaServer;
    protected NodeManagementServiceHandler nodeServiceHandler;
    protected Set<SecurityMode> httpsSecurityModes = new CopyOnWriteArraySet<SecurityMode>();
    protected Set<SecurityMode> securityModes = new CopyOnWriteArraySet<SecurityMode>();
    protected Set<String> serverUris;
    protected SessionManager sessionManager;
    protected ScheduledExecutorService executor;
    protected final SessionManagerListener sessionManagerListener = new SessionManagerAdapter(){

        @Override
        public boolean onActivateSession(Session session, ServerUserIdentity serverUserIdentity) throws StatusException {
            logger.debug("onActivateSession: userIdentity={}", (Object)serverUserIdentity);
            return UaServer.this.validateUserIdentity(session, serverUserIdentity);
        }

        @Override
        public void onActivateSessionError(Session session, UserIdentityToken userIdentityToken, Exception exception) {
            UaServer.this.validateUserError(session, userIdentityToken, exception);
        }

        @Override
        public void onAfterActivateSession(Session session) {
            logger.debug("onAfterActivateSession: session={} (doing nothing)", (Object)session);
        }

        @Override
        public void onCancelSession(Session session) {
            if (logger.isDebugEnabled()) {
                logger.debug("onCancelSession: session={} (doing nothing)", (Object)session);
            }
        }

        @Override
        public void onCloseSession(Session session, boolean bl) {
            logger.debug("onCloseSession: session={} deleteSubscriptions={} (doing nothing)", (Object)session, (Object)bl);
        }

        @Override
        public void onCreateSession(Session session) throws StatusException {
            StatusCode statusCode;
            logger.debug("onCreateSession: session={}", (Object)session);
            if (!session.getSecurityMode().getMessageSecurityMode().equals(MessageSecurityMode.None) && !(statusCode = UaServer.this.validateApplicationCertificate(session.getClientIdentity())).isGood()) {
                throw new StatusException(statusCode);
            }
        }
    };
    protected SessionServiceHandler sessionServiceHandler;
    protected SubscriptionManager subscriptionManager;
    protected SubscriptionServiceHandler subscriptionServiceHandler;
    a mo;
    Timer mp = null;
    protected DiagnosticsManager diagnosticsManager;
    private PubSubConfigurator mq;

    public static UnsignedByte getEndpointSecurityLevel(SecurityMode securityMode) {
        int n2 = (securityMode.getMessageSecurityMode().getValue() - 1) * 10;
        String string = securityMode.getSecurityPolicy().getPolicyUri();
        int n3 = 0;
        if (string.equals("http://opcfoundation.org/UA/SecurityPolicy#None") || string.equals("http://opcfoundation.org/UA-Profile/Securitypolicy/None")) {
            n3 = 0;
        } else if (string.equals("http://opcfoundation.org/UA/SecurityPolicy#Basic128Rsa15") || string.equals("http://opcfoundation.org/UA-Profile/Securitypolicy/Basic128Rsa15")) {
            n3 = 1;
        } else if (string.equals("http://opcfoundation.org/UA/SecurityPolicy#Basic256") || string.equals("http://opcfoundation.org/UA-Profile/Securitypolicy/Basic256")) {
            n3 = 2;
        } else if (string.equals("http://opcfoundation.org/UA/SecurityPolicy#Basic256Sha256")) {
            n3 = 4;
        } else if (string.equals("http://opcfoundation.org/UA/SecurityPolicy#Aes128_Sha256_RsaOaep")) {
            n3 = 3;
        } else if (string.equals("http://opcfoundation.org/UA/SecurityPolicy#Aes256_Sha256_RsaPss")) {
            n3 = 5;
        }
        if (n3 == 0) {
            return UnsignedByte.ZERO;
        }
        return UnsignedByte.valueOf(n2 + n3);
    }

    protected static RegisteredServer toRegisteredServer(String string, boolean bl, UaServer uaServer) {
        ApplicationDescription applicationDescription = uaServer.getApplicationIdentity().getApplicationDescription();
        logger.debug("toRegisteredServer: d={}", (Object)applicationDescription);
        RegisteredServer registeredServer = new RegisteredServer(applicationDescription.getApplicationUri(), applicationDescription.getProductUri(), new LocalizedText[]{applicationDescription.getApplicationName()}, applicationDescription.getApplicationType(), applicationDescription.getGatewayServerUri(), applicationDescription.getDiscoveryUrls(), string, bl);
        return registeredServer;
    }

    public UaServer() {
        this.registerModel(ServerInformationModel.MODEL);
        ArrayList<Class<? extends UaInstance>> arrayList = new ArrayList<Class<? extends UaInstance>>();
        arrayList.add(BaseVariableTypeNode.class);
        arrayList.add(BaseObjectTypeNode.class);
        this.registerClasses(arrayList);
    }

    public void addEndpoint(String string, SecurityMode securityMode, UserTokenPolicy ... userTokenPolicyArray) throws UaServerException {
        if (this.isRunning()) {
            throw new UaServerException("Cannot define endpoints when running");
        }
        UserTokenPolicy[] userTokenPolicyArray2 = userTokenPolicyArray.length > 0 ? userTokenPolicyArray : this.getUserTokenPolicies();
        this.mb.add(new EndpointDescription(string, this.getApplicationIdentity().getApplicationDescription(), ByteString.valueOf(this.getApplicationIdentity().getCertificate().getEncoded()), securityMode.getMessageSecurityMode(), securityMode.getSecurityPolicy().getPolicyUri(), userTokenPolicyArray2, null, UaServer.getEndpointSecurityLevel(securityMode)));
        if (logger.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder(" [");
            for (UserTokenPolicy userTokenPolicy : userTokenPolicyArray2) {
                stringBuilder.append(userTokenPolicy.getTokenType());
                stringBuilder.append(",");
            }
            stringBuilder.setCharAt(stringBuilder.length() - 1, ']');
            logger.debug("Endpoint added: {} {} {}", new Object[]{string, securityMode, stringBuilder});
        }
    }

    public String[] addEndpointHost(String string) throws UaServerException {
        int n2;
        int n3;
        String string2;
        if (this.serverUris == null) {
            throw new RuntimeException("Cannot call addEndpointHost() before UaServer.init() is called");
        }
        int n4 = this.getPort();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n4 > 0) {
            string2 = UaAddress.formatUri(UaApplication.Protocol.OpcTcp, string, n4, this.getServerName(UaApplication.Protocol.OpcTcp));
            this.serverUris.add(string2);
            arrayList.add(string2);
            if (this.initialized) {
                for (SecurityMode securityMode : this.securityModes) {
                    this.addEndpoint(string2, securityMode, this.getUserTokenPolicies());
                }
            }
            if (this.getServerName(UaApplication.Protocol.OpcTcp) != null) {
                this.discoveryUris.add(UaAddress.formatUri(UaApplication.Protocol.OpcTcp, string, n4, null));
            }
        }
        if ((n3 = this.getPort(UaApplication.Protocol.OpcHttps)) > 0) {
            string2 = UaAddress.formatUri(UaApplication.Protocol.OpcHttps, string, n3, this.getServerName(UaApplication.Protocol.OpcHttps));
            this.httpsUris.add(string2);
            arrayList.add(string2);
            if (this.initialized) {
                this.addEndpoint(string2, SecurityMode.NONE, this.getUserTokenPolicies());
            }
            if (this.getServerName(UaApplication.Protocol.OpcHttps) != null) {
                this.discoveryUris.add(UaAddress.formatUri(UaApplication.Protocol.OpcHttps, string, n3, null));
            }
        }
        if ((n2 = this.getPort(UaApplication.Protocol.Http)) > 0) {
            string2 = UaAddress.formatUri(UaApplication.Protocol.Http, string, n2, this.getServerName(UaApplication.Protocol.Http));
            this.httpsUris.add(string2);
            arrayList.add(string2);
            if (this.initialized) {
                this.addEndpoint(string2, SecurityMode.NONE, this.getUserTokenPolicies());
            }
            if (this.getServerName(UaApplication.Protocol.Http) != null) {
                this.discoveryUris.add(UaAddress.formatUri(UaApplication.Protocol.Http, string, n2, null));
            }
        }
        this.me.add(string);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void addLocale(Locale locale) throws UaServerException {
        this.j("Locales");
        this.server.getApplication().addLocale(locale);
    }

    public synchronized void addReverseConnection(String string, String string2) {
        com.prosysopc.ua.server.a a2 = new com.prosysopc.ua.server.a();
        a2.endpointUrl = string2;
        a2.iF = string;
        boolean bl = this.mh.add(a2);
        if (bl && this.isRunning()) {
            try {
                this.a(a2);
            }
            catch (UaServerException uaServerException) {
                throw new IllegalArgumentException("Could not add reverse connection", uaServerException);
            }
        }
    }

    public void addServiceHandler(Object object) {
        logger.debug("addServiceHandler {}: {}", (Object)this.server, object);
        this.server.addServiceHandler(object);
    }

    public void addToServerArray(String string) throws StatusException {
        this.getAddressSpace().getServerTable().add(-1, string);
        this.updateServerArray();
    }

    public void addUserTokenPolicy(UserTokenPolicy userTokenPolicy) throws UaServerException {
        this.j("UserTokenPolicies");
        if (!this.userTokenPolicies.contains(userTokenPolicy)) {
            this.userTokenPolicies.add(userTokenPolicy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.initialized) {
            try {
                if (this.running) {
                    this.shutdown(0, "");
                }
                this.dU();
                this.nodeManagerTable.close();
                this.server.close();
                logger.info("UaServer closed.");
            }
            finally {
                this.initialized = false;
            }
        }
    }

    @Override
    public NodeManagerTable getAddressSpace() {
        return this.nodeManagerTable;
    }

    public ApplicationIdentity getApplicationIdentity() {
        return this.applicationIdentity;
    }

    public ServiceHandler getAttributeServiceHandler() {
        return this.attributeServiceHandler;
    }

    public Set<InetAddress> getBindAddresses() {
        if (this.lU == null) {
            try {
                return EndpointUtil.getInetAddresses(this.isEnableIPv6());
            }
            catch (SocketException socketException) {
                logger.warn("Cannot initialize bindAddresses", (Throwable)socketException);
                return null;
            }
        }
        return this.lU;
    }

    public Set<InetAddress> getBindAddresses(UaApplication.Protocol protocol) {
        Set<InetAddress> set = this.lV.get((Object)protocol);
        if (set != null) {
            return set;
        }
        return this.getBindAddresses();
    }

    public DiagnosticsManager getDiagnosticsManager() {
        return this.diagnosticsManager;
    }

    public UaAddress getDiscoveryServerAddress() {
        return this.lY;
    }

    public long getDiscoveryServerRegistrationPeriod() {
        return this.lZ;
    }

    public SecurityMode getDiscoveryServerRegistrationSecurityMode() {
        return this.lT;
    }

    public String getDiscoveryServerUrl() {
        if (this.lY == null) {
            return "";
        }
        if (this.lY.getAddress() == null) {
            return "";
        }
        return this.lY.getAddress();
    }

    @Override
    public EncoderContext getEncoderContext() {
        return this.server.getEncoderContext();
    }

    public EndpointDescription getEndpoint(String string, SecurityMode securityMode) {
        for (EndpointDescription endpointDescription : this.mb) {
            if (!endpointDescription.getEndpointUrl().equals(string) || !endpointDescription.getSecurityMode().equals(securityMode.getMessageSecurityMode()) || !endpointDescription.getSecurityPolicyUri().equals(securityMode.getSecurityPolicy().getPolicyUri())) continue;
            return endpointDescription;
        }
        return null;
    }

    public EndpointConfiguration getEndpointConfiguration() {
        return this.em;
    }

    public EndpointDescription[] getEndpoints() {
        return this.server.getEndpointDescriptions();
    }

    public EndpointDescription[] getEndpoints(String string) {
        ArrayList<EndpointDescription> arrayList = new ArrayList<EndpointDescription>();
        for (EndpointDescription endpointDescription : this.getEndpoints()) {
            if (!endpointDescription.getEndpointUrl().equals(string)) continue;
            arrayList.add(endpointDescription);
        }
        return arrayList.toArray(new EndpointDescription[arrayList.size()]);
    }

    public String[] getHostNames() {
        if (this.me.isEmpty()) {
            try {
                this.getServerUris();
            }
            catch (UaServerException uaServerException) {
                // empty catch block
            }
        }
        return this.me.toArray(new String[this.me.size()]);
    }

    public Set<SecurityMode> getHttpsSecurityModes() {
        return this.httpsSecurityModes;
    }

    public HttpsSettings getHttpsSettings() {
        return this.eo;
    }

    public int getHttpsWorkerThreadCount() {
        return this.mf;
    }

    public UaServerListener getListener() {
        return this.listener;
    }

    public Locale[] getLocales() {
        return this.server.getApplication().getLocales();
    }

    public NodeManagementServiceHandler getNodeManagementServiceHandler() {
        return this.nodeServiceHandler;
    }

    public NodeManagerRoot getNodeManagerRoot() {
        return this.nodeManagerRoot;
    }

    @Deprecated
    public NodeManagerTable getNodeManagerTable() {
        return this.nodeManagerTable;
    }

    public NodeManagerUaServer getNodeManagerUaServer() {
        return this.nodeManagerUaServer;
    }

    public int getPort() {
        return this.getPort(UaApplication.Protocol.OpcTcp);
    }

    public int getPort(UaApplication.Protocol protocol) {
        if (this.mg.containsKey((Object)protocol)) {
            return this.mg.get((Object)protocol);
        }
        return 0;
    }

    public PubSubConfigurator getPubSubConfigurator() throws StatusException {
        PubSubConfigurator pubSubConfigurator = this.mq;
        if (pubSubConfigurator == null) {
            throw new StatusException(StatusCodes.Bad_NotSupported);
        }
        return pubSubConfigurator;
    }

    public Set<SecurityMode> getSecurityModes() {
        return this.securityModes;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerName(UaApplication.Protocol protocol) {
        if (this.mi.containsKey((Object)protocol)) {
            return this.mi.get((Object)protocol);
        }
        return this.getServerName();
    }

    public String[] getServerUris() throws UaServerException {
        if (this.serverUris == null) {
            this.serverUris = new HashSet<String>();
            this.discoveryUris = new HashSet<String>();
            this.httpsUris = new HashSet<String>();
            String string = ApplicationIdentity.getActualHostName();
            this.addEndpointHost(string);
            this.serverUris.addAll(this.httpsUris);
        }
        return this.serverUris.toArray(new String[this.serverUris.size()]);
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public SessionServiceHandler getSessionServiceHandler() {
        return this.sessionServiceHandler;
    }

    public SubscriptionManager getSubscriptionManager() {
        return this.subscriptionManager;
    }

    public SubscriptionServiceHandler getSubscriptionServiceHandler() {
        return this.subscriptionServiceHandler;
    }

    public UserTokenPolicy[] getUserTokenPolicies() {
        return this.userTokenPolicies.toArray(new UserTokenPolicy[this.userTokenPolicies.size()]);
    }

    public synchronized void init() throws UaServerException {
        if (!this.initialized) {
            if (this.applicationIdentity == null) {
                throw new NullPointerException("ApplicationIdentity must be defined before calling init or start");
            }
            this.dW();
            this.dZ();
            this.dY();
            this.ao();
            this.initServiceHandlers();
            this.dX();
            this.initServerArray();
            this.initAggregateFunctions();
            this.ee();
            this.registerServer(false);
            this.initialized = true;
            this.md = false;
        }
        if (this.executor == null) {
            this.executor = this.createExecutor();
        }
    }

    public boolean isDiscoveryEndpointEnabled() {
        return this.lW;
    }

    public boolean isEnableIPv6() {
        return this.ma;
    }

    public boolean isFailOnBindError() {
        return this.mc;
    }

    public boolean isRunning() {
        return this.running;
    }

    @Deprecated
    public boolean isUseAllIpAddresses() {
        return this.mj;
    }

    @Deprecated
    public boolean isUseCanonicalHostName() {
        return this.mk;
    }

    @Deprecated
    public boolean isUseHostName() {
        return this.ml;
    }

    @Deprecated
    public boolean isUseLocalhost() {
        return this.mm;
    }

    public void registerAndLoadModel(ServerCodegenModel serverCodegenModel, URI uRI) throws SAXException, IOException, ModelException, ServiceException {
        this.registerModelInternal(serverCodegenModel);
        this.getAddressSpace().loadModel(uRI);
    }

    public void registerModel(ServerCodegenModel serverCodegenModel) {
        this.registerModelInternal(serverCodegenModel);
    }

    public boolean registerServer(boolean bl) {
        if (this.isDiscoveryEndpointEnabled()) {
            this.getDiscoveryServer().registerServer(this, null, bl);
            if (!this.getDiscoveryServerUrl().isEmpty()) {
                try {
                    String string = bl ? "online" : "offline";
                    this.registerServer(this.getDiscoveryServerUrl(), bl);
                    logger.info("Registered server {} to DiscoveryServerUrl={}", (Object)string, (Object)this.getDiscoveryServerUrl());
                    if (this.listener != null) {
                        this.listener.onRegisterServer(this.getDiscoveryServerUrl(), bl);
                    }
                    return true;
                }
                catch (UaServerException uaServerException) {
                    this.logRegisterServerError(this.getDiscoveryServerUrl(), bl, uaServerException);
                }
            }
        }
        return false;
    }

    public void registerServer(String string, boolean bl) throws UaServerException {
        UaClient uaClient;
        if (!bl) {
            this.ed();
        }
        if (this.applicationIdentity.getCertificate().getCertificate() == null) {
            throw new UaServerException("Application Certificate not defined when calling registerServer");
        }
        RegisteredServer registeredServer = UaServer.toRegisteredServer(null, bl, this);
        try {
            uaClient = new UaClient(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UaServerException("Invalid URI", illegalArgumentException);
        }
        ApplicationIdentity applicationIdentity = this.getApplicationIdentity();
        uaClient.setApplicationIdentity(applicationIdentity);
        uaClient.setSecurityMode(this.getDiscoveryServerRegistrationSecurityMode());
        uaClient.setTimeout(10000L);
        String string2 = bl ? "online" : "offline";
        boolean bl2 = true;
        try {
            MdnsDiscoveryConfiguration mdnsDiscoveryConfiguration = new MdnsDiscoveryConfiguration(this.getApplicationIdentity().getApplicationDescription().getApplicationName().getText(), ServerCapability.getIdentifiers(ServerCapability.DA));
            ExtensionObject[] extensionObjectArray = new ExtensionObject[]{ExtensionObject.binaryEncode(mdnsDiscoveryConfiguration, this.getEncoderContext())};
            uaClient.sessionlessRequest(new RegisterServer2Request(null, registeredServer, extensionObjectArray));
            if (logger.isDebugEnabled()) {
                logger.debug("Registered server ({}) to Discovery Server at {} with RegisterServer2", (Object)string2, (Object)uaClient.getEndpoint().getEndpointUrl());
            }
            bl2 = false;
        }
        catch (ServerConnectionException serverConnectionException) {
            throw new UaServerException("Could not register server (" + string2 + ") to Discovery Server at " + this.getDiscoveryServerUrl(), serverConnectionException);
        }
        catch (ServiceException serviceException) {
            logger.debug("Failed to register server with RegisterServer2", (Throwable)serviceException);
        }
        catch (EncodingException encodingException) {
            logger.warn("Failed to encode DiscoveryConfiguration", (Throwable)encodingException);
        }
        if (bl2) {
            try {
                uaClient.sessionlessRequest(new RegisterServerRequest(null, registeredServer));
                if (logger.isDebugEnabled()) {
                    logger.debug("Registered server ({}) to Discovery Server at {} with RegisterServer", (Object)string2, (Object)uaClient.getEndpoint().getEndpointUrl());
                }
            }
            catch (ServerConnectionException serverConnectionException) {
                throw new UaServerException("Could not register server (" + string2 + ") to Discovery Server at " + this.getDiscoveryServerUrl(), serverConnectionException);
            }
            catch (ServiceException serviceException) {
                throw new UaServerException("Could not register server (" + string2 + ") to Discovery Server at " + this.getDiscoveryServerUrl(), serviceException);
            }
        }
    }

    public void removeEndpoint(String string, SecurityMode securityMode) {
        for (int i2 = this.mb.size() - 1; i2 >= 0; --i2) {
            EndpointDescription endpointDescription = this.mb.get(i2);
            if (!endpointDescription.getEndpointUrl().equals(string) || !endpointDescription.getSecurityMode().equals(securityMode.getMessageSecurityMode()) || !endpointDescription.getSecurityPolicyUri().equals(securityMode.getSecurityPolicy().getPolicyUri())) continue;
            this.mb.remove(i2);
        }
    }

    public void removeEndpointHost(String string) {
        ArrayList<EndpointDescription> arrayList = new ArrayList<EndpointDescription>();
        for (EndpointDescription endpointDescription : this.mb) {
            arrayList.add(endpointDescription);
        }
        for (EndpointDescription endpointDescription : arrayList) {
            if (!string.equals(endpointDescription.getEndpointUrl())) continue;
            this.mb.remove(endpointDescription);
        }
    }

    public void removeLocale(Locale locale) throws UaServerException {
        this.j("Locales");
        this.server.getApplication().removeLocale(locale);
    }

    public synchronized void removeReverseConnection(String string, String string2) {
        com.prosysopc.ua.server.a a2 = new com.prosysopc.ua.server.a();
        a2.endpointUrl = string2;
        a2.iF = string;
        this.mh.remove(a2);
    }

    public void removeUserTokenPolicy(UserTokenPolicy userTokenPolicy) throws UaServerException {
        this.j("UserTokenPolicies");
        this.userTokenPolicies.remove(userTokenPolicy);
    }

    public boolean requestServerStateChange(ServiceContext serviceContext, ServerState serverState, DateTime dateTime, UnsignedInteger unsignedInteger, LocalizedText localizedText, final Boolean bl) throws StatusException {
        final UaServerListener uaServerListener = this.getListener();
        if (uaServerListener == null) {
            return false;
        }
        if (bl.booleanValue() || serverState == ServerState.Shutdown) {
            int n2;
            int n3 = n2 = unsignedInteger.intValue() > 3600 ? 3600 : unsignedInteger.intValue();
            if (!uaServerListener.onShutdownRequest(serviceContext, n2, localizedText, bl)) {
                return false;
            }
            this.shutdownBegin(n2, localizedText);
            if (n2 > 0) {
                final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
                scheduledExecutorService.schedule(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            uaServerListener.onShutdown(UaServer.this, bl);
                            UaServer.this.shutdownEnd(true);
                        }
                        finally {
                            scheduledExecutorService.shutdown();
                        }
                    }
                }, (long)n2, TimeUnit.SECONDS);
            } else {
                uaServerListener.onShutdown(this, bl);
                this.shutdownEnd(true);
            }
            return true;
        }
        return false;
    }

    public void setApplicationIdentity(ApplicationIdentity applicationIdentity) {
        if (applicationIdentity == null) {
            throw new NullPointerException("identity must be defined");
        }
        if (applicationIdentity.getApplicationDescription() == null) {
            throw new IllegalArgumentException("identity's ApplicationDescription must be defined");
        }
        this.applicationIdentity = applicationIdentity;
    }

    public void setBindAddresses(UaApplication.Protocol protocol, Set<InetAddress> set) {
        this.lV.put(protocol, set);
        this.ea();
    }

    public void setBindAddresses(Set<InetAddress> set) {
        this.lU = set;
    }

    public void setDiscoveryEndpointEnabled(boolean bl) {
        this.lW = bl;
    }

    public void setDiscoveryServerAddress(UaAddress uaAddress) {
        this.lY = uaAddress;
    }

    public void setDiscoveryServerRegistrationPeriod(long l2) {
        this.lZ = l2;
    }

    public void setDiscoveryServerRegistrationSecurityMode(SecurityMode securityMode) {
        this.lT = securityMode;
    }

    public void setDiscoveryServerUrl(String string) throws URISyntaxException {
        this.lY = string == null || string.isEmpty() ? null : new UaAddress(string);
    }

    public void setEnableIPv6(boolean bl) {
        this.ma = bl;
    }

    public void setEndpointConfiguration(EndpointConfiguration endpointConfiguration) {
        this.em = endpointConfiguration != null ? endpointConfiguration : Endpoint.createDefaultEndpointConfiguration();
    }

    public void setFailOnBindError(boolean bl) {
        this.mc = bl;
    }

    public void setHttpsSecurityPolicies(HttpsSecurityPolicy ... httpsSecurityPolicyArray) throws UaServerException {
        this.k("HttpsSecurityPolicies");
        this.getHttpsSettings().setHttpsSecurityPolicies(httpsSecurityPolicyArray);
    }

    public void setHttpsSettings(HttpsSettings httpsSettings) {
        this.eo = httpsSettings;
    }

    public void setHttpsWorkerThreadCount(int n2) {
        this.mf = n2;
    }

    public void setListener(UaServerListener uaServerListener) {
        this.listener = uaServerListener;
    }

    public void setPort(int n2) throws UaServerException {
        this.setPort(UaApplication.Protocol.OpcTcp, n2);
    }

    public void setPort(UaApplication.Protocol protocol, int n2) throws UaServerException {
        this.k("Port");
        this.mg.put(protocol, n2);
        this.ea();
    }

    public void setPubSubConfigurator(PubSubConfigurator pubSubConfigurator) {
        this.mq = pubSubConfigurator;
    }

    @Deprecated
    public void setSecurityModes(SecurityMode[] securityModeArray) throws UaServerException {
        this.k("SecurityModes");
        this.securityModes.clear();
        this.securityModes.addAll(Arrays.asList(securityModeArray));
    }

    public void setServerName(UaApplication.Protocol protocol, String string) throws UaServerException {
        this.k("ServerName");
        if (string == null) {
            this.mi.remove((Object)protocol);
        } else {
            this.mi.put(protocol, string);
        }
        this.ea();
    }

    public void setServerName(String string) throws UaServerException {
        this.k("ServerName");
        this.serverName = string == null ? "" : string;
    }

    @Deprecated
    public void setUseAllIpAddresses(boolean bl) {
        this.mj = bl;
    }

    @Deprecated
    public void setUseCanonicalHostName(boolean bl) {
        this.mk = bl;
    }

    @Deprecated
    public void setUseHostName(boolean bl) {
        this.ml = bl;
    }

    @Deprecated
    public void setUseLocalhost(boolean bl) throws UaServerException {
        this.k("UseLocalhost");
        this.mm = bl;
    }

    public void setUserTokenPolicies(UserTokenPolicy ... userTokenPolicyArray) throws UaServerException {
        this.k("UserTokenPolicies");
        this.userTokenPolicies.clear();
        this.userTokenPolicies.addAll(Arrays.asList(userTokenPolicyArray));
    }

    public void setUserValidator(UserValidator userValidator) {
        this.mn = userValidator;
    }

    public void shutdown(int n2, LocalizedText localizedText) {
        this.shutdown(n2, localizedText, true);
    }

    public synchronized void shutdown(int n2, LocalizedText localizedText, boolean bl) {
        ScheduledExecutorService scheduledExecutorService;
        if (this.initialized) {
            this.shutdownBegin(n2, localizedText);
            this.shutdownSleep(n2);
            this.shutdownEnd(bl);
        }
        if ((scheduledExecutorService = this.executor) != null) {
            scheduledExecutorService.shutdownNow();
            this.executor = null;
        }
    }

    public void shutdown(int n2, String string) {
        this.shutdown(n2, new LocalizedText(string, LocalizedText.NO_LOCALE));
    }

    public void shutdown(int n2, String string, boolean bl) {
        this.shutdown(n2, new LocalizedText(string, LocalizedText.NO_LOCALE), bl);
    }

    public synchronized void start() throws UaServerException {
        if (!this.isRunning()) {
            this.init();
            this.running = true;
            try {
                this.ec();
                this.ef();
                this.dS();
                this.ee();
                this.registerServer(true);
                this.eb();
                this.dT();
            }
            catch (UaServerException uaServerException) {
                this.close();
                this.running = false;
                throw uaServerException;
            }
        }
    }

    private void b(String string, String string2) throws ServiceResultException {
        try {
            Endpoint endpoint;
            String string3 = this.getDiscoveryUriOf(string2);
            if (logger.isDebugEnabled()) {
                logger.debug("bindDiscoveryEndpoint: discoveryUriString={}", (Object)string3);
                logger.debug("bindDiscoveryEndpoint: discovery bindings={}", (Object)Arrays.toString(this.getDiscoveryServer().getBindings()));
                logger.debug("bindDiscoveryEndpoint: server bindings={}", (Object)Arrays.toString(this.server.getBindings()));
            }
            if ((endpoint = !this.getDiscoveryServer().hasEndpoint(string3) && !this.server.hasEndpoint(string3) ? new Endpoint(string3, SecurityMode.NONE) : this.getDiscoveryServer().getEndpointByUri(string3)) != null) {
                this.getDiscoveryServer().bind(string, endpoint);
                logger.debug("Discovery endpoint bound to {}", (Object)string);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    private void i(String string) throws UaServerException {
        if (!this.server.hasEndpoint(string)) {
            try {
                URI uRI;
                Object object;
                if (string.startsWith("opc.https")) {
                    object = this.server.getOrCreateHttpsServer();
                    ((HttpsServer)object).getHttpsSettings().readFrom(this.eo);
                    if (((HttpsServer)object).getWorkerThreadCount() != this.getHttpsWorkerThreadCount()) {
                        ((HttpsServer)object).setWorkerThreadCount(this.getHttpsWorkerThreadCount());
                    }
                }
                object = new Endpoint(string, string.startsWith("opc.https") ? this.httpsSecurityModes.toArray(SecurityMode.EMPTY_ARRAY) : this.securityModes.toArray(SecurityMode.EMPTY_ARRAY));
                ((Endpoint)object).setEndpointConfiguration(this.em);
                logger.info("Server endpoint: {}", object);
                try {
                    uRI = new URI(string);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new UaServerException("Invalid URI: " + string, uRISyntaxException);
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                Set<InetAddress> set = this.getBindAddresses(UaApplication.Protocol.parseProtocol(uRI.getScheme()));
                if (set == null) {
                    throw new UaServerException("BindAddresses not available.");
                }
                for (InetAddress inetAddress : set) {
                    Object object2;
                    if (!this.ma && inetAddress instanceof Inet6Address) continue;
                    String string2 = inetAddress instanceof Inet6Address ? "%s://[%s]:%d" : "%s://%s:%d";
                    int n2 = uRI.getPort();
                    if (n2 == -1) {
                        logger.debug("Cannot parse host using URI. Diverting to custom parser");
                        object2 = string.split("/+");
                        if (((String[])object2).length < 2) {
                            throw new UaServerException("Invalid URI: " + string);
                        }
                        String string3 = object2[0];
                        String[] stringArray = object2[1].split(":");
                        try {
                            n2 = Integer.parseInt(stringArray[1]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            n2 = UriUtil.defaultPort(string3);
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            n2 = UriUtil.defaultPort(string3);
                        }
                    }
                    object2 = String.format(string2, uRI.getScheme(), inetAddress.getHostAddress(), n2);
                    this.server.bind((String)object2, (Endpoint)object);
                    arrayList.add(inetAddress.getHostAddress() + ":" + n2);
                    if (this.isDiscoveryEndpointEnabled()) {
                        this.b((String)object2, string);
                        continue;
                    }
                    logger.debug("Skipping binding DiscoveryEndpoint because isDiscoveryEndpointEnabled is false");
                }
                logger.info("Endpoint bound to: {}", arrayList);
            }
            catch (ServiceResultException serviceResultException) {
                if (this.mc) {
                    this.server.close();
                    throw new UaServerException("Failed to initialize server endpoint: " + string, serviceResultException);
                }
                logger.error("Failed to initialize server endpoint: " + string, (Throwable)serviceResultException);
            }
        }
    }

    private void dS() throws UaServerException {
        for (EndpointDescription endpointDescription : this.mb) {
            String string = endpointDescription.getEndpointUrl();
            this.i(string);
        }
    }

    private void a(com.prosysopc.ua.server.a a2) throws UaServerException {
        try {
            this.server.bindReverse(a2.iF, a2.endpointUrl);
        }
        catch (Exception exception) {
            throw new UaServerException("Could not add a reverse connection binding", exception);
        }
    }

    private void dT() throws UaServerException {
        for (com.prosysopc.ua.server.a a2 : this.mh) {
            this.a(a2);
        }
    }

    private void j(String string) throws UaServerException {
        if (this.initialized) {
            throw new UaServerException(String.format("Cannot configure %s after the server is initialized.", string));
        }
    }

    private void k(String string) throws UaServerException {
        if (this.isRunning()) {
            throw new UaServerException(String.format("Cannot change %s when running", string));
        }
    }

    private void dU() {
        for (UserTokenPolicy userTokenPolicy : this.server.getUserTokenPolicies()) {
            this.server.removeUserTokenPolicy(userTokenPolicy);
        }
    }

    private String[] dV() {
        return this.serverUris.toArray(new String[0]);
    }

    private void dW() {
        if (!this.md) {
            return;
        }
        Application application = this.server.getApplication();
        application.setApplicationName(this.applicationIdentity.getApplicationDescription().getApplicationName());
        application.setApplicationUri(this.applicationIdentity.getApplicationDescription().getApplicationUri());
        application.setProductUri(this.applicationIdentity.getApplicationDescription().getProductUri());
        KeyPair[] keyPairArray = this.applicationIdentity.getCertificates();
        if (keyPairArray != null) {
            for (KeyPair object : keyPairArray) {
                application.addApplicationInstanceCertificate(object);
                logger.debug("certificateThumbPrint: {}", (Object)Arrays.toString(object.getCertificate().getEncodedThumbprint()));
            }
        } else {
            application.addApplicationInstanceCertificate(this.applicationIdentity.getKeys());
            logger.debug("certificateThumbPrint: {}", (Object)Arrays.toString(this.applicationIdentity.getKeys().getCertificate().getEncodedThumbprint()));
        }
        application.getHttpsSettings().setKeyPair(this.applicationIdentity.getHttpsCertificate(), new Cert[0]);
        application.getOpctcpSettings().setCertificateValidator(this.getCertificateValidator());
        for (SignedSoftwareCertificate signedSoftwareCertificate : this.applicationIdentity.getSoftwareCertificates()) {
            application.addSoftwareCertificate(signedSoftwareCertificate);
        }
    }

    private void dX() throws UaServerException {
        try {
            BuildInfoTypeNode buildInfoTypeNode = this.getNodeManagerRoot().getServerData().getServerStatusNode().getBuildInfoNode();
            if (buildInfoTypeNode.getProductUri() == null) {
                buildInfoTypeNode.setProductUri(this.getApplicationIdentity().getApplicationDescription().getProductUri());
            }
            if (buildInfoTypeNode.getProductName() == null) {
                buildInfoTypeNode.setProductName(this.getApplicationIdentity().getApplicationDescription().getApplicationName().getText());
            }
        }
        catch (StatusException statusException) {
            throw new UaServerException("Failed to initialize BuildInfo", statusException);
        }
    }

    private void dY() throws UaServerException {
        this.mb = new ArrayList<EndpointDescription>();
        logger.debug("initEndpoints: SecurityModes={} httpsSecurityPolicies={}", this.securityModes, (Object)Arrays.toString((Object[])this.getHttpsSecurityPolicies()));
        for (String string : this.getServerUris()) {
            logger.debug("uri: {}", (Object)string);
            Set<SecurityMode> set = string.startsWith("opc.https") ? this.httpsSecurityModes : this.securityModes;
            try {
                for (SecurityMode securityMode : set) {
                    this.addEndpoint(string, securityMode, this.getUserTokenPolicies());
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.server.close();
                throw new UaServerException("Failed to initialize server endpoint: " + string, illegalArgumentException);
            }
        }
    }

    private void ao() {
        this.registerModel(GdsServerInformationModel.MODEL);
        if (this.isAutoDiscoverCodegenModels()) {
            this.registerAutoDiscoveredModels(ServerCodegenModelProvider.class);
        }
    }

    private void dZ() throws UaServerException {
        if (this.userTokenPolicies.isEmpty()) {
            throw new UaServerException("No UserTokenPolicies defined");
        }
        this.dU();
        for (UserTokenPolicy userTokenPolicy : this.userTokenPolicies) {
            this.server.addUserTokenPolicy(userTokenPolicy);
        }
    }

    private void listenerError(String string, Object object, RuntimeException runtimeException) {
        logger.error("Exception while calling " + string + " on object " + object, (Throwable)runtimeException);
        throw runtimeException;
    }

    private void ea() {
        this.serverUris = null;
        this.me.clear();
    }

    private void eb() {
        long l2 = TimeUnit.MINUTES.toMillis(this.getDiscoveryServerRegistrationPeriod());
        if (this.mp == null && this.isDiscoveryEndpointEnabled() && !this.getDiscoveryServerUrl().isEmpty() && l2 > 0L) {
            this.mp = new Timer("DiscoveryRegistrationTimer");
            this.mo = new a(this.getDiscoveryServerUrl());
            this.mp.schedule((TimerTask)this.mo, l2, l2);
            logger.debug("discoveryRegistrationTimer scheduled: period={}", (Object)l2);
        }
    }

    private void ec() throws UaServerException {
        try {
            this.diagnosticsManager.start();
            this.sessionManager.start();
            this.subscriptionManager.start();
            this.nodeServiceHandler.start();
        }
        catch (StatusException statusException) {
            throw new UaServerException("Failed to start all managers", statusException);
        }
        catch (UaNodeFactoryException uaNodeFactoryException) {
            throw new UaServerException("Failed to start all managers", uaNodeFactoryException);
        }
    }

    private void ed() {
        if (this.mp != null) {
            this.mp.cancel();
            this.mp = null;
            logger.debug("discoveryRegistrationTimer canceled");
        }
    }

    private void ee() {
        String[] stringArray = this.dV();
        this.getApplicationIdentity().getApplicationDescription().setDiscoveryUrls(stringArray);
        this.getServer().getApplication().getApplicationDescription().setDiscoveryUrls(stringArray);
        if (logger.isDebugEnabled()) {
            logger.debug("updateApplicationDescription: applicationDescription={}", (Object)this.getApplicationIdentity().getApplicationDescription());
        }
    }

    private void ef() {
        this.getAddressSpace().getNodeManagerRoot().getServerData().getServerCapabilitiesNode().setFieldsFromEndpointConfiguration(this.em);
    }

    protected AttributeServiceHandler createAttributeServiceHandler() {
        return new AttributeServiceHandler(this.sessionManager, this.nodeManagerTable);
    }

    protected DiagnosticsManager createDiagnosticsManager() {
        DiagnosticsManager diagnosticsManager = new DiagnosticsManager(this);
        return diagnosticsManager;
    }

    protected ScheduledExecutorService createExecutor() {
        return Executors.newSingleThreadScheduledExecutor();
    }

    protected NodeManager createNewNodeManager(ServiceContext serviceContext, String string) throws StatusException {
        NodeManager nodeManager = null;
        if (this.getListener() != null) {
            nodeManager = this.getListener().onCreateNewNodeManager(serviceContext, string);
        }
        if (nodeManager == null) {
            nodeManager = new NodeManagerUaNode(this, string);
        }
        return nodeManager;
    }

    protected NodeManagementServiceHandler createNodeManagementServiceHandler() {
        return new NodeManagementServiceHandler(this.sessionManager, this.nodeManagerTable);
    }

    protected SessionManager createSessionManager() {
        SessionManager sessionManager = new SessionManager(this);
        return sessionManager;
    }

    protected SessionServiceHandler createSessionServiceHandler() {
        return new SessionServiceHandler(this.sessionManager);
    }

    protected SubscriptionManager createSubscriptionManager() {
        return new SubscriptionManager(this.sessionManager, this.nodeManagerTable);
    }

    protected SubscriptionServiceHandler createSubscriptionServiceHandler() {
        return new SubscriptionServiceHandler(this.subscriptionManager);
    }

    protected DiscoveryServer getDiscoveryServer() {
        DiscoveryServer discoveryServer = this.lX.get();
        if (discoveryServer != null) {
            return discoveryServer;
        }
        discoveryServer = new DiscoveryServer(this.server);
        try {
            this.server.getOrCreateOpcTcpServer().discoveryServer = discoveryServer;
        }
        catch (ServiceResultException serviceResultException) {
            logger.debug("Cannot assign discoveryServer");
        }
        this.lX.compareAndSet(null, discoveryServer);
        return this.lX.get();
    }

    protected String getDiscoveryUriOf(String string) throws URISyntaxException {
        URI uRI = new URI(string);
        String string2 = new URI(uRI.getScheme(), null, uRI.getHost(), uRI.getPort(), null, null, null).toString();
        return string2;
    }

    protected ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    protected int getHttpsPort() {
        return this.getPort(UaApplication.Protocol.OpcHttps);
    }

    protected HttpsSecurityPolicy[] getHttpsSecurityPolicies() {
        return this.getHttpsSettings().getHttpsSecurityPolicies();
    }

    protected Server getServer() {
        return this.server;
    }

    protected void initAggregateFunctions() {
        try {
            FolderTypeNode folderTypeNode = this.getNodeManagerRoot().getServerData().getServerCapabilitiesNode().getAggregateFunctionsNode();
            FolderTypeNode folderTypeNode2 = this.getAddressSpace().getNode(Identifiers.HistoryServerCapabilities_AggregateFunctions, FolderTypeNode.class);
            for (NodeId nodeId : this.getAggregateCalculator().getSupportedFunctions()) {
                folderTypeNode.addReference(nodeId, Identifiers.Organizes, false);
                folderTypeNode2.addReference(nodeId, Identifiers.Organizes, false);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not init AggregateFunctions", exception);
        }
    }

    protected void initServerArray() throws UaServerException {
        if (this.md) {
            try {
                this.addToServerArray(this.applicationIdentity.getApplicationDescription().getApplicationUri());
            }
            catch (StatusException statusException) {
                throw new UaServerException("Failed to add server to server array.", statusException);
            }
        }
        try {
            this.updateServerArray();
        }
        catch (StatusException statusException) {
            throw new UaServerException("Failed to initialize UaServer", statusException);
        }
    }

    protected void initServiceHandlers() throws UaServerException {
        if (!this.md) {
            try {
                this.nodeServiceHandler.init();
            }
            catch (UaNodeFactoryException uaNodeFactoryException) {
                throw new UaServerException("Failed to initialize UaServer", uaNodeFactoryException);
            }
            catch (StatusException statusException) {
                throw new UaServerException("Failed to initialize UaServer", statusException);
            }
            return;
        }
        if (this.isDiscoveryEndpointEnabled()) {
            this.addServiceHandler(this.getDiscoveryServer());
        }
        this.diagnosticsManager = this.createDiagnosticsManager();
        this.sessionManager = this.createSessionManager();
        this.sessionManager.addListener(this.sessionManagerListener);
        this.sessionServiceHandler = this.createSessionServiceHandler();
        this.addServiceHandler(this.sessionServiceHandler);
        this.nodeManagerTable = new NodeManagerTable(this);
        this.nodeManagerRoot = new NodeManagerRoot(this);
        this.nodeManagerTable.addNodeManager(0, this.nodeManagerRoot);
        this.nodeServiceHandler = this.createNodeManagementServiceHandler();
        this.addServiceHandler(this.nodeServiceHandler);
        this.attributeServiceHandler = this.createAttributeServiceHandler();
        this.addServiceHandler(this.attributeServiceHandler);
        this.subscriptionManager = this.createSubscriptionManager();
        this.subscriptionServiceHandler = this.createSubscriptionServiceHandler();
        this.addServiceHandler(this.subscriptionServiceHandler);
        this.nodeManagerUaServer = new NodeManagerUaServer(this, this.applicationIdentity.getApplicationDescription().getApplicationUri());
        try {
            this.nodeServiceHandler.init();
        }
        catch (StatusException statusException) {
            throw new UaServerException("Failed to initialize UaServer", statusException);
        }
        catch (UaNodeFactoryException uaNodeFactoryException) {
            throw new UaServerException("Failed to initialize UaServer", uaNodeFactoryException);
        }
    }

    protected void logRegisterServerError(String string, boolean bl, UaServerException uaServerException) {
        String string2 = uaServerException.getCause() == null ? "" : " Cause: " + uaServerException.getCause().getMessage();
        boolean bl2 = false;
        if (this.listener != null) {
            bl2 = this.listener.onRegisterServerError(string, bl, uaServerException);
        }
        if (!bl2) {
            logger.warn(uaServerException.getMessage() + string2);
        }
    }

    protected void setHttpsPort(int n2) throws UaServerException {
        this.setPort(UaApplication.Protocol.OpcHttps, n2);
    }

    protected void shutdownBegin(int n2, LocalizedText localizedText) {
        logger.info("Shutdown: Delay (s)={}; Reason={}", (Object)n2, (Object)localizedText);
        this.registerServer(false);
        this.getNodeManagerRoot().shutdown(n2, localizedText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownEnd(boolean bl) {
        try {
            if (this.subscriptionManager != null) {
                this.subscriptionManager.close();
            }
            this.sessionManager.close();
            this.diagnosticsManager.close();
        }
        finally {
            this.running = false;
        }
        if (bl) {
            this.close();
        }
    }

    protected void shutdownSleep(int n2) {
        logger.debug("Sleeping {} seconds", (Object)n2);
        try {
            Thread.sleep(n2 * 1000);
        }
        catch (InterruptedException interruptedException) {
            logger.debug("Shutdown interrupted", (Throwable)interruptedException);
        }
    }

    protected void updateNamespaceArray() {
        this.getNodeManagerRoot().getServerData().updateNamespaceArray();
    }

    protected void updateServerArray() throws StatusException {
        this.getNodeManagerRoot().getServerData().updateServerArray();
    }

    protected void validateUserError(Session session, UserIdentityToken userIdentityToken, Exception exception) {
        logger.debug("validateUserIdentity: userValidator={}", (Object)this.mn);
        if (this.mn != null) {
            try {
                this.mn.onValidationError(session, userIdentityToken, exception);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("userValidationError", this.mn, runtimeException);
            }
        }
    }

    protected boolean validateUserIdentity(Session session, ServerUserIdentity serverUserIdentity) throws StatusException {
        logger.debug("validateUserIdentity: userValidator={}", (Object)this.mn);
        if (this.mn != null) {
            try {
                return this.mn.onValidate(session, serverUserIdentity);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("validateUserIdentity", this.mn, runtimeException);
            }
        }
        return true;
    }

    private class a
    extends TimerTask {
        private final String discoveryUrl;

        public a(String string) {
            this.discoveryUrl = string;
        }

        @Override
        public void run() {
            long l2 = 5L;
            while (l2 > 0L && System.currentTimeMillis() - this.scheduledExecutionTime() < TimeUnit.MINUTES.toMillis(UaServer.this.getDiscoveryServerRegistrationPeriod())) {
                try {
                    UaServer.this.registerServer(this.discoveryUrl, true);
                    l2 = 0L;
                }
                catch (UaServerException uaServerException) {
                    try {
                        UaServer.this.logRegisterServerError(this.discoveryUrl, true, uaServerException);
                        logger.debug("Retrying to register server in {} seconds", (Object)l2);
                        long l3 = System.currentTimeMillis();
                        do {
                            TimeUnit.SECONDS.sleep(1L);
                        } while (UaServer.this.isRunning() && System.currentTimeMillis() - l3 < l2 * 1000L);
                        l2 = UaServer.this.isRunning() ? Math.min(2L * l2, TimeUnit.MINUTES.toSeconds(UaServer.this.getDiscoveryServerRegistrationPeriod())) : 0L;
                    }
                    catch (InterruptedException interruptedException) {
                        logger.debug("DiscoveryRegistrationTask interrupted");
                        l2 = 0L;
                    }
                }
            }
            logger.debug("DiscoveryRegistrationTask end");
        }
    }

    public class NodeManagerUaServer
    extends NodeManagerUaNode {
        private final IoManagerListener mx;

        public NodeManagerUaServer(UaServer uaServer2, String string) {
            super(uaServer2, string);
            this.mx = new IoManagerListener(){

                @Override
                public AccessLevelType onGetUserAccessLevel(ServiceContext serviceContext, NodeId nodeId, UaVariable uaVariable) {
                    if (uaVariable == null) {
                        return AccessLevelType.CurrentRead;
                    }
                    if (uaVariable instanceof SessionSecurityDiagnosticsType) {
                        return NodeManagerUaServer.this.getAccessLevelForSecurityDiagnostics(serviceContext);
                    }
                    UaReference uaReference = uaVariable.getReference(Identifiers.HasComponent, true);
                    if (uaReference == null) {
                        uaReference = uaVariable.getReference(Identifiers.HasProperty, true);
                    }
                    if (uaReference != null && uaReference.getSourceNode() instanceof SessionSecurityDiagnosticsType) {
                        return NodeManagerUaServer.this.getAccessLevelForSecurityDiagnostics(serviceContext);
                    }
                    return AccessLevelType.CurrentRead;
                }

                @Override
                public Boolean onGetUserExecutable(ServiceContext serviceContext, NodeId nodeId, UaMethod uaMethod) {
                    return false;
                }

                @Override
                public AttributeWriteMask onGetUserWriteMask(ServiceContext serviceContext, NodeId nodeId, UaNode uaNode) {
                    return AttributeWriteMask.of();
                }

                @Override
                public boolean onReadNonValue(ServiceContext serviceContext, NodeId nodeId, UaNode uaNode, UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
                    return false;
                }

                @Override
                public boolean onReadValue(ServiceContext serviceContext, NodeId nodeId, UaValueNode uaValueNode, NumericRange numericRange, TimestampsToReturn timestampsToReturn, DateTime dateTime, DataValue dataValue) throws StatusException {
                    return false;
                }

                @Override
                public boolean onWriteNonValue(ServiceContext serviceContext, NodeId nodeId, UaNode uaNode, UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
                    return false;
                }

                @Override
                public boolean onWriteValue(ServiceContext serviceContext, NodeId nodeId, UaValueNode uaValueNode, NumericRange numericRange, DataValue dataValue) throws StatusException {
                    return false;
                }
            };
            this.getIoManager().addListeners(this.mx);
        }

        @Override
        protected NodeId addNode(ServiceContext serviceContext, NodeId nodeId, NodeId nodeId2, QualifiedName qualifiedName, NodeClass nodeClass, ExpandedNodeId expandedNodeId, NodeAttributes nodeAttributes, NodeId nodeId3) throws StatusException {
            if (!serviceContext.isInternal()) {
                throw new StatusException(StatusCodes.Bad_UserAccessDenied);
            }
            return super.addNode(serviceContext, nodeId, nodeId2, qualifiedName, nodeClass, expandedNodeId, nodeAttributes, nodeId3);
        }

        @Override
        protected void addReference(ServiceContext serviceContext, NodeId nodeId, ExpandedNodeId expandedNodeId, NodeId nodeId2, boolean bl, NodeClass nodeClass, String string) throws StatusException {
            super.addReference(serviceContext, nodeId, expandedNodeId, nodeId2, bl, nodeClass, string);
        }

        @Override
        protected void deleteNode(ServiceContext serviceContext, NodeId nodeId, Boolean bl) throws StatusException {
            if (!serviceContext.isInternal()) {
                throw new StatusException(StatusCodes.Bad_UserAccessDenied);
            }
            super.deleteNode(serviceContext, nodeId, bl);
        }

        @Override
        protected void deleteReference(ServiceContext serviceContext, NodeId nodeId, ExpandedNodeId expandedNodeId, NodeId nodeId2, Boolean bl, Boolean bl2) throws StatusException {
            super.deleteReference(serviceContext, nodeId, expandedNodeId, nodeId2, bl, bl2);
        }

        protected AccessLevelType getAccessLevelForSecurityDiagnostics(ServiceContext serviceContext) {
            if (UaServer.this.listener != null && UaServer.this.listener.onAllowReadSecurityDiagnostics(serviceContext)) {
                return AccessLevelType.CurrentRead;
            }
            return AccessLevelType.of();
        }
    }

    public class DiscoveryServer
    extends Server {
        private final Logger logger;
        private final Map<String, RegisteredServer> mv;
        private final Server mw;

        public DiscoveryServer(Server server) {
            super(server.getApplication());
            this.logger = LoggerFactory.getLogger(DiscoveryServer.class);
            this.mv = new ConcurrentHashMap<String, RegisteredServer>(2, 1.0f, 2);
            this.mw = server;
            this.addServiceHandler(this);
        }

        @Override
        public synchronized HttpsServer getOrCreateHttpsServer() throws ServiceResultException {
            return this.mw.getOrCreateHttpsServer();
        }

        @Override
        public synchronized OpcTcpServer getOrCreateOpcTcpServer() throws ServiceResultException {
            return this.mw.getOrCreateOpcTcpServer();
        }

        public RegisteredServer[] getRegisteredServers() {
            return this.mv.values().toArray(new RegisteredServer[this.mv.size()]);
        }

        public final void onFindServers(EndpointServiceRequest<FindServersRequest, FindServersResponse> endpointServiceRequest) throws ServiceFaultException {
            this.logger.debug("onFindServers");
            FindServersResponse findServersResponse = new FindServersResponse();
            ArrayList<ApplicationDescription> arrayList = new ArrayList<ApplicationDescription>();
            FindServersRequest findServersRequest = endpointServiceRequest.getRequest();
            String string = findServersRequest.getEndpointUrl();
            this.logger.debug("endpointUrl={}", (Object)string);
            List<Object> list = findServersRequest.getServerUris() != null && findServersRequest.getServerUris().length != 0 ? Arrays.asList(findServersRequest.getServerUris()) : Collections.emptyList();
            List<Object> list2 = findServersRequest.getLocaleIds() != null && findServersRequest.getLocaleIds().length != 0 ? Arrays.asList(findServersRequest.getLocaleIds()) : Collections.emptyList();
            this.logger.debug("serverUris={}", list);
            this.logger.debug("registeredServers={}", this.mv.values());
            for (RegisteredServer registeredServer : this.mv.values()) {
                if (!registeredServer.getIsOnline().booleanValue() || !list.isEmpty() && !list.contains(registeredServer.getServerUri())) continue;
                List<LocalizedText> list3 = Arrays.asList(registeredServer.getServerNames());
                LocalizedText localizedText = list3.get(0);
                block1: for (String string2 : list2) {
                    for (LocalizedText localizedText2 : list3) {
                        if (!string2.equals(localizedText2.getLocale().getLanguage())) continue;
                        localizedText = localizedText2;
                        continue block1;
                    }
                }
                ArrayList arrayList2 = new ArrayList();
                if (string != null) {
                    for (String string3 : registeredServer.getDiscoveryUrls()) {
                        if (!string3.contains(string)) continue;
                        arrayList2.add(string3);
                    }
                }
                if (arrayList2.isEmpty()) {
                    for (String string3 : registeredServer.getDiscoveryUrls()) {
                        if (string3.contains("localhost")) continue;
                        arrayList2.add(string3);
                    }
                }
                arrayList.add(new ApplicationDescription(registeredServer.getServerUri(), registeredServer.getProductUri(), localizedText, registeredServer.getServerType(), registeredServer.getGatewayServerUri(), null, arrayList2.toArray(new String[arrayList2.size()])));
            }
            this.logger.debug("servers={}", arrayList);
            findServersResponse.setServers(arrayList.toArray(new ApplicationDescription[arrayList.size()]));
            ResponseHeader responseHeader = new ResponseHeader(DateTime.currentTime(), findServersRequest.getRequestHeader().getRequestHandle(), null, null, this.getApplication().getLocaleIds(), null);
            findServersResponse.setResponseHeader(responseHeader);
            endpointServiceRequest.sendResponse(findServersResponse);
        }

        public void registerServer(UaServer uaServer, String string, boolean bl) {
            boolean bl2 = this.eg();
            RegisteredServer registeredServer = UaServer.toRegisteredServer(string, bl, uaServer);
            this.mv.put(registeredServer.getServerUri(), registeredServer);
            this.logger.debug("registerServer: server={} isOnline={}", (Object)registeredServer, (Object)bl);
            if (bl2 && !this.eg()) {
                this.logger.debug("No Online Servers: closing the internal Discovery Server");
                this.close();
                UaServer.this.lX.set(null);
            }
        }

        private boolean eg() {
            for (RegisteredServer registeredServer : this.mv.values()) {
                if (!registeredServer.getIsOnline().booleanValue()) continue;
                return true;
            }
            return false;
        }
    }
}

