/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.SubscriptionBase;
import com.prosysopc.ua.server.MonitoredDataItem;
import com.prosysopc.ua.server.MonitoredItem;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.ServiceHandler;
import com.prosysopc.ua.server.Session;
import com.prosysopc.ua.server.SessionManagerAdapter;
import com.prosysopc.ua.server.SessionManagerListener;
import com.prosysopc.ua.server.Subscription;
import com.prosysopc.ua.server.SubscriptionManager;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.ServiceFaultException;
import com.prosysopc.ua.stack.core.CreateMonitoredItemsRequest;
import com.prosysopc.ua.stack.core.CreateMonitoredItemsResponse;
import com.prosysopc.ua.stack.core.CreateSubscriptionRequest;
import com.prosysopc.ua.stack.core.CreateSubscriptionResponse;
import com.prosysopc.ua.stack.core.DeleteMonitoredItemsRequest;
import com.prosysopc.ua.stack.core.DeleteMonitoredItemsResponse;
import com.prosysopc.ua.stack.core.DeleteSubscriptionsRequest;
import com.prosysopc.ua.stack.core.DeleteSubscriptionsResponse;
import com.prosysopc.ua.stack.core.ModifyMonitoredItemsRequest;
import com.prosysopc.ua.stack.core.ModifyMonitoredItemsResponse;
import com.prosysopc.ua.stack.core.ModifySubscriptionRequest;
import com.prosysopc.ua.stack.core.ModifySubscriptionResponse;
import com.prosysopc.ua.stack.core.MonitoredItemCreateRequest;
import com.prosysopc.ua.stack.core.MonitoredItemCreateResult;
import com.prosysopc.ua.stack.core.MonitoredItemModifyRequest;
import com.prosysopc.ua.stack.core.MonitoredItemModifyResult;
import com.prosysopc.ua.stack.core.MonitoringFilterResult;
import com.prosysopc.ua.stack.core.PublishRequest;
import com.prosysopc.ua.stack.core.PublishResponse;
import com.prosysopc.ua.stack.core.ReadValueId;
import com.prosysopc.ua.stack.core.RepublishRequest;
import com.prosysopc.ua.stack.core.RepublishResponse;
import com.prosysopc.ua.stack.core.RequestHeader;
import com.prosysopc.ua.stack.core.SetMonitoringModeRequest;
import com.prosysopc.ua.stack.core.SetMonitoringModeResponse;
import com.prosysopc.ua.stack.core.SetPublishingModeRequest;
import com.prosysopc.ua.stack.core.SetPublishingModeResponse;
import com.prosysopc.ua.stack.core.SetTriggeringRequest;
import com.prosysopc.ua.stack.core.SetTriggeringResponse;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.TimestampsToReturn;
import com.prosysopc.ua.stack.core.TransferResult;
import com.prosysopc.ua.stack.core.TransferSubscriptionsRequest;
import com.prosysopc.ua.stack.core.TransferSubscriptionsResponse;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.transport.endpoint.EndpointServiceRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionServiceHandler
extends ServiceHandler {
    private static Logger logger = LoggerFactory.getLogger(SubscriptionServiceHandler.class);
    private final ConcurrentHashMap<Session, LinkedBlockingQueue<a>> lK = new ConcurrentHashMap();
    private final ConcurrentHashMap<Session, Thread> lL = new ConcurrentHashMap();
    private final SessionManagerListener sessionManagerListener = new SessionManagerAdapter(){

        @Override
        public void onCloseSession(Session session, boolean bl) {
            logger.debug("sessionClose: session={}", (Object)session);
            LinkedBlockingQueue linkedBlockingQueue = (LinkedBlockingQueue)SubscriptionServiceHandler.this.lK.remove(session);
            if (linkedBlockingQueue != null) {
                linkedBlockingQueue.clear();
                linkedBlockingQueue.add(SubscriptionServiceHandler.this.lM);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("sessionClose: publishThreads={}", (Object)Arrays.toString(SubscriptionServiceHandler.this.lL.keySet().toArray(new Session[0])));
            }
            Thread thread = (Thread)SubscriptionServiceHandler.this.lL.remove(session);
            logger.debug("sessionClose: t={}", (Object)thread);
            if (thread != null) {
                thread.interrupt();
            }
        }
    };
    private final a lM = new a(null, null, null);
    private final SubscriptionManager subscriptionManager;

    public SubscriptionServiceHandler(SubscriptionManager subscriptionManager) {
        super(subscriptionManager.getSessionManager(), subscriptionManager.getNodeManagerTable());
        this.subscriptionManager = subscriptionManager;
        subscriptionManager.getSessionManager().addListener(this.sessionManagerListener);
    }

    public int getMaxMonitoredItemsPerCall() {
        return this.getOperationLimits().getMaxMonitoredItemsPerCall().intValue();
    }

    public final void onCreateMonitoredItems(EndpointServiceRequest<CreateMonitoredItemsRequest, CreateMonitoredItemsResponse> endpointServiceRequest) throws ServiceFaultException {
        CreateMonitoredItemsRequest createMonitoredItemsRequest = endpointServiceRequest.getRequest();
        CreateMonitoredItemsResponse createMonitoredItemsResponse = new CreateMonitoredItemsResponse();
        ServiceContext serviceContext = null;
        ArrayList<ReadValueId> arrayList = new ArrayList<ReadValueId>();
        ArrayList<MonitoredDataItem> arrayList2 = new ArrayList<MonitoredDataItem>();
        try {
            serviceContext = this.validateRequest(createMonitoredItemsRequest, endpointServiceRequest.getChannel());
            this.createMonitoredItems(serviceContext, createMonitoredItemsRequest, createMonitoredItemsResponse, arrayList, arrayList2);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException(createMonitoredItemsResponse, serviceException);
        }
        createMonitoredItemsResponse.setDiagnosticInfos(this.validateResponse(createMonitoredItemsRequest, createMonitoredItemsResponse, serviceContext, createMonitoredItemsResponse.getDiagnosticInfos()));
        endpointServiceRequest.sendResponse(createMonitoredItemsResponse);
    }

    public final void onCreateSubscription(EndpointServiceRequest<CreateSubscriptionRequest, CreateSubscriptionResponse> endpointServiceRequest) throws ServiceFaultException {
        CreateSubscriptionRequest createSubscriptionRequest = endpointServiceRequest.getRequest();
        CreateSubscriptionResponse createSubscriptionResponse = new CreateSubscriptionResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest(createSubscriptionRequest, endpointServiceRequest.getChannel());
            this.createSubscription(serviceContext, createSubscriptionRequest, createSubscriptionResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException(createSubscriptionResponse, serviceException);
        }
        this.validateResponse(createSubscriptionRequest, createSubscriptionResponse, serviceContext);
        endpointServiceRequest.sendResponse(createSubscriptionResponse);
    }

    public final void onDeleteMonitoredItems(EndpointServiceRequest<DeleteMonitoredItemsRequest, DeleteMonitoredItemsResponse> endpointServiceRequest) throws ServiceFaultException {
        DeleteMonitoredItemsRequest deleteMonitoredItemsRequest = endpointServiceRequest.getRequest();
        DeleteMonitoredItemsResponse deleteMonitoredItemsResponse = new DeleteMonitoredItemsResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest(deleteMonitoredItemsRequest, endpointServiceRequest.getChannel());
            this.deleteMonitoredItems(serviceContext, deleteMonitoredItemsRequest, deleteMonitoredItemsResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException(deleteMonitoredItemsResponse, serviceException);
        }
        deleteMonitoredItemsResponse.setDiagnosticInfos(this.validateResponse(deleteMonitoredItemsRequest, deleteMonitoredItemsResponse, serviceContext, deleteMonitoredItemsResponse.getDiagnosticInfos()));
        endpointServiceRequest.sendResponse(deleteMonitoredItemsResponse);
    }

    public final void onDeleteSubscriptions(EndpointServiceRequest<DeleteSubscriptionsRequest, DeleteSubscriptionsResponse> endpointServiceRequest) throws ServiceFaultException {
        DeleteSubscriptionsRequest deleteSubscriptionsRequest = endpointServiceRequest.getRequest();
        DeleteSubscriptionsResponse deleteSubscriptionsResponse = new DeleteSubscriptionsResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest(deleteSubscriptionsRequest, endpointServiceRequest.getChannel());
            this.deleteSubscriptions(serviceContext, deleteSubscriptionsRequest, deleteSubscriptionsResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException(deleteSubscriptionsResponse, serviceException);
        }
        deleteSubscriptionsResponse.setDiagnosticInfos(this.validateResponse(deleteSubscriptionsRequest, deleteSubscriptionsResponse, serviceContext, deleteSubscriptionsResponse.getDiagnosticInfos()));
        endpointServiceRequest.sendResponse(deleteSubscriptionsResponse);
    }

    public final void onModifyMonitoredItems(EndpointServiceRequest<ModifyMonitoredItemsRequest, ModifyMonitoredItemsResponse> endpointServiceRequest) throws ServiceFaultException {
        ModifyMonitoredItemsRequest modifyMonitoredItemsRequest = endpointServiceRequest.getRequest();
        ModifyMonitoredItemsResponse modifyMonitoredItemsResponse = new ModifyMonitoredItemsResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest(modifyMonitoredItemsRequest, endpointServiceRequest.getChannel());
            this.modifyMonitoredItems(serviceContext, modifyMonitoredItemsRequest, modifyMonitoredItemsResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException(modifyMonitoredItemsResponse, serviceException);
        }
        modifyMonitoredItemsResponse.setDiagnosticInfos(this.validateResponse(modifyMonitoredItemsRequest, modifyMonitoredItemsResponse, serviceContext, modifyMonitoredItemsResponse.getDiagnosticInfos()));
        endpointServiceRequest.sendResponse(modifyMonitoredItemsResponse);
    }

    public final void onModifySubscription(EndpointServiceRequest<ModifySubscriptionRequest, ModifySubscriptionResponse> endpointServiceRequest) throws ServiceFaultException {
        ModifySubscriptionRequest modifySubscriptionRequest = endpointServiceRequest.getRequest();
        ModifySubscriptionResponse modifySubscriptionResponse = new ModifySubscriptionResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest(modifySubscriptionRequest, endpointServiceRequest.getChannel());
            this.modifySubscription(serviceContext, modifySubscriptionRequest, modifySubscriptionResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException(modifySubscriptionResponse, serviceException);
        }
        this.validateResponse(modifySubscriptionRequest, modifySubscriptionResponse, serviceContext);
        endpointServiceRequest.sendResponse(modifySubscriptionResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onPublish(EndpointServiceRequest<PublishRequest, PublishResponse> endpointServiceRequest) throws ServiceFaultException {
        PublishRequest publishRequest = endpointServiceRequest.getRequest();
        ServiceContext serviceContext = null;
        try {
            logger.debug("onPublish");
            SubscriptionServiceHandler subscriptionServiceHandler = this;
            synchronized (subscriptionServiceHandler) {
                serviceContext = this.validateRequest(publishRequest, endpointServiceRequest.getChannel());
                this.a(endpointServiceRequest, serviceContext);
            }
        }
        catch (ServiceException serviceException) {
            PublishResponse publishResponse = new PublishResponse();
            this.handleServiceResultException(publishResponse, serviceException);
            publishResponse.setDiagnosticInfos(this.validateResponse(publishRequest, publishResponse, serviceContext, publishResponse.getDiagnosticInfos()));
            endpointServiceRequest.sendResponse(publishResponse);
        }
        logger.debug("onPublish: done");
    }

    public final void onRepublish(EndpointServiceRequest<RepublishRequest, RepublishResponse> endpointServiceRequest) throws ServiceFaultException {
        RepublishRequest republishRequest = endpointServiceRequest.getRequest();
        RepublishResponse republishResponse = new RepublishResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest(republishRequest, endpointServiceRequest.getChannel());
            this.subscriptionManager.republish(serviceContext, republishRequest, republishResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException(republishResponse, serviceException);
        }
        this.validateResponse(republishRequest, republishResponse, serviceContext);
        endpointServiceRequest.sendResponse(republishResponse);
    }

    public final void onSetMonitoringMode(EndpointServiceRequest<SetMonitoringModeRequest, SetMonitoringModeResponse> endpointServiceRequest) throws ServiceFaultException {
        SetMonitoringModeRequest setMonitoringModeRequest = endpointServiceRequest.getRequest();
        SetMonitoringModeResponse setMonitoringModeResponse = new SetMonitoringModeResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest(setMonitoringModeRequest, endpointServiceRequest.getChannel());
            this.setMonitoringMode(serviceContext, setMonitoringModeRequest, setMonitoringModeResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException(setMonitoringModeResponse, serviceException);
        }
        setMonitoringModeResponse.setDiagnosticInfos(this.validateResponse(setMonitoringModeRequest, setMonitoringModeResponse, serviceContext, setMonitoringModeResponse.getDiagnosticInfos()));
        endpointServiceRequest.sendResponse(setMonitoringModeResponse);
    }

    public final void onSetPublishingMode(EndpointServiceRequest<SetPublishingModeRequest, SetPublishingModeResponse> endpointServiceRequest) throws ServiceFaultException {
        SetPublishingModeRequest setPublishingModeRequest = endpointServiceRequest.getRequest();
        SetPublishingModeResponse setPublishingModeResponse = new SetPublishingModeResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest(setPublishingModeRequest, endpointServiceRequest.getChannel());
            this.setPublishingMode(serviceContext, setPublishingModeRequest, setPublishingModeResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException(setPublishingModeResponse, serviceException);
        }
        setPublishingModeResponse.setDiagnosticInfos(this.validateResponse(setPublishingModeRequest, setPublishingModeResponse, serviceContext, setPublishingModeResponse.getDiagnosticInfos()));
        endpointServiceRequest.sendResponse(setPublishingModeResponse);
    }

    public final void onSetTriggering(EndpointServiceRequest<SetTriggeringRequest, SetTriggeringResponse> endpointServiceRequest) throws ServiceFaultException {
        SetTriggeringRequest setTriggeringRequest = endpointServiceRequest.getRequest();
        SetTriggeringResponse setTriggeringResponse = new SetTriggeringResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest(setTriggeringRequest, endpointServiceRequest.getChannel());
            this.subscriptionManager.setTriggering(serviceContext, setTriggeringRequest, setTriggeringResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException(setTriggeringResponse, serviceException);
        }
        this.validateResponse(setTriggeringRequest, setTriggeringResponse, serviceContext);
        endpointServiceRequest.sendResponse(setTriggeringResponse);
    }

    public final void onTransferSubscriptions(EndpointServiceRequest<TransferSubscriptionsRequest, TransferSubscriptionsResponse> endpointServiceRequest) throws ServiceFaultException {
        TransferSubscriptionsRequest transferSubscriptionsRequest = endpointServiceRequest.getRequest();
        TransferSubscriptionsResponse transferSubscriptionsResponse = new TransferSubscriptionsResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest(transferSubscriptionsRequest, endpointServiceRequest.getChannel());
            this.transferSubscriptions(serviceContext, transferSubscriptionsRequest, transferSubscriptionsResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException(transferSubscriptionsResponse, serviceException);
        }
        transferSubscriptionsResponse.setDiagnosticInfos(this.validateResponse(transferSubscriptionsRequest, transferSubscriptionsResponse, serviceContext, transferSubscriptionsResponse.getDiagnosticInfos()));
        endpointServiceRequest.sendResponse(transferSubscriptionsResponse);
    }

    public void setMaxMonitoredItemsPerCall(int n2) {
        this.getOperationLimits().setMaxMonitoredItemsPerCall(UnsignedInteger.valueOf(n2));
    }

    private void a(EndpointServiceRequest<PublishRequest, PublishResponse> endpointServiceRequest, ServiceContext serviceContext) throws ServiceException {
        Object object;
        Session session = serviceContext.getSession();
        LinkedBlockingQueue<a> linkedBlockingQueue = this.lK.get(session);
        logger.debug("addToPublishRequestQueue: queue={}, MaxPublishRequestCount={}", linkedBlockingQueue, (Object)this.subscriptionManager.getMaxPublishRequestCount());
        if (linkedBlockingQueue == null && this.lK.putIfAbsent(session, linkedBlockingQueue = new LinkedBlockingQueue(this.subscriptionManager.getMaxPublishRequestCount())) == null) {
            object = new Thread(new b(session, linkedBlockingQueue));
            ((Thread)object).setName("PublishRequestQueue-" + session.getSessionName());
            ((Thread)object).start();
            if (logger.isDebugEnabled()) {
                logger.debug("addToPublishRequestQueue: thread={} session={}", (Object)((Thread)object).getName(), (Object)session);
            }
            this.lL.put(session, (Thread)object);
        }
        object = new PublishResponse();
        this.subscriptionManager.acknowledge(serviceContext, endpointServiceRequest.getRequest(), (PublishResponse)object);
        logger.debug("addToPublishRequestQueue: publishRequestQueue.size()={}, maxPublishRequestCount={}", (Object)linkedBlockingQueue.size(), (Object)this.subscriptionManager.getMaxPublishRequestCount());
        if (linkedBlockingQueue.size() >= this.subscriptionManager.getMaxPublishRequestCount() || !linkedBlockingQueue.offer(new a(serviceContext, endpointServiceRequest, (PublishResponse)object))) {
            throw new ServiceException(StatusCodes.Bad_TooManyPublishRequests);
        }
    }

    private void a(TimestampsToReturn timestampsToReturn) throws ServiceException {
        if (timestampsToReturn == null) {
            throw new ServiceException(StatusCodes.Bad_TimestampsToReturnInvalid);
        }
    }

    protected void createMonitoredItems(ServiceContext serviceContext, CreateMonitoredItemsRequest createMonitoredItemsRequest, CreateMonitoredItemsResponse createMonitoredItemsResponse, List<ReadValueId> list, List<MonitoredDataItem> list2) throws ServiceException {
        Object[] objectArray = createMonitoredItemsRequest.getItemsToCreate();
        this.checkRequestLength(objectArray, this.getMaxMonitoredItemsPerCall());
        Subscription subscription = this.subscriptionManager.getSubscription(createMonitoredItemsRequest.getSubscriptionId());
        TimestampsToReturn timestampsToReturn = createMonitoredItemsRequest.getTimestampsToReturn();
        this.a(timestampsToReturn);
        MonitoredItemCreateResult[] monitoredItemCreateResultArray = new MonitoredItemCreateResult[objectArray.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            try {
                monitoredItemCreateResultArray[i2] = new MonitoredItemCreateResult();
                this.validateEncoding(((MonitoredItemCreateRequest)objectArray[i2]).getItemToMonitor());
                MonitoredItem monitoredItem = this.subscriptionManager.createMonitoredItem(serviceContext, subscription, timestampsToReturn, (MonitoredItemCreateRequest)objectArray[i2]);
                monitoredItemCreateResultArray[i2].setRevisedQueueSize(UnsignedInteger.valueOf(monitoredItem.getQueueSize()));
                monitoredItemCreateResultArray[i2].setRevisedSamplingInterval(monitoredItem.getSamplingInterval());
                monitoredItemCreateResultArray[i2].setStatusCode(StatusCode.GOOD);
                monitoredItemCreateResultArray[i2].setMonitoredItemId(monitoredItem.getMonitoredItemId());
                MonitoringFilterResult monitoringFilterResult = monitoredItem.getFilterResult();
                if (monitoringFilterResult != null) {
                    monitoredItemCreateResultArray[i2].setFilterResult(ExtensionObject.binaryEncode(monitoringFilterResult, this.getEncoderContext()));
                }
                if (!(monitoredItem instanceof MonitoredDataItem)) continue;
                list.add(((MonitoredItemCreateRequest)objectArray[i2]).getItemToMonitor());
                list2.add((MonitoredDataItem)monitoredItem);
                continue;
            }
            catch (ServiceException serviceException) {
                logger.debug("ServiceException: ", (Throwable)serviceException);
                monitoredItemCreateResultArray[i2].setStatusCode(serviceException.getServiceResult());
                diagnosticInfoArray[i2] = serviceException.getDiagnosticInfo();
                continue;
            }
            catch (StatusException statusException) {
                logger.debug("StatusException: ", (Throwable)statusException);
                monitoredItemCreateResultArray[i2].setStatusCode(statusException.getStatusCode());
                diagnosticInfoArray[i2] = statusException.getDiagnosticInfo();
                continue;
            }
            catch (EncodingException encodingException) {
                monitoredItemCreateResultArray[i2].setStatusCode(encodingException.getStatusCode());
                diagnosticInfoArray[i2] = new DiagnosticInfo(encodingException.getMessage(), null, null, null, null, null, null);
            }
        }
        subscription.resetLastAliveTime();
        createMonitoredItemsResponse.setResults(monitoredItemCreateResultArray);
        createMonitoredItemsResponse.setDiagnosticInfos(diagnosticInfoArray);
    }

    protected void createSubscription(ServiceContext serviceContext, CreateSubscriptionRequest createSubscriptionRequest, CreateSubscriptionResponse createSubscriptionResponse) throws ServiceException {
        SubscriptionBase subscriptionBase = this.subscriptionManager.addSubscription(serviceContext, createSubscriptionRequest);
        createSubscriptionResponse.setSubscriptionId(subscriptionBase.getSubscriptionId());
        createSubscriptionResponse.setRevisedLifetimeCount(UnsignedInteger.valueOf(subscriptionBase.getLifetimeCount()));
        createSubscriptionResponse.setRevisedMaxKeepAliveCount(UnsignedInteger.valueOf(subscriptionBase.getMaxKeepAliveCount()));
        createSubscriptionResponse.setRevisedPublishingInterval(subscriptionBase.getPublishingInterval());
    }

    protected void deleteMonitoredItems(ServiceContext serviceContext, DeleteMonitoredItemsRequest deleteMonitoredItemsRequest, DeleteMonitoredItemsResponse deleteMonitoredItemsResponse) throws ServiceException {
        Subscription subscription = this.subscriptionManager.getSubscription(deleteMonitoredItemsRequest.getSubscriptionId());
        Object[] objectArray = deleteMonitoredItemsRequest.getMonitoredItemIds();
        this.checkRequestLength(objectArray, this.getMaxMonitoredItemsPerCall());
        StatusCode[] statusCodeArray = new StatusCode[objectArray.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            try {
                this.subscriptionManager.deleteMonitoredItem(serviceContext, subscription, (UnsignedInteger)objectArray[i2]);
                statusCodeArray[i2] = StatusCode.GOOD;
                continue;
            }
            catch (StatusException statusException) {
                logger.debug("StatusException: ", (Throwable)statusException);
                statusCodeArray[i2] = statusException.getStatusCode();
                diagnosticInfoArray[i2] = statusException.getDiagnosticInfo();
            }
        }
        subscription.resetLastAliveTime();
        deleteMonitoredItemsResponse.setResults(statusCodeArray);
        deleteMonitoredItemsResponse.setDiagnosticInfos(diagnosticInfoArray);
    }

    protected void deleteSubscriptions(ServiceContext serviceContext, DeleteSubscriptionsRequest deleteSubscriptionsRequest, DeleteSubscriptionsResponse deleteSubscriptionsResponse) throws ServiceException {
        logger.debug("deleteSubscriptions");
        Object[] objectArray = deleteSubscriptionsRequest.getSubscriptionIds();
        this.checkRequestLength(objectArray, this.getMaxMonitoredItemsPerCall());
        StatusCode[] statusCodeArray = new StatusCode[objectArray.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            try {
                Subscription subscription = this.subscriptionManager.getSubscription((UnsignedInteger)objectArray[i2]);
                this.subscriptionManager.removeSubscription(serviceContext, subscription, true);
                statusCodeArray[i2] = StatusCode.GOOD;
                continue;
            }
            catch (ServiceException serviceException) {
                logger.debug("ServiceException: ", (Throwable)serviceException);
                statusCodeArray[i2] = serviceException.getServiceResult();
                diagnosticInfoArray[i2] = serviceException.getDiagnosticInfo();
            }
        }
        deleteSubscriptionsResponse.setResults(statusCodeArray);
        deleteSubscriptionsResponse.setDiagnosticInfos(diagnosticInfoArray);
        if (logger.isDebugEnabled()) {
            logger.debug("deleteSubscriptions, remaining requests:{}", this.lK.get(serviceContext.getSession()));
            logger.debug("subscriptions left in session:{}", (Object)serviceContext.getSession().getSubscriptionCount());
        }
        if (serviceContext.getSession().getSubscriptionCount() == 0) {
            Thread thread = this.lL.get(serviceContext.getSession());
            if (thread != null) {
                thread.interrupt();
                logger.debug("Interrupted publishThread");
            } else {
                logger.debug("Could not interrupt publishThread, it is null");
            }
        }
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    protected void modifyMonitoredItems(ServiceContext serviceContext, ModifyMonitoredItemsRequest modifyMonitoredItemsRequest, ModifyMonitoredItemsResponse modifyMonitoredItemsResponse) throws ServiceException {
        Subscription subscription = this.subscriptionManager.getSubscription(modifyMonitoredItemsRequest.getSubscriptionId());
        Object[] objectArray = modifyMonitoredItemsRequest.getItemsToModify();
        this.checkRequestLength(objectArray, this.getMaxMonitoredItemsPerCall());
        this.a(modifyMonitoredItemsRequest.getTimestampsToReturn());
        MonitoredItemModifyResult[] monitoredItemModifyResultArray = new MonitoredItemModifyResult[objectArray.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            try {
                monitoredItemModifyResultArray[i2] = new MonitoredItemModifyResult();
                MonitoredItem monitoredItem = this.subscriptionManager.modifyMonitoredItem(serviceContext, subscription, (MonitoredItemModifyRequest)objectArray[i2], modifyMonitoredItemsRequest.getTimestampsToReturn(), ((MonitoredItemModifyRequest)objectArray[i2]).getRequestedParameters());
                monitoredItemModifyResultArray[i2].setStatusCode(StatusCode.GOOD);
                monitoredItemModifyResultArray[i2].setRevisedQueueSize(UnsignedInteger.valueOf(monitoredItem.getQueueSize()));
                monitoredItemModifyResultArray[i2].setRevisedSamplingInterval(monitoredItem.getSamplingInterval());
                if (monitoredItem.getFilterResult() == null) continue;
                MonitoringFilterResult monitoringFilterResult = monitoredItem.getFilterResult();
                monitoredItemModifyResultArray[i2].setFilterResult(ExtensionObject.binaryEncode(monitoredItem.getFilterResult(), this.getEncoderContext()));
                continue;
            }
            catch (StatusException statusException) {
                logger.debug("StatusException: ", (Throwable)statusException);
                monitoredItemModifyResultArray[i2].setStatusCode(statusException.getStatusCode());
                diagnosticInfoArray[i2] = statusException.getDiagnosticInfo();
                continue;
            }
            catch (EncodingException encodingException) {
                monitoredItemModifyResultArray[i2].setStatusCode(encodingException.getStatusCode());
                diagnosticInfoArray[i2] = new DiagnosticInfo(encodingException.getMessage(), null, null, null, null, null, null);
            }
        }
        subscription.resetLastAliveTime();
        modifyMonitoredItemsResponse.setResults(monitoredItemModifyResultArray);
        modifyMonitoredItemsResponse.setDiagnosticInfos(diagnosticInfoArray);
    }

    protected void modifySubscription(ServiceContext serviceContext, ModifySubscriptionRequest modifySubscriptionRequest, ModifySubscriptionResponse modifySubscriptionResponse) throws ServiceException {
        SubscriptionBase subscriptionBase = this.subscriptionManager.modifySubscription(serviceContext, modifySubscriptionRequest);
        modifySubscriptionResponse.setRevisedLifetimeCount(UnsignedInteger.valueOf(subscriptionBase.getLifetimeCount()));
        modifySubscriptionResponse.setRevisedMaxKeepAliveCount(UnsignedInteger.valueOf(subscriptionBase.getMaxKeepAliveCount()));
        modifySubscriptionResponse.setRevisedPublishingInterval(subscriptionBase.getPublishingInterval());
    }

    protected void setMonitoringMode(ServiceContext serviceContext, SetMonitoringModeRequest setMonitoringModeRequest, SetMonitoringModeResponse setMonitoringModeResponse) throws ServiceException {
        Subscription subscription = this.subscriptionManager.getSubscription(setMonitoringModeRequest.getSubscriptionId());
        Object[] objectArray = setMonitoringModeRequest.getMonitoredItemIds();
        this.checkRequestLength(objectArray, this.getMaxMonitoredItemsPerCall());
        this.subscriptionManager.a(setMonitoringModeRequest.getMonitoringMode());
        StatusCode[] statusCodeArray = new StatusCode[objectArray.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            try {
                this.subscriptionManager.setMonitoringMode(serviceContext, subscription, (UnsignedInteger)objectArray[i2], setMonitoringModeRequest.getMonitoringMode());
                statusCodeArray[i2] = StatusCode.GOOD;
                continue;
            }
            catch (StatusException statusException) {
                logger.debug("StatusException: ", (Throwable)statusException);
                statusCodeArray[i2] = statusException.getStatusCode();
                diagnosticInfoArray[i2] = statusException.getDiagnosticInfo();
            }
        }
        subscription.resetLastAliveTime();
        setMonitoringModeResponse.setResults(statusCodeArray);
        setMonitoringModeResponse.setDiagnosticInfos(diagnosticInfoArray);
    }

    protected void setPublishingMode(ServiceContext serviceContext, SetPublishingModeRequest setPublishingModeRequest, SetPublishingModeResponse setPublishingModeResponse) throws ServiceException {
        Object[] objectArray = setPublishingModeRequest.getSubscriptionIds();
        this.checkRequestLength(objectArray, 0);
        StatusCode[] statusCodeArray = new StatusCode[objectArray.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            try {
                this.subscriptionManager.setPublishingMode(serviceContext, (UnsignedInteger)objectArray[i2], setPublishingModeRequest.getPublishingEnabled());
                statusCodeArray[i2] = StatusCode.GOOD;
                continue;
            }
            catch (ServiceException serviceException) {
                logger.debug("ServiceException: ", (Throwable)serviceException);
                statusCodeArray[i2] = serviceException.getServiceResult();
                diagnosticInfoArray[i2] = serviceException.getDiagnosticInfo();
                continue;
            }
            catch (StatusException statusException) {
                logger.debug("StatusException: ", (Throwable)statusException);
                statusCodeArray[i2] = statusException.getStatusCode();
                diagnosticInfoArray[i2] = statusException.getDiagnosticInfo();
            }
        }
        setPublishingModeResponse.setResults(statusCodeArray);
        setPublishingModeResponse.setDiagnosticInfos(diagnosticInfoArray);
    }

    protected void transferSubscriptions(ServiceContext serviceContext, TransferSubscriptionsRequest transferSubscriptionsRequest, TransferSubscriptionsResponse transferSubscriptionsResponse) throws ServiceException {
        Object[] objectArray = transferSubscriptionsRequest.getSubscriptionIds();
        this.checkRequestLength(objectArray, 0);
        TransferResult[] transferResultArray = new TransferResult[objectArray.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            try {
                transferResultArray[i2] = new TransferResult();
                Subscription subscription = this.subscriptionManager.transferSubscription(serviceContext, (UnsignedInteger)objectArray[i2]);
                subscription.resetLastAliveTime();
                transferResultArray[i2].setStatusCode(StatusCode.GOOD);
                transferResultArray[i2].setAvailableSequenceNumbers(subscription.getAvailableSequenceNumbers());
                logger.debug("transferred: {}", (Object)subscription);
                continue;
            }
            catch (ServiceException serviceException) {
                logger.debug("ServiceException: ", (Throwable)serviceException);
                transferResultArray[i2].setStatusCode(serviceException.getServiceResult());
                diagnosticInfoArray[i2] = serviceException.getDiagnosticInfo();
            }
        }
        transferSubscriptionsResponse.setResults(transferResultArray);
        transferSubscriptionsResponse.setDiagnosticInfos(diagnosticInfoArray);
    }

    private class b
    implements Runnable {
        private static final double lQ = 0.1;
        private final Logger logger = LoggerFactory.getLogger(b.class);
        private final Session iV;
        BlockingQueue<a> lR;

        public b(Session session, LinkedBlockingQueue<a> linkedBlockingQueue) {
            this.iV = session;
            this.lR = linkedBlockingQueue;
        }

        @Override
        public void run() {
            this.logger.debug("PublishRequestQueueHandler.run");
            while (SubscriptionServiceHandler.this.subscriptionManager.isRunning() && this.iV.isActive()) {
                try {
                    a a2;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("PublishRequestQueueHandler.run: publishRequestQueue.size={}", (Object)this.lR.size());
                    }
                    if ((a2 = this.lR.take()) == SubscriptionServiceHandler.this.lM) break;
                    EndpointServiceRequest endpointServiceRequest = a2.dQ();
                    PublishRequest publishRequest = (PublishRequest)endpointServiceRequest.getRequest();
                    PublishResponse publishResponse = a2.dR();
                    ServiceContext serviceContext = a2.getServiceContext();
                    try {
                        if (this.d(a2)) {
                            this.logger.debug("PublishRequest Timeout: {} - Timestamp= {}", (Object)publishRequest.getRequestHeader(), (Object)DateTime.fromMillis(a2.dP()));
                            throw new ServiceException(StatusCodes.Bad_Timeout);
                        }
                        SubscriptionServiceHandler.this.subscriptionManager.publish(serviceContext, publishRequest, publishResponse);
                    }
                    catch (ServiceException serviceException) {
                        SubscriptionServiceHandler.this.handleServiceResultException(publishResponse, serviceException);
                    }
                    catch (Exception exception) {
                        this.logger.error("PublishRequestQueueHandler.run", (Throwable)exception);
                        SubscriptionServiceHandler.this.handleServiceResultException(publishResponse, new ServiceException(new ServiceFaultException(exception)));
                    }
                    SubscriptionServiceHandler.this.validateResponse(publishRequest, publishResponse, serviceContext);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Returning sequence numbers: {}", (Object)Arrays.toString(publishResponse.getAvailableSequenceNumbers()));
                    }
                    endpointServiceRequest.sendResponse(publishResponse);
                }
                catch (InterruptedException interruptedException) {
                    this.logger.debug("PublishRequestQueueHandler: interrupted");
                }
            }
            this.logger.debug("PublishRequestQueueHandler: terminated");
        }

        private boolean d(a a2) {
            RequestHeader requestHeader = ((PublishRequest)a2.dQ().getRequest()).getRequestHeader();
            long l2 = a2.dP();
            long l3 = requestHeader.getTimeoutHint().getValue();
            if (l2 <= 0L || l3 <= 0L) {
                return false;
            }
            long l4 = System.currentTimeMillis() - l2;
            boolean bl = (double)l4 > (double)l3 * 0.9;
            this.logger.debug("publishTimeoutCheck: elapsed={} vs. timeout={} -> {}", new Object[]{l4, l3, bl});
            return bl;
        }
    }

    private class a {
        private final EndpointServiceRequest<PublishRequest, PublishResponse> lO;
        private final PublishResponse lP;
        private final ServiceContext serviceContext;
        private final long timestamp = System.currentTimeMillis();

        private a(ServiceContext serviceContext, EndpointServiceRequest<PublishRequest, PublishResponse> endpointServiceRequest, PublishResponse publishResponse) {
            this.serviceContext = serviceContext;
            this.lO = endpointServiceRequest;
            this.lP = publishResponse;
        }

        public long dP() {
            return this.timestamp;
        }

        private EndpointServiceRequest<PublishRequest, PublishResponse> dQ() {
            return this.lO;
        }

        private PublishResponse dR() {
            return this.lP;
        }

        private ServiceContext getServiceContext() {
            return this.serviceContext;
        }
    }
}

