/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.ApplicationIdentity;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.server.AbstractContinuationPoint;
import com.prosysopc.ua.server.BrowseContinuationPoint;
import com.prosysopc.ua.server.DiagnosticsManager;
import com.prosysopc.ua.server.HistoryContinuationPoint;
import com.prosysopc.ua.server.ServerUserIdentity;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.SessionDiagnostics;
import com.prosysopc.ua.server.SessionListener;
import com.prosysopc.ua.server.SessionManager;
import com.prosysopc.ua.server.SessionSecurityDiagnostics;
import com.prosysopc.ua.server.Subscription;
import com.prosysopc.ua.server.UaServer;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.ServiceResponse;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.IdType;
import com.prosysopc.ua.stack.core.PublishRequest;
import com.prosysopc.ua.stack.core.PublishResponse;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.transport.ServerSecureChannel;
import com.prosysopc.ua.stack.transport.UriUtil;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.SecurityMode;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import com.prosysopc.ua.stack.utils.ObjectUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session {
    public static final Session INTERNAL_SESSION = new Session();
    private static long iZ = 10000L;
    static final Logger logger = LoggerFactory.getLogger(Session.class);
    private volatile boolean active = false;
    private final NodeId authenticationToken;
    private final Map<Long, BrowseContinuationPoint> ja = new ConcurrentSkipListMap<Long, BrowseContinuationPoint>();
    private volatile ServerSecureChannel jb;
    private final ApplicationIdentity jc;
    private final SessionDiagnostics jd;
    private final SessionSecurityDiagnostics je;
    private final Map<Long, HistoryContinuationPoint> jf = new ConcurrentSkipListMap<Long, HistoryContinuationPoint>();
    private volatile long jg = 0L;
    private volatile long jh;
    private final List<Locale> ji = new CopyOnWriteArrayList<Locale>();
    private volatile ByteString serverNonce;
    private volatile SessionManager sessionManager;
    private volatile double jj;
    private final List<Subscription> eU = new CopyOnWriteArrayList<Subscription>();
    private final Queue<Subscription> jk = new ConcurrentLinkedQueue<Subscription>();
    private ServerUserIdentity jl = null;
    protected List<SessionListener> listeners = new CopyOnWriteArrayList<SessionListener>();
    private final SecurityMode eD;

    public static long getActivationTimeout() {
        return iZ;
    }

    public static void setActivationTimeout(long l2) {
        iZ = l2;
    }

    private static NodeId bL() {
        byte[] byArray = new byte[32];
        CryptoUtil.getRandom().nextBytes(byArray);
        return NodeId.get(IdType.Opaque, 0, ByteString.valueOf(byArray));
    }

    private Session() {
        this.sessionManager = null;
        this.jd = null;
        this.je = null;
        this.jc = null;
        this.authenticationToken = null;
        this.eD = SecurityMode.NONE;
    }

    protected Session(SessionManager sessionManager, ApplicationIdentity applicationIdentity, String string, SecurityMode securityMode) {
        this.eD = securityMode;
        this.sessionManager = sessionManager;
        UaServer.NodeManagerUaServer nodeManagerUaServer = sessionManager.getServer().getNodeManagerUaServer();
        NodeId nodeId = NodeId.randomGUID(nodeManagerUaServer.getNamespaceIndex());
        if (string == null) {
            string = "ServerAssigned " + nodeId;
        }
        String string2 = null;
        DateTime dateTime = DateTime.currentTime();
        String string3 = null;
        String[] stringArray = null;
        DateTime dateTime2 = dateTime;
        Double d2 = null;
        UnsignedInteger unsignedInteger = null;
        this.jd = new SessionDiagnostics(nodeId, string, applicationIdentity.getApplicationDescription(), string2, string3, stringArray, d2, unsignedInteger, dateTime, dateTime2);
        Cert cert = applicationIdentity.getCertificate();
        ByteString byteString = cert != null ? ByteString.valueOf(cert.getEncoded()) : null;
        String string4 = null;
        String[] stringArray2 = new String[]{};
        String string5 = null;
        String string6 = null;
        String string7 = null;
        this.je = new SessionSecurityDiagnostics(nodeId, string4, stringArray2, string5, string6, string7, securityMode.getMessageSecurityMode(), securityMode.getSecurityPolicy().getPolicyUri(), byteString);
        this.jc = applicationIdentity;
        this.authenticationToken = Session.bL();
        this.jh = System.currentTimeMillis();
    }

    public void addSessionListener(SessionListener sessionListener) {
        if (!this.listeners.contains(sessionListener)) {
            this.listeners.add(sessionListener);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Session session = (Session)object;
        if (this.authenticationToken == null ? session.authenticationToken != null : !this.authenticationToken.equals(session.authenticationToken)) {
            return false;
        }
        return !(this.getSessionId() == null ? session.getSessionId() != null : !this.getSessionId().equals(session.getSessionId()));
    }

    public NodeId getAuthenticationToken() {
        return this.authenticationToken;
    }

    public ServerSecureChannel getChannel() {
        return this.jb;
    }

    public ApplicationIdentity getClientIdentity() {
        return this.jc;
    }

    public DateTime getClientLastContactTime() {
        return this.jd.bZ().get();
    }

    public Locale getDefaultLocale() {
        if (this.ji == null || this.ji.isEmpty()) {
            return Locale.ENGLISH;
        }
        return this.ji.get(0);
    }

    public Locale[] getLocales() {
        return this.ji.toArray(new Locale[this.ji.size()]);
    }

    public UnsignedInteger getMaxResponseMessageSize() {
        return this.jd.cn().get();
    }

    public SecurityMode getSecurityMode() {
        return this.eD;
    }

    public SessionDiagnostics getSessionDiagnostics() {
        return this.jd;
    }

    public NodeId getSessionId() {
        return this.jd == null ? null : this.jd.getSessionId();
    }

    public String getSessionName() {
        return this.jd == null ? "INTERNAL_SESSION" : this.jd.cx().get();
    }

    public SessionSecurityDiagnostics getSessionSecurityDiagnostics() {
        return this.je;
    }

    public double getSessionTimeout() {
        return this.jj;
    }

    public int getSubscriptionCount() {
        return this.eU.size();
    }

    public ServerUserIdentity getUserIdentity() {
        return this.jl;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.authenticationToken == null ? 0 : this.authenticationToken.hashCode());
        n3 = 31 * n3;
        if (this.jd != null) {
            n3 += this.getSessionId().hashCode();
        }
        return n3;
    }

    public boolean hasLocale(Locale locale) {
        return this.ji.contains(locale);
    }

    public boolean hasSessionListener(SessionListener sessionListener) {
        return this.listeners.contains(sessionListener);
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isTimeout() {
        long l2 = System.currentTimeMillis() - this.jh;
        double d2 = this.isActive() ? this.jj : (double)iZ;
        logger.trace("isTimeout: timeout={} delay={}", (Object)d2, (Object)l2);
        return (double)l2 > d2;
    }

    public void removeSessionListener(SessionListener sessionListener) {
        this.listeners.remove(sessionListener);
    }

    public String toString() {
        return String.format("%s (ID=%s Token=%s Channel=(%s))", this.getSessionName(), this.getSessionId(), this.getAuthenticationToken(), this.getChannel());
    }

    private Long c(ByteString byteString) throws StatusException {
        Long l2;
        if (byteString == null) {
            throw new StatusException("null", StatusCodes.Bad_ContinuationPointInvalid);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteString.getValue());
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            l2 = dataInputStream.readLong();
        }
        catch (IOException iOException) {
            throw new StatusException("Too short array: " + byteString, StatusCodes.Bad_ContinuationPointInvalid);
        }
        return l2;
    }

    private void bM() {
        for (SessionListener sessionListener : this.listeners) {
            try {
                sessionListener.onSessionActivated(this);
            }
            catch (Exception exception) {
                logger.warn("Exception in SessionListener, onSessionActivated:", (Throwable)exception);
            }
        }
    }

    private void bN() {
        for (SessionListener sessionListener : this.listeners) {
            try {
                sessionListener.onSessionChanged(this);
            }
            catch (Exception exception) {
                logger.warn("Exception in SessionListener, onSessionChanged:", (Throwable)exception);
            }
        }
    }

    private void bO() {
        for (SessionListener sessionListener : this.listeners) {
            try {
                sessionListener.onSessionClosed(this);
            }
            catch (Exception exception) {
                logger.warn("Exception in SessionListener, onSessionClosed:", (Throwable)exception);
            }
        }
    }

    private AbstractContinuationPoint a(ByteString byteString, Map<Long, ? extends AbstractContinuationPoint> map) throws StatusException {
        Long l2 = this.c(byteString);
        AbstractContinuationPoint abstractContinuationPoint = map.remove(l2);
        logger.debug("getContinuationPoint: i={} result={}", (Object)l2, (Object)abstractContinuationPoint);
        if (abstractContinuationPoint == null) {
            throw new StatusException("Not found: " + byteString, StatusCodes.Bad_ContinuationPointInvalid);
        }
        return abstractContinuationPoint;
    }

    private DiagnosticsManager getDiagnosticsManager() {
        SessionManager sessionManager = this.getSessionManager();
        return sessionManager == null ? null : sessionManager.getServer().getDiagnosticsManager();
    }

    private boolean isDiagnosticsEnabled() {
        DiagnosticsManager diagnosticsManager = this.getDiagnosticsManager();
        return diagnosticsManager == null ? false : diagnosticsManager.isEnabled();
    }

    private ByteString a(Long l2) throws StatusException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeLong(l2);
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
            throw new StatusException("Cannot create long");
        }
        return ByteString.valueOf(byteArrayOutputStream.toByteArray());
    }

    private synchronized long bP() {
        return ++this.jg;
    }

    private void a(ServiceContext serviceContext, Map<Long, ? extends AbstractContinuationPoint> map, int n2) throws StatusException {
        if (n2 == 0) {
            return;
        }
        Iterator<? extends AbstractContinuationPoint> iterator = map.values().iterator();
        try {
            while (map.size() > n2) {
                AbstractContinuationPoint abstractContinuationPoint = iterator.next();
                if (abstractContinuationPoint.getServiceContext().equals(serviceContext)) continue;
                iterator.remove();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new StatusException(StatusCodes.Bad_NoContinuationPoints);
        }
    }

    protected void activate(ServerUserIdentity serverUserIdentity) throws StatusException {
        this.jl = serverUserIdentity;
        this.active = true;
        logger.debug("ServerUserIdentity: {}", (Object)serverUserIdentity);
        if (serverUserIdentity != null) {
            this.je.cP().set(serverUserIdentity.getType().name());
            if (serverUserIdentity.getName() != null && serverUserIdentity.getName().length() > 0) {
                this.je.cQ().add(serverUserIdentity.getName());
            }
            this.je.cR().set(serverUserIdentity.getName());
        }
        this.bM();
    }

    protected ByteString addBrowseContinuationPoint(BrowseContinuationPoint browseContinuationPoint) throws StatusException {
        this.a(browseContinuationPoint.getServiceContext(), this.ja, this.getSessionManager().getMaxBrowseContinuationPoints());
        Long l2 = this.bP();
        logger.debug("addContinuationPoint: i={}", (Object)l2);
        this.ja.put(l2, browseContinuationPoint);
        this.bN();
        return this.a(l2);
    }

    protected ByteString addHistoryContinuationPoint(HistoryContinuationPoint historyContinuationPoint) throws StatusException {
        this.a(historyContinuationPoint.getServiceContext(), this.jf, this.getSessionManager().getMaxHistoryContinuationPoints());
        long l2 = this.bP();
        this.jf.put(l2, historyContinuationPoint);
        this.bN();
        return this.a(l2);
    }

    protected void addSubscription(Subscription subscription) {
        this.eU.add(subscription);
        this.bN();
    }

    protected void cancel() {
    }

    protected void close(boolean bl) {
        logger.debug("close");
        this.bO();
        this.listeners.clear();
        this.active = false;
        this.sessionManager = null;
    }

    protected void deactivate() {
        this.active = false;
        this.bN();
    }

    protected BrowseContinuationPoint getBrowseContinuationPoint(ByteString byteString) throws StatusException {
        return (BrowseContinuationPoint)this.a(byteString, this.ja);
    }

    protected QualifiedName getDefaultEncoding() {
        return QualifiedName.DEFAULT_BINARY_ENCODING;
    }

    protected HistoryContinuationPoint getHistoryContinuationPoint(ByteString byteString) throws StatusException {
        return (HistoryContinuationPoint)this.a(byteString, this.jf);
    }

    protected ByteString getNewServerNonce(int n2) {
        this.serverNonce = CryptoUtil.createNonce(n2);
        this.bN();
        return this.serverNonce;
    }

    protected ByteString getServerNonce() {
        return this.serverNonce;
    }

    protected SessionManager getSessionManager() {
        return this.sessionManager;
    }

    protected Queue<Subscription> getTransferredSubscriptions() {
        return this.jk;
    }

    protected void removeSubscription(Subscription subscription) {
        this.eU.remove(subscription);
    }

    protected void resetDiagnostics() {
        this.jd.cH();
        this.bN();
    }

    protected void setChannel(ServerSecureChannel serverSecureChannel) {
        this.jb = serverSecureChannel;
        if (logger.isDebugEnabled()) {
            logger.debug("setChannel: serverSecureChannel=" + (serverSecureChannel == null ? "null" : ObjectUtils.printFields(serverSecureChannel)));
        }
        if (serverSecureChannel != null) {
            String string = serverSecureChannel.getEndpoint().getEndpointUrl();
            this.jd.cj().set(string);
            this.je.cS().set("UA Binary");
            this.je.cV().set(UriUtil.getTransportProtocol(string).toLowerCase());
            this.je.cT().set(serverSecureChannel.getMessageSecurityMode());
            this.je.cU().set(serverSecureChannel.getSecurityPolicy().getPolicyUri());
        }
        this.bN();
    }

    protected void setLocaleIds(String[] stringArray) {
        if (stringArray != null) {
            this.ji.clear();
            for (String string : stringArray) {
                this.ji.add(LocalizedText.toLocale(string));
            }
        }
        this.jd.cm().set(stringArray);
        this.bN();
    }

    protected void setMaxResponseMessageSize(UnsignedInteger unsignedInteger) {
        this.jd.cn().set(unsignedInteger);
        this.bN();
    }

    protected void setSessionName(String string) {
        this.jd.cx().set(string);
        this.bN();
    }

    protected void setSessionTimeout(double d2) {
        logger.debug("setSessionTimeout: {}", (Object)d2);
        this.jj = d2;
        this.jd.bR().set(this.jj);
        this.bN();
    }

    protected void updateDiagnostics() {
        this.getSessionManager().getServer().getDiagnosticsManager().updateSession(this);
    }

    List<Subscription> bQ() {
        return this.eU;
    }

    void a(ServiceRequest serviceRequest) {
        this.jh = System.currentTimeMillis();
        if (this.isDiagnosticsEnabled()) {
            this.jd.bZ().set(DateTime.currentTime());
            String string = serviceRequest.getClass().getName().replace("Request", "").replaceAll(".*[.]", "");
            SessionDiagnostics.ServiceCounter serviceCounter = this.jd.h(string);
            if (serviceCounter != null) {
                serviceCounter.cL();
            }
            this.jd.cB().cL();
            if (serviceRequest instanceof PublishRequest) {
                this.jd.cd().incrementAndGet();
            }
            this.updateDiagnostics();
        }
        this.bN();
    }

    void a(ServiceResponse serviceResponse) {
        if (this.isDiagnosticsEnabled()) {
            StatusCode statusCode = serviceResponse.getResponseHeader().getServiceResult();
            if (statusCode.isBad()) {
                String string = serviceResponse.getClass().getName().replace("Response", "").replaceAll(".*[.]", "");
                SessionDiagnostics.ServiceCounter serviceCounter = this.jd.h(string);
                if (serviceCounter != null) {
                    serviceCounter.cK();
                }
                this.jd.cB().cK();
                if (statusCode.getValue().equals(StatusCodes.Bad_UserAccessDenied)) {
                    this.jd.cE().incrementAndGet();
                }
            }
            if (serviceResponse instanceof PublishResponse) {
                this.jd.cd().decrementAndGet();
            }
            this.updateDiagnostics();
            this.bN();
        }
    }
}

