/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.nodes.UaInstance;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.SemanticChangeStructureDataType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SemanticChangeEvent {
    private final Map<NodeId, SemanticChangeStructureDataType> iG = new ConcurrentHashMap<NodeId, SemanticChangeStructureDataType>();
    private final NamespaceTable namespaceTable;
    private SemanticChangeStructureDataType[] iH = null;

    public SemanticChangeEvent(NamespaceTable namespaceTable) {
        this.namespaceTable = namespaceTable;
    }

    public void addChange(NodeId nodeId, NodeId nodeId2) {
        if (!this.iG.containsKey(nodeId)) {
            this.iG.put(nodeId, new SemanticChangeStructureDataType(nodeId, nodeId2));
        }
    }

    public void addChange(UaNode uaNode) {
        NodeId nodeId = uaNode.getNodeId();
        NodeId nodeId2 = NodeId.NULL;
        if (uaNode instanceof UaInstance) {
            try {
                nodeId2 = this.namespaceTable.toNodeId(((UaInstance)uaNode).getTypeDefinitionId());
            }
            catch (ServiceResultException serviceResultException) {
                throw new RuntimeException(serviceResultException);
            }
        }
        this.addChange(nodeId, nodeId2);
    }

    public void clearChanges() {
        this.iG.clear();
        this.iH = null;
    }

    public SemanticChangeStructureDataType[] getChanges() {
        if (this.iH != null) {
            return this.iH;
        }
        return this.iG.values().toArray(new SemanticChangeStructureDataType[this.iG.size()]);
    }

    public void setChanges(SemanticChangeStructureDataType[] semanticChangeStructureDataTypeArray) {
        this.clearChanges();
        this.iH = semanticChangeStructureDataTypeArray;
    }
}

