/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.UaNodeUtils;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.NamingRuleType;

public final class ModellingRule {
    public static final ModellingRule ExposesItsArray = new ModellingRule(Identifiers.ModellingRule_ExposesItsArray, NamingRuleType.Constraint);
    public static final ModellingRule Mandatory = new ModellingRule(Identifiers.ModellingRule_Mandatory, NamingRuleType.Mandatory);
    public static final ModellingRule MandatoryPlaceholder = new ModellingRule(Identifiers.ModellingRule_MandatoryPlaceholder, NamingRuleType.Constraint);
    public static final ModellingRule Optional = new ModellingRule(Identifiers.ModellingRule_Optional, NamingRuleType.Optional);
    public static final ModellingRule OptionalPlaceholder = new ModellingRule(Identifiers.ModellingRule_OptionalPlaceholder, NamingRuleType.Constraint);
    public static final ModellingRule[] values = new ModellingRule[]{Mandatory, Optional, ExposesItsArray, OptionalPlaceholder, MandatoryPlaceholder};
    private final NamingRuleType gC;
    private final NodeId nodeId;

    public static ModellingRule byInstanceDeclaration(UaNode uaNode) {
        if (uaNode == null) {
            return null;
        }
        UaNode uaNode2 = UaNodeUtils.getModellingRule(uaNode);
        return uaNode2 == null ? null : ModellingRule.byModellingRuleNode(uaNode2);
    }

    public static ModellingRule byModellingRuleNode(UaNode uaNode) {
        if (!UaNodeUtils.isModellingRule(uaNode)) {
            throw new IllegalArgumentException("Node is not a modelling rule");
        }
        ModellingRule modellingRule = ModellingRule.i(uaNode.getNodeId());
        return modellingRule == null ? new ModellingRule(uaNode) : modellingRule;
    }

    private static ModellingRule i(NodeId nodeId) {
        for (ModellingRule modellingRule : values) {
            if (!modellingRule.nodeId.equals(nodeId)) continue;
            return modellingRule;
        }
        return null;
    }

    private ModellingRule(NodeId nodeId, NamingRuleType namingRuleType) {
        this.nodeId = nodeId;
        this.gC = namingRuleType;
    }

    private ModellingRule(UaNode uaNode) {
        this.nodeId = uaNode.getNodeId();
        this.gC = UaNodeUtils.getNamingRule(uaNode);
    }

    public NamingRuleType getNamingRule() {
        return this.gC;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }
}

