/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.DataChangeListener;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.server.Session;
import com.prosysopc.ua.server.Subscription;
import com.prosysopc.ua.server.SubscriptionManager;
import com.prosysopc.ua.server.UaServer;
import com.prosysopc.ua.server.b;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.SessionDiagnosticsDataType;
import com.prosysopc.ua.stack.core.SessionSecurityDiagnosticsDataType;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.SubscriptionDiagnosticsDataType;
import com.prosysopc.ua.types.opcua.server.ServerDiagnosticsTypeNode;
import com.prosysopc.ua.types.opcua.server.SessionDiagnosticsArrayTypeNode;
import com.prosysopc.ua.types.opcua.server.SessionDiagnosticsObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.SessionSecurityDiagnosticsArrayTypeNode;
import com.prosysopc.ua.types.opcua.server.SessionsDiagnosticsSummaryTypeNode;
import com.prosysopc.ua.types.opcua.server.SubscriptionDiagnosticsArrayTypeNode;
import com.prosysopc.ua.types.opcua.server.SubscriptionDiagnosticsTypeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagnosticsManager {
    private static final Logger logger = LoggerFactory.getLogger(DiagnosticsManager.class);
    private final AtomicBoolean fN = new AtomicBoolean(false);
    private SubscriptionDiagnosticsArrayTypeNode fO;
    private boolean fP = true;
    private final UaServer fQ;
    private ServerDiagnosticsTypeNode fR;
    private final b fS = new b();
    private final Map<Session, SessionDiagnosticsObjectTypeNode> fT = new ConcurrentHashMap<Session, SessionDiagnosticsObjectTypeNode>();
    private SessionsDiagnosticsSummaryTypeNode fU;
    private final Map<Subscription, SubscriptionDiagnosticsTypeNode> fV = new ConcurrentHashMap<Subscription, SubscriptionDiagnosticsTypeNode>();
    private volatile boolean fW = this.fN.get();

    protected DiagnosticsManager(UaServer uaServer) {
        this.fQ = uaServer;
    }

    public boolean isEnabled() {
        return this.fN.get();
    }

    public boolean isRemoveSamplingIntervalDiagnosticsArrayOnStart() {
        return this.fP;
    }

    public void setRemoveSamplingIntervalDiagnosticsArrayOnStart(boolean bl) {
        this.fP = bl;
    }

    private void a(Collection<Session> collection, SessionDiagnosticsArrayTypeNode sessionDiagnosticsArrayTypeNode) {
        try {
            ArrayList<SessionDiagnosticsDataType> arrayList = new ArrayList<SessionDiagnosticsDataType>();
            for (Session session : collection) {
                SessionDiagnosticsObjectTypeNode sessionDiagnosticsObjectTypeNode = this.fT.get(session);
                arrayList.add(sessionDiagnosticsObjectTypeNode.getSessionDiagnostics());
            }
            sessionDiagnosticsArrayTypeNode.setValue(arrayList.toArray(new SessionDiagnosticsDataType[arrayList.size()]));
        }
        catch (Exception exception) {
            logger.error("Could not set diagnostics", (Throwable)exception);
        }
    }

    private void a(Collection<Session> collection, SessionSecurityDiagnosticsArrayTypeNode sessionSecurityDiagnosticsArrayTypeNode) {
        try {
            ArrayList<SessionSecurityDiagnosticsDataType> arrayList = new ArrayList<SessionSecurityDiagnosticsDataType>();
            for (Session session : collection) {
                SessionDiagnosticsObjectTypeNode sessionDiagnosticsObjectTypeNode = this.fT.get(session);
                arrayList.add(sessionDiagnosticsObjectTypeNode.getSessionSecurityDiagnostics());
            }
            sessionSecurityDiagnosticsArrayTypeNode.setValue(arrayList.toArray(new SessionSecurityDiagnosticsDataType[arrayList.size()]));
        }
        catch (Exception exception) {
            logger.error("Could not set diagnostics", (Throwable)exception);
        }
    }

    private void a(Collection<Subscription> collection, SubscriptionDiagnosticsArrayTypeNode subscriptionDiagnosticsArrayTypeNode) {
        try {
            ArrayList<SubscriptionDiagnosticsDataType> arrayList = new ArrayList<SubscriptionDiagnosticsDataType>();
            for (Subscription subscription : collection) {
                SubscriptionDiagnosticsTypeNode subscriptionDiagnosticsTypeNode = this.fV.get(subscription);
                if (subscriptionDiagnosticsTypeNode == null) continue;
                arrayList.add((SubscriptionDiagnosticsDataType)subscriptionDiagnosticsTypeNode.getValue().getValue().getValue());
            }
            subscriptionDiagnosticsArrayTypeNode.setValue(arrayList.toArray(new SubscriptionDiagnosticsDataType[arrayList.size()]));
        }
        catch (Exception exception) {
            logger.error("Could not set diagnostics", (Throwable)exception);
        }
    }

    private SubscriptionManager getSubscriptionManager() {
        return this.fQ.getSubscriptionManager();
    }

    private void aO() throws StatusException {
        this.fR = this.fQ.getNodeManagerRoot().getServerData().getServerDiagnosticsNode();
        this.fU = this.fR.getSessionsDiagnosticsSummaryNode();
        this.fO = this.fR.getSubscriptionDiagnosticsArrayNode();
        DataChangeListener dataChangeListener = new DataChangeListener(){

            @Override
            public void onDataChange(UaNode uaNode, DataValue dataValue, DataValue dataValue2) {
                if (dataValue2.isNull()) {
                    return;
                }
                boolean bl = dataValue2.getValue().booleanValue();
                DiagnosticsManager.this.fN.set(bl);
                if (bl) {
                    DiagnosticsManager.this.onDiagnosticsEnabled();
                } else {
                    DiagnosticsManager.this.onDiagnosticsDisabled();
                }
            }
        };
        this.fR.addEnabledChangeListener(dataChangeListener);
        DataValue dataValue = this.fR.getEnabledFlagNode().getValue();
        if (dataValue != null && !dataValue.isNull() && ((Boolean)dataValue.getValue().getValue()).booleanValue()) {
            dataChangeListener.onDataChange(this.fR, null, dataValue);
        }
    }

    private void aP() {
        try {
            UaNode uaNode = this.fQ.getNodeManagerRoot().getNode(Identifiers.ViewsFolder);
            this.fS.bI().set(uaNode.getComponents().length);
            this.aR();
        }
        catch (StatusException statusException) {
            logger.warn("ViewsFolder not available", (Throwable)statusException);
        }
    }

    private void aQ() {
        DataValue dataValue = new DataValue(new StatusCode(StatusCodes.Bad_NotReadable));
        try {
            for (NodeId nodeId : this.fQ.getNodeManagerRoot().bi()) {
                UaVariable uaVariable = (UaVariable)this.fQ.getAddressSpace().getNode(nodeId);
                uaVariable.setValue(dataValue);
            }
        }
        catch (Exception exception) {
            logger.error("Could not update diagnostics", (Throwable)exception);
        }
    }

    private void aR() {
        if (this.isEnabled()) {
            try {
                this.fR.setServerDiagnosticsSummary(this.fS.by());
            }
            catch (Exception exception) {
                logger.error("Could not update diagnostics", (Throwable)exception);
            }
        }
    }

    protected void addSession(Session session) {
        logger.trace("addSession: session:{}", (Object)session);
        if (this.isEnabled()) {
            try {
                logger.trace("addSession, creating diagnostics node");
                SessionDiagnosticsObjectTypeNode sessionDiagnosticsObjectTypeNode = this.fQ.getNodeManagerUaServer().createInstance(SessionDiagnosticsObjectTypeNode.class, session.getSessionName(), session.getSessionId());
                logger.trace("addSession, created diagnostics node");
                sessionDiagnosticsObjectTypeNode.setSessionDiagnostics(session.getSessionDiagnostics().snapshot());
                sessionDiagnosticsObjectTypeNode.setSessionSecurityDiagnostics(session.getSessionSecurityDiagnostics().snapshot());
                this.fT.put(session, sessionDiagnosticsObjectTypeNode);
                this.fU.getSessionDiagnosticsArrayNode().addComponent(sessionDiagnosticsObjectTypeNode.getSessionDiagnosticsNode());
                this.fU.getSessionSecurityDiagnosticsArrayNode().addComponent(sessionDiagnosticsObjectTypeNode.getSessionSecurityDiagnosticsNode());
                this.fU.addComponent(sessionDiagnosticsObjectTypeNode);
                this.updateSession(session);
                this.fS.bB().incrementAndGet();
                this.aS();
                this.aR();
            }
            catch (Exception exception) {
                logger.error("Could not set diagnostics", (Throwable)exception);
            }
        } else {
            this.aS();
        }
    }

    protected void addSessionNoIncrement(Session session) {
        logger.trace("addSession: session:{}", (Object)session);
        if (this.isEnabled()) {
            try {
                logger.trace("addSession, creating diagnostics node");
                SessionDiagnosticsObjectTypeNode sessionDiagnosticsObjectTypeNode = this.fQ.getNodeManagerUaServer().createInstance(SessionDiagnosticsObjectTypeNode.class, session.getSessionName(), session.getSessionId());
                logger.trace("addSession, created diagnostics node");
                sessionDiagnosticsObjectTypeNode.setSessionDiagnostics(session.getSessionDiagnostics().snapshot());
                sessionDiagnosticsObjectTypeNode.setSessionSecurityDiagnostics(session.getSessionSecurityDiagnostics().snapshot());
                this.fT.put(session, sessionDiagnosticsObjectTypeNode);
                this.fU.getSessionDiagnosticsArrayNode().addComponent(sessionDiagnosticsObjectTypeNode.getSessionDiagnosticsNode());
                this.fU.getSessionSecurityDiagnosticsArrayNode().addComponent(sessionDiagnosticsObjectTypeNode.getSessionSecurityDiagnosticsNode());
                this.fU.addComponent(sessionDiagnosticsObjectTypeNode);
                this.updateSession(session);
                this.fS.bB().incrementAndGet();
                this.aR();
            }
            catch (Exception exception) {
                logger.error("Could not set diagnostics", (Throwable)exception);
            }
        }
    }

    protected void addSubscription(Session session, Subscription subscription) {
        if (this.isEnabled()) {
            try {
                SubscriptionDiagnosticsTypeNode subscriptionDiagnosticsTypeNode = this.fQ.getNodeManagerUaServer().createInstance(SubscriptionDiagnosticsTypeNode.class, subscription.getSubscriptionId().toString(), NodeId.randomGUID(this.fQ.getNodeManagerUaServer().getNamespaceIndex()));
                subscriptionDiagnosticsTypeNode.setValue(subscription.getDiagnostics().snapshot());
                this.fV.put(subscription, subscriptionDiagnosticsTypeNode);
                SessionDiagnosticsObjectTypeNode sessionDiagnosticsObjectTypeNode = this.fT.get(session);
                logger.trace("addSubscription: session:{}, diag:{}", (Object)session, (Object)sessionDiagnosticsObjectTypeNode);
                sessionDiagnosticsObjectTypeNode.getSubscriptionDiagnosticsArrayNode().addComponent(subscriptionDiagnosticsTypeNode);
                this.fR.getSubscriptionDiagnosticsArrayNode().addComponent(subscriptionDiagnosticsTypeNode);
                this.updateSubscription(subscription);
                this.aT();
                this.fS.bC().incrementAndGet();
                this.aR();
                session.getSessionDiagnostics().ce().incrementAndGet();
            }
            catch (Exception exception) {
                logger.error("Could not add diagnostics node", (Throwable)exception);
            }
        } else {
            this.aT();
        }
    }

    protected void close() {
        logger.debug("close");
        if (this.fR != null) {
            this.fR.setEnabled(false);
        }
        this.fR = null;
    }

    protected void onDiagnosticsDisabled() {
        if (this.fW) {
            for (Subscription object : this.fQ.getSubscriptionManager().dN()) {
                this.removeSubscription(object.getSession(), object);
            }
            for (Session session : this.fQ.getSessionManager().getSessions()) {
                this.removeSession(session);
            }
            this.aQ();
        } else {
            logger.trace("Diagnostics is disabled, onDiagnosticsDisabled aborted");
        }
        this.fW = false;
    }

    protected void onDiagnosticsEnabled() {
        if (!this.fW) {
            for (Session iterator : this.fQ.getSessionManager().getSessions()) {
                iterator.resetDiagnostics();
                this.fQ.getDiagnosticsManager().addSessionNoIncrement(iterator);
            }
            this.fS.bB().set(this.fQ.getSessionManager().getSessionCount());
            SubscriptionManager subscriptionManager = this.getSubscriptionManager();
            this.fS.bC().set(subscriptionManager.getSubscriptionCount());
            this.aR();
            for (Subscription subscription : subscriptionManager.dN()) {
                subscription.getSession().getSessionDiagnostics().ce().set(0L);
            }
            for (Subscription subscription : subscriptionManager.dN()) {
                subscription.getDiagnostics().cH();
                this.addSubscription(subscription.getSession(), subscription);
                subscription.getSession().getSessionDiagnostics().cc().set(subscription.getItemCount());
            }
            this.aP();
        } else {
            logger.trace("Diagnostics is enabled, onDiagnosticsEnabled aborted");
        }
        this.fW = true;
    }

    protected void removeSession(Session session) {
        SessionDiagnosticsObjectTypeNode sessionDiagnosticsObjectTypeNode = this.fT.remove(session);
        logger.trace("removeSession, session: {}, diag: {}", (Object)session, (Object)sessionDiagnosticsObjectTypeNode);
        if (sessionDiagnosticsObjectTypeNode != null) {
            try {
                logger.trace("removeSession, deleting diagnostics nodes");
                this.fU.getSessionDiagnosticsArrayNode().removeComponent(sessionDiagnosticsObjectTypeNode.getSessionDiagnosticsNode());
                this.fU.getSessionSecurityDiagnosticsArrayNode().removeComponent(sessionDiagnosticsObjectTypeNode.getSessionSecurityDiagnosticsNode());
                this.fU.removeComponent(sessionDiagnosticsObjectTypeNode);
                sessionDiagnosticsObjectTypeNode.getNodeManager().deleteNode(sessionDiagnosticsObjectTypeNode, true, true);
                logger.trace("removeSession, deleted diagnostics nodes");
            }
            catch (Exception exception) {
                logger.error("Could not remove diagnostics", (Throwable)exception);
            }
        }
        if (this.fR.isEnabled()) {
            this.fS.bB().set(this.fQ.getSessionManager().getSessionCount());
            this.aR();
        }
    }

    protected void removeSubscription(Session session, Subscription subscription) {
        logger.trace("removeSubscription, session: {}, subscription {}", (Object)session, (Object)subscription);
        SubscriptionDiagnosticsTypeNode subscriptionDiagnosticsTypeNode = this.fV.remove(subscription);
        if (subscriptionDiagnosticsTypeNode != null) {
            try {
                if (session != null) {
                    SessionDiagnosticsObjectTypeNode sessionDiagnosticsObjectTypeNode = this.fT.get(session);
                    logger.trace("removeSubscription: session:{}, diag:{}", (Object)session, (Object)sessionDiagnosticsObjectTypeNode);
                    if (sessionDiagnosticsObjectTypeNode != null) {
                        sessionDiagnosticsObjectTypeNode.getSubscriptionDiagnosticsArrayNode().removeComponent(subscriptionDiagnosticsTypeNode);
                    }
                }
                this.fR.getSubscriptionDiagnosticsArrayNode().removeComponent(subscriptionDiagnosticsTypeNode);
                subscriptionDiagnosticsTypeNode.getNodeManager().deleteNode(subscriptionDiagnosticsTypeNode, true, true);
            }
            catch (Exception exception) {
                logger.error("Could not remove diagnostics", (Throwable)exception);
            }
        }
        if (this.isEnabled()) {
            try {
                this.fS.bC().set(this.getSubscriptionManager().getSubscriptionCount());
                this.aR();
                if (session.getSessionDiagnostics() != null) {
                    session.getSessionDiagnostics().ce().decrementAndGet();
                    session.updateDiagnostics();
                }
            }
            catch (Exception exception) {
                logger.error("Could not set diagnostics", (Throwable)exception);
            }
        }
    }

    protected void start() throws StatusException {
        logger.debug("start");
        if (this.fP) {
            try {
                this.fQ.getNodeManagerRoot().deleteNode(Identifiers.Server_ServerDiagnostics_SamplingIntervalDiagnosticsArray, true, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.aO();
    }

    protected void updateSession(Session session) {
        logger.trace("updateSession, session: {}", (Object)session);
        SessionDiagnosticsObjectTypeNode sessionDiagnosticsObjectTypeNode = this.fT.get(session);
        if (this.isEnabled() && sessionDiagnosticsObjectTypeNode != null) {
            try {
                sessionDiagnosticsObjectTypeNode.setSessionDiagnostics(session.getSessionDiagnostics().snapshot());
                sessionDiagnosticsObjectTypeNode.setSessionSecurityDiagnostics(session.getSessionSecurityDiagnostics().snapshot());
                this.a(this.fT.keySet(), this.fU.getSessionDiagnosticsArrayNode());
                this.a(this.fT.keySet(), this.fU.getSessionSecurityDiagnosticsArrayNode());
            }
            catch (Exception exception) {
                logger.error("Could not update diagnostics", (Throwable)exception);
            }
        }
    }

    protected void updateSubscription(Subscription subscription) {
        SubscriptionDiagnosticsTypeNode subscriptionDiagnosticsTypeNode = this.fV.get(subscription);
        if (this.isEnabled() && subscriptionDiagnosticsTypeNode != null) {
            try {
                subscriptionDiagnosticsTypeNode.setValue(subscription.getDiagnostics().snapshot());
                this.a(this.fV.keySet(), this.fO);
                Session session = subscription.getSession();
                if (session == null) {
                    return;
                }
                SessionDiagnosticsObjectTypeNode sessionDiagnosticsObjectTypeNode = this.fT.get(session);
                logger.debug("diag object debug: {}, session: {}, subscription", new Object[]{sessionDiagnosticsObjectTypeNode, session, subscription});
                if (sessionDiagnosticsObjectTypeNode == null) {
                    return;
                }
                SubscriptionDiagnosticsArrayTypeNode subscriptionDiagnosticsArrayTypeNode = sessionDiagnosticsObjectTypeNode.getSubscriptionDiagnosticsArrayNode();
                if (subscriptionDiagnosticsArrayTypeNode != null) {
                    this.a(session.bQ(), subscriptionDiagnosticsArrayTypeNode);
                }
            }
            catch (Exception exception) {
                logger.error("Could not update diagnostics", (Throwable)exception);
            }
        }
    }

    void aS() {
        this.fS.bz().incrementAndGet();
        this.aR();
    }

    void aT() {
        this.fS.bA().incrementAndGet();
        this.aR();
    }

    void aU() {
        this.fS.bF().incrementAndGet();
        this.aR();
    }

    void aV() {
        this.fS.bH().incrementAndGet();
        this.aR();
    }

    void aW() {
        this.fS.bK().incrementAndGet();
        this.aR();
    }
}

