/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.EventData;
import com.prosysopc.ua.server.FilterOperatorDefinition;
import com.prosysopc.ua.server.NodeManagerRoot;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.ContentFilter;
import com.prosysopc.ua.stack.core.ContentFilterElement;
import com.prosysopc.ua.stack.core.ContentFilterElementResult;
import com.prosysopc.ua.stack.core.ContentFilterResult;
import com.prosysopc.ua.stack.core.EventFilter;
import com.prosysopc.ua.stack.core.EventFilterResult;
import com.prosysopc.ua.stack.core.SimpleAttributeOperand;
import com.prosysopc.ua.stack.core.StatusCodes;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentFilterDefinition {
    private static Logger logger = LoggerFactory.getLogger(ContentFilterDefinition.class);
    private DiagnosticInfo[] elementDiagnosticInfos;
    private ContentFilterElementResult[] elementResults;
    private FilterOperatorDefinition[] fM;

    public static void parseEventFilter(NodeManagerRoot nodeManagerRoot, EventFilter eventFilter, List<List<QualifiedName>> list, ContentFilterDefinition contentFilterDefinition, EventFilterResult eventFilterResult) {
        list.clear();
        SimpleAttributeOperand[] simpleAttributeOperandArray = eventFilter.getSelectClauses();
        if (simpleAttributeOperandArray != null) {
            for (SimpleAttributeOperand simpleAttributeOperand : simpleAttributeOperandArray) {
                if (simpleAttributeOperand == null) continue;
                Object[] objectArray = simpleAttributeOperand.getBrowsePath();
                logger.debug("BrowsePath={}", (Object)Arrays.toString(objectArray));
                if (simpleAttributeOperand.getAttributeId().equals(Attributes.Value)) {
                    if (objectArray == null) continue;
                    list.add(Arrays.asList(objectArray));
                    continue;
                }
                if (!simpleAttributeOperand.getAttributeId().equals(Attributes.NodeId)) continue;
                list.add(null);
                simpleAttributeOperand.getTypeDefinitionId();
            }
        }
        contentFilterDefinition.parse(eventFilter.getWhereClause(), nodeManagerRoot);
        eventFilterResult.setWhereClauseResult(new ContentFilterResult(contentFilterDefinition.getElementResults(), contentFilterDefinition.getElementDiagnosticInfos()));
    }

    public Boolean evaluate(EventData eventData, Boolean bl) {
        Boolean bl2;
        if (this.fM == null || this.fM.length == 0 || this.fM[0] == null) {
            return true;
        }
        try {
            bl2 = (Boolean)this.fM[0].evaluate(eventData, bl);
        }
        catch (ClassCastException classCastException) {
            bl2 = null;
        }
        logger.debug("evaluate: {}", bl2);
        return bl2;
    }

    public DiagnosticInfo[] getElementDiagnosticInfos() {
        return this.elementDiagnosticInfos;
    }

    public ContentFilterElementResult[] getElementResults() {
        return this.elementResults;
    }

    public void parse(ContentFilter contentFilter, NodeManagerRoot nodeManagerRoot) {
        ContentFilterElement[] contentFilterElementArray;
        ContentFilterElement[] contentFilterElementArray2 = contentFilterElementArray = contentFilter == null ? null : contentFilter.getElements();
        if (contentFilterElementArray != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("parse: elements.length={}", (Object)contentFilterElementArray.length);
            }
            this.fM = new FilterOperatorDefinition[contentFilterElementArray.length];
            this.elementResults = new ContentFilterElementResult[contentFilterElementArray.length];
            this.elementDiagnosticInfos = new DiagnosticInfo[contentFilterElementArray.length];
            for (int i2 = contentFilterElementArray.length - 1; i2 >= 0; --i2) {
                ContentFilterElement contentFilterElement = contentFilterElementArray[i2];
                logger.debug("parse: i={} element={}", (Object)i2, (Object)contentFilterElement);
                if (contentFilterElement == null) continue;
                this.fM[i2] = FilterOperatorDefinition.newOperator(contentFilterElement.getFilterOperator(), contentFilterElement.getFilterOperands(), nodeManagerRoot, this.fM);
                if (this.fM[i2] == null) {
                    this.elementResults[i2] = new ContentFilterElementResult(new StatusCode(StatusCodes.Bad_FilterOperatorUnsupported), null, null);
                } else {
                    this.elementResults[i2] = this.fM[i2].getElementResult();
                    this.elementDiagnosticInfos[i2] = this.fM[i2].getElementDiagnosticInfo();
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("parse: i={} operator={}", (Object)i2, (Object)this.fM[i2]);
            }
        }
    }
}

