/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class BrowsePath
implements Comparable<BrowsePath> {
    public static final BrowsePath EMPTY = new BrowsePath(new QualifiedName[0]);
    private final LinkedList<QualifiedName> list = new LinkedList();

    public static BrowsePath from(int n2, String ... stringArray) {
        return EMPTY.append(n2, stringArray);
    }

    public static BrowsePath from(QualifiedName ... qualifiedNameArray) {
        return EMPTY.append(qualifiedNameArray);
    }

    private BrowsePath(List<QualifiedName> list) {
        this.list.addAll(list);
    }

    private BrowsePath(QualifiedName ... qualifiedNameArray) {
        this.list.addAll(Arrays.asList(qualifiedNameArray));
    }

    public BrowsePath append(BrowsePath browsePath) {
        return this.append(browsePath.toArray());
    }

    public BrowsePath append(int n2, String ... stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("nameparts cannot be null");
        }
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("nameparts cannot be empty");
        }
        ArrayList<QualifiedName> arrayList = new ArrayList<QualifiedName>();
        for (String string : Arrays.asList(stringArray)) {
            arrayList.add(new QualifiedName(n2, string));
        }
        return this.append(arrayList.toArray(new QualifiedName[arrayList.size()]));
    }

    public BrowsePath append(QualifiedName ... qualifiedNameArray) {
        if (qualifiedNameArray == null) {
            throw new IllegalArgumentException("the qualified names to append cannot be null");
        }
        if (qualifiedNameArray.length == 0) {
            return this;
        }
        LinkedList<QualifiedName> linkedList = new LinkedList<QualifiedName>(this.list);
        linkedList.addAll(Arrays.asList(qualifiedNameArray));
        return new BrowsePath(linkedList);
    }

    @Override
    public int compareTo(BrowsePath browsePath) {
        QualifiedName qualifiedName;
        QualifiedName qualifiedName2;
        if (this.equals(browsePath)) {
            return 0;
        }
        Iterator iterator = this.list.iterator();
        Iterator iterator2 = browsePath.list.iterator();
        do {
            if (!iterator.hasNext()) {
                return -1;
            }
            qualifiedName2 = (QualifiedName)iterator.next();
            if (!iterator2.hasNext()) {
                return 1;
            }
            qualifiedName = (QualifiedName)iterator2.next();
        } while (qualifiedName2.equals(qualifiedName));
        return this.a(qualifiedName2, qualifiedName);
    }

    public boolean equals(Object object) {
        if (object instanceof BrowsePath) {
            BrowsePath browsePath = (BrowsePath)object;
            return this.list.equals(browsePath.list);
        }
        return super.equals(object);
    }

    public QualifiedName getFirst() {
        if (this.list.isEmpty()) {
            return QualifiedName.NULL;
        }
        return this.list.peekFirst();
    }

    public QualifiedName getLast() {
        if (this.list.isEmpty()) {
            return QualifiedName.NULL;
        }
        return this.list.peekLast();
    }

    public int getSize() {
        return this.list.size();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public BrowsePath removeFirst() {
        LinkedList<QualifiedName> linkedList = new LinkedList<QualifiedName>(this.list);
        linkedList.pollFirst();
        return new BrowsePath(linkedList);
    }

    public BrowsePath removeLast() {
        LinkedList<QualifiedName> linkedList = new LinkedList<QualifiedName>(this.list);
        linkedList.pollLast();
        return new BrowsePath(linkedList);
    }

    public QualifiedName[] toArray() {
        if (this.list == null) {
            return new QualifiedName[0];
        }
        return this.list.toArray(new QualifiedName[0]);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("/");
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            QualifiedName qualifiedName = (QualifiedName)iterator.next();
            stringBuilder.append(qualifiedName.getNamespaceIndex()).append(':').append(qualifiedName.getName());
            if (!iterator.hasNext()) continue;
            stringBuilder.append('/');
        }
        return stringBuilder.toString();
    }

    private int a(QualifiedName qualifiedName, QualifiedName qualifiedName2) {
        Integer n2 = qualifiedName.getNamespaceIndex();
        n2.compareTo(qualifiedName2.getNamespaceIndex());
        int n3 = n2.compareTo(qualifiedName2.getNamespaceIndex());
        if (n3 != 0) {
            return n3;
        }
        return qualifiedName.getName().compareTo(qualifiedName2.getName());
    }
}

