/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.server.HistoryContinuationPoint;
import com.prosysopc.ua.server.HistoryResult;
import com.prosysopc.ua.server.NodeManager;
import com.prosysopc.ua.server.NodeManagerTable;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.ServiceHandler;
import com.prosysopc.ua.server.Session;
import com.prosysopc.ua.server.SessionManager;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.ServiceResult;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.ServiceFaultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.HistoryReadDetails;
import com.prosysopc.ua.stack.core.HistoryReadRequest;
import com.prosysopc.ua.stack.core.HistoryReadResponse;
import com.prosysopc.ua.stack.core.HistoryReadResult;
import com.prosysopc.ua.stack.core.HistoryReadValueId;
import com.prosysopc.ua.stack.core.HistoryUpdateDetails;
import com.prosysopc.ua.stack.core.HistoryUpdateRequest;
import com.prosysopc.ua.stack.core.HistoryUpdateResponse;
import com.prosysopc.ua.stack.core.HistoryUpdateResult;
import com.prosysopc.ua.stack.core.ReadRequest;
import com.prosysopc.ua.stack.core.ReadResponse;
import com.prosysopc.ua.stack.core.ReadValueId;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.TimestampsToReturn;
import com.prosysopc.ua.stack.core.WriteRequest;
import com.prosysopc.ua.stack.core.WriteResponse;
import com.prosysopc.ua.stack.core.WriteValue;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.transport.endpoint.EndpointServiceRequest;
import com.prosysopc.ua.stack.utils.AttributesUtil;
import com.prosysopc.ua.stack.utils.NumericRange;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeServiceHandler
extends ServiceHandler {
    protected static Logger logger = LoggerFactory.getLogger(AttributeServiceHandler.class);

    private static ServiceResult a(WriteValue writeValue) {
        if (writeValue == null) {
            return new ServiceResult(StatusCodes.Bad_StructureMissing);
        }
        if (writeValue.getNodeId() == null) {
            return new ServiceResult(StatusCodes.Bad_NodeIdInvalid);
        }
        if (!AttributesUtil.isValid(writeValue.getAttributeId())) {
            return new ServiceResult(StatusCodes.Bad_AttributeIdInvalid);
        }
        if (writeValue.getIndexRange() != null && !writeValue.getIndexRange().isEmpty()) {
            try {
                NumericRange.parse(writeValue.getIndexRange());
            }
            catch (Exception exception) {
                return new ServiceResult(StatusCodes.Bad_IndexRangeInvalid, (Throwable)exception);
            }
        }
        return null;
    }

    public AttributeServiceHandler(SessionManager sessionManager, NodeManagerTable nodeManagerTable) {
        super(sessionManager, nodeManagerTable);
    }

    public int getMaxNodesPerHistoryReadData() {
        return this.getOperationLimits().getMaxNodesPerHistoryReadData().intValue();
    }

    public int getMaxNodesPerHistoryReadEvents() {
        return this.getOperationLimits().getMaxNodesPerHistoryReadEvents().intValue();
    }

    public int getMaxNodesPerHistoryUpdateData() {
        return this.getOperationLimits().getMaxNodesPerHistoryUpdateData().intValue();
    }

    public int getMaxNodesPerHistoryUpdateEvents() {
        return this.getOperationLimits().getMaxNodesPerHistoryUpdateEvents().intValue();
    }

    public int getMaxNodesPerRead() {
        return this.getOperationLimits().getMaxNodesPerRead().intValue();
    }

    public int getMaxNodesPerWrite() {
        return this.getOperationLimits().getMaxNodesPerWrite().intValue();
    }

    public final void onHistoryRead(EndpointServiceRequest<HistoryReadRequest, HistoryReadResponse> endpointServiceRequest) throws ServiceFaultException {
        HistoryReadRequest historyReadRequest = endpointServiceRequest.getRequest();
        HistoryReadResponse historyReadResponse = new HistoryReadResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest(historyReadRequest, endpointServiceRequest.getChannel());
            this.historyRead(serviceContext, historyReadRequest, historyReadResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException(historyReadResponse, serviceException);
        }
        historyReadResponse.setDiagnosticInfos(this.validateResponse(historyReadRequest, historyReadResponse, serviceContext, historyReadResponse.getDiagnosticInfos()));
        endpointServiceRequest.sendResponse(historyReadResponse);
    }

    public final void onHistoryUpdate(EndpointServiceRequest<HistoryUpdateRequest, HistoryUpdateResponse> endpointServiceRequest) throws ServiceFaultException {
        HistoryUpdateRequest historyUpdateRequest = endpointServiceRequest.getRequest();
        HistoryUpdateResponse historyUpdateResponse = new HistoryUpdateResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest(historyUpdateRequest, endpointServiceRequest.getChannel());
            this.historyUpdate(serviceContext, endpointServiceRequest.getRequest(), historyUpdateResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException(historyUpdateResponse, serviceException);
        }
        historyUpdateResponse.setDiagnosticInfos(this.validateResponse(historyUpdateRequest, historyUpdateResponse, serviceContext, historyUpdateResponse.getDiagnosticInfos()));
        endpointServiceRequest.sendResponse(historyUpdateResponse);
    }

    public final void onRead(EndpointServiceRequest<ReadRequest, ReadResponse> endpointServiceRequest) throws ServiceFaultException {
        ReadRequest readRequest = endpointServiceRequest.getRequest();
        ReadResponse readResponse = new ReadResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest(readRequest, endpointServiceRequest.getChannel());
            this.read(serviceContext, readRequest, readResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException(readResponse, serviceException);
        }
        readResponse.setDiagnosticInfos(this.validateResponse(readRequest, readResponse, serviceContext, readResponse.getDiagnosticInfos()));
        endpointServiceRequest.sendResponse(readResponse);
    }

    public final void onWrite(EndpointServiceRequest<WriteRequest, WriteResponse> endpointServiceRequest) throws ServiceFaultException {
        WriteRequest writeRequest = endpointServiceRequest.getRequest();
        WriteResponse writeResponse = new WriteResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest(writeRequest, endpointServiceRequest.getChannel());
            this.write(serviceContext, writeRequest, writeResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException(writeResponse, serviceException);
        }
        writeResponse.setDiagnosticInfos(this.validateResponse(writeRequest, writeResponse, serviceContext, writeResponse.getDiagnosticInfos()));
        endpointServiceRequest.sendResponse(writeResponse);
    }

    public void setMaxNodesPerHistoryReadData(int n2) {
        this.getOperationLimits().setMaxNodesPerHistoryReadData(UnsignedInteger.valueOf(n2));
    }

    public void setMaxNodesPerHistoryReadEvents(int n2) {
        this.getOperationLimits().setMaxNodesPerHistoryReadEvents(UnsignedInteger.valueOf(n2));
    }

    public void setMaxNodesPerHistoryUpdateData(int n2) {
        this.getOperationLimits().setMaxNodesPerHistoryUpdateData(UnsignedInteger.valueOf(n2));
    }

    public void setMaxNodesPerHistoryUpdateEvents(int n2) {
        this.getOperationLimits().setMaxNodesPerHistoryUpdateEvents(UnsignedInteger.valueOf(n2));
    }

    public void setMaxNodesPerRead(int n2) {
        this.getOperationLimits().setMaxNodesPerRead(UnsignedInteger.valueOf(n2));
    }

    public void setMaxNodesPerWrite(int n2) {
        this.getOperationLimits().setMaxNodesPerWrite(UnsignedInteger.valueOf(n2));
    }

    private void a(ServiceContext serviceContext, Map<Integer, Object> map, HistoryReadDetails historyReadDetails, HistoryReadValueId[] historyReadValueIdArray, HistoryContinuationPoint[] historyContinuationPointArray, TimestampsToReturn timestampsToReturn, HistoryResult[] historyResultArray) throws ServiceException {
        for (Integer n2 : map.keySet()) {
            try {
                NodeManager nodeManager = this.getNodeManagerTable().getNodeManager(n2);
                Object object = nodeManager.getHistoryManager().beginHistoryRead(serviceContext, historyReadDetails, timestampsToReturn, historyReadValueIdArray, historyContinuationPointArray, historyResultArray);
                map.put(n2, object);
            }
            catch (StatusException statusException) {}
        }
    }

    private void a(ServiceContext serviceContext, Map<Integer, Object> map, HistoryUpdateDetails[] historyUpdateDetailsArray, HistoryUpdateResult[] historyUpdateResultArray, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
        for (Integer n2 : map.keySet()) {
            try {
                NodeManager nodeManager = this.getNodeManagerTable().getNodeManager(n2);
                Object object = nodeManager.getHistoryManager().beginHistoryUpdate(serviceContext, historyUpdateDetailsArray, historyUpdateResultArray, diagnosticInfoArray);
                map.put(n2, object);
            }
            catch (StatusException statusException) {}
        }
    }

    private void a(ServiceContext serviceContext, Map<Integer, Object> map, ReadValueId[] readValueIdArray, TimestampsToReturn timestampsToReturn, DateTime dateTime, DataValue[] dataValueArray, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
        for (Integer n2 : map.keySet()) {
            try {
                NodeManager nodeManager = this.getNodeManagerTable().getNodeManager(n2);
                Object object = nodeManager.getIoManager().beginRead(serviceContext, readValueIdArray, timestampsToReturn, dateTime, dataValueArray, diagnosticInfoArray);
                map.put(n2, object);
            }
            catch (StatusException statusException) {}
        }
    }

    private void a(ServiceContext serviceContext, Map<Integer, Object> map, WriteValue[] writeValueArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
        for (Integer n2 : map.keySet()) {
            try {
                NodeManager nodeManager = this.getNodeManagerTable().getNodeManager(n2);
                Object object = nodeManager.getIoManager().beginWrite(serviceContext, writeValueArray, statusCodeArray, diagnosticInfoArray);
                map.put(n2, object);
            }
            catch (StatusException statusException) {}
        }
    }

    private void a(ServiceContext serviceContext, Map<Integer, Object> map, HistoryReadDetails historyReadDetails, TimestampsToReturn timestampsToReturn, HistoryReadValueId[] historyReadValueIdArray, HistoryContinuationPoint[] historyContinuationPointArray, HistoryResult[] historyResultArray) throws ServiceException {
        for (Integer n2 : map.keySet()) {
            try {
                NodeManager nodeManager = this.getNodeManagerTable().getNodeManager(n2);
                nodeManager.getHistoryManager().endHistoryRead(serviceContext, map.get(n2), historyReadDetails, timestampsToReturn, historyReadValueIdArray, historyContinuationPointArray, historyResultArray);
            }
            catch (StatusException statusException) {}
        }
    }

    private void b(ServiceContext serviceContext, Map<Integer, Object> map, HistoryUpdateDetails[] historyUpdateDetailsArray, HistoryUpdateResult[] historyUpdateResultArray, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
        for (Integer n2 : map.keySet()) {
            try {
                NodeManager nodeManager = this.getNodeManagerTable().getNodeManager(n2);
                nodeManager.getHistoryManager().endHistoryUpdate(serviceContext, map.get(n2), historyUpdateDetailsArray, historyUpdateResultArray, diagnosticInfoArray);
            }
            catch (StatusException statusException) {}
        }
    }

    private void b(ServiceContext serviceContext, Map<Integer, Object> map, ReadValueId[] readValueIdArray, TimestampsToReturn timestampsToReturn, DateTime dateTime, DataValue[] dataValueArray, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
        for (Integer n2 : map.keySet()) {
            try {
                NodeManager nodeManager = this.getNodeManagerTable().getNodeManager(n2);
                nodeManager.getIoManager().endRead(serviceContext, map.get(n2), readValueIdArray, timestampsToReturn, dateTime, dataValueArray, diagnosticInfoArray);
            }
            catch (StatusException statusException) {}
        }
    }

    private void b(ServiceContext serviceContext, Map<Integer, Object> map, WriteValue[] writeValueArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
        for (Integer n2 : map.keySet()) {
            try {
                NodeManager nodeManager = this.getNodeManagerTable().getNodeManager(n2);
                nodeManager.getIoManager().endWrite(serviceContext, map.get(n2), writeValueArray, statusCodeArray, diagnosticInfoArray);
            }
            catch (StatusException statusException) {}
        }
    }

    private int aN() {
        int n2 = this.getMaxNodesPerHistoryUpdateData();
        int n3 = this.getMaxNodesPerHistoryUpdateEvents();
        if (n2 <= 0) {
            return n3;
        }
        if (n3 <= 0) {
            return n2;
        }
        return Math.max(n2, n3);
    }

    private void a(TimestampsToReturn timestampsToReturn, DataValue dataValue) {
        switch (timestampsToReturn) {
            case Neither: {
                dataValue.setServerTimestamp(DateTime.MIN_VALUE);
                dataValue.setSourceTimestamp(DateTime.MIN_VALUE);
                break;
            }
            case Server: {
                dataValue.setSourceTimestamp(DateTime.MIN_VALUE);
                if (dataValue.getServerTimestamp() != null) break;
                dataValue.setServerTimestamp(DateTime.currentTime());
                break;
            }
            case Source: {
                dataValue.setServerTimestamp(DateTime.MIN_VALUE);
                break;
            }
            case Both: {
                if (dataValue.getServerTimestamp() != null) break;
                dataValue.setServerTimestamp(DateTime.currentTime());
            }
        }
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    protected void historyRead(ServiceContext serviceContext, HistoryReadRequest historyReadRequest, HistoryReadResponse historyReadResponse) throws ServiceException {
        Object object;
        Object object2;
        Object object3;
        int n2;
        HistoryReadDetails historyReadDetails;
        TimestampsToReturn timestampsToReturn = historyReadRequest.getTimestampsToReturn();
        if (timestampsToReturn == TimestampsToReturn.Neither) {
            throw new ServiceException(StatusCodes.Bad_InvalidTimestampArgument);
        }
        Session session = serviceContext.getSession();
        Object[] objectArray = historyReadRequest.getNodesToRead();
        this.checkRequestLength(objectArray, this.getMaxNodesPerHistoryReadData());
        try {
            historyReadDetails = (HistoryReadDetails)historyReadRequest.getHistoryReadDetails().decode(this.getEncoderContext());
        }
        catch (DecodingException decodingException) {
            throw new ServiceException(decodingException);
        }
        Boolean bl = historyReadRequest.getReleaseContinuationPoints();
        TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
        HistoryContinuationPoint[] historyContinuationPointArray = new HistoryContinuationPoint[objectArray.length];
        HistoryResult[] historyResultArray = new HistoryResult[objectArray.length];
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            object3 = objectArray[n2];
            try {
                if (bl.booleanValue()) {
                    this.releaseHistoryContinuationPoint(serviceContext, ((HistoryReadValueId)object3).getNodeId(), ((HistoryReadValueId)object3).getContinuationPoint());
                    continue;
                }
                object2 = ((HistoryReadValueId)object3).getNodeId().getNamespaceIndex();
                if (!treeMap.containsKey(object2)) {
                    treeMap.put((Integer)object2, null);
                }
                if (((HistoryReadValueId)object3).getContinuationPoint() == null) continue;
                historyContinuationPointArray[n2] = session.getHistoryContinuationPoint(((HistoryReadValueId)object3).getContinuationPoint());
                if (historyContinuationPointArray[n2].getDetails() != null) continue;
                throw new StatusException(StatusCodes.Bad_ContinuationPointInvalid);
            }
            catch (StatusException statusException) {
                logger.debug("historyRead: Invalid continuation point for nodeToRead=" + object3 + " error:", (Throwable)statusException);
                historyResultArray[n2] = new HistoryResult(statusException.getStatusCode(), statusException.getDiagnosticInfo());
            }
        }
        if (!bl.booleanValue()) {
            this.a(serviceContext, treeMap, historyReadDetails, (HistoryReadValueId[])objectArray, historyContinuationPointArray, timestampsToReturn, historyResultArray);
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                if (historyResultArray[n2] != null) continue;
                object3 = objectArray[n2];
                try {
                    try {
                        object2 = NumericRange.parse(((HistoryReadValueId)object3).getIndexRange());
                    }
                    catch (ServiceResultException serviceResultException) {
                        throw new StatusException(serviceResultException);
                    }
                    object = treeMap.get(((HistoryReadValueId)object3).getNodeId().getNamespaceIndex());
                    historyResultArray[n2] = this.readNodeHistory(serviceContext, object, timestampsToReturn, ((HistoryReadValueId)object3).getNodeId(), (NumericRange)object2, historyContinuationPointArray[n2], historyReadDetails, n2);
                    continue;
                }
                catch (StatusException statusException) {
                    logger.debug("historyRead: Invalid continuation point for nodeToRead=" + object3 + " error:", (Throwable)statusException);
                    historyResultArray[n2] = new HistoryResult(statusException.getStatusCode(), statusException.getDiagnosticInfo());
                }
            }
            this.a(serviceContext, treeMap, historyReadDetails, timestampsToReturn, (HistoryReadValueId[])objectArray, historyContinuationPointArray, historyResultArray);
        }
        HistoryReadResult[] historyReadResultArray = new HistoryReadResult[objectArray.length];
        object3 = new DiagnosticInfo[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            historyReadResultArray[i2] = new HistoryReadResult();
            object3[i2] = new DiagnosticInfo();
            object = objectArray[i2];
            QualifiedName qualifiedName = ((HistoryReadValueId)object).getDataEncoding();
            if (QualifiedName.isNull(qualifiedName)) {
                qualifiedName = QualifiedName.DEFAULT_BINARY_ENCODING;
            }
            historyReadResultArray[i2].setHistoryData(AttributeServiceHandler.toExtensionObject(serviceContext, historyResultArray[i2].getData(), qualifiedName, this.getEncoderContext()));
            historyReadResultArray[i2].setStatusCode(historyResultArray[i2].getStatusCode());
            object3[i2] = historyResultArray[i2].getDiagnosticInfo();
            ByteString byteString = null;
            if (historyResultArray[i2].getContinuationPoint() == null) continue;
            try {
                if (historyContinuationPointArray[i2] != null) {
                    HistoryContinuationPoint historyContinuationPoint = historyContinuationPointArray[i2];
                    byteString = session.addHistoryContinuationPoint(new HistoryContinuationPoint(serviceContext, historyResultArray[i2].getContinuationPoint(), historyContinuationPoint.getDetails(), historyContinuationPoint.getTimestampsToReturn()));
                }
                byteString = session.addHistoryContinuationPoint(new HistoryContinuationPoint(serviceContext, historyResultArray[i2].getContinuationPoint(), historyReadDetails, timestampsToReturn));
                historyReadResultArray[i2].setContinuationPoint(byteString);
                continue;
            }
            catch (StatusException statusException) {
                historyReadResultArray[i2].setStatusCode(statusException.getStatusCode());
                object3[i2] = statusException.getDiagnosticInfo();
            }
        }
        historyReadResponse.setResults(historyReadResultArray);
        historyReadResponse.setDiagnosticInfos((DiagnosticInfo[])object3);
    }

    protected void historyUpdate(ServiceContext serviceContext, HistoryUpdateRequest historyUpdateRequest, HistoryUpdateResponse historyUpdateResponse) throws ServiceException {
        Object[] objectArray = historyUpdateRequest.getHistoryUpdateDetails();
        this.checkRequestLength(objectArray, this.aN());
        HistoryUpdateResult[] historyUpdateResultArray = new HistoryUpdateResult[objectArray.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[objectArray.length];
        HistoryUpdateDetails[] historyUpdateDetailsArray = new HistoryUpdateDetails[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            try {
                historyUpdateDetailsArray[i2] = (HistoryUpdateDetails)((ExtensionObject)objectArray[i2]).decode(this.getEncoderContext());
                continue;
            }
            catch (DecodingException decodingException) {
                logger.debug("DecodingException: ", (Throwable)decodingException);
                historyUpdateResultArray[i2].setStatusCode(decodingException.getStatusCode());
            }
        }
        TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
        for (HistoryUpdateDetails historyUpdateDetails : historyUpdateDetailsArray) {
            Integer n2 = historyUpdateDetails.getNodeId().getNamespaceIndex();
            if (treeMap.containsKey(n2)) continue;
            treeMap.put(n2, null);
        }
        this.a(serviceContext, treeMap, historyUpdateDetailsArray, historyUpdateResultArray, diagnosticInfoArray);
        for (int i3 = 0; i3 < historyUpdateDetailsArray.length; ++i3) {
            historyUpdateResultArray[i3] = new HistoryUpdateResult();
            diagnosticInfoArray[i3] = new DiagnosticInfo();
            try {
                Object v = treeMap.get(historyUpdateDetailsArray[i3].getNodeId().getNamespaceIndex());
                this.updateNodeHistory(serviceContext, v, historyUpdateDetailsArray[i3], historyUpdateResultArray[i3]);
                historyUpdateResultArray[i3].setStatusCode(StatusCode.GOOD);
                continue;
            }
            catch (StatusException statusException) {
                logger.debug("StatusException: ", (Throwable)statusException);
                historyUpdateResultArray[i3].setStatusCode(statusException.getStatusCode());
                diagnosticInfoArray[i3] = statusException.getDiagnosticInfo();
            }
        }
        this.b(serviceContext, treeMap, historyUpdateDetailsArray, historyUpdateResultArray, diagnosticInfoArray);
        historyUpdateResponse.setResults(historyUpdateResultArray);
        historyUpdateResponse.setDiagnosticInfos(diagnosticInfoArray);
    }

    protected void read(ServiceContext serviceContext, ReadRequest readRequest, ReadResponse readResponse) throws ServiceException {
        int n2;
        Object object;
        DateTime dateTime;
        logger.debug("read");
        Double d2 = readRequest.getMaxAge();
        if (d2 == null || d2 == 0.0) {
            dateTime = DateTime.MAX_VALUE;
        } else {
            if (d2 < 0.0) {
                throw new ServiceException(StatusCodes.Bad_MaxAgeInvalid);
            }
            dateTime = d2 >= 2.147483647E9 ? DateTime.MIN_VALUE : new DateTime((long)(((double)DateTime.currentTime().getMilliSeconds() - d2) * 10000.0));
        }
        TimestampsToReturn timestampsToReturn = readRequest.getTimestampsToReturn();
        if (timestampsToReturn == null) {
            throw new ServiceException(StatusCodes.Bad_TimestampsToReturnInvalid);
        }
        Object[] objectArray = readRequest.getNodesToRead();
        this.checkRequestLength(objectArray, this.getMaxNodesPerRead());
        TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
        for (Object object2 : objectArray) {
            object = ((ReadValueId)object2).getNodeId().getNamespaceIndex();
            if (treeMap.containsKey(object)) continue;
            treeMap.put((Integer)object, null);
        }
        Object[] objectArray2 = new DataValue[objectArray.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[objectArray.length];
        this.a(serviceContext, treeMap, (ReadValueId[])objectArray, timestampsToReturn, dateTime, (DataValue[])objectArray2, diagnosticInfoArray);
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            if (objectArray2[n2] != null || objectArray[n2] == null) continue;
            objectArray2[n2] = new DataValue(StatusCode.GOOD);
            try {
                Object object2;
                object2 = objectArray[n2];
                this.validateEncoding((ReadValueId)object2);
                logger.debug("nodesToRead[{}]{}", (Object)n2, object2);
                object = NumericRange.parse(((ReadValueId)object2).getIndexRange());
                if (((ReadValueId)object2).getAttributeId() != Attributes.Value && !((NumericRange)object).equals(NumericRange.getEmpty())) {
                    throw new StatusException(StatusCodes.Bad_IndexRangeNoData);
                }
                NodeId nodeId = ((ReadValueId)object2).getNodeId();
                this.readAttribute(serviceContext, treeMap.get(nodeId.getNamespaceIndex()), nodeId, ((ReadValueId)object2).getAttributeId(), (NumericRange)object, timestampsToReturn, dateTime, (DataValue)objectArray2[n2]);
                logger.debug("results[{}]{}", (Object)n2, objectArray2[n2]);
                if (((DataValue)objectArray2[n2]).getStatusCode() == null || ((DataValue)objectArray2[n2]).getStatusCode().isBad()) {
                    ((DataValue)objectArray2[n2]).setValue(null);
                }
                this.a(timestampsToReturn, (DataValue)objectArray2[n2]);
                if (!((ReadValueId)object2).getAttributeId().equals(Attributes.Value) || !logger.isDebugEnabled()) continue;
                logger.debug("TimestampsToReturn: {} AttributeId: {} Node: {}, Server timestamp: {}, Source timestamp: {}", new Object[]{timestampsToReturn, ((ReadValueId)object2).getAttributeId(), nodeId.toString(), ((DataValue)objectArray2[n2]).getServerTimestamp(), ((DataValue)objectArray2[n2]).getSourceTimestamp()});
                continue;
            }
            catch (StatusException statusException) {
                logger.debug("StatusException: ", (Throwable)statusException);
                ((DataValue)objectArray2[n2]).setStatusCode(statusException.getStatusCode());
                diagnosticInfoArray[n2] = statusException.getDiagnosticInfo();
                continue;
            }
            catch (ServiceResultException serviceResultException) {
                logger.debug("ServiceResultException: ", (Throwable)serviceResultException);
                ((DataValue)objectArray2[n2]).setStatusCode(serviceResultException.getStatusCode());
                object = serviceResultException.getAdditionalTextField();
                if (object == null) continue;
                diagnosticInfoArray[n2] = new DiagnosticInfo();
                diagnosticInfoArray[n2].setAdditionalInfo((String)object);
            }
        }
        this.b(serviceContext, treeMap, (ReadValueId[])objectArray, timestampsToReturn, dateTime, (DataValue[])objectArray2, diagnosticInfoArray);
        readResponse.setResults((DataValue[])objectArray2);
        n2 = 1;
        for (DiagnosticInfo diagnosticInfo : diagnosticInfoArray) {
            if (diagnosticInfo != null) continue;
            n2 = 0;
            break;
        }
        readResponse.setDiagnosticInfos((DiagnosticInfo[])(n2 != 0 ? diagnosticInfoArray : null));
    }

    protected void readAttribute(ServiceContext serviceContext, Object object, NodeId nodeId, UnsignedInteger unsignedInteger, NumericRange numericRange, TimestampsToReturn timestampsToReturn, DateTime dateTime, DataValue dataValue) throws StatusException {
        this.getNodeManagerTable().readAttribute(serviceContext, object, nodeId, unsignedInteger, numericRange, timestampsToReturn, dateTime, dataValue);
    }

    protected HistoryResult readNodeHistory(ServiceContext serviceContext, Object object, TimestampsToReturn timestampsToReturn, NodeId nodeId, NumericRange numericRange, HistoryContinuationPoint historyContinuationPoint, HistoryReadDetails historyReadDetails, int n2) throws StatusException {
        return this.getNodeManagerTable().historyRead(serviceContext, object, timestampsToReturn, nodeId, numericRange, historyContinuationPoint, historyReadDetails, n2);
    }

    protected void releaseHistoryContinuationPoint(ServiceContext serviceContext, NodeId nodeId, ByteString byteString) throws StatusException {
        this.getNodeManagerTable().releaseHistoryContinuationPoint(serviceContext, nodeId, byteString);
    }

    protected void updateNodeHistory(ServiceContext serviceContext, Object object, HistoryUpdateDetails historyUpdateDetails, HistoryUpdateResult historyUpdateResult) throws StatusException {
        this.getNodeManagerTable().historyUpdate(serviceContext, object, historyUpdateDetails, historyUpdateResult);
    }

    protected void write(ServiceContext serviceContext, WriteRequest writeRequest, WriteResponse writeResponse) throws ServiceException {
        Object object;
        logger.debug("write");
        Object[] objectArray = writeRequest.getNodesToWrite();
        this.checkRequestLength(objectArray, this.getMaxNodesPerWrite());
        TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
        for (Object object2 : objectArray) {
            object = ((WriteValue)object2).getNodeId().getNamespaceIndex();
            if (treeMap.containsKey(object)) continue;
            treeMap.put((Integer)object, null);
        }
        Object[] objectArray2 = new StatusCode[objectArray.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[objectArray.length];
        this.a(serviceContext, treeMap, (WriteValue[])objectArray, (StatusCode[])objectArray2, diagnosticInfoArray);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (objectArray2[i2] != null) continue;
            try {
                Object object2;
                object2 = objectArray[i2];
                object = AttributeServiceHandler.a((WriteValue)object2);
                if (object != null && ((ServiceResult)object).isBad()) {
                    throw new StatusException(((ServiceResult)object).getCode());
                }
                NodeId nodeId = ((WriteValue)object2).getNodeId();
                if (this.writeAttribute(serviceContext, treeMap.get(nodeId.getNamespaceIndex()), nodeId, ((WriteValue)object2).getAttributeId(), NumericRange.parse(((WriteValue)object2).getIndexRange()), ((WriteValue)object2).getValue())) {
                    objectArray2[i2] = StatusCode.GOOD;
                    continue;
                }
                objectArray2[i2] = new StatusCode(StatusCodes.Good_CompletesAsynchronously);
                continue;
            }
            catch (StatusException statusException) {
                logger.debug("Write failed", (Throwable)statusException);
                diagnosticInfoArray[i2] = statusException.getDiagnosticInfo();
                objectArray2[i2] = statusException.getStatusCode();
                continue;
            }
            catch (ServiceResultException serviceResultException) {
                objectArray2[i2] = serviceResultException.getStatusCode();
                object = serviceResultException.getAdditionalTextField();
                if (object == null) continue;
                diagnosticInfoArray[i2] = new DiagnosticInfo();
                diagnosticInfoArray[i2].setAdditionalInfo((String)object);
            }
        }
        this.b(serviceContext, treeMap, (WriteValue[])objectArray, (StatusCode[])objectArray2, diagnosticInfoArray);
        writeResponse.setResults((StatusCode[])objectArray2);
        writeResponse.setDiagnosticInfos(diagnosticInfoArray);
    }

    protected boolean writeAttribute(ServiceContext serviceContext, Object object, NodeId nodeId, UnsignedInteger unsignedInteger, NumericRange numericRange, DataValue dataValue) throws StatusException {
        return this.getNodeManagerTable().writeAttribute(serviceContext, object, nodeId, unsignedInteger, numericRange, dataValue);
    }
}

