/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.nodes;

import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaReferenceType;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.common.NamespaceTable;

public abstract class UaReference
implements Comparable<UaReference> {
    @Override
    public int compareTo(UaReference uaReference) {
        if (uaReference == null) {
            return 1;
        }
        int n2 = this.getSourceId().compareTo(uaReference.getSourceId());
        if (n2 == 0) {
            n2 = this.getTargetId().compareTo(uaReference.getTargetId());
        }
        if (n2 == 0) {
            n2 = this.getReferenceTypeId().compareTo(uaReference.getReferenceTypeId());
        }
        return n2;
    }

    public abstract void delete();

    public abstract boolean getIsInverse(NodeId var1);

    public abstract boolean getIsInverse(UaNode var1);

    public UaNode getOppositeNode(UaNode uaNode) {
        NamespaceTable namespaceTable = uaNode.getAddressSpace().getNamespaceTable();
        if (namespaceTable.nodeIdEquals(uaNode.getNodeId(), this.getSourceId())) {
            return this.getTargetNode();
        }
        if (namespaceTable.nodeIdEquals(uaNode.getNodeId(), this.getTargetId())) {
            return this.getSourceNode();
        }
        throw new IllegalArgumentException("getOppositeNode: node (" + uaNode + ") is neither targetNode (" + this.getTargetNode() + ") nor sourceNode (" + this.getSourceNode() + ")");
    }

    public ExpandedNodeId getOppositeNodeId(ExpandedNodeId expandedNodeId) {
        if (expandedNodeId.equals(this.getSourceId())) {
            return this.getTargetId();
        }
        if (expandedNodeId.equals(this.getTargetId())) {
            return this.getSourceId();
        }
        throw new IllegalArgumentException("getOppositeNode: node is neither targetNode nor sourceNode, target=" + this.getTargetId() + ", source=" + this.getSourceId() + ", asked nodeid=" + expandedNodeId);
    }

    public abstract UaReferenceType getReferenceType();

    public abstract NodeId getReferenceTypeId();

    public abstract ExpandedNodeId getSourceId();

    public abstract UaNode getSourceNode();

    public abstract ExpandedNodeId getTargetId();

    public abstract UaNode getTargetNode();

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("UaReference: ");
        stringBuilder.append(" ReferenceTypeId=");
        stringBuilder.append(this.getReferenceTypeId());
        stringBuilder.append(" SourceId=");
        stringBuilder.append(this.getSourceId());
        stringBuilder.append(" TargetId=");
        stringBuilder.append(this.getTargetId());
        return stringBuilder.toString();
    }
}

