/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.nodes;

import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.nodes.UaReferenceType;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbstractUaNode
implements UaNode {
    @Override
    public UaReference[] getForwardReferences(NodeId ... nodeIdArray) {
        return this.getReferences(false, nodeIdArray);
    }

    @Override
    public UaReference[] getInverseReferences(NodeId ... nodeIdArray) {
        return this.getReferences(true, nodeIdArray);
    }

    @Override
    public UaReference[] getReferences() {
        return this.getReferencesAsList(null, new NodeId[0]).toArray(new UaReference[0]);
    }

    protected abstract Collection<UaReference> getReferenceList();

    protected UaReference[] getReferences(boolean bl, NodeId ... nodeIdArray) {
        List<UaReference> list = this.getReferencesAsList(bl, nodeIdArray);
        return list.toArray(new UaReference[list.size()]);
    }

    protected List<UaReference> getReferencesAsList(Boolean bl, NodeId ... nodeIdArray) {
        ArrayList<UaReference> arrayList = new ArrayList<UaReference>();
        Collection<UaReference> collection = this.getReferenceList();
        if (collection != null) {
            for (UaReference uaReference : collection) {
                boolean bl2 = this.referenceTypeInherits(uaReference.getReferenceTypeId(), nodeIdArray);
                if (!bl2 || bl != null && uaReference.getIsInverse(this) != bl.booleanValue()) continue;
                arrayList.add(uaReference);
            }
        }
        return arrayList;
    }

    protected abstract boolean referenceTypeInherits(NodeId var1, NodeId ... var2);

    protected boolean referenceTypeInherits(UaReferenceType uaReferenceType, NodeId ... nodeIdArray) {
        if (nodeIdArray == null || nodeIdArray.length == 0) {
            return true;
        }
        for (NodeId nodeId : nodeIdArray) {
            if (uaReferenceType == null || !uaReferenceType.inheritsFrom(nodeId)) continue;
            return true;
        }
        return false;
    }
}

