/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.client.nodes;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.client.nodes.UaClientReference;
import com.prosysopc.ua.client.nodes.UaTypeImpl;
import com.prosysopc.ua.nodes.UaDataType;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.nodes.UaVariableType;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.AttributeWriteMask;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.NodeAttributes;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.VariableTypeAttributes;
import java.util.List;
import java.util.Locale;

public class UaVariableTypeImpl
extends UaTypeImpl
implements UaVariableType {
    private UaDataType fA;
    UnsignedInteger[] arrayDimensions = null;
    NodeId dataTypeId = Identifiers.BaseDataType;
    DataValue value;
    Integer valueRank = -2;

    public UaVariableTypeImpl(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    public UaVariableTypeImpl(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText, LocalizedText localizedText2, AttributeWriteMask attributeWriteMask, AttributeWriteMask attributeWriteMask2, UaClientReference[] uaClientReferenceArray, UaProperty[] uaPropertyArray, DataValue dataValue, NodeId nodeId2, Integer n2, UnsignedInteger[] unsignedIntegerArray, Boolean bl) {
        super(addressSpace, nodeId, qualifiedName, localizedText, localizedText2, attributeWriteMask, attributeWriteMask2, uaClientReferenceArray, uaPropertyArray, bl);
        this.value = dataValue;
        this.dataTypeId = nodeId2;
        this.valueRank = n2;
        this.arrayDimensions = unsignedIntegerArray;
    }

    public UaVariableTypeImpl(AddressSpace addressSpace, NodeId nodeId, String string, Locale locale) {
        this(addressSpace, nodeId, new QualifiedName(string), new LocalizedText(string, locale));
    }

    @Override
    public UnsignedInteger[] getArrayDimensions() {
        return this.arrayDimensions;
    }

    @Override
    public NodeAttributes getAttributes() {
        return this.getAttributes(new VariableTypeAttributes());
    }

    @Override
    public UaDataType getDataType() {
        return this.fA;
    }

    @Override
    public NodeId getDataTypeId() {
        return this.dataTypeId;
    }

    @Override
    public final NodeClass getNodeClass() {
        return NodeClass.VariableType;
    }

    @Override
    public DataValue getValue() {
        return this.value;
    }

    @Override
    public Integer getValueRank() {
        return this.valueRank;
    }

    @Override
    public void setArrayDimensions(UnsignedInteger[] unsignedIntegerArray) {
        this.arrayDimensions = unsignedIntegerArray;
    }

    @Override
    public void setAttribute(UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        if (unsignedInteger.equals(Attributes.Value)) {
            this.setValue(dataValue);
        } else {
            super.setAttribute(unsignedInteger, dataValue);
        }
    }

    public void setAttributes(VariableTypeAttributes variableTypeAttributes) {
        this.setArrayDimensions(variableTypeAttributes.getArrayDimensions());
        this.setDataTypeId(variableTypeAttributes.getDataType());
        this.setValue(new DataValue(new Variant(variableTypeAttributes.getValue())));
        this.setValueRank(variableTypeAttributes.getValueRank());
        this.setIsAbstract(variableTypeAttributes.getIsAbstract());
        super.setAttributes(variableTypeAttributes);
    }

    @Override
    public void setDataType(UaDataType uaDataType) {
        this.setDataTypeId(uaDataType.getNodeId());
        this.fA = uaDataType;
    }

    @Override
    public void setDataTypeId(NodeId nodeId) {
        this.dataTypeId = nodeId;
    }

    @Override
    public void setValue(DataValue dataValue) {
        this.value = dataValue;
    }

    @Override
    public void setValue(Object object) throws StatusException {
        DataValue dataValue;
        if (object instanceof DataValue) {
            dataValue = (DataValue)object;
        } else {
            Variant variant = object instanceof Variant ? (Variant)object : new Variant(object);
            dataValue = new DataValue(variant);
        }
        this.setValue(dataValue);
    }

    @Override
    public void setValueRank(int n2) {
        this.valueRank = n2;
    }

    @Override
    public boolean supportsAttribute(UnsignedInteger unsignedInteger) {
        if (unsignedInteger.equals(Attributes.Value)) {
            return this.value.getValue() != null;
        }
        if (unsignedInteger.equals(Attributes.ArrayDimensions)) {
            return this.arrayDimensions != null && this.arrayDimensions.length != 0;
        }
        return super.supportsAttribute(unsignedInteger);
    }

    @Override
    public String toString() {
        return super.toString() + String.format(", DataType=%s, ValueRank=%s, ArrayDimensions=%s, Value=%s", this.dataTypeId, this.valueRank, this.arrayDimensions, this.value);
    }

    protected VariableTypeAttributes getAttributes(VariableTypeAttributes variableTypeAttributes) {
        super.getAttributes(variableTypeAttributes);
        variableTypeAttributes.setArrayDimensions(this.getArrayDimensions());
        variableTypeAttributes.setDataType(this.getDataTypeId());
        variableTypeAttributes.setIsAbstract(this.getIsAbstract());
        variableTypeAttributes.setValue(this.getValue().getValue());
        variableTypeAttributes.setValueRank(this.getValueRank());
        return variableTypeAttributes;
    }

    @Override
    protected void initSupportedAttributes(List<UnsignedInteger> list) {
        super.initSupportedAttributes(list);
        list.add(Attributes.Value);
        list.add(Attributes.DataType);
        list.add(Attributes.ValueRank);
        list.add(Attributes.ArrayDimensions);
    }

    @Override
    protected void readAttributeValue(UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        if (unsignedInteger.equals(Attributes.DataType)) {
            dataValue.setValue(new Variant(this.dataTypeId));
        } else if (unsignedInteger.equals(Attributes.ValueRank)) {
            dataValue.setValue(new Variant(this.valueRank));
        } else if (unsignedInteger.equals(Attributes.Value)) {
            dataValue.setValue(this.getValue().getValue());
            dataValue.setSourceTimestamp(this.getValue().getSourceTimestamp());
            dataValue.setSourcePicoseconds(this.getValue().getSourcePicoseconds());
            dataValue.setServerTimestamp(this.getValue().getServerTimestamp());
            dataValue.setServerPicoseconds(this.getValue().getServerPicoseconds());
            dataValue.setStatusCode(this.getValue().getStatusCode());
        } else if (unsignedInteger.equals(Attributes.ArrayDimensions)) {
            if (this.arrayDimensions == null || this.arrayDimensions.length == 0) {
                throw new StatusException(StatusCodes.Bad_AttributeIdInvalid);
            }
            dataValue.setValue(new Variant(this.arrayDimensions));
        } else {
            super.readAttributeValue(unsignedInteger, dataValue);
        }
    }

    @Override
    protected void writeAttributeValue(UnsignedInteger unsignedInteger, Object object, StatusCode statusCode, DateTime dateTime, UnsignedShort unsignedShort) throws StatusException {
        block11: {
            try {
                if (unsignedInteger.equals(Attributes.DataType)) {
                    if (object instanceof NodeId) {
                        this.setDataTypeId((NodeId)object);
                        break block11;
                    }
                    if (object instanceof ExpandedNodeId) {
                        try {
                            this.setDataTypeId(this.addressSpace.getNamespaceTable().toNodeId((ExpandedNodeId)object));
                            break block11;
                        }
                        catch (ServiceResultException serviceResultException) {
                            throw new StatusException(serviceResultException);
                        }
                    }
                    throw new StatusException("Cannot set NodeId to the specified value", StatusCodes.Bad_InvalidArgument);
                }
                if (unsignedInteger.equals(Attributes.ValueRank)) {
                    this.valueRank = (Integer)object;
                } else if (unsignedInteger.equals(Attributes.ArrayDimensions)) {
                    this.arrayDimensions = (UnsignedInteger[])object;
                } else {
                    super.writeAttributeValue(unsignedInteger, object, statusCode, dateTime, unsignedShort);
                }
            }
            catch (RuntimeException runtimeException) {
                throw new StatusException("Cannot write value", StatusCodes.Bad_InvalidArgument, null, (Throwable)runtimeException);
            }
        }
    }
}

