/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.client.nodes;

import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.nodes.UaReferenceType;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UaClientReference
extends UaReference {
    private static Logger logger = LoggerFactory.getLogger(UaClientReference.class);
    private final AddressSpace addressSpace;
    private final NodeId referenceTypeId;
    private final ExpandedNodeId fl;
    private final ExpandedNodeId targetId;

    public UaClientReference(NodeId nodeId, ExpandedNodeId expandedNodeId, ExpandedNodeId expandedNodeId2, AddressSpace addressSpace) {
        this.referenceTypeId = nodeId;
        this.targetId = expandedNodeId2;
        this.fl = expandedNodeId;
        this.addressSpace = addressSpace;
    }

    public UaClientReference(NodeId nodeId, UaNode uaNode, UaNode uaNode2, AddressSpace addressSpace) {
        this(nodeId, new ExpandedNodeId(uaNode.getNodeId()), new ExpandedNodeId(uaNode2.getNodeId()), addressSpace);
    }

    @Override
    public void delete() {
        UaNode uaNode = this.getSourceNode();
        UaNode uaNode2 = this.getTargetNode();
        if (uaNode != null) {
            uaNode.deleteReference(this);
        }
        if (uaNode2 != null) {
            uaNode2.deleteReference(this);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UaClientReference uaClientReference = (UaClientReference)object;
        if (this.targetId == null ? uaClientReference.targetId != null : !this.addressSpace.getNamespaceTable().nodeIdEquals(this.targetId, uaClientReference.targetId)) {
            return false;
        }
        if (this.fl == null ? uaClientReference.fl != null : !this.addressSpace.getNamespaceTable().nodeIdEquals(this.fl, uaClientReference.fl)) {
            return false;
        }
        return !(this.referenceTypeId == null ? uaClientReference.referenceTypeId != null : !this.referenceTypeId.equals(uaClientReference.referenceTypeId));
    }

    @Override
    public boolean getIsInverse(NodeId nodeId) {
        logger.debug("getIsInverse: nodeId={} sourceId={} targetId={}", new Object[]{nodeId, this.fl, this.targetId});
        if (this.addressSpace.getNamespaceTable().nodeIdEquals(nodeId, this.fl)) {
            return false;
        }
        if (this.addressSpace.getNamespaceTable().nodeIdEquals(nodeId, this.targetId)) {
            return true;
        }
        throw new RuntimeException("getIsInverse() called from non-related node");
    }

    @Override
    public boolean getIsInverse(UaNode uaNode) {
        return this.getIsInverse(uaNode.getNodeId());
    }

    @Override
    public UaReferenceType getReferenceType() {
        UaNode uaNode = this.g(this.referenceTypeId);
        if (uaNode instanceof UaReferenceType) {
            return (UaReferenceType)uaNode;
        }
        return null;
    }

    @Override
    public NodeId getReferenceTypeId() {
        return this.referenceTypeId;
    }

    @Override
    public ExpandedNodeId getSourceId() {
        return this.fl;
    }

    @Override
    public UaNode getSourceNode() {
        UaNode uaNode = this.b(this.fl);
        return uaNode;
    }

    @Override
    public ExpandedNodeId getTargetId() {
        return this.targetId;
    }

    @Override
    public UaNode getTargetNode() {
        UaNode uaNode = this.b(this.targetId);
        return uaNode;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.referenceTypeId == null ? 0 : this.referenceTypeId.hashCode());
        n3 = 31 * n3 + (this.targetId == null ? 0 : this.targetId.hashCode());
        n3 = 31 * n3 + (this.fl == null ? 0 : this.fl.hashCode());
        return n3;
    }

    @Override
    public String toString() {
        UaReferenceType uaReferenceType;
        StringBuilder stringBuilder = new StringBuilder("");
        UaReferenceType uaReferenceType2 = uaReferenceType = this.addressSpace.getClient().isConnected() ? this.getReferenceType() : null;
        if (uaReferenceType != null) {
            stringBuilder.append(" ReferenceType=");
            stringBuilder.append(uaReferenceType.getBrowseName());
        } else {
            stringBuilder.append(" ReferenceTypeId=");
            stringBuilder.append(this.getReferenceTypeId());
        }
        stringBuilder.append(" SourceId=");
        stringBuilder.append(this.getSourceId());
        stringBuilder.append(" TargetId=");
        stringBuilder.append(this.getTargetId());
        return stringBuilder.toString();
    }

    private UaNode b(ExpandedNodeId expandedNodeId) {
        try {
            return this.g(this.addressSpace.getNamespaceTable().toNodeId(expandedNodeId));
        }
        catch (Exception exception) {
            logger.warn("Unable to retrieve node from AddressSpace: ", (Throwable)exception);
            return null;
        }
    }

    private UaNode g(NodeId nodeId) {
        try {
            return this.addressSpace.getNode(nodeId);
        }
        catch (Exception exception) {
            logger.warn("Unable to retrieve node from AddressSpace: ", (Throwable)exception);
            return null;
        }
    }
}

