/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.client;

import com.prosysopc.ua.MethodCallStatusException;
import com.prosysopc.ua.MonitoredItemBase;
import com.prosysopc.ua.OperationLimits;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.SubscriptionBase;
import com.prosysopc.ua.client.MonitoredDataItem;
import com.prosysopc.ua.client.MonitoredEventItem;
import com.prosysopc.ua.client.MonitoredItem;
import com.prosysopc.ua.client.ServerConnectionException;
import com.prosysopc.ua.client.SubscriptionAliveListener;
import com.prosysopc.ua.client.SubscriptionNotificationListener;
import com.prosysopc.ua.client.UaClient;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.ServiceResponse;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.common.ServiceFaultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.CreateMonitoredItemsResponse;
import com.prosysopc.ua.stack.core.DataChangeNotification;
import com.prosysopc.ua.stack.core.DeleteMonitoredItemsResponse;
import com.prosysopc.ua.stack.core.EventFieldList;
import com.prosysopc.ua.stack.core.EventNotificationList;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.ModifyMonitoredItemsResponse;
import com.prosysopc.ua.stack.core.MonitoredItemCreateRequest;
import com.prosysopc.ua.stack.core.MonitoredItemCreateResult;
import com.prosysopc.ua.stack.core.MonitoredItemModifyRequest;
import com.prosysopc.ua.stack.core.MonitoredItemModifyResult;
import com.prosysopc.ua.stack.core.MonitoredItemNotification;
import com.prosysopc.ua.stack.core.MonitoringFilterResult;
import com.prosysopc.ua.stack.core.MonitoringMode;
import com.prosysopc.ua.stack.core.MonitoringParameters;
import com.prosysopc.ua.stack.core.NotificationData;
import com.prosysopc.ua.stack.core.PublishResponse;
import com.prosysopc.ua.stack.core.ReadValueId;
import com.prosysopc.ua.stack.core.RepublishResponse;
import com.prosysopc.ua.stack.core.ResponseHeader;
import com.prosysopc.ua.stack.core.SetMonitoringModeResponse;
import com.prosysopc.ua.stack.core.StatusChangeNotification;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.SubscriptionAcknowledgement;
import com.prosysopc.ua.stack.core.TimestampsToReturn;
import com.prosysopc.ua.stack.core.TransferSubscriptionsResponse;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.utils.AttributesUtil;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.stack.utils.NumericRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Subscription
extends SubscriptionBase {
    private static final ExtensionObject[] dH = new ExtensionObject[0];
    private static final long dI = UnsignedInteger.MAX_VALUE.longValue() / 2L;
    private static final Logger logger = LoggerFactory.getLogger(Subscription.class);
    private final List<SubscriptionAliveListener> dJ = new CopyOnWriteArrayList<SubscriptionAliveListener>();
    private volatile UaClient cs;
    private DiagnosticInfo diagnosticInfo;
    private volatile Calendar dK;
    private DiagnosticInfo[] dL;
    private volatile UnsignedInteger dM = UnsignedInteger.ZERO;
    private ResponseHeader dN;
    private final AtomicReference<a> dO = new AtomicReference();
    private int dP = -1;
    private int dQ = 100;
    private final List<SubscriptionNotificationListener> dR = new CopyOnWriteArrayList<SubscriptionNotificationListener>();
    private final ConcurrentSkipListMap<UnsignedInteger, ExtensionObject[]> dS = new ConcurrentSkipListMap();
    private boolean dT = true;
    private StatusCode status = StatusCode.GOOD;
    private volatile boolean dU;
    private volatile boolean dV = true;
    private double dW = 1.1;
    private double dX = 1.3;
    private TimestampsToReturn timestampsToReturn = TimestampsToReturn.Source;
    protected boolean modified;

    public Subscription() {
        this(true, 1000.0, 60L, 20L, 0L, 0);
    }

    public Subscription(Boolean bl, Double d2, long l2, long l3, long l4, int n2) {
        super(null, bl, d2, UnsignedInteger.valueOf(l2), UnsignedInteger.valueOf(l3), UnsignedInteger.valueOf(l4), UnsignedByte.valueOf(n2));
    }

    public Subscription(UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2, UnsignedInteger unsignedInteger3, Double d2, Boolean bl, UnsignedByte unsignedByte) {
        super(null, bl, d2, unsignedInteger2, unsignedInteger3, unsignedInteger, unsignedByte);
    }

    public void addAliveListener(SubscriptionAliveListener subscriptionAliveListener) {
        if (!this.hasAliveListener(subscriptionAliveListener)) {
            this.dJ.add(subscriptionAliveListener);
        }
    }

    public MonitoredItemCreateResult addItem(MonitoredItem monitoredItem) throws ServiceException, StatusException {
        this.addItem(monitoredItem, monitoredItem.getClientHandle());
        monitoredItem.a(this);
        try {
            CreateMonitoredItemsResponse createMonitoredItemsResponse = this.createMonitoredItems(monitoredItem);
            if (createMonitoredItemsResponse != null && createMonitoredItemsResponse.getResults() != null && createMonitoredItemsResponse.getResults().length >= 1) {
                if (createMonitoredItemsResponse.getResults().length > 1 && logger.isWarnEnabled()) {
                    logger.warn("Got more than one CreateMonitoredItemResponse for one added item: {}, results: {}", (Object)monitoredItem, (Object)MultiDimensionArrayUtils.toString(createMonitoredItemsResponse.getResults()));
                }
                this.cs.checkOperationResult(createMonitoredItemsResponse.getResults()[0].getStatusCode());
                return createMonitoredItemsResponse.getResults()[0];
            }
        }
        catch (ServiceException serviceException) {
            throw serviceException;
        }
        catch (StatusException statusException) {
            throw statusException;
        }
        return null;
    }

    public MonitoredItemCreateResult[] addItems(MonitoredItem ... monitoredItemArray) throws ServiceException {
        for (int i2 = 0; i2 < monitoredItemArray.length; ++i2) {
            this.addItem(monitoredItemArray[i2], monitoredItemArray[i2].getClientHandle());
            monitoredItemArray[i2].a(this);
        }
        CreateMonitoredItemsResponse createMonitoredItemsResponse = this.createMonitoredItems(monitoredItemArray);
        if (createMonitoredItemsResponse != null) {
            return createMonitoredItemsResponse.getResults();
        }
        return null;
    }

    public void addNotificationListener(SubscriptionNotificationListener subscriptionNotificationListener) {
        if (!this.hasNotificationListener(subscriptionNotificationListener)) {
            this.dR.add(subscriptionNotificationListener);
        }
    }

    public void conditionRefresh() throws MethodCallStatusException, ServiceException {
        this.cs.call(Identifiers.Server, Identifiers.ConditionType_ConditionRefresh, new Variant(this.getSubscriptionId()));
    }

    public double getAliveDetectionFactor() {
        return this.dW;
    }

    public SubscriptionAliveListener[] getAliveListeners() {
        return this.dJ.toArray(new SubscriptionAliveListener[this.dJ.size()]);
    }

    public UnsignedInteger[] getAvailableSequenceNumbers() {
        List<UnsignedInteger> list = this.getAvailableSequenceNumbersList();
        return list.toArray(new UnsignedInteger[list.size()]);
    }

    public UaClient getClient() {
        return this.cs;
    }

    public DiagnosticInfo getDiagnosticInfo() {
        return this.diagnosticInfo;
    }

    @Override
    public MonitoredItem getItem(NodeId nodeId, UnsignedInteger unsignedInteger) {
        return (MonitoredItem)super.getItem(nodeId, unsignedInteger);
    }

    public Calendar getLastAlive() {
        return this.dK;
    }

    public DiagnosticInfo[] getLastOperationDiagnostics() {
        return this.dL;
    }

    public UnsignedInteger getLastSequenceNumber() {
        return this.dM;
    }

    public DiagnosticInfo getLastServiceDiagnostics() {
        return this.dN.getServiceDiagnostics();
    }

    public StatusCode getLastServiceResult() {
        return this.dN.getServiceResult();
    }

    public int getMaxMonitoredItemsPerCall() {
        if (this.dP < 0) {
            return this.V();
        }
        return this.dP;
    }

    public int getNotificationBufferSize() {
        return this.dQ;
    }

    public SubscriptionNotificationListener[] getNotificationListeners() {
        return this.dR.toArray(new SubscriptionNotificationListener[this.dR.size()]);
    }

    public StatusCode getStatus() {
        return this.status;
    }

    public double getTimeoutDetectionFactor() {
        return this.dX;
    }

    public TimestampsToReturn getTimestampsToReturn() {
        return this.timestampsToReturn;
    }

    public boolean hasAliveListener(SubscriptionAliveListener subscriptionAliveListener) {
        if (subscriptionAliveListener == null) {
            throw new NullPointerException("null listener not allowed");
        }
        return this.dJ.contains(subscriptionAliveListener);
    }

    public boolean hasNotificationListener(SubscriptionNotificationListener subscriptionNotificationListener) {
        if (subscriptionNotificationListener == null) {
            throw new NullPointerException("null listener not allowed");
        }
        return this.dR.contains(subscriptionNotificationListener);
    }

    public boolean isAlive() {
        return this.dV;
    }

    public boolean isConnected() {
        UnsignedInteger unsignedInteger = this.getSubscriptionId();
        return unsignedInteger != null && !unsignedInteger.equals(UnsignedInteger.ZERO);
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isRetransmissionEnabled() {
        return this.dT;
    }

    public boolean isTimeout() {
        return this.dU;
    }

    public String itemsToString() {
        return this.items.toString();
    }

    public DataValue[] readAll(Double d2, TimestampsToReturn timestampsToReturn) throws ServiceException {
        MonitoredItemBase[] monitoredItemBaseArray = this.getItems();
        ReadValueId[] readValueIdArray = new ReadValueId[monitoredItemBaseArray.length];
        for (int i2 = 0; i2 < monitoredItemBaseArray.length; ++i2) {
            if (!(monitoredItemBaseArray[i2] instanceof MonitoredDataItem)) continue;
            MonitoredDataItem monitoredDataItem = (MonitoredDataItem)monitoredItemBaseArray[i2];
            readValueIdArray[i2] = new ReadValueId(monitoredDataItem.getNodeId(), monitoredDataItem.getAttributeId(), NumericRange.toString(monitoredDataItem.getIndexRange()), monitoredDataItem.getDataEncoding());
        }
        return this.cs.read(d2, timestampsToReturn, readValueIdArray).getResults();
    }

    public void removeAliveListener(SubscriptionAliveListener subscriptionAliveListener) {
        this.dJ.remove(subscriptionAliveListener);
    }

    @Override
    public MonitoredItemBase removeItem(MonitoredItemBase monitoredItemBase) throws ServiceException, StatusException {
        logger.debug("removeItem: {}", (Object)monitoredItemBase);
        return this.removeItem(monitoredItemBase.getClientHandle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MonitoredItemBase removeItem(UnsignedInteger unsignedInteger) throws ServiceException, StatusException {
        MonitoredItemBase monitoredItemBase = super.removeItem(unsignedInteger);
        try {
            DeleteMonitoredItemsResponse deleteMonitoredItemsResponse;
            DeleteMonitoredItemsResponse deleteMonitoredItemsResponse2 = deleteMonitoredItemsResponse = monitoredItemBase == null ? null : this.deleteMonitoredItems(monitoredItemBase);
            if (deleteMonitoredItemsResponse != null && deleteMonitoredItemsResponse.getResults()[0].isBad()) {
                throw new StatusException(deleteMonitoredItemsResponse.getResults()[0]);
            }
        }
        finally {
            if (monitoredItemBase != null) {
                ((MonitoredItem)monitoredItemBase).setMonitoredItemId(UnsignedInteger.ZERO);
            }
        }
        return monitoredItemBase;
    }

    public StatusCode[] removeItems() throws ServiceException {
        return this.removeItems(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatusCode[] removeItems(MonitoredItemBase ... monitoredItemBaseArray) throws ServiceException {
        StatusCode[] statusCodeArray = null;
        if (monitoredItemBaseArray == null) {
            monitoredItemBaseArray = this.getItems();
        }
        for (MonitoredItemBase object : monitoredItemBaseArray) {
            try {
                if (null == object) continue;
                super.removeItem(object.getClientHandle());
            }
            catch (StatusException statusException) {
                // empty catch block
            }
        }
        try {
            DeleteMonitoredItemsResponse deleteMonitoredItemsResponse = this.deleteMonitoredItems(monitoredItemBaseArray);
            if (deleteMonitoredItemsResponse != null) {
                statusCodeArray = deleteMonitoredItemsResponse.getResults();
            }
        }
        finally {
            for (MonitoredItemBase monitoredItemBase : monitoredItemBaseArray) {
                if (null == monitoredItemBase) continue;
                ((MonitoredItem)monitoredItemBase).setMonitoredItemId(UnsignedInteger.ZERO);
            }
        }
        return statusCodeArray;
    }

    public void removeNotificationListener(SubscriptionNotificationListener subscriptionNotificationListener) {
        this.dR.remove(subscriptionNotificationListener);
    }

    public void republishAllAvailable() throws ServiceException {
        StatusCode statusCode = StatusCode.GOOD;
        UnsignedInteger unsignedInteger = this.dM;
        while (statusCode.isGood()) {
            unsignedInteger = this.dM;
            long l2 = unsignedInteger.longValue() + 1L;
            if (l2 > 0xFFFFFFFFL) {
                l2 = 1L;
            }
            statusCode = this.a(l2, false);
        }
        if (!statusCode.getValue().equals(StatusCodes.Bad_MessageNotAvailable)) {
            throw new ServiceException(statusCode);
        }
        this.dM = unsignedInteger;
    }

    public void setAliveDetectionFactor(double d2) {
        if (d2 <= 1.0) {
            throw new IllegalArgumentException("aliveDetectionFactor must be greater than 1");
        }
        this.dW = d2;
    }

    public void setMaxMonitoredItemsPerCall(int n2) {
        this.dP = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMonitoringMode(MonitoringMode monitoringMode) throws ServiceException {
        this.beginUpdate();
        try {
            for (MonitoredItemBase monitoredItemBase : this.items.values()) {
                monitoredItemBase.setMonitoringMode(monitoringMode);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void setNotificationBufferSize(int n2) {
        this.dQ = n2;
    }

    @Override
    public void setPublishingInterval(long l2, TimeUnit timeUnit) throws ServiceException {
        super.setPublishingInterval(l2, timeUnit);
    }

    public void setRetransmissionEnabled(boolean bl) {
        this.dT = bl;
    }

    public void setTimeoutDetectionFactor(double d2) {
        if (d2 <= 1.0) {
            throw new IllegalArgumentException("timeoutDetectionFactor must be greater than 1");
        }
        this.dX = d2;
    }

    public void setTimestampsToReturn(TimestampsToReturn timestampsToReturn) {
        this.timestampsToReturn = timestampsToReturn;
    }

    public void transferTo(UaClient uaClient) throws ServiceException, StatusException {
        UnsignedInteger unsignedInteger = this.getSubscriptionId();
        this.transferTo(uaClient, unsignedInteger);
    }

    public void transferTo(UaClient uaClient, UnsignedInteger unsignedInteger) throws ServiceException, StatusException {
        if (this.cs != uaClient) {
            if (this.isConnected()) {
                if (uaClient.isConnected()) {
                    TransferSubscriptionsResponse transferSubscriptionsResponse;
                    UnsignedInteger[] unsignedIntegerArray = new UnsignedInteger[]{unsignedInteger};
                    try {
                        transferSubscriptionsResponse = uaClient.u().TransferSubscriptions(uaClient.getRequestHeader(), unsignedIntegerArray, true);
                    }
                    catch (ServiceFaultException serviceFaultException) {
                        throw new ServiceException(serviceFaultException);
                    }
                    catch (ServiceResultException serviceResultException) {
                        throw new ServiceException(serviceResultException);
                    }
                    this.checkServiceResult(transferSubscriptionsResponse, transferSubscriptionsResponse.getDiagnosticInfos());
                    this.checkOperationResult(transferSubscriptionsResponse.getResults()[0].getStatusCode());
                    this.setAvailableSequenceNumbers(transferSubscriptionsResponse.getResults()[0].getAvailableSequenceNumbers());
                }
                if (this.cs != null) {
                    this.cs.eU.remove(this);
                }
                uaClient.eU.add(this);
            }
            this.setClient(uaClient);
        }
    }

    public void updateItems() throws ServiceException {
        ArrayList<MonitoredItem> arrayList = new ArrayList<MonitoredItem>();
        for (MonitoredItemBase monitoredItemBase : this.items.values()) {
            MonitoredItem monitoredItem = (MonitoredItem)monitoredItemBase;
            if (!monitoredItem.isModified()) continue;
            arrayList.add(monitoredItem);
        }
        this.modifyMonitoredItems(arrayList);
        for (MonitoredItem monitoredItem : arrayList) {
            monitoredItem.clearModified();
        }
    }

    public void updateMonitoringModes() throws ServiceException {
        for (MonitoringMode monitoringMode : MonitoringMode.values()) {
            ArrayList<MonitoredItem> arrayList = new ArrayList<MonitoredItem>();
            for (MonitoredItemBase monitoredItemBase : this.items.values()) {
                MonitoredItem monitoredItem = (MonitoredItem)monitoredItemBase;
                if (!monitoredItem.isMonitoringModeModified() || !monitoredItem.getMonitoringMode().equals(monitoringMode)) continue;
                arrayList.add(monitoredItem);
            }
            this.setMonitoringMode(monitoringMode, arrayList);
            for (MonitoredItem monitoredItem : arrayList) {
                monitoredItem.clearModified();
            }
        }
    }

    private void acknowledge(UnsignedInteger unsignedInteger) {
        logger.debug("acknowledge: requestedSeqNumber={}", (Object)unsignedInteger);
        UaClient uaClient = this.getClient();
        if (uaClient != null) {
            uaClient.addSubscriptionAck(new SubscriptionAcknowledgement(this.getSubscriptionId(), unsignedInteger));
        }
        logger.debug("acknowledge: availableSequenceNumbers={}", this.getAvailableSequenceNumbersList());
    }

    private StatusCode a(long l2, boolean bl) {
        StatusCode statusCode;
        ExtensionObject[] extensionObjectArray;
        this.dM = this.dM.add(1);
        if (bl && !this.getAvailableSequenceNumbersList().contains(this.dM)) {
            logger.info("Missing NotificationMessage (SequenceNumber={})  no longer available from server.  Target SequenceNumber={}", (Object)this.dM, (Object)l2);
            this.fireMissingData(this.dM, l2, 0L, null);
            return StatusCode.GOOD;
        }
        UnsignedInteger unsignedInteger = this.dM;
        logger.info("Requesting missing NotificationMessage (SequenceNumber={}) from the server using Republish: Target SequenceNumber={}", (Object)unsignedInteger, (Object)l2);
        RepublishResponse republishResponse = null;
        try {
            extensionObjectArray = this.cs.u();
            if (extensionObjectArray == null) {
                return new StatusCode(StatusCodes.Bad_NotConnected);
            }
            republishResponse = extensionObjectArray.Republish(this.cs.getRequestHeader(), this.getSubscriptionId(), this.dM);
            statusCode = republishResponse.getResponseHeader().getServiceResult();
        }
        catch (ServiceResultException serviceResultException) {
            statusCode = serviceResultException.getStatusCode();
        }
        if (statusCode.isBad()) {
            logger.debug("Republish failed: Error={}", (Object)statusCode);
        } else if (logger.isDebugEnabled()) {
            logger.debug("Republish: serviceResult={}", (Object)statusCode);
        }
        if (statusCode.getValue().equals(StatusCodes.Bad_MessageNotAvailable)) {
            logger.info("Message not available");
            long l3 = (l2 + this.dM.longValue()) / 2L;
            if (bl) {
                this.a(l2, l3, statusCode);
            }
            this.dK = Calendar.getInstance();
            return statusCode;
        }
        if (republishResponse == null) {
            logger.info("Failed to get a response to Republish (SequenceNumber={}): Error={}", (Object)unsignedInteger, (Object)statusCode);
            if (bl) {
                this.a(l2, this.dM.longValue() + 1L, statusCode);
            }
            return statusCode;
        }
        if (!unsignedInteger.equals(republishResponse.getNotificationMessage().getSequenceNumber())) {
            logger.info("Received SequenceNumber ({}) for Republish is different than the one requested ({})", (Object)republishResponse.getNotificationMessage().getSequenceNumber(), (Object)unsignedInteger);
        }
        if ((extensionObjectArray = republishResponse.getNotificationMessage().getNotificationData()) != null && extensionObjectArray.length > 0) {
            if (this.cs.getListener() == null || this.cs.getListener().validateRepublishResponse(this.cs, republishResponse)) {
                this.a(extensionObjectArray);
            } else {
                logger.info("NotificationData returned for Republish (SequenceNumber={}) is not valid, ignoring", (Object)unsignedInteger);
            }
        } else if (republishResponse.getResponseHeader().getServiceResult().isGood()) {
            logger.warn("NotificationData returned for Republish (SequenceNumber={}) is empty", (Object)unsignedInteger);
        }
        this.acknowledge(unsignedInteger);
        this.dK = Calendar.getInstance();
        return StatusCode.GOOD;
    }

    private MonitoringFilterResult a(MonitoredItem monitoredItem, ExtensionObject extensionObject) {
        MonitoringFilterResult monitoringFilterResult = null;
        if (extensionObject != null) {
            try {
                monitoringFilterResult = (MonitoringFilterResult)extensionObject.decode(this.cs.getEncoderContext());
            }
            catch (DecodingException decodingException) {
                logger.info("Cannot decode FilterResult of item " + monitoredItem.getNodeId(), (Throwable)decodingException);
            }
        }
        return monitoringFilterResult;
    }

    private CreateMonitoredItemsResponse a(MonitoredItemBase ... monitoredItemBaseArray) throws ServiceException {
        CreateMonitoredItemsResponse createMonitoredItemsResponse;
        Object object;
        MonitoredItemCreateResult[] monitoredItemCreateResultArray;
        MonitoredItemCreateRequest[] monitoredItemCreateRequestArray = new MonitoredItemCreateRequest[monitoredItemBaseArray.length];
        for (int i2 = 0; i2 < monitoredItemBaseArray.length; ++i2) {
            monitoredItemCreateResultArray = monitoredItemBaseArray[i2];
            ReadValueId readValueId = new ReadValueId(monitoredItemCreateResultArray.getNodeId(), monitoredItemCreateResultArray.getAttributeId(), NumericRange.toString(monitoredItemCreateResultArray.getIndexRange()), monitoredItemCreateResultArray.getDataEncoding());
            object = this.getMonitoringParameters((MonitoredItemBase)monitoredItemCreateResultArray);
            monitoredItemCreateRequestArray[i2] = new MonitoredItemCreateRequest(readValueId, monitoredItemCreateResultArray.getMonitoringMode(), (MonitoringParameters)object);
        }
        try {
            createMonitoredItemsResponse = this.cs.u().CreateMonitoredItems(this.cs.getRequestHeader(), this.getSubscriptionId(), this.getTimestampsToReturn(), monitoredItemCreateRequestArray);
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
        this.checkServiceResult(createMonitoredItemsResponse, createMonitoredItemsResponse.getDiagnosticInfos());
        monitoredItemCreateResultArray = createMonitoredItemsResponse.getResults();
        if (monitoredItemCreateResultArray == null || monitoredItemCreateResultArray.length == 0) {
            throw new ServiceException("The server returned empty Results for the call", StatusCodes.Bad_UnexpectedError);
        }
        if (monitoredItemCreateResultArray.length < monitoredItemBaseArray.length) {
            logger.warn("Received fewer MonitoredItemCreateResults than expected, got {} while expecting {}", (Object)monitoredItemCreateResultArray.length, (Object)monitoredItemBaseArray.length);
        }
        if (monitoredItemCreateResultArray.length > monitoredItemBaseArray.length) {
            logger.warn("Received more MonitoredItemCreateResults than expected, got {} while expecting {}", (Object)monitoredItemCreateResultArray.length, (Object)monitoredItemBaseArray.length);
        }
        for (int i3 = 0; i3 < monitoredItemBaseArray.length; ++i3) {
            object = (MonitoredItem)monitoredItemBaseArray[i3];
            if (i3 < monitoredItemCreateResultArray.length) {
                MonitoredItemCreateResult monitoredItemCreateResult = monitoredItemCreateResultArray[i3];
                UnsignedInteger unsignedInteger = monitoredItemCreateResult.getMonitoredItemId();
                logger.debug("createMonitoredItems: i={}, monitoredItemId={}, resultStatus={}", new Object[]{i3, unsignedInteger, monitoredItemCreateResult.getStatusCode()});
                ((MonitoredItem)object).setMonitoredItemId(unsignedInteger);
                MonitoringFilterResult monitoringFilterResult = this.a((MonitoredItem)object, monitoredItemCreateResult.getFilterResult());
                ((MonitoredItem)object).setErrorCode(monitoredItemCreateResult.getStatusCode());
                ((MonitoredItem)object).setFilterResult(monitoringFilterResult);
                ((MonitoredItem)object).setRevisedQueueSize(monitoredItemCreateResult.getRevisedQueueSize());
                if (!(object instanceof MonitoredDataItem)) continue;
                MonitoredDataItem monitoredDataItem = (MonitoredDataItem)object;
                monitoredDataItem.setRevisedSamplingInterval(monitoredItemCreateResult.getRevisedSamplingInterval());
                continue;
            }
            ((MonitoredItem)object).setErrorCode(new StatusCode(StatusCodes.Bad_UnexpectedError));
        }
        return createMonitoredItemsResponse;
    }

    private DeleteMonitoredItemsResponse b(MonitoredItemBase ... monitoredItemBaseArray) throws ServiceException {
        DeleteMonitoredItemsResponse deleteMonitoredItemsResponse;
        UnsignedInteger[] unsignedIntegerArray = new UnsignedInteger[monitoredItemBaseArray.length];
        for (int i2 = 0; i2 < monitoredItemBaseArray.length; ++i2) {
            unsignedIntegerArray[i2] = monitoredItemBaseArray[i2].getMonitoredItemId();
        }
        try {
            logger.debug("DeleteMonitoredItems");
            deleteMonitoredItemsResponse = this.cs.u().DeleteMonitoredItems(this.cs.getRequestHeader(), this.getSubscriptionId(), unsignedIntegerArray);
            logger.debug("DeleteMonitoredItems: response={}", (Object)deleteMonitoredItemsResponse);
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
        this.checkServiceResult(deleteMonitoredItemsResponse, deleteMonitoredItemsResponse.getDiagnosticInfos());
        return deleteMonitoredItemsResponse;
    }

    private boolean a(long l2, long l3, StatusCode statusCode) {
        logger.debug("doMissingData: newSequenceNumber={}", (Object)l3);
        long l4 = this.fireMissingData(this.dM, l2, l3, statusCode);
        if (l4 > 0L && l4 != l3 && l4 < l2) {
            l3 = l4;
            logger.debug("doMissingData: (modified) newSequenceNumber={}", (Object)l3);
        }
        if (l3 >= l2) {
            logger.debug("doMissingData: break; newSequenceNumber >= sequenceNumber");
            return false;
        }
        this.dM = UnsignedInteger.valueOf(l3);
        return true;
    }

    private ModifyMonitoredItemsResponse c(List<MonitoredItem> list) throws ServiceException {
        ModifyMonitoredItemsResponse modifyMonitoredItemsResponse;
        MonitoredItemModifyRequest[] monitoredItemModifyRequestArray = new MonitoredItemModifyRequest[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            MonitoredItemBase monitoredItemBase = list.get(i2);
            monitoredItemModifyRequestArray[i2] = new MonitoredItemModifyRequest(monitoredItemBase.getMonitoredItemId(), this.getMonitoringParameters(monitoredItemBase));
        }
        try {
            modifyMonitoredItemsResponse = this.cs.u().ModifyMonitoredItems(this.cs.getRequestHeader(), this.getSubscriptionId(), this.getTimestampsToReturn(), monitoredItemModifyRequestArray);
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
        this.checkServiceResult(modifyMonitoredItemsResponse, modifyMonitoredItemsResponse.getDiagnosticInfos());
        for (int i3 = 0; i3 < list.size(); ++i3) {
            MonitoredItem monitoredItem = list.get(i3);
            MonitoredItemModifyResult monitoredItemModifyResult = modifyMonitoredItemsResponse.getResults()[i3];
            UnsignedInteger unsignedInteger = monitoredItem.getMonitoredItemId();
            logger.debug("monitoredItemId={}", (Object)unsignedInteger);
            monitoredItem.setFilterResult(this.a(monitoredItem, monitoredItemModifyResult.getFilterResult()));
            monitoredItem.setQueueSize(monitoredItemModifyResult.getRevisedQueueSize());
            if (!(monitoredItem instanceof MonitoredDataItem)) continue;
            MonitoredDataItem monitoredDataItem = (MonitoredDataItem)monitoredItem;
            monitoredDataItem.setSamplingInterval(monitoredItemModifyResult.getRevisedSamplingInterval());
        }
        return modifyMonitoredItemsResponse;
    }

    private void c(long l2) throws ServerConnectionException, ServiceException {
        if (this.isRetransmissionEnabled() && this.isConnected()) {
            StatusCode statusCode;
            while (this.dM != null && this.dM.longValue() < l2 && !(statusCode = this.a(l2, true)).isBad()) {
            }
        } else if (this.dM != null && this.dM.longValue() < l2) {
            this.a(l2, 0L, null);
        }
    }

    private SetMonitoringModeResponse a(MonitoringMode monitoringMode, List<MonitoredItem> list) throws ServiceException {
        SetMonitoringModeResponse setMonitoringModeResponse;
        UnsignedInteger[] unsignedIntegerArray = new UnsignedInteger[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            MonitoredItemBase monitoredItemBase = list.get(i2);
            unsignedIntegerArray[i2] = monitoredItemBase.getMonitoredItemId();
        }
        try {
            setMonitoringModeResponse = this.cs.u().SetMonitoringMode(this.cs.getRequestHeader(), this.getSubscriptionId(), monitoringMode, unsignedIntegerArray);
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
        this.checkServiceResult(setMonitoringModeResponse, setMonitoringModeResponse.getDiagnosticInfos());
        for (int i3 = 0; i3 < list.size(); ++i3) {
            MonitoredItemBase monitoredItemBase = list.get(i3);
            monitoredItemBase.setMonitoringMode(monitoringMode);
        }
        return setMonitoringModeResponse;
    }

    private Date U() {
        Calendar calendar = this.dK;
        Date date = calendar == null ? null : calendar.getTime();
        return date;
    }

    private int V() {
        int n2 = 0;
        OperationLimits operationLimits = this.getOperationLimits();
        if (operationLimits != null) {
            try {
                n2 = operationLimits.getMaxMonitoredItemsPerCall().intValue();
            }
            catch (Exception exception) {
                logger.debug("operationLimits", (Throwable)exception);
            }
        }
        logger.debug("getMaxMonitoredItemsPerCall={}", (Object)n2);
        return n2;
    }

    private OperationLimits getOperationLimits() {
        return this.cs.getActualOperationLimits();
    }

    private void a(ExtensionObject[] extensionObjectArray) {
        UaClient uaClient = this.cs;
        if (uaClient == null) {
            logger.debug("handleNotificationData: client is null, therefore skipping handling");
            return;
        }
        EncoderContext encoderContext = uaClient.getEncoderContext();
        if (encoderContext == null) {
            logger.debug("handleNotificationData: encoder context is null, skipping handling");
            return;
        }
        logger.debug("handleNotificationData: notificationDatas.length={}", (Object)extensionObjectArray.length);
        for (ExtensionObject extensionObject : extensionObjectArray) {
            MonitoredItem classCastException;
            Object object;
            NotificationData notificationData;
            NotificationData notificationData2;
            if (extensionObject == null) {
                logger.debug("handleNotificationData: o=null");
                continue;
            }
            try {
                notificationData2 = (NotificationData)extensionObject.decode(encoderContext);
                logger.debug("handleNotificationData: notificationData={}", (Object)notificationData2);
            }
            catch (DecodingException decodingException) {
                logger.info("handleNotificationData: Failed to decode notification {}", (Object)extensionObject, (Object)decodingException);
                this.fireError(extensionObject, decodingException);
                continue;
            }
            catch (RuntimeException runtimeException) {
                logger.error("handleNotificationData: Got RuntimeException while decoding NotificationData {}", (Object)extensionObject, (Object)runtimeException);
                throw runtimeException;
            }
            if (notificationData2 instanceof DataChangeNotification) {
                notificationData = (DataChangeNotification)notificationData2;
                object = ((DataChangeNotification)notificationData).getMonitoredItems();
                if (object == null) {
                    logger.debug("handleNotificationData: dataChangeNotification.getMonitoredItems()=null");
                } else {
                    logger.debug("handleNotificationData: dataChangeNotification.length={}", (Object)((MonitoredItemNotification[])object).length);
                    for (MonitoredItemNotification monitoredItemNotification : object) {
                        if (monitoredItemNotification == null) {
                            logger.debug("handleNotificationData: MonitoredItemNotification=null");
                            continue;
                        }
                        logger.debug("handleNotificationData: MonitoredItemNotification ClientHandle={} Value={}", (Object)monitoredItemNotification.getClientHandle(), (Object)monitoredItemNotification.getValue());
                        try {
                            classCastException = (MonitoredDataItem)this.getItem(monitoredItemNotification.getClientHandle());
                            logger.debug("item={}; firing data changes", (Object)classCastException);
                            this.fireDataChange((MonitoredDataItem)classCastException, monitoredItemNotification.getValue());
                            logger.debug("Setting value {} to {}", (Object)monitoredItemNotification.getValue(), (Object)classCastException);
                            ((MonitoredDataItem)classCastException).setValue(monitoredItemNotification.getValue());
                        }
                        catch (StatusException exception) {
                            logger.debug("handleNotificationData: ", (Throwable)exception);
                            if (!this.isConnected()) break;
                            if (exception.getStatusCode().getValue().equals(StatusCodes.Bad_MonitoredItemIdInvalid)) {
                                logger.info("handleNotificationData: unknown clientHandle={} subscriptionId={}", (Object)monitoredItemNotification.getClientHandle(), (Object)this.getSubscriptionId());
                            }
                            this.fireError(monitoredItemNotification, exception);
                        }
                        catch (ClassCastException classCastException2) {
                            logger.debug("handleNotificationData: ", (Throwable)classCastException2);
                            this.fireError(monitoredItemNotification, classCastException2);
                        }
                        catch (Exception exception) {
                            logger.error("handleNotificationData: Unexpected error (most likely MonitoredDataItem.setValue did throw RuntimeException which it should not)", (Throwable)exception);
                            this.fireError(monitoredItemNotification, exception);
                        }
                    }
                    logger.debug("handleNotificationData: handled all MonitoredItemNotifications length={}", (Object)((MonitoredItemNotification[])object).length);
                }
            } else if (notificationData2 instanceof StatusChangeNotification) {
                notificationData = (StatusChangeNotification)notificationData2;
                object = this.status;
                this.status = ((StatusChangeNotification)notificationData).getStatus();
                this.diagnosticInfo = ((StatusChangeNotification)notificationData).getDiagnosticInfo();
                logger.debug("handleNotificationData: statusChange status={} diagnosticInfo={}", (Object)this.status, (Object)this.diagnosticInfo);
                try {
                    this.fireStatusChange((StatusCode)object, this.status, this.diagnosticInfo);
                }
                catch (ClassCastException classCastException3) {
                    logger.debug("handleNotificationData: ", (Throwable)classCastException3);
                    this.fireError(notificationData, classCastException3);
                }
            } else if (notificationData2 instanceof EventNotificationList) {
                notificationData = (EventNotificationList)notificationData2;
                object = ((EventNotificationList)notificationData).getEvents();
                if (object != null) {
                    logger.debug("handleNotificationData: events.length={}", (Object)((MonitoredItemNotification[])object).length);
                    for (MonitoredItemNotification monitoredItemNotification : object) {
                        if (monitoredItemNotification == null) continue;
                        try {
                            classCastException = (MonitoredEventItem)this.getItem(((EventFieldList)((Object)monitoredItemNotification)).getClientHandle());
                            Variant[] classCastException2 = Variant.asVariantArray(((EventFieldList)((Object)monitoredItemNotification)).getEventFields());
                            if (classCastException == null) {
                                logger.debug("item=null");
                                continue;
                            }
                            if (logger.isDebugEnabled()) {
                                logger.debug("handleNotificationData: EventFieldList clientHandle={} itemId={} nodeId={} eventFields={}", new Object[]{((EventFieldList)((Object)monitoredItemNotification)).getClientHandle(), classCastException.getMonitoredItemId(), classCastException.getNodeId(), Arrays.toString(((EventFieldList)((Object)monitoredItemNotification)).getEventFields())});
                            }
                            this.fireEvent((MonitoredEventItem)classCastException, classCastException2);
                            ((MonitoredEventItem)classCastException).doEvent(classCastException2);
                        }
                        catch (StatusException statusException) {
                            logger.debug("handleNotificationData: ", (Throwable)statusException);
                            if (statusException.getStatusCode().getValue().equals(StatusCodes.Bad_MonitoredItemIdInvalid)) {
                                logger.info("handleNotificationData: unknown clientHandle={}", (Object)((EventFieldList)((Object)monitoredItemNotification)).getClientHandle());
                            }
                            this.fireError(monitoredItemNotification, statusException);
                        }
                        catch (ClassCastException classCastException4) {
                            logger.debug("handleNotificationData: ", (Throwable)classCastException4);
                            this.fireError(monitoredItemNotification, classCastException4);
                        }
                    }
                } else {
                    logger.debug("handleNotificationData: eventNotificationList.getEvents() was null");
                }
            } else {
                logger.debug("handleNotificationData: unknown notificationData type, or it is null");
            }
            this.fireNotification(notificationData2);
        }
        logger.debug("handleNotificationData: handled all notificationDatas.length={}", (Object)extensionObjectArray.length);
    }

    private void c(UnsignedInteger unsignedInteger) {
        for (UnsignedInteger unsignedInteger2 : this.getAvailableSequenceNumbersList()) {
            if (unsignedInteger2.getValue() <= unsignedInteger.getValue() || unsignedInteger2.getValue() - unsignedInteger.getValue() >= dI || this.dS.containsKey(unsignedInteger2)) continue;
            logger.info("Invalid sequence number {} in availableSequenceNumbers list received from server. Current SequenceNumber={}", (Object)unsignedInteger2, (Object)unsignedInteger);
        }
    }

    private void setAvailableSequenceNumbers(UnsignedInteger[] unsignedIntegerArray) {
        if (unsignedIntegerArray != null && unsignedIntegerArray.length > 0) {
            UnsignedInteger unsignedInteger = Collections.max(Arrays.asList(unsignedIntegerArray));
            logger.debug("setAvailableSequenceNumbers: availableSequenceNumbers={} latest={}", (Object)unsignedIntegerArray, (Object)unsignedInteger);
            this.dO.set(new a(unsignedIntegerArray, unsignedInteger.longValue()));
        } else {
            this.dO.set(null);
        }
    }

    private void a(UnsignedInteger unsignedInteger, UnsignedInteger[] unsignedIntegerArray) {
        if (unsignedIntegerArray != null) {
            logger.debug("addAvailableSequenceNumbers: lastSequenceNumber={} seqNumbers={}", (Object)this.dM, (Object)Arrays.toString(unsignedIntegerArray));
            long l2 = unsignedInteger.getValue();
            a a2 = null;
            do {
                long l3;
                if ((a2 = this.dO.get()) == null || l2 > (l3 = a2.dZ) || l3 > dI && l2 < 100L) continue;
                logger.debug("setAvailableSequenceNumbers not updated, sequenceNumber={} latestAvailableSequenceNumber={}", (Object)l2, (Object)l3);
                break;
            } while (!this.dO.compareAndSet(a2, new a(unsignedIntegerArray, l2)));
            logger.debug("addAvailableSequenceNumbers: availableSequenceNumbers={}", this.getAvailableSequenceNumbersList());
        }
    }

    @Override
    protected void applyUpdates() throws ServiceException {
        super.applyUpdates();
        if (this.updateCount == 0) {
            this.updateSubscription();
            this.updateItems();
            this.updateMonitoringModes();
        }
    }

    protected void checkOperationResult(StatusCode statusCode) throws StatusException {
        if (statusCode.isBad()) {
            if (this.dL == null) {
                throw new StatusException(statusCode);
            }
            throw new StatusException(statusCode, this.dL[0]);
        }
    }

    protected void checkServiceResult(ServiceResponse serviceResponse, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
        this.dN = serviceResponse.getResponseHeader();
        this.dL = diagnosticInfoArray;
        if (this.getLastServiceResult().isBad()) {
            throw new ServiceException(this.getLastServiceResult());
        }
    }

    protected void checkTimeout() {
        Calendar calendar = this.getLastAlive();
        if (calendar != null) {
            boolean bl;
            boolean bl2;
            long l2 = Calendar.getInstance().getTimeInMillis() - calendar.getTimeInMillis();
            boolean bl3 = bl2 = (double)l2 > this.getPublishingInterval() * (double)this.getMaxKeepAliveCount() * this.dX;
            if (bl2 && logger.isDebugEnabled()) {
                logger.debug("checkTimeout: timeout, msAfterLastAlive={}", (Object)l2);
            }
            this.setTimeout(bl2);
            boolean bl4 = bl = (double)l2 > this.getPublishingInterval() * (double)this.getLifetimeCount() * this.dW;
            if (bl && logger.isDebugEnabled()) {
                logger.debug("checkTimeout: lifetime ended, msAfterLastAlive={}", (Object)l2);
            }
            this.setAlive(!bl);
        }
    }

    protected void createItems() throws ServiceException {
        this.createMonitoredItems(this.items.values().toArray(new MonitoredItemBase[this.items.size()]));
    }

    protected CreateMonitoredItemsResponse createMonitoredItems(MonitoredItemBase ... monitoredItemBaseArray) throws ServiceException {
        if (this.serverConnected() && monitoredItemBaseArray.length > 0) {
            int n2;
            if (logger.isDebugEnabled()) {
                logger.debug("createMonitoredItems: " + (monitoredItemBaseArray.length < 100 ? Arrays.toString(monitoredItemBaseArray) : monitoredItemBaseArray.length + " items"));
            }
            if ((n2 = this.getMaxMonitoredItemsPerCall()) > 0 && n2 < monitoredItemBaseArray.length) {
                ResponseHeader responseHeader = null;
                MonitoredItemCreateResult[] monitoredItemCreateResultArray = new MonitoredItemCreateResult[monitoredItemBaseArray.length];
                DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[monitoredItemBaseArray.length];
                for (int i2 = 0; i2 < monitoredItemBaseArray.length; i2 += n2) {
                    int n3 = Math.min(n2, monitoredItemBaseArray.length - i2);
                    MonitoredItemBase[] monitoredItemBaseArray2 = Arrays.copyOfRange(monitoredItemBaseArray, i2, i2 + n3);
                    CreateMonitoredItemsResponse createMonitoredItemsResponse = this.a(monitoredItemBaseArray2);
                    responseHeader = createMonitoredItemsResponse.getResponseHeader();
                    for (int i3 = 0; i3 < n3; ++i3) {
                        monitoredItemCreateResultArray[i2 + i3] = createMonitoredItemsResponse.getResults()[i3];
                    }
                    DiagnosticInfo[] diagnosticInfoArray2 = createMonitoredItemsResponse.getDiagnosticInfos();
                    if (diagnosticInfoArray2 == null || diagnosticInfoArray2.length <= 0) continue;
                    for (int i4 = 0; i4 < n3; ++i4) {
                        diagnosticInfoArray[i2 + i4] = diagnosticInfoArray2[i4];
                    }
                }
                return new CreateMonitoredItemsResponse(responseHeader, monitoredItemCreateResultArray, diagnosticInfoArray);
            }
            return this.a(monitoredItemBaseArray);
        }
        return null;
    }

    protected DeleteMonitoredItemsResponse deleteMonitoredItems(MonitoredItemBase ... monitoredItemBaseArray) throws ServiceException {
        if (this.isConnected() && monitoredItemBaseArray.length > 0) {
            int n2 = this.getMaxMonitoredItemsPerCall();
            if (n2 > 0 && n2 < monitoredItemBaseArray.length) {
                ResponseHeader responseHeader = null;
                StatusCode[] statusCodeArray = new StatusCode[monitoredItemBaseArray.length];
                DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[monitoredItemBaseArray.length];
                for (int i2 = 0; i2 < monitoredItemBaseArray.length; i2 += n2) {
                    int n3 = Math.min(n2, monitoredItemBaseArray.length - i2);
                    MonitoredItemBase[] monitoredItemBaseArray2 = Arrays.copyOfRange(monitoredItemBaseArray, i2, i2 + n3);
                    DeleteMonitoredItemsResponse deleteMonitoredItemsResponse = this.b(monitoredItemBaseArray2);
                    responseHeader = deleteMonitoredItemsResponse.getResponseHeader();
                    for (int i3 = 0; i3 < n3; ++i3) {
                        statusCodeArray[i2 + i3] = deleteMonitoredItemsResponse.getResults()[i3];
                    }
                    DiagnosticInfo[] diagnosticInfoArray2 = deleteMonitoredItemsResponse.getDiagnosticInfos();
                    if (diagnosticInfoArray2 == null || diagnosticInfoArray2.length <= 0) continue;
                    for (int i4 = 0; i4 < n3; ++i4) {
                        diagnosticInfoArray[i2 + i4] = diagnosticInfoArray2[i4];
                    }
                }
                return new DeleteMonitoredItemsResponse(responseHeader, statusCodeArray, diagnosticInfoArray);
            }
            return this.b(monitoredItemBaseArray);
        }
        return null;
    }

    @Override
    protected void enabledChanged() throws ServiceException, StatusException {
        if (this.cs != null) {
            this.cs.b((SubscriptionBase)this);
        }
    }

    protected void finalize() throws Throwable {
        this.items.clear();
        super.finalize();
    }

    protected void fireAfterCreate() {
        for (SubscriptionAliveListener subscriptionAliveListener : this.dJ) {
            if (subscriptionAliveListener == null) continue;
            try {
                subscriptionAliveListener.onAfterCreate(this);
            }
            catch (Exception exception) {
                logger.error("Exception while calling onAlive with listener=" + subscriptionAliveListener, (Throwable)exception);
            }
        }
    }

    protected void fireAlive() {
        for (SubscriptionAliveListener subscriptionAliveListener : this.dJ) {
            if (subscriptionAliveListener == null) continue;
            try {
                subscriptionAliveListener.onAlive(this);
            }
            catch (Exception exception) {
                logger.error("Exception while calling onAlive with listener=" + subscriptionAliveListener, (Throwable)exception);
            }
        }
    }

    protected void fireBufferOverflow(UnsignedInteger unsignedInteger, ExtensionObject[] extensionObjectArray) {
        for (SubscriptionNotificationListener subscriptionNotificationListener : this.dR) {
            if (subscriptionNotificationListener == null) continue;
            try {
                subscriptionNotificationListener.onBufferOverflow(this, unsignedInteger, extensionObjectArray);
            }
            catch (Exception exception) {
                logger.error("Exception while calling onBufferOverflow with listener=" + subscriptionNotificationListener, (Throwable)exception);
            }
        }
    }

    protected void fireDataChange(MonitoredDataItem monitoredDataItem, DataValue dataValue) {
        for (SubscriptionNotificationListener subscriptionNotificationListener : this.dR) {
            if (subscriptionNotificationListener == null) continue;
            try {
                subscriptionNotificationListener.onDataChange(this, monitoredDataItem, dataValue);
            }
            catch (Exception exception) {
                logger.error("Exception while calling onDataChange with listener=" + subscriptionNotificationListener, (Throwable)exception);
            }
        }
    }

    protected void fireError(Object object, Exception exception) {
        for (SubscriptionNotificationListener subscriptionNotificationListener : this.dR) {
            if (subscriptionNotificationListener == null) continue;
            try {
                subscriptionNotificationListener.onError(this, object, exception);
            }
            catch (Exception exception2) {
                logger.error("Exception while calling onError with listener=" + subscriptionNotificationListener, (Throwable)exception2);
            }
        }
    }

    protected void fireEvent(MonitoredEventItem monitoredEventItem, Variant[] variantArray) {
        for (SubscriptionNotificationListener subscriptionNotificationListener : this.dR) {
            if (subscriptionNotificationListener == null) continue;
            try {
                subscriptionNotificationListener.onEvent(this, monitoredEventItem, variantArray);
            }
            catch (Exception exception) {
                logger.error("Exception while calling onEvent with listener=" + subscriptionNotificationListener, (Throwable)exception);
            }
        }
    }

    protected void fireLifetimeTimeout() {
        for (SubscriptionAliveListener subscriptionAliveListener : this.dJ) {
            if (subscriptionAliveListener == null) continue;
            try {
                subscriptionAliveListener.onLifetimeTimeout(this);
            }
            catch (Exception exception) {
                logger.error("Exception while calling onTimeout with listener=" + subscriptionAliveListener, (Throwable)exception);
            }
        }
    }

    protected long fireMissingData(UnsignedInteger unsignedInteger, long l2, long l3, StatusCode statusCode) {
        for (SubscriptionNotificationListener subscriptionNotificationListener : this.dR) {
            try {
                l3 = subscriptionNotificationListener.onMissingData(this, unsignedInteger, l2, l3, statusCode);
            }
            catch (Exception exception) {
                logger.error("Exception while calling onMissingData with listener=" + subscriptionNotificationListener, (Throwable)exception);
            }
        }
        return l3;
    }

    protected void fireNotification(NotificationData notificationData) {
        logger.debug("fireNotification");
        for (SubscriptionNotificationListener subscriptionNotificationListener : this.dR) {
            if (subscriptionNotificationListener == null) continue;
            try {
                subscriptionNotificationListener.onNotificationData(this, notificationData);
            }
            catch (Exception exception) {
                logger.error("Exception while calling onNotificationData with listener=" + subscriptionNotificationListener, (Throwable)exception);
            }
        }
    }

    protected void fireStatusChange(StatusCode statusCode, StatusCode statusCode2, DiagnosticInfo diagnosticInfo) {
        for (SubscriptionNotificationListener subscriptionNotificationListener : this.dR) {
            if (subscriptionNotificationListener == null) continue;
            try {
                subscriptionNotificationListener.onStatusChange(this, statusCode, statusCode2, diagnosticInfo);
            }
            catch (Exception exception) {
                logger.error("Exception while calling onStatusChange with listener=" + subscriptionNotificationListener, (Throwable)exception);
            }
        }
    }

    protected void fireTimeout() {
        for (SubscriptionAliveListener subscriptionAliveListener : this.dJ) {
            if (subscriptionAliveListener == null) continue;
            try {
                subscriptionAliveListener.onTimeout(this);
            }
            catch (Exception exception) {
                logger.error("Exception while calling onTimeout with listener=" + subscriptionAliveListener, (Throwable)exception);
            }
        }
    }

    protected List<UnsignedInteger> getAvailableSequenceNumbersList() {
        a a2 = this.dO.get();
        if (a2 != null) {
            return a2.dY;
        }
        return Collections.emptyList();
    }

    protected MonitoringParameters getMonitoringParameters(MonitoredItemBase monitoredItemBase) {
        ExtensionObject extensionObject;
        try {
            extensionObject = monitoredItemBase.getFilter() == null ? null : ExtensionObject.binaryEncode(monitoredItemBase.getFilter(), this.cs.getEncoderContext());
        }
        catch (EncodingException encodingException) {
            throw new IllegalArgumentException(String.format("Cannot encode filter of item {%s.%s}", monitoredItemBase.getNodeId(), AttributesUtil.toString(monitoredItemBase.getAttributeId())), encodingException);
        }
        MonitoringParameters monitoringParameters = new MonitoringParameters(monitoredItemBase.getClientHandle(), monitoredItemBase.getSamplingInterval(), extensionObject, UnsignedInteger.valueOf(monitoredItemBase.getQueueSize()), monitoredItemBase.isDiscardOldest());
        return monitoringParameters;
    }

    protected void handleNotificationDatas() throws ServerConnectionException, ServiceException {
        Map.Entry<UnsignedInteger, ExtensionObject[]> entry;
        logger.debug("handleNotificationDatas: isConnected={}", (Object)this.isConnected());
        while ((entry = this.dS.pollFirstEntry()) != null) {
            boolean bl;
            logger.debug("handleNotificationDatas: entry={}", entry);
            UnsignedInteger unsignedInteger = entry.getKey();
            ExtensionObject[] extensionObjectArray = entry.getValue();
            long l2 = this.dM == null ? 0L : this.dM.longValue();
            boolean bl2 = bl = l2 - unsignedInteger.longValue() > dI;
            if (bl) {
                logger.debug("handleNotificationDatas: need Republish: isOverflow");
                this.c(UnsignedInteger.MAX_VALUE.longValue());
                if (l2 > dI) {
                    this.dM = UnsignedInteger.ZERO;
                    l2 = 0L;
                }
            }
            if (l2 == 0L || unsignedInteger.longValue() > l2 && unsignedInteger.longValue() - l2 < dI) {
                logger.debug("handleNotificationDatas: need Republish? lastSeqNumber={} VS. sequenceNumber={}", (Object)l2, (Object)unsignedInteger.longValue());
                this.c(unsignedInteger.longValue() - 1L);
                if (this.isAliveNotification(extensionObjectArray)) {
                    logger.debug("handleNotificationDatas: this is Alive Notification");
                    this.fireAlive();
                } else {
                    logger.debug("handleNotificationDatas: calling handleNotificationData");
                    this.a(extensionObjectArray);
                    logger.debug("handleNotificationDatas: calling handleNotificationData ended, setting new lastSequenceNumber {}", (Object)unsignedInteger);
                    this.dM = unsignedInteger;
                }
                logger.debug("handleNotificationDatas: leaving, lastSequenceNumber={} lastAlive={}", (Object)this.dM, (Object)this.U());
                continue;
            }
            if (l2 <= 0L) continue;
            logger.warn("Server sent a previously acknowledged sequence number {} for Subscription {}", (Object)unsignedInteger, (Object)this.getSubscriptionId());
        }
        this.c(this.dM);
    }

    protected boolean hasPublishResponses() {
        return !this.dS.isEmpty();
    }

    protected boolean isAliveNotification(ExtensionObject[] extensionObjectArray) {
        return extensionObjectArray.length == 0;
    }

    protected void itemChanged(MonitoredItem monitoredItem) throws ServiceException {
        if (!this.isConnected()) {
            monitoredItem.clearModified();
        } else if (this.updateCount == 0) {
            this.updateItems();
        }
    }

    protected ModifyMonitoredItemsResponse modifyMonitoredItems(List<MonitoredItem> list) throws ServiceException {
        if (this.serverConnected() && list.size() > 0) {
            int n2;
            if (logger.isDebugEnabled()) {
                logger.debug("modifyMonitoredItems: getSubscriptionId()={}; items={}", (Object)this.getSubscriptionId(), (Object)Arrays.toString(list.toArray()));
            }
            if ((n2 = this.getMaxMonitoredItemsPerCall()) > 0 && n2 < list.size()) {
                ResponseHeader responseHeader = null;
                MonitoredItemModifyResult[] monitoredItemModifyResultArray = new MonitoredItemModifyResult[list.size()];
                DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[list.size()];
                for (int i2 = 0; i2 < list.size(); i2 += n2) {
                    int n3 = Math.min(n2, list.size() - i2);
                    List<MonitoredItem> list2 = list.subList(i2, i2 + n3);
                    ModifyMonitoredItemsResponse modifyMonitoredItemsResponse = this.c(list2);
                    responseHeader = modifyMonitoredItemsResponse.getResponseHeader();
                    for (int i3 = 0; i3 < n3; ++i3) {
                        monitoredItemModifyResultArray[i2 + i3] = modifyMonitoredItemsResponse.getResults()[i3];
                    }
                    DiagnosticInfo[] diagnosticInfoArray2 = modifyMonitoredItemsResponse.getDiagnosticInfos();
                    if (diagnosticInfoArray2 == null || diagnosticInfoArray2.length <= 0) continue;
                    for (int i4 = 0; i4 < n3; ++i4) {
                        diagnosticInfoArray[i2 + i4] = diagnosticInfoArray2[i4];
                    }
                }
                return new ModifyMonitoredItemsResponse(responseHeader, monitoredItemModifyResultArray, diagnosticInfoArray);
            }
            return this.c(list);
        }
        return null;
    }

    protected void monitoringModeChanged(MonitoredItem monitoredItem) throws ServiceException {
        if (this.updateCount == 0) {
            this.updateMonitoringModes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onPublishResponse(PublishResponse publishResponse) {
        if (this.cs == null) {
            logger.debug("onPublishResponse: client is null, therefore skipping processing because this subscription has been removed from the client");
            return;
        }
        if (publishResponse.getNotificationMessage() != null) {
            UnsignedInteger unsignedInteger;
            if (logger.isDebugEnabled()) {
                logger.debug("onPublishResponse: entering, SubscriptionID={} SequenceNumber={}", (Object)publishResponse.getSubscriptionId(), (Object)publishResponse.getNotificationMessage().getSequenceNumber());
            }
            if ((unsignedInteger = publishResponse.getNotificationMessage().getSequenceNumber()) != null) {
                Map.Entry<UnsignedInteger, ExtensionObject[]> entry;
                long l2;
                this.dK = Calendar.getInstance();
                ExtensionObject[] extensionObjectArray = publishResponse.getNotificationMessage().getNotificationData();
                if (extensionObjectArray == null || extensionObjectArray.length == 0) {
                    extensionObjectArray = dH;
                } else {
                    this.acknowledge(unsignedInteger);
                }
                this.dS.put(unsignedInteger, extensionObjectArray);
                this.a(unsignedInteger, publishResponse.getAvailableSequenceNumbers());
                logger.debug("onPublishResponse: responseQueue.size()={}", (Object)this.dS.size());
                UnsignedInteger unsignedInteger2 = this.getLastSequenceNumber();
                long l3 = unsignedInteger2 == null ? 0L : unsignedInteger2.getValue();
                long l4 = l2 = l3 == UnsignedInteger.MAX_VALUE.longValue() ? 1L : l3 + 1L;
                if (l3 == 0L || unsignedInteger.getValue() == l2) {
                    entry = this.cs;
                    if (entry == null) {
                        return;
                    }
                    UaClient uaClient = entry;
                    synchronized (uaClient) {
                        entry.notify();
                    }
                }
                while (this.dS.size() > this.dQ) {
                    entry = this.dS.pollFirstEntry();
                    if (entry == null) continue;
                    this.fireBufferOverflow((UnsignedInteger)entry.getKey(), (ExtensionObject[])entry.getValue());
                }
            } else {
                logger.debug("onPublishResponse: sequenceNumber=null");
            }
        }
    }

    @Override
    protected void paramChanged() throws ServiceException {
        if (this.isConnected()) {
            if (this.updateCount == 0) {
                this.applyUpdates();
            } else {
                this.modified = true;
            }
        }
    }

    protected void reset() {
        this.cs = null;
        super.setSubscriptionId(null);
        this.dK = null;
        this.dU = false;
        this.dV = true;
        this.dM = UnsignedInteger.ZERO;
        this.setAvailableSequenceNumbers(null);
    }

    protected boolean serverConnected() {
        return this.cs != null && this.cs.isConnected();
    }

    protected void setAlive(boolean bl) {
        if (this.dV != bl) {
            this.dV = bl;
            if (!bl) {
                this.fireLifetimeTimeout();
            }
        }
    }

    protected void setClient(UaClient uaClient) {
        if (this.cs != uaClient) {
            this.cs = uaClient;
        }
    }

    protected SetMonitoringModeResponse setMonitoringMode(MonitoringMode monitoringMode, List<MonitoredItem> list) throws ServiceException {
        if (this.serverConnected() && list.size() > 0) {
            int n2;
            if (logger.isDebugEnabled()) {
                logger.debug("modifyMonitoredItems: getSubscriptionId()={}; items={}", (Object)this.getSubscriptionId(), (Object)list.toString());
            }
            if ((n2 = this.getMaxMonitoredItemsPerCall()) > 0 && n2 < list.size()) {
                ResponseHeader responseHeader = null;
                StatusCode[] statusCodeArray = new StatusCode[list.size()];
                DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[list.size()];
                for (int i2 = 0; i2 < list.size(); i2 += n2) {
                    int n3 = Math.min(n2, list.size() - i2);
                    List<MonitoredItem> list2 = list.subList(i2, i2 + n3);
                    SetMonitoringModeResponse setMonitoringModeResponse = this.a(monitoringMode, list2);
                    responseHeader = setMonitoringModeResponse.getResponseHeader();
                    for (int i3 = 0; i3 < n3; ++i3) {
                        statusCodeArray[i2 + i3] = setMonitoringModeResponse.getResults()[i3];
                    }
                    DiagnosticInfo[] diagnosticInfoArray2 = setMonitoringModeResponse.getDiagnosticInfos();
                    if (diagnosticInfoArray2 == null || diagnosticInfoArray2.length <= 0) continue;
                    for (int i4 = 0; i4 < n3; ++i4) {
                        diagnosticInfoArray[i2 + i4] = diagnosticInfoArray2[i4];
                    }
                }
                return new SetMonitoringModeResponse(responseHeader, statusCodeArray, diagnosticInfoArray);
            }
            return this.a(monitoringMode, list);
        }
        return null;
    }

    protected void setSubscriptionId(int n2) {
        this.setSubscriptionId(UnsignedInteger.valueOf(n2));
    }

    @Override
    protected void setSubscriptionId(UnsignedInteger unsignedInteger) {
        super.setSubscriptionId(unsignedInteger);
        if (unsignedInteger == null || unsignedInteger.getValue() == 0L) {
            this.reset();
        }
    }

    protected void setTimeout(boolean bl) {
        if (bl != this.dU) {
            this.dU = bl;
            if (this.dU) {
                this.fireTimeout();
            }
        }
    }

    protected void updateSubscription() throws ServiceException {
        if (this.serverConnected()) {
            this.cs.a((SubscriptionBase)this);
        }
        this.modified = false;
    }

    private static class a {
        private final List<UnsignedInteger> dY;
        private final long dZ;

        public a(UnsignedInteger[] unsignedIntegerArray, long l2) {
            this.dY = Arrays.asList(unsignedIntegerArray);
            this.dZ = l2;
        }
    }
}

