/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.client;

import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.MonitoredDataItemListener;
import com.prosysopc.ua.client.MonitoredItem;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.AggregateFilter;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.DataChangeFilter;
import com.prosysopc.ua.stack.core.MonitoringMode;
import com.prosysopc.ua.stack.utils.NumericRange;
import java.util.concurrent.TimeUnit;

public class MonitoredDataItem
extends MonitoredItem {
    private NumericRange ds = null;
    private double dt = -1.0;
    private DataValue value;
    protected volatile MonitoredDataItemListener dataChangeListener = null;

    public MonitoredDataItem(ExpandedNodeId expandedNodeId) {
        this(expandedNodeId, Attributes.Value);
    }

    public MonitoredDataItem(ExpandedNodeId expandedNodeId, UnsignedInteger unsignedInteger) {
        this(expandedNodeId, unsignedInteger, MonitoringMode.Reporting);
    }

    public MonitoredDataItem(ExpandedNodeId expandedNodeId, UnsignedInteger unsignedInteger, MonitoringMode monitoringMode) {
        this(expandedNodeId, unsignedInteger, monitoringMode, -1.0);
    }

    public MonitoredDataItem(ExpandedNodeId expandedNodeId, UnsignedInteger unsignedInteger, MonitoringMode monitoringMode, double d2) {
        super(expandedNodeId, unsignedInteger, monitoringMode);
        this.dt = d2;
    }

    public MonitoredDataItem(NodeId nodeId) {
        this(nodeId, Attributes.Value);
    }

    public MonitoredDataItem(NodeId nodeId, UnsignedInteger unsignedInteger) {
        this(nodeId, unsignedInteger, MonitoringMode.Reporting);
    }

    public MonitoredDataItem(NodeId nodeId, UnsignedInteger unsignedInteger, MonitoringMode monitoringMode) {
        this(nodeId, unsignedInteger, monitoringMode, -1.0);
    }

    public MonitoredDataItem(NodeId nodeId, UnsignedInteger unsignedInteger, MonitoringMode monitoringMode, double d2) {
        super(nodeId, unsignedInteger, monitoringMode);
        this.dt = d2;
    }

    public DataChangeFilter getDataChangeFilter() {
        return (DataChangeFilter)this.getFilter();
    }

    public MonitoredDataItemListener getDataChangeListener() {
        return this.dataChangeListener;
    }

    @Override
    public NumericRange getIndexRange() {
        return this.ds;
    }

    @Override
    public double getSamplingInterval() {
        return this.dt;
    }

    public DataValue getValue() {
        return this.value;
    }

    public void setAggregateFilter(AggregateFilter aggregateFilter) throws ServiceException, StatusException {
        this.setFilter(aggregateFilter);
    }

    public void setDataChangeFilter(DataChangeFilter dataChangeFilter) throws ServiceException, StatusException {
        this.setFilter(dataChangeFilter);
    }

    public void setDataChangeListener(MonitoredDataItemListener monitoredDataItemListener) {
        this.dataChangeListener = monitoredDataItemListener;
    }

    public void setIndexRange(NumericRange numericRange) throws ServiceException {
        if (this.ds != numericRange) {
            this.ds = numericRange;
            this.itemChanged();
        }
    }

    public void setSamplingInterval(double d2) throws ServiceException {
        if (this.dt != d2) {
            this.dt = d2;
            this.itemChanged();
        }
    }

    public void setSamplingInterval(long l2, TimeUnit timeUnit) throws ServiceException {
        double d2;
        switch (timeUnit) {
            case MICROSECONDS: {
                d2 = l2 / 1000L;
                break;
            }
            case NANOSECONDS: {
                d2 = l2 / 1000000L;
                break;
            }
            default: {
                d2 = timeUnit.toMillis(l2);
            }
        }
        this.setSamplingInterval(d2);
    }

    protected void fireDataChange(DataValue dataValue, DataValue dataValue2) {
        if (this.dataChangeListener != null) {
            try {
                this.dataChangeListener.onDataChange(this, dataValue, dataValue2);
            }
            catch (Exception exception) {
                logger.error("Exception while calling onDataChange with listener=" + this.dataChangeListener, (Throwable)exception);
            }
        }
    }

    @Override
    protected long getDefaultQueueSize() {
        return 1L;
    }

    protected void setRevisedSamplingInterval(Double d2) {
        this.dt = d2;
    }

    protected void setValue(DataValue dataValue) {
        if (dataValue != this.value) {
            DataValue dataValue2 = this.value;
            this.value = dataValue;
            this.fireDataChange(dataValue2, dataValue);
        }
    }
}

