/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.UaNamespace;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.common.InternalNamespaceUtils;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.ServiceResultException;

public class UaQualifiedName {
    private final UaNamespace ck;
    private final String name;

    public static UaQualifiedName from(QualifiedName qualifiedName, NamespaceTable namespaceTable) {
        String string = InternalNamespaceUtils.getUriOrUseInvalidPattern(qualifiedName.getNamespaceIndex(), namespaceTable);
        return new UaQualifiedName(UaNamespace.from(string), qualifiedName.getName());
    }

    public static UaQualifiedName from(String string, String string2) {
        return new UaQualifiedName(UaNamespace.from(string), string2);
    }

    public static UaQualifiedName from(UaNamespace uaNamespace, String string) {
        if (uaNamespace == null) {
            throw new IllegalArgumentException("The given namespace cannot be null");
        }
        return new UaQualifiedName(uaNamespace, string);
    }

    public static UaQualifiedName standard(String string) {
        return new UaQualifiedName(UaNamespace.STANDARD, string);
    }

    private UaQualifiedName(UaNamespace uaNamespace, String string) {
        if (uaNamespace == null || string == null) {
            throw new IllegalArgumentException("Given parameters cannot be null");
        }
        this.ck = uaNamespace;
        this.name = string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UaQualifiedName uaQualifiedName = (UaQualifiedName)object;
        if (this.name == null ? uaQualifiedName.name != null : !this.name.equals(uaQualifiedName.name)) {
            return false;
        }
        return !(this.ck == null ? uaQualifiedName.ck != null : !this.ck.equals(uaQualifiedName.ck));
    }

    public String getName() {
        return this.name;
    }

    public UaNamespace getNamespace() {
        return this.ck;
    }

    public String getNamespaceUri() {
        return this.ck.getURI();
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.name == null ? 0 : this.name.hashCode());
        n3 = 31 * n3 + (this.ck == null ? 0 : this.ck.hashCode());
        return n3;
    }

    public QualifiedName toQualifiedName(NamespaceTable namespaceTable) {
        if (namespaceTable == null) {
            throw new IllegalArgumentException("The given namespace table cannot be null");
        }
        try {
            int n2 = InternalNamespaceUtils.getIndexFromPotentialInvalidPattern(this.ck.getURI(), namespaceTable);
            return new QualifiedName(n2, this.name);
        }
        catch (ServiceResultException serviceResultException) {
            throw new IllegalArgumentException("Cannot find Namespace to URI mapping in given table, uri:" + this.ck, serviceResultException);
        }
    }

    public String toString() {
        return this.ck + ":" + this.name;
    }
}

