/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.UaNamespace;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.IdType;

public class UaNodeId {
    private final UaNamespace ck;
    private final NodeId cl;
    private final int hash;

    public static UaNodeId from(String string, Object object) {
        return new UaNodeId(string, object);
    }

    public static UaNodeId fromLocal(ExpandedNodeId expandedNodeId) {
        if (!expandedNodeId.isLocal()) {
            throw new IllegalArgumentException("The given ExpandedNodeId.isLocal is not true");
        }
        if (expandedNodeId.getNamespaceUri() == null) {
            throw new IllegalArgumentException("The given ExpandedNode does not have namespace uri");
        }
        return UaNodeId.from(expandedNodeId.getNamespaceUri(), expandedNodeId.getValue());
    }

    public static UaNodeId fromLocal(ExpandedNodeId expandedNodeId, NamespaceTable namespaceTable) {
        if (!expandedNodeId.isLocal()) {
            throw new IllegalArgumentException("The given ExpandedNodeId.isLocal is not true");
        }
        if (expandedNodeId.getNamespaceUri() == null) {
            String string = namespaceTable.getUri(expandedNodeId.getNamespaceIndex());
            if (string == null) {
                return UaNodeId.fromLocal(NodeId.get(expandedNodeId.getIdType(), expandedNodeId.getNamespaceIndex(), expandedNodeId.getValue()), namespaceTable);
            }
            return UaNodeId.from(string, expandedNodeId.getValue());
        }
        return UaNodeId.from(expandedNodeId.getNamespaceUri(), expandedNodeId.getValue());
    }

    public static UaNodeId fromLocal(NodeId nodeId, NamespaceTable namespaceTable) {
        String string = namespaceTable.getUri(nodeId.getNamespaceIndex());
        if (string == null) {
            return UaNodeId.fromLocal(namespaceTable.toExpandedNodeId(nodeId));
        }
        return UaNodeId.from(string, nodeId.getValue());
    }

    public static UaNodeId fromStandard(NodeId nodeId) {
        if (nodeId.getNamespaceIndex() != 0) {
            throw new IllegalArgumentException("Given NodeId contains NamespaceIndex other than 0, was: " + nodeId.getNamespaceIndex());
        }
        return UaNodeId.from(NamespaceTable.OPCUA_NAMESPACE, nodeId.getValue());
    }

    public static UaNodeId parse(String string, String string2) {
        NodeId nodeId = NodeId.parseNodeId(string2);
        return UaNodeId.from(string, nodeId.getValue());
    }

    private UaNodeId(String string, Object object) {
        this.ck = UaNamespace.from(string);
        ExpandedNodeId expandedNodeId = new ExpandedNodeId(string, object);
        this.cl = NodeId.get(expandedNodeId.getIdType(), 0, expandedNodeId.getValue());
        this.hash = this.t();
    }

    public ExpandedNodeId asExpandedNodeId() {
        return new ExpandedNodeId(this.ck.getURI(), this.cl.getValue());
    }

    public ExpandedNodeId asLocalExpandedNodeId() {
        return new ExpandedNodeId(this.ck.getURI(), this.getValue());
    }

    public NodeId asNodeId(NamespaceTable namespaceTable) {
        try {
            return namespaceTable.toNodeId(this.asLocalExpandedNodeId());
        }
        catch (ServiceResultException serviceResultException) {
            throw new IllegalArgumentException("No mapping found for namespace uri:" + this.ck.getURI());
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UaNodeId uaNodeId = (UaNodeId)object;
        if (this.hash != uaNodeId.hash) {
            return false;
        }
        if (this.ck == null ? uaNodeId.ck != null : !this.ck.equals(uaNodeId.ck)) {
            return false;
        }
        return !(this.cl == null ? uaNodeId.cl != null : !this.cl.equals(uaNodeId.cl));
    }

    public IdType getIdType() {
        return this.cl.getIdType();
    }

    public UaNamespace getNamespace() {
        return this.ck;
    }

    public String getNamespaceUri() {
        return this.ck.getURI();
    }

    public Object getValue() {
        return this.cl.getValue();
    }

    public String getValueAsParseForm() {
        return this.cl.toString();
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return this.ck + ":" + this.cl.getValue();
    }

    private int t() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.ck == null ? 0 : this.ck.hashCode());
        n3 = 31 * n3 + (this.cl == null ? 0 : this.cl.hashCode());
        return n3;
    }
}

