/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.AggregateCalculator;
import com.prosysopc.ua.AnnotationException;
import com.prosysopc.ua.ApplicationIdentity;
import com.prosysopc.ua.CodegenModel;
import com.prosysopc.ua.CodegenModelProvider;
import com.prosysopc.ua.OperationLimits;
import com.prosysopc.ua.RegisteredClasses;
import com.prosysopc.ua.RegisteredClassesImpl;
import com.prosysopc.ua.UaAddressSpace;
import com.prosysopc.ua.nodes.UaInstance;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.transport.security.CertificateValidator;
import com.prosysopc.ua.typedictionary.DataTypeDictionary;
import com.prosysopc.ua.typedictionary.DataTypeDictionaryComposition;
import com.prosysopc.ua.typedictionary.GeneratedDataTypeDictionary;
import java.util.Collection;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UaApplication {
    private static Logger logger = LoggerFactory.getLogger(UaApplication.class);
    static final String bZ = "4.4.2-1266";
    private final AggregateCalculator ca = new AggregateCalculator();
    private CertificateValidator cb;
    private final RegisteredClasses cc = new RegisteredClassesImpl();
    private final DataTypeDictionaryComposition cd = new DataTypeDictionaryComposition();
    private OperationLimits ce = OperationLimits.defaults();
    private boolean cf = true;

    @Deprecated
    public static String formatUri(Protocol protocol, String string, int n2, String string2) {
        if (string2 == null) {
            string2 = "";
        } else if (!string2.isEmpty() && string2.charAt(0) != '/') {
            string2 = "/" + string2;
        }
        return String.format("%s://%s:%d%s", new Object[]{protocol, string, n2, string2});
    }

    public static String getSdkVersion() {
        return bZ;
    }

    @Deprecated
    public static String getVersion() {
        return "v" + UaApplication.getSdkVersion();
    }

    private static void c(String string) {
        System.out.println(string);
    }

    public abstract UaAddressSpace getAddressSpace();

    public AggregateCalculator getAggregateCalculator() {
        return this.ca;
    }

    public CertificateValidator getCertificateValidator() {
        return this.cb;
    }

    public abstract EncoderContext getEncoderContext();

    public DataTypeDictionary getKnownDataTypeDictionary() {
        return this.cd;
    }

    public NamespaceTable getNamespaceTable() {
        return this.getEncoderContext().getNamespaceTable();
    }

    public OperationLimits getOperationLimits() {
        return this.ce;
    }

    public RegisteredClasses getRegisteredClasses() {
        return this.cc;
    }

    public boolean isAutoDiscoverCodegenModels() {
        return this.cf;
    }

    public void registerClass(Class<? extends UaInstance> clazz) throws AnnotationException {
        this.cc.registerClass(clazz);
    }

    public void registerClass(Class<? extends UaInstance> clazz, ExpandedNodeId expandedNodeId) {
        this.cc.registerClass(clazz, expandedNodeId);
    }

    public void registerClass(Class<? extends UaInstance> clazz, NodeId nodeId) {
        this.registerClass(clazz, this.getNamespaceTable().toExpandedNodeId(nodeId));
    }

    public void registerClasses(Collection<Class<? extends UaInstance>> collection) {
        this.cc.registerClasses(collection);
    }

    public void setAutoDiscoverCodegenModels(boolean bl) {
        this.cf = bl;
    }

    public void setCertificateValidator(CertificateValidator certificateValidator) {
        this.cb = certificateValidator;
    }

    public void setOperationLimits(OperationLimits operationLimits) {
        this.ce = operationLimits;
    }

    protected <T extends CodegenModelProvider> void registerAutoDiscoveredModels(Class<T> clazz) {
        logger.debug("Discovering CodegenModels from the classpath");
        ServiceLoader<CodegenModelProvider> serviceLoader = ServiceLoader.load(clazz);
        for (CodegenModelProvider codegenModelProvider : serviceLoader) {
            CodegenModel codegenModel = codegenModelProvider.get();
            logger.debug("Found {}", (Object)codegenModelProvider.getClass().getName());
            this.registerModelInternal(codegenModel);
        }
    }

    protected void registerModelInternal(CodegenModel codegenModel) {
        codegenModel.register(this);
        GeneratedDataTypeDictionary generatedDataTypeDictionary = codegenModel.getDataTypeDictionary();
        if (generatedDataTypeDictionary != null) {
            this.cd.addGeneratedDataTypeDictionary(generatedDataTypeDictionary);
        }
    }

    protected StatusCode validateApplicationCertificate(ApplicationIdentity applicationIdentity) {
        if (this.cb != null) {
            return this.cb.validateCertificate(applicationIdentity.getApplicationDescription(), applicationIdentity.getCertificate());
        }
        return StatusCode.GOOD;
    }

    static {
        logger.info("Prosys OPC UA SDK for Java v{}", (Object)bZ);
        logger.info("(c) Prosys OPC Ltd. <http://www.prosysopc.com>");
        if (logger.isDebugEnabled()) {
            for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
                logger.debug("{}={}", entry.getKey(), entry.getValue());
            }
        }
    }

    public static enum Protocol {
        Http,
        OpcHttps,
        OpcTcp;


        public static Protocol parseProtocol(String string) {
            String string2 = string.toLowerCase();
            if (string2.equals("http")) {
                return Http;
            }
            if (string2.equals("opc.tcp")) {
                return OpcTcp;
            }
            if (string2.equals("opc.https")) {
                return OpcHttps;
            }
            return Protocol.valueOf(string);
        }

        public String getTransportProfileUri() {
            if (this.equals((Object)Http)) {
                return "http://opcfoundation.org/UA-Profile/Transport/https-uabinary";
            }
            if (this.equals((Object)OpcHttps)) {
                return "http://opcfoundation.org/UA-Profile/Transport/https-uabinary";
            }
            return "http://opcfoundation.org/UA-Profile/Transport/uatcp-uasc-uabinary";
        }

        public String toString() {
            if (this.equals((Object)Http)) {
                return "http";
            }
            if (this.equals((Object)OpcHttps)) {
                return "opc.https";
            }
            return "opc.tcp";
        }
    }

    public static enum DiagnosticMask {
        AdditionalInfo(4),
        InnerDiagnostics(16),
        InnerStatusCode(8),
        LocalizedText(2),
        SymbolicId(1);

        int value;

        private DiagnosticMask(int n3) {
            this.value = n3;
        }

        public int getValue() {
            return this.value;
        }
    }
}

