/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.UaApplication;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UaAddress {
    private static UaApplication.Protocol bU = UaApplication.Protocol.OpcTcp;
    private static final String bV = "\\p{Alnum}(?>[\\p{Alnum}-_]{0,62})?";
    private static final String bW = String.format("^(%s)(\\.(%1$s))*$", "\\p{Alnum}(?>[\\p{Alnum}-_]{0,62})?");
    private static final String bX = "^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$";
    private static final Logger logger = LoggerFactory.getLogger(UaAddress.class);
    private final String address;
    private final String host;
    private final int port;
    private final UaApplication.Protocol bY;
    private final String serverName;

    public static String formatUri(UaApplication.Protocol protocol, String string, int n2, String string2) {
        if (string2 == null) {
            string2 = "";
        } else if (!string2.isEmpty() && string2.charAt(0) != '/') {
            string2 = "/" + string2;
        }
        String string3 = string.contains(":") && !string.contains("[") ? "%s://[%s]:%d%s" : "%s://%s:%d%s";
        return String.format(string3, new Object[]{protocol, string, n2, string2});
    }

    public static UaAddress fromComponents(UaApplication.Protocol protocol, String string, int n2) {
        try {
            return new UaAddress(protocol, string, n2, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Could not create UaAddress from the given components");
        }
    }

    public static UaAddress fromComponents(UaApplication.Protocol protocol, String string, int n2, String string2) {
        try {
            return new UaAddress(protocol, string, n2, string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Could not create UaAddress from the given components");
        }
    }

    public static UaApplication.Protocol getDefaultProtocol() {
        return bU;
    }

    public static UaAddress parse(String string) {
        try {
            return new UaAddress(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Could not create UaAddress by parsing the given input: " + string);
        }
    }

    public static UaAddress parse(URI uRI) {
        return UaAddress.parse(uRI.toString());
    }

    public static UaAddress parse(URL uRL) {
        return UaAddress.parse(uRL.toString());
    }

    public static void setDefaultProtocol(UaApplication.Protocol protocol) {
        bU = protocol;
    }

    public static void validate(String string) throws URISyntaxException {
        new UaAddress(string);
    }

    public static UaAddress wildcardOpcTcp(int n2) {
        String string = System.getProperty("java.version");
        if (string == null || string.startsWith("1.6")) {
            return UaAddress.wildcardOpcTcpIPv4(n2);
        }
        return UaAddress.wildcardOpcTcpIPv6(n2);
    }

    public static UaAddress wildcardOpcTcpIPv4(int n2) {
        return UaAddress.fromComponents(UaApplication.Protocol.OpcTcp, "0.0.0.0", n2, null);
    }

    public static UaAddress wildcardOpcTcpIPv6(int n2) {
        return UaAddress.fromComponents(UaApplication.Protocol.OpcTcp, "[::]", n2, null);
    }

    @Deprecated
    public UaAddress(UaApplication.Protocol protocol, String string, int n2) throws URISyntaxException {
        this(protocol, string, n2, "");
    }

    @Deprecated
    public UaAddress(UaApplication.Protocol protocol, String string, int n2, String string2) throws URISyntaxException {
        this(UaAddress.formatUri(protocol, string, n2, string2));
    }

    @Deprecated
    public UaAddress(String string) throws URISyntaxException {
        if (string == null) {
            throw new URISyntaxException("(null)", "UaAddress requires a valid URI");
        }
        string = string.trim();
        string = string.replace(".local.:", ".local:");
        try {
            int n2;
            String string2;
            String string3 = null;
            int n3 = -1;
            String string4 = "";
            int n4 = string.indexOf("://");
            if (n4 >= 0) {
                this.bY = UaApplication.Protocol.parseProtocol(string.substring(0, n4));
                if (this.bY == UaApplication.Protocol.Http) {
                    logger.warn("The current Java stack does not support the HTTP (SOAP) protocol!");
                    throw new IllegalArgumentException("'http'-protocol is not supported");
                }
                string2 = string.substring(n4 + 3);
            } else {
                this.bY = bU;
                string2 = string;
            }
            String[] stringArray = string2.split("/");
            String string5 = stringArray[0];
            String string6 = "";
            if (string5.startsWith("[")) {
                n2 = string5.indexOf("]");
                if (n2 < 0) {
                    throw new IllegalArgumentException("Invalid hostname :");
                }
                string3 = string5.substring(0, n2 + 1);
                if (string5.length() > n2 + 1 && string5.charAt(n2 + 1) == ':') {
                    string6 = string5.substring(n2 + 2);
                }
            } else {
                String[] stringArray2 = string5.split(":");
                if (stringArray2.length > 2) {
                    throw new IllegalArgumentException("Invalid hostname: " + string5);
                }
                string3 = stringArray2[0];
                if (stringArray2.length > 1) {
                    string6 = stringArray2[1];
                }
                if (!string3.matches(bX) && !string3.matches(bW)) {
                    throw new IllegalArgumentException("Invalid hostname: " + string3);
                }
            }
            if (!string6.isEmpty()) {
                try {
                    n3 = Integer.parseInt(string6);
                    if (n3 < 1 || n3 > 65535) {
                        throw new IllegalArgumentException("Invalid port - not in valid range (1-65535): " + string6);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Invalid port: " + string6);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new IllegalArgumentException("Invalid port: " + string6);
                }
            }
            if (stringArray.length > 1) {
                string4 = stringArray[1];
                for (n2 = 2; n2 < stringArray.length; ++n2) {
                    string4 = string4 + "/" + stringArray[n2];
                }
            } else {
                string4 = "";
            }
            if (n3 <= 0) {
                n3 = this.bY == UaApplication.Protocol.OpcTcp ? 4840 : 443;
            }
            this.host = string3;
            this.port = n3;
            this.serverName = string4;
            this.address = UaApplication.formatUri(this.bY, this.host, this.port, this.serverName);
        }
        catch (Exception exception) {
            logger.debug("Could not parse uri: {}", (Object)string, (Object)exception);
            throw new URISyntaxException(string, "Could not parse URI:" + exception.getMessage());
        }
    }

    @Deprecated
    public UaAddress(URI uRI) throws Exception {
        this(uRI.toString());
    }

    @Deprecated
    public UaAddress(URL uRL) throws Exception {
        this(uRL.toString());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UaAddress uaAddress = (UaAddress)object;
        return !(this.address == null ? uaAddress.address != null : !this.address.equals(uaAddress.address));
    }

    public boolean equalsAddress(String string) {
        return this.address.equals(string);
    }

    public String getAddress() {
        return this.address;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public UaApplication.Protocol getProtocol() {
        return this.bY;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.address == null ? 0 : this.address.hashCode());
        return n3;
    }

    public String toString() {
        return this.address;
    }
}

