/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.AnnotationException;
import com.prosysopc.ua.AnnotationUtils;
import com.prosysopc.ua.RegisteredClasses;
import com.prosysopc.ua.nodes.UaInstance;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import java.util.Collection;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisteredClassesImpl
implements RegisteredClasses {
    private final HashMap<ExpandedNodeId, Class<? extends UaInstance>> bQ = new HashMap();
    private final Logger logger = LoggerFactory.getLogger(RegisteredClassesImpl.class);

    @Override
    public boolean containsClass(ExpandedNodeId expandedNodeId) {
        return this.bQ.containsKey(expandedNodeId);
    }

    @Override
    public Class<? extends UaInstance> getClass(ExpandedNodeId expandedNodeId) {
        return this.bQ.get(expandedNodeId);
    }

    @Override
    public void registerClass(Class<? extends UaInstance> clazz) throws AnnotationException {
        this.registerClass(clazz, AnnotationUtils.readTypeDefinitionId(clazz));
    }

    @Override
    public void registerClass(Class<? extends UaInstance> clazz, ExpandedNodeId expandedNodeId) {
        Class<? extends UaInstance> clazz2 = this.bQ.put(expandedNodeId, clazz);
        if (clazz2 != null && clazz2 != clazz) {
            this.logger.warn("Class re-registered: {}", clazz);
        }
    }

    @Override
    public void registerClasses(Collection<Class<? extends UaInstance>> collection) {
        for (Class<? extends UaInstance> clazz : collection) {
            if (!UaInstance.class.isAssignableFrom(clazz)) continue;
            try {
                this.registerClass(clazz);
            }
            catch (AnnotationException annotationException) {
                this.logger.info("Cannot register class without TypeDefinitionId annotation");
            }
        }
    }
}

