/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaNodeFactory;
import com.prosysopc.ua.nodes.UaNodeFactoryException;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.core.NodeClass;
import java.util.Locale;

public abstract class NodeMap {
    protected final Locale defaultLocale = Locale.ENGLISH;
    protected UaNodeFactory nodeFactory;

    public NodeMap(UaNodeFactory uaNodeFactory) {
        this.nodeFactory = uaNodeFactory;
    }

    public abstract UaNode addNode(UaNode var1);

    public <T extends UaType> T addType(NodeClass nodeClass, NodeId nodeId, String string, Class<?> clazz) throws UaNodeFactoryException {
        UaType uaType = (UaType)this.nodeFactory.createNode(nodeClass, nodeId, new QualifiedName(string), new LocalizedText(string, this.defaultLocale));
        uaType.setJavaClass(clazz);
        this.addNode(uaType);
        return (T)uaType;
    }

    public <T extends UaType> T addType(T t, NodeId nodeId, String string, Class<?> clazz) throws UaNodeFactoryException {
        NodeClass nodeClass = this.addType((T)((Object)t.getNodeClass()), nodeId, string, clazz);
        nodeClass.setSuperType(t);
        t.addSubType((UaType)((Object)nodeClass));
        return (T)nodeClass;
    }

    public abstract void clear();

    public abstract UaNode getNode(NodeId var1);

    public UaNodeFactory getNodeFactory() {
        return this.nodeFactory;
    }

    public abstract boolean hasNode(NodeId var1);

    public abstract UaNode remove(NodeId var1);

    public UaNode remove(UaNode uaNode) {
        return this.remove(uaNode.getNodeId());
    }
}

