/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import java.util.Iterator;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;

public class LocalizedTextMap {
    private final CopyOnWriteArrayList<LocalizedText> ag = new CopyOnWriteArrayList();

    public static LocalizedTextMap[] createMany(LocalizedText[] localizedTextArray) {
        LocalizedTextMap[] localizedTextMapArray = new LocalizedTextMap[localizedTextArray.length];
        for (int i2 = 0; i2 < localizedTextArray.length; ++i2) {
            localizedTextMapArray[i2] = new LocalizedTextMap(localizedTextArray[i2]);
        }
        return localizedTextMapArray;
    }

    public static LocalizedText[] getArrayValues(LocalizedTextMap[] localizedTextMapArray, Locale locale) {
        if (localizedTextMapArray == null) {
            return null;
        }
        LocalizedText[] localizedTextArray = new LocalizedText[localizedTextMapArray.length];
        for (int i2 = 0; i2 < localizedTextMapArray.length; ++i2) {
            localizedTextArray[i2] = localizedTextMapArray[i2].getLocalizedText(locale);
        }
        return localizedTextArray;
    }

    public LocalizedTextMap() {
    }

    public LocalizedTextMap(LocalizedText localizedText) {
        this.setLocalizedText(localizedText);
    }

    public LocalizedTextMap(String string, Locale locale) {
        this.setText(string, locale);
    }

    public Locale getDefaultLocale() {
        Iterator<LocalizedText> iterator = this.ag.iterator();
        if (iterator.hasNext()) {
            LocalizedText localizedText = iterator.next();
            return localizedText.getLocale();
        }
        return null;
    }

    public LocalizedText getLocalizedText(Locale locale) {
        String string = locale == null ? null : locale.toString();
        return this.getLocalizedText(string);
    }

    public LocalizedText getLocalizedText(String string) {
        LocalizedText localizedText = this.a(string);
        if (localizedText != null) {
            return localizedText;
        }
        Iterator<LocalizedText> iterator = this.ag.iterator();
        if (iterator.hasNext()) {
            LocalizedText localizedText2 = iterator.next();
            return localizedText2;
        }
        return LocalizedText.NULL;
    }

    public String getText(Locale locale) {
        LocalizedText localizedText = this.getLocalizedText(locale);
        return localizedText == null ? null : localizedText.getText();
    }

    public boolean hasText(Locale locale) {
        if (locale == null || "".equals(locale.toString())) {
            return false;
        }
        return locale.toString().equals(this.getLocalizedText(locale).getLocaleId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocalizedText(LocalizedText localizedText) {
        if (localizedText == null) {
            localizedText = LocalizedText.NULL;
        }
        if ("".equals(localizedText.getLocaleId())) {
            localizedText = new LocalizedText(localizedText.getText(), LocalizedText.NULL_LOCALE);
        }
        String string = localizedText.getLocaleId();
        String string2 = localizedText.getText();
        CopyOnWriteArrayList<LocalizedText> copyOnWriteArrayList = this.ag;
        synchronized (copyOnWriteArrayList) {
            if (string == null && string2 == null) {
                this.ag.clear();
                return;
            }
            if (string == null && string2 != null) {
                LocalizedText localizedText2 = this.a(null);
                if (localizedText2 != null) {
                    this.ag.remove(localizedText2);
                }
                this.ag.add(0, localizedText);
                return;
            }
            if (string != null && string2 == null) {
                LocalizedText localizedText3 = this.a(localizedText.getLocaleId());
                if (localizedText3 != null) {
                    this.ag.remove(localizedText3);
                }
                return;
            }
            LocalizedText localizedText4 = this.a(localizedText.getLocaleId());
            if (localizedText4 != null) {
                this.ag.remove(localizedText4);
            }
            this.ag.add(localizedText);
        }
    }

    public void setText(String string, Locale locale) {
        LocalizedText localizedText = new LocalizedText(string, locale);
        this.setLocalizedText(localizedText);
    }

    public String toString() {
        return this.ag.toString();
    }

    private LocalizedText a(String string) {
        if ("".equals(string)) {
            string = null;
        }
        if (string == null) {
            for (LocalizedText localizedText : this.ag) {
                if (localizedText.getLocaleId() != null) continue;
                return localizedText;
            }
        } else {
            for (LocalizedText localizedText : this.ag) {
                if (!string.equals(localizedText.getLocaleId())) continue;
                return localizedText;
            }
        }
        return null;
    }

    int size() {
        return this.ag.size();
    }
}

