/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.SecureIdentity;
import com.prosysopc.ua.SecureIdentityException;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.core.ApplicationDescription;
import com.prosysopc.ua.stack.core.SignedSoftwareCertificate;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.KeyPair;
import com.prosysopc.ua.stack.transport.security.PrivKey;
import com.prosysopc.ua.stack.utils.CertificateUtils;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationIdentity
extends SecureIdentity {
    public static final String CERT_FILE_EXTENSIONS = ".der";
    private static int J = 3650;
    private static Logger logger = LoggerFactory.getLogger(ApplicationIdentity.class);
    private static final String[] K = new String[]{".pem", ".pfx", ".key"};
    private static volatile boolean L = true;
    private static volatile String M = null;
    private ApplicationDescription N = new ApplicationDescription();
    private KeyPair[] O;
    private KeyPair P;
    private String Q;

    public static ApplicationIdentity createCertificate(ApplicationDescription applicationDescription, String string, KeyPair keyPair, String ... stringArray) throws SecureIdentityException {
        ApplicationIdentity.a(applicationDescription);
        ApplicationIdentity applicationIdentity = ApplicationIdentity.createCertificate(applicationDescription.getApplicationName().getText(), string, keyPair, applicationDescription.getApplicationUri(), stringArray);
        applicationIdentity.setApplicationDescription(applicationDescription);
        return applicationIdentity;
    }

    public static ApplicationIdentity createCertificate(ApplicationDescription applicationDescription, String string, String ... stringArray) throws SecureIdentityException {
        return ApplicationIdentity.createCertificate(applicationDescription, string, null, stringArray);
    }

    public static ApplicationIdentity createCertificate(String string, String string2, KeyPair keyPair, String string3, String ... stringArray) throws SecureIdentityException {
        KeyPair keyPair2 = ApplicationIdentity.createKeyPair(string, string2, J, keyPair, string3, stringArray);
        ApplicationIdentity applicationIdentity = new ApplicationIdentity(keyPair2.getCertificate(), keyPair2.getPrivateKey());
        applicationIdentity.setOrganisation(string2);
        return applicationIdentity;
    }

    public static KeyPair createHttpsCertificate(ApplicationDescription applicationDescription, String string, KeyPair keyPair) throws GeneralSecurityException, IOException {
        String string2 = applicationDescription.getApplicationUri();
        KeyPair keyPair2 = CertificateUtils.createHttpsCertificate(string, string2, 3650, keyPair);
        return keyPair2;
    }

    public static KeyPair createKeyPair(String string, String string2, int n2, KeyPair keyPair, String string3, String ... stringArray) throws SecureIdentityException {
        KeyPair keyPair2;
        if (string3 != null && string3.contains("localhost")) {
            throw new IllegalArgumentException("ApplicationURI should not contain 'localhost'.");
        }
        try {
            keyPair2 = CertificateUtils.createApplicationInstanceCertificate(string, string2, string3, n2, keyPair, stringArray);
            logger.info("Created a new Certificate: {}; ApplicationURI={} KeySize={}", new Object[]{keyPair2.getCertificate().getCertificate().getSubjectX500Principal().toString(), string3, CertificateUtils.getKeySize()});
        }
        catch (Exception exception) {
            throw new SecureIdentityException("Cannot create certificate for application " + string, exception);
        }
        return keyPair2;
    }

    public static String getActualHostName() {
        String string;
        InetAddress inetAddress;
        if (M != null) {
            return M;
        }
        logger.debug("Resolving local hostname..");
        try {
            inetAddress = InetAddress.getLocalHost();
            logger.debug("host address: {}", (Object)inetAddress);
        }
        catch (UnknownHostException unknownHostException) {
            logger.warn("Cannot determine Hostname. Using 'localhost'", (Throwable)unknownHostException);
            return "localhost";
        }
        String string2 = inetAddress.getHostName();
        logger.debug("hostName={}", (Object)string2);
        boolean bl = string2.toLowerCase().contains("localhost");
        String string3 = inetAddress.getHostAddress();
        logger.debug("ipAddress={}", (Object)string3);
        if (!bl && string2.contains(".") && !string2.equals(string3)) {
            string = string2;
            logger.debug("hostname has domain name");
        } else {
            logger.debug("Resolving canonical hostname..");
            String string4 = inetAddress.getCanonicalHostName();
            logger.debug("canonicalHostName={}", (Object)string4);
            boolean bl2 = string4.toLowerCase().contains("localhost");
            string = bl ? (bl2 ? string3 : string4) : (string2.contains(".") || bl2 || string4.equals(string3) ? string2 : string4);
        }
        if (L) {
            M = string;
        }
        return string;
    }

    public static String getActualHostNameWithoutDomain() {
        String string = ApplicationIdentity.getActualHostName();
        if (string == null) {
            return null;
        }
        int n2 = string.indexOf(".");
        if (n2 < 0) {
            return string;
        }
        String string2 = string.substring(0, n2);
        if (string2.matches(".*[^0-9].*")) {
            return string2;
        }
        return string;
    }

    public static int getDefaultCertificateDays() {
        return J;
    }

    public static ApplicationIdentity loadOrCreateCertificate(ApplicationDescription applicationDescription, String string, String string2, File file, boolean bl, String ... stringArray) throws SecureIdentityException, IOException {
        return ApplicationIdentity.loadOrCreateCertificate(applicationDescription, string, string2, file, null, null, bl, stringArray);
    }

    public static ApplicationIdentity loadOrCreateCertificate(ApplicationDescription applicationDescription, String string, String string2, File file, KeyPair keyPair, int[] nArray, boolean bl, String ... stringArray) throws SecureIdentityException, IOException {
        ApplicationIdentity.a(applicationDescription);
        ApplicationIdentity applicationIdentity = ApplicationIdentity.loadOrCreateCertificate(applicationDescription.getApplicationName().getText(), string, string2, file, keyPair, nArray, bl, applicationDescription.getApplicationUri(), stringArray);
        applicationIdentity.setApplicationDescription(applicationDescription);
        return applicationIdentity;
    }

    public static ApplicationIdentity loadOrCreateCertificate(String string, String string2, File file, File file2, String string3, KeyPair keyPair, boolean bl, String string4, String ... stringArray) throws SecureIdentityException, IOException {
        KeyPair keyPair2 = ApplicationIdentity.loadOrCreateKeyPair(string, string2, file, file2, string3, keyPair, bl, string4, stringArray);
        return new ApplicationIdentity(keyPair2.getCertificate(), keyPair2.getPrivateKey());
    }

    public static ApplicationIdentity loadOrCreateCertificate(String string, String string2, String string3, File file, KeyPair keyPair, int[] nArray, boolean bl, String string4, String ... stringArray) throws SecureIdentityException, IOException {
        if (nArray == null || nArray.length == 0) {
            nArray = new int[]{0};
        }
        KeyPair[] keyPairArray = new KeyPair[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2] == 0 ? 2048 : nArray[i2];
            CertificateUtils.setKeySize(n2);
            String string5 = string;
            string5 = string5 + "_" + n2;
            File file2 = ApplicationIdentity.getBestFile(file, string5, CERT_FILE_EXTENSIONS);
            File file3 = ApplicationIdentity.getBestFile(file, string5, K);
            keyPairArray[i2] = ApplicationIdentity.loadOrCreateKeyPair(string, string2, file2, file3, string3, keyPair, bl, string4, stringArray);
        }
        return new ApplicationIdentity(keyPairArray);
    }

    public static KeyPair loadOrCreateHttpsCertificate(ApplicationDescription applicationDescription, String string, String string2, KeyPair keyPair, File file, boolean bl) throws IOException, SecureIdentityException {
        boolean bl2;
        File file2;
        String string3 = applicationDescription.getApplicationName().getText();
        String string4 = string3 + "_https";
        File file3 = ApplicationIdentity.getBestFile(file, string4, CERT_FILE_EXTENSIONS);
        KeyPair keyPair2 = ApplicationIdentity.loadCertificate("HTTPS", string2, bl, file3, file2 = ApplicationIdentity.getBestFile(file, string4, K), bl2 = file2.getName().toLowerCase().endsWith(".pfx"));
        if (keyPair2 == null) {
            try {
                keyPair2 = ApplicationIdentity.createHttpsCertificate(applicationDescription, string, keyPair);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new SecureIdentityException("Failed to create HTTPS certificate.", generalSecurityException);
            }
            try {
                ApplicationIdentity.saveCertificate("HTTPS", keyPair2, file3, file2, string2, bl2);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new SecureIdentityException("Failed to save HTTPS certificate to PKCS12 store.", generalSecurityException);
            }
        }
        return keyPair2;
    }

    public static KeyPair loadOrCreateIssuerCertificate(String string, File file, String string2, int n2, boolean bl) throws IOException, SecureIdentityException {
        boolean bl2;
        File file2;
        File file3 = ApplicationIdentity.getBestFile(file, string, CERT_FILE_EXTENSIONS);
        KeyPair keyPair = ApplicationIdentity.loadCertificate("Issuer", string2, bl, file3, file2 = ApplicationIdentity.getBestFile(file, string, K), bl2 = file2.getName().toLowerCase().endsWith(".pfx"));
        if (keyPair == null) {
            try {
                keyPair = CertificateUtils.createIssuerCertificate(string, n2, null);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new SecureIdentityException("Failed to create Issuer certificate.", generalSecurityException);
            }
            try {
                ApplicationIdentity.saveCertificate("Issuer", keyPair, file3, file2, string2, bl2);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new SecureIdentityException("Failed to save Issuer certificate to PKCS12 store.", generalSecurityException);
            }
        }
        return keyPair;
    }

    /*
     * Unable to fully structure code
     */
    public static KeyPair loadOrCreateKeyPair(String var0, String var1_1, File var2_2, File var3_3, String var4_4, KeyPair var5_5, boolean var6_6, String var7_7, String ... var8_8) throws IOException, SecureIdentityException {
        var9_9 = false;
        var10_10 = false;
        var11_11 = null;
        var12_12 = null;
        var13_13 = null;
        if (var2_2.exists() && var3_3.exists()) {
            ApplicationIdentity.logger.info("Reading application certificate from {}", (Object)var2_2.getAbsolutePath());
            try {
                var12_12 = Cert.load(var2_2);
            }
            catch (CertificateException var14_14) {
                throw new SecureIdentityException("Cannot load certificate", var14_14);
            }
            if (var12_12 != null) {
                try {
                    var12_12.getCertificate().checkValidity();
                }
                catch (CertificateExpiredException var14_15) {
                    ApplicationIdentity.logger.info("Certificate expired.");
                    if (var6_6) {
                        var9_9 = true;
                    }
                    throw new SecureIdentityException("Certificate expired", var14_15);
                }
                catch (CertificateException var14_16) {
                    throw new SecureIdentityException("Certificate cannot be loaded from file " + var2_2, var14_16);
                }
            }
            ApplicationIdentity.logger.info("Reading private key from keystore {}", (Object)var3_3.getAbsolutePath());
            try {
                block30: {
                    try {
                        var13_13 = PrivKey.load(var3_3, var4_4);
                        ApplicationIdentity.logger.debug("Read private key in PEM format");
                    }
                    catch (Exception var14_17) {
                        ApplicationIdentity.logger.debug("Failed to read PEM: " + var14_17.getMessage(), (Throwable)var14_17);
                        if (!var14_17.getMessage().contains("password")) break block30;
                        throw new SecureIdentityException("Private key cannot be loaded from file " + var3_3, var14_17);
                    }
                }
                if (var13_13 != null) ** GOTO lbl47
                var13_13 = PrivKey.loadFromKeyStore(var3_3, var4_4);
                ApplicationIdentity.logger.debug("Read private key in PKCS12 format");
                var10_10 = true;
            }
            catch (IOException var14_19) {
                throw new SecureIdentityException("Private key cannot be loaded from file " + var3_3, var14_19);
            }
            catch (GeneralSecurityException var14_20) {
                throw new SecureIdentityException("Private key cannot be loaded from file " + var3_3, var14_20);
            }
        } else {
            ApplicationIdentity.logger.debug("Application certificate or private key not found");
            var9_9 = true;
        }
lbl47:
        // 3 sources

        if (var9_9) {
            ApplicationIdentity.logger.info("Creating a new application certificate & private key");
            ApplicationIdentity.a(var2_2);
            ApplicationIdentity.a(var3_3);
            if (var12_12 != null) {
                try {
                    var11_11 = CertificateUtils.renewApplicationInstanceCertificate(var0, var1_1, var7_7, ApplicationIdentity.J, new KeyPair(var12_12, var13_13), var5_5, var8_8);
                }
                catch (GeneralSecurityException var14_21) {
                    throw new SecureIdentityException("Failed to renew the application instance certificate", var14_21);
                }
                catch (IllegalStateException var14_22) {
                    throw new SecureIdentityException("Failed to renew the application instance certificate", var14_22);
                }
            } else {
                var11_11 = ApplicationIdentity.createKeyPair(var0, var1_1, ApplicationIdentity.J, var5_5, var7_7, var8_8);
            }
            var12_12 = var11_11.getCertificate();
            var13_13 = var11_11.getPrivateKey();
            var12_12.save(var2_2);
            if (var10_10) {
                try {
                    var13_13.saveToKeyStore(var12_12, var3_3, var4_4, var4_4, "PKCS12");
                }
                catch (KeyStoreException var14_23) {
                    throw new SecureIdentityException("Cannot save the private key to file " + var3_3, var14_23);
                }
                catch (NoSuchProviderException var14_24) {
                    throw new SecureIdentityException("Cannot save the private key to file " + var3_3, var14_24);
                }
                catch (NoSuchAlgorithmException var14_25) {
                    throw new SecureIdentityException("Cannot save the private key to file " + var3_3, var14_25);
                }
                catch (CertificateException var14_26) {
                    throw new SecureIdentityException("Cannot save the private key to file " + var3_3, var14_26);
                }
            } else {
                var14_18 = System.getProperty("java.runtime.name").toLowerCase();
                if (var14_18.contains("android")) {
                    var13_13.save(var3_3);
                } else {
                    var13_13.save(var3_3, var4_4);
                }
            }
        } else {
            var11_11 = new KeyPair(var12_12, var13_13);
        }
        return var11_11;
    }

    public static void setCacheLocalHostname(boolean bl) {
        L = bl;
    }

    public static void setDefaultCertificateDays(int n2) {
        J = n2;
    }

    private static void a(File file) {
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
    }

    private static void a(ApplicationDescription applicationDescription) throws NullPointerException {
        if (applicationDescription == null) {
            throw new NullPointerException("Cannot set null to ApplicationDescription");
        }
        String string = ApplicationIdentity.replaceHostNameTagWithActualHostName(applicationDescription.getApplicationUri());
        applicationDescription.setApplicationUri(string);
        String string2 = ApplicationIdentity.replaceHostNameTagWithActualHostName(applicationDescription.getApplicationName().getText());
        Locale locale = applicationDescription.getApplicationName().getLocale();
        applicationDescription.setApplicationName(new LocalizedText(string2, locale));
    }

    protected static File getBestFile(File file, String string, String ... stringArray) {
        File file2 = new File(file, string + stringArray[0]);
        if (!file2.exists()) {
            for (int i2 = 1; i2 < stringArray.length; ++i2) {
                File file3 = new File(file, string + stringArray[i2]);
                if (!file3.exists()) continue;
                return file3;
            }
        }
        return file2;
    }

    protected static KeyPair loadCertificate(String string, String string2, boolean bl, File file, File file2, boolean bl2) throws SecureIdentityException {
        if (file.exists() && file2.exists()) {
            Cert cert;
            try {
                cert = Cert.load(file);
                logger.info("{} certificate loaded from {}", (Object)string, (Object)file);
            }
            catch (CertificateException certificateException) {
                throw new SecureIdentityException("Failed to load " + string + " certificate from " + file, certificateException);
            }
            catch (IOException iOException) {
                throw new SecureIdentityException("Failed to load " + string + " certificate from " + file, iOException);
            }
            boolean bl3 = false;
            try {
                cert.getCertificate().checkValidity();
                bl3 = true;
            }
            catch (CertificateExpiredException certificateExpiredException) {
                logger.info("{} certificate expired.", (Object)string);
                if (!bl) {
                    throw new SecureIdentityException(string + " certificate expired", certificateExpiredException);
                }
            }
            catch (CertificateException certificateException) {
                throw new SecureIdentityException("Failed to load " + string + " certificate from " + file, certificateException);
            }
            if (bl3) {
                PrivKey privKey;
                try {
                    if (bl2) {
                        logger.debug("Reading private key in PKCS12 format");
                        privKey = PrivKey.loadFromKeyStore(file2, string2);
                    } else {
                        logger.debug("Reading private key in PEM format");
                        privKey = PrivKey.load(file2, string2);
                    }
                    logger.info("{} private key loaded from {}", (Object)string, (Object)file2);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new SecureIdentityException("Failed to load " + string + " private key from " + file2, generalSecurityException);
                }
                catch (IOException iOException) {
                    throw new SecureIdentityException("Failed to load " + string + " private key from " + file2, iOException);
                }
                return new KeyPair(cert, privKey);
            }
        }
        return null;
    }

    protected static ApplicationIdentity loadOrCreateFromProtectedStore(ApplicationDescription applicationDescription, String string, String string2, String string3, String string4, KeyPair keyPair, String ... stringArray) throws IOException, SecureIdentityException {
        KeyPair keyPair2;
        String string5;
        ApplicationIdentity.a(applicationDescription);
        String string6 = string5 = applicationDescription.getApplicationName().getText();
        try {
            keyPair2 = CertificateUtils.loadKeyPairFromProtectedStore(string3, string6, string4, string2);
        }
        catch (Exception exception) {
            keyPair2 = ApplicationIdentity.createKeyPair(string5, string, J, keyPair, applicationDescription.getApplicationUri(), stringArray);
            try {
                CertificateUtils.saveKeyPairToProtectedStore(keyPair2, string3, string6, string4, string2);
            }
            catch (KeyStoreException keyStoreException) {
                throw new SecureIdentityException("Cannot save key pair to key store " + string3, exception);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new SecureIdentityException("Cannot save key pair to key store " + string3, exception);
            }
            catch (CertificateException certificateException) {
                throw new SecureIdentityException("Cannot save key pair to key store " + string3, exception);
            }
        }
        ApplicationIdentity applicationIdentity = new ApplicationIdentity(keyPair2.getCertificate(), keyPair2.getPrivateKey());
        applicationIdentity.setApplicationDescription(applicationDescription);
        applicationIdentity.setOrganisation(string);
        return applicationIdentity;
    }

    protected static String replaceHostNameTagWithActualHostName(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        return string.replaceAll("localhost", ApplicationIdentity.getActualHostName()).replaceAll("domainname", ApplicationIdentity.getActualHostName()).replaceAll("hostname", ApplicationIdentity.getActualHostNameWithoutDomain());
    }

    protected static void saveCertificate(String string, KeyPair keyPair, File file, File file2, String string2, boolean bl) throws IOException, GeneralSecurityException {
        ApplicationIdentity.a(file);
        ApplicationIdentity.a(file2);
        keyPair.getCertificate().save(file);
        logger.info("{} certificate saved to {}", (Object)string, (Object)file);
        if (bl) {
            keyPair.getPrivateKey().saveToKeyStore(keyPair.getCertificate(), file2, string2, string2, "PKCS12");
        }
        keyPair.getPrivateKey().save(file2, string2);
        logger.info("{} private key saved to {}", (Object)string, (Object)file2);
    }

    public ApplicationIdentity() {
    }

    public ApplicationIdentity(Cert cert, PrivKey privKey) {
        super(cert, privKey);
    }

    public ApplicationIdentity(File file, File file2, String string) throws IOException, SecureIdentityException {
        super(file, file2, string);
    }

    public ApplicationIdentity(File file, String string, String string2, String string3, String string4) throws IOException, SecureIdentityException {
        super(file, string, string2, string3, string4);
    }

    public ApplicationIdentity(KeyPair ... keyPairArray) {
        super(keyPairArray != null && keyPairArray.length > 0 ? keyPairArray[0].getCertificate() : null, keyPairArray != null && keyPairArray.length > 0 ? keyPairArray[0].getPrivateKey() : null);
        this.O = keyPairArray;
    }

    public ApplicationIdentity(URL uRL, URL uRL2, String string) throws IOException, SecureIdentityException {
        super(uRL, uRL2, string);
    }

    @Deprecated
    public void addSoftwareCertificates(SignedSoftwareCertificate[] signedSoftwareCertificateArray) {
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        return this.getClass() == object.getClass();
    }

    public ApplicationDescription getApplicationDescription() {
        return this.N;
    }

    public KeyPair[] getCertificates() {
        if (this.O != null) {
            return this.O;
        }
        return new KeyPair[]{new KeyPair(this.getCertificate(), this.getPrivateKey())};
    }

    public KeyPair getHttpsCertificate() {
        return this.P;
    }

    public String getOrganisation() {
        return this.Q;
    }

    @Deprecated
    public SignedSoftwareCertificate[] getSoftwareCertificates() {
        return new SignedSoftwareCertificate[0];
    }

    @Override
    public int hashCode() {
        int n2 = 31;
        int n3 = super.hashCode();
        n3 = 31 * n3;
        return n3;
    }

    public void setApplicationDescription(ApplicationDescription applicationDescription) {
        this.setApplicationDescription(applicationDescription, true);
    }

    public void setApplicationDescription(ApplicationDescription applicationDescription, boolean bl) {
        if (bl) {
            ApplicationIdentity.a(applicationDescription);
        }
        this.N = applicationDescription;
    }

    public void setHttpsCertificate(KeyPair keyPair) {
        this.P = keyPair;
    }

    public void setOrganisation(String string) {
        this.Q = string;
    }
}

