/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.utils.bytebuffer;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.opcfoundation.ua.utils.bytebuffer.IBinaryWriteable;

public class OutputStreamWriteable
implements IBinaryWriteable {
    ByteOrder order = ByteOrder.nativeOrder();
    OutputStream out;

    public OutputStreamWriteable(OutputStream outputStream) {
        if (outputStream == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.out = outputStream;
    }

    public OutputStream getStream() {
        return this.out;
    }

    void _put(int n) throws IOException {
        this.out.write(n);
    }

    @Override
    public void put(byte by) throws IOException {
        this._put(by);
    }

    @Override
    public void put(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer.hasArray()) {
            byte[] byArray = byteBuffer.array();
            this.put(byArray, byteBuffer.position(), byteBuffer.remaining());
            byteBuffer.position(byteBuffer.limit());
        } else {
            while (byteBuffer.hasRemaining()) {
                this._put(byteBuffer.get());
            }
        }
    }

    @Override
    public void put(ByteBuffer byteBuffer, int n) throws IOException {
        if (byteBuffer.hasArray()) {
            byte[] byArray = byteBuffer.array();
            this.put(byArray, byteBuffer.position(), n);
            byteBuffer.position(n);
        } else {
            for (int i = 0; i < n; ++i) {
                this._put(byteBuffer.get());
            }
        }
    }

    @Override
    public void put(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
    }

    @Override
    public void put(byte[] byArray) throws IOException {
        this.out.write(byArray);
    }

    @Override
    public void putDouble(double d) throws IOException {
        this.putLong(Double.doubleToLongBits(d));
    }

    @Override
    public void putFloat(float f) throws IOException {
        this.putInt(Float.floatToIntBits(f));
    }

    @Override
    public void putInt(int n) throws IOException {
        if (this.order == ByteOrder.BIG_ENDIAN) {
            this._put(n >> 24);
            this._put(n >> 16);
            this._put(n >> 8);
            this._put(n);
        } else {
            this._put(n);
            this._put(n >> 8);
            this._put(n >> 16);
            this._put(n >> 24);
        }
    }

    @Override
    public void putLong(long l) throws IOException {
        if (this.order == ByteOrder.BIG_ENDIAN) {
            this._put((int)(l >> 56));
            this._put((int)(l >> 48));
            this._put((int)(l >> 40));
            this._put((int)(l >> 32));
            this._put((int)(l >> 24));
            this._put((int)(l >> 16));
            this._put((int)(l >> 8));
            this._put((int)l);
        } else {
            this._put((int)l);
            this._put((int)(l >> 8));
            this._put((int)(l >> 16));
            this._put((int)(l >> 24));
            this._put((int)(l >> 32));
            this._put((int)(l >> 40));
            this._put((int)(l >> 48));
            this._put((int)(l >> 56));
        }
    }

    @Override
    public void putShort(short s) throws IOException {
        if (this.order == ByteOrder.BIG_ENDIAN) {
            this._put(s >> 8);
            this._put(s);
        } else {
            this._put(s);
            this._put(s >> 8);
        }
    }

    @Override
    public ByteOrder order() {
        return this.order;
    }

    @Override
    public void order(ByteOrder byteOrder) {
        this.order = byteOrder;
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }
}

