/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.utils.bytebuffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.TreeMap;

public class OrderedByteBufferInputStream
extends InputStream {
    ByteBuffer cur;
    int next = 0;
    int last = -1;
    int close = -1;
    TreeMap<Integer, ByteBuffer> bufs = new TreeMap();

    public synchronized void offer(int n, ByteBuffer byteBuffer) {
        if (n < 0 || this.bufs.containsKey(n) || n < this.next) {
            throw new IllegalArgumentException("sequence number");
        }
        if (this.close > 0 && n >= this.close) {
            throw new RuntimeException("Cannot put data at " + n + " because the stream was closed at " + this.close);
        }
        if (n > this.last) {
            this.last = n;
        }
        this.bufs.put(n, byteBuffer);
        this.notify();
    }

    public void offer(ByteBuffer byteBuffer) {
        this.offer(this.last + 1, byteBuffer);
    }

    @Override
    public void close() {
        this.close(this.last + 1);
    }

    public synchronized void close(int n) {
        if (this.close >= 0) {
            return;
        }
        if (n < 0 || n <= this.last) {
            throw new IllegalArgumentException("sequence number illegal");
        }
        this.close = n;
        this.notifyAll();
    }

    public synchronized void forceClose() {
        this.close = this.next;
        this.notifyAll();
    }

    private synchronized ByteBuffer getByteBuffer() throws InterruptedIOException {
        if (this.cur != null && this.cur.hasRemaining()) {
            return this.cur;
        }
        if (this.cur != null && !this.cur.hasRemaining()) {
            this.cur = null;
        }
        while (this.cur == null) {
            if (this.next >= this.close && this.close > 0) {
                return null;
            }
            this.cur = this.bufs.remove(this.next);
            if (this.cur == null) {
                try {
                    this.wait();
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException();
                }
            }
            ++this.next;
            if (this.cur.hasRemaining()) continue;
            this.cur = null;
        }
        return this.cur;
    }

    @Override
    public synchronized int read() throws IOException {
        ByteBuffer byteBuffer = this.getByteBuffer();
        if (byteBuffer == null) {
            return -1;
        }
        return byteBuffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n2 > 0) {
            ByteBuffer byteBuffer = this.getByteBuffer();
            if (byteBuffer == null) {
                return n3 > 0 ? n3 : -1;
            }
            int n4 = Math.min(byteBuffer.remaining(), n2);
            byteBuffer.put(byArray, n, n4);
            n += n4;
            n3 += n4;
            n2 -= n4;
        }
        return n3;
    }

    @Override
    public synchronized int available() throws IOException {
        ByteBuffer byteBuffer;
        int n = 0;
        if (this.cur != null) {
            n += this.cur.remaining();
        }
        for (int i = this.next; i <= this.last && (byteBuffer = this.bufs.get(i)) != null; ++i) {
            n += byteBuffer.remaining();
        }
        return n;
    }
}

