/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.utils.bytebuffer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.opcfoundation.ua.utils.bytebuffer.IBinaryWriteable;

public class ByteBufferWriteable
implements IBinaryWriteable {
    ByteBuffer buf;

    public ByteBufferWriteable(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            throw new IllegalArgumentException("null");
        }
        this.buf = byteBuffer;
    }

    @Override
    public void put(byte by) {
        this.buf.put(by);
    }

    @Override
    public void put(ByteBuffer byteBuffer) {
        this.buf.put(byteBuffer);
    }

    @Override
    public void put(ByteBuffer byteBuffer, int n) {
        if (byteBuffer.hasArray()) {
            byte[] byArray = byteBuffer.array();
            this.buf.put(byArray, byteBuffer.arrayOffset() + byteBuffer.position(), n);
        } else {
            for (int i = 0; i < n; ++i) {
                this.buf.put(byteBuffer.get());
            }
        }
    }

    @Override
    public void put(byte[] byArray, int n, int n2) {
        this.buf.put(byArray, n, n2);
    }

    @Override
    public void put(byte[] byArray) {
        this.buf.put(byArray);
    }

    @Override
    public void putDouble(double d) {
        this.buf.putDouble(d);
    }

    @Override
    public void putFloat(float f) {
        this.buf.putFloat(f);
    }

    @Override
    public void putInt(int n) {
        this.buf.putInt(n);
    }

    @Override
    public void putLong(long l) {
        this.buf.putLong(l);
    }

    @Override
    public void putShort(short s) {
        this.buf.putShort(s);
    }

    @Override
    public ByteOrder order() {
        return this.buf.order();
    }

    @Override
    public void order(ByteOrder byteOrder) {
        this.buf.order(byteOrder);
    }

    @Override
    public void flush() {
    }

    public long position() throws IOException {
        return this.buf.position();
    }

    public void position(long l) throws IOException {
        if (l >= Integer.MAX_VALUE || l < 0L) {
            throw new IllegalArgumentException("index out of range");
        }
        this.buf.position((int)l);
    }
}

