/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.utils.bytebuffer;

import java.nio.ByteBuffer;

public class ByteBufferUtils {
    public static void copyRemaining(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        int n = Math.min(byteBuffer.remaining(), byteBuffer2.remaining());
        ByteBufferUtils.copy(byteBuffer, byteBuffer2, n);
    }

    public static void copy(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n) {
        int n2 = byteBuffer.limit();
        int n3 = byteBuffer2.limit();
        byteBuffer.limit(byteBuffer.position() + n);
        byteBuffer2.limit(byteBuffer2.position() + n);
        byteBuffer2.put(byteBuffer);
        byteBuffer.limit(n2);
        byteBuffer2.limit(n3);
    }

    public static byte[] concatenate(byte[] ... byArray) {
        int n = 0;
        for (byte[] byArray2 : byArray) {
            n += byArray2.length;
        }
        byte[] byArray3 = new byte[n];
        int n2 = 0;
        for (byte[] byArray4 : byArray) {
            System.arraycopy(byArray4, 0, byArray3, n2, byArray4.length);
            n2 += byArray4.length;
        }
        return byArray3;
    }
}

