/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.utils.bytebuffer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.opcfoundation.ua.utils.bytebuffer.IBinaryReadable;

public class ByteBufferReadable
implements IBinaryReadable {
    ByteBuffer buf;

    public ByteBufferReadable(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            throw new IllegalArgumentException("null");
        }
        this.buf = byteBuffer;
    }

    public ByteBufferReadable(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("null");
        }
        this.buf = ByteBuffer.wrap(byArray);
    }

    @Override
    public byte get() {
        return this.buf.get();
    }

    @Override
    public void get(byte[] byArray, int n, int n2) {
        this.buf.get(byArray, n, n2);
    }

    @Override
    public void get(byte[] byArray) {
        this.buf.get(byArray);
    }

    @Override
    public void get(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            this.buf.get(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            byteBuffer.position(byteBuffer.capacity());
        } else {
            byteBuffer.put(byteBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void get(ByteBuffer byteBuffer, int n) {
        if (byteBuffer.hasArray()) {
            this.buf.get(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), n);
            byteBuffer.position(byteBuffer.position() + n);
        } else {
            int n2 = n;
            int n3 = this.buf.limit();
            try {
                this.buf.limit(this.buf.position() + n2);
                byteBuffer.put(this.buf);
            }
            finally {
                this.buf.limit(n3);
            }
        }
    }

    @Override
    public double getDouble() {
        return this.buf.getDouble();
    }

    @Override
    public float getFloat() {
        return this.buf.getFloat();
    }

    @Override
    public int getInt() {
        return this.buf.getInt();
    }

    @Override
    public long getLong() {
        return this.buf.getLong();
    }

    @Override
    public short getShort() {
        return this.buf.getShort();
    }

    @Override
    public long limit() {
        return this.buf.limit();
    }

    @Override
    public long position() {
        return this.buf.position();
    }

    @Override
    public ByteOrder order() {
        return this.buf.order();
    }

    @Override
    public void order(ByteOrder byteOrder) {
        this.buf.order(byteOrder);
    }

    public void position(int n) throws IOException {
        this.buf.position(n);
    }

    public void position(long l) throws IOException {
        if (l >= Integer.MAX_VALUE || l < 0L) {
            throw new IllegalArgumentException("index out of range");
        }
        this.buf.position((int)l);
    }

    public void skip(long l) throws IOException {
        long l2 = l + this.position();
        this.position(l2);
    }
}

