/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.utils.bytebuffer;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.opcfoundation.ua.utils.bytebuffer.ByteBufferUtils;
import org.opcfoundation.ua.utils.bytebuffer.IBinaryWriteable;

public class ByteBufferArrayWriteable2
implements IBinaryWriteable {
    ByteBuffer[] bufs;
    int i = 0;
    ByteBuffer cur;
    ByteOrder order;
    ChunkListener listener;

    public ByteBufferArrayWriteable2(ByteBuffer[] byteBufferArray, ChunkListener chunkListener) {
        if (byteBufferArray == null || chunkListener == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.bufs = byteBufferArray;
        this.listener = chunkListener;
        this.cur = byteBufferArray[0];
    }

    protected void fireChunkComplete(int n) {
        if (this.listener != null) {
            this.listener.onChunkComplete(this.bufs, n);
        }
    }

    @Override
    public ByteOrder order() {
        return this.order;
    }

    @Override
    public void order(ByteOrder byteOrder) {
        this.order = byteOrder;
        this.cur.order(byteOrder);
    }

    private void checkChunk() {
        if (!this.cur.hasRemaining()) {
            this.fireChunkComplete(this.i);
        }
    }

    private void prepareNextChunk() {
        while (!this.cur.hasRemaining()) {
            ++this.i;
            if (this.i >= this.bufs.length) {
                throw new BufferOverflowException();
            }
            this.cur = this.bufs[this.i];
            this.cur.order(this.order);
        }
    }

    void _put(int n) throws IOException {
        this.prepareNextChunk();
        this.cur.put((byte)n);
        this.checkChunk();
    }

    @Override
    public void put(byte by) throws IOException {
        this.prepareNextChunk();
        this.cur.put(by);
        this.checkChunk();
    }

    @Override
    public void put(ByteBuffer byteBuffer) throws IOException {
        while (byteBuffer.hasRemaining()) {
            this.prepareNextChunk();
            ByteBufferUtils.copyRemaining(byteBuffer, this.cur);
            this.checkChunk();
        }
    }

    @Override
    public void put(ByteBuffer byteBuffer, int n) throws IOException {
        while (n > 0) {
            this.prepareNextChunk();
            int n2 = Math.min(n, Math.min(byteBuffer.remaining(), this.cur.remaining()));
            ByteBufferUtils.copy(byteBuffer, this.cur, n2);
            n -= n2;
            this.checkChunk();
        }
    }

    @Override
    public void put(byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            this.prepareNextChunk();
            int n3 = Math.min(n2, this.cur.remaining());
            this.cur.put(byArray, n, n3);
            n += n3;
            n2 -= n3;
            this.checkChunk();
        }
    }

    @Override
    public void put(byte[] byArray) throws IOException {
        this.put(byArray, 0, byArray.length);
    }

    @Override
    public void putDouble(double d) throws IOException {
        this.putLong(Double.doubleToLongBits(d));
    }

    @Override
    public void putFloat(float f) throws IOException {
        this.putInt(Float.floatToIntBits(f));
    }

    @Override
    public void putInt(int n) throws IOException {
        if (this.order == ByteOrder.BIG_ENDIAN) {
            this._put(n >> 24);
            this._put(n >> 16);
            this._put(n >> 8);
            this._put(n);
        } else {
            this._put(n);
            this._put(n >> 8);
            this._put(n >> 16);
            this._put(n >> 24);
        }
    }

    @Override
    public void putLong(long l) throws IOException {
        if (this.order == ByteOrder.BIG_ENDIAN) {
            this._put((int)(l >> 56));
            this._put((int)(l >> 48));
            this._put((int)(l >> 40));
            this._put((int)(l >> 32));
            this._put((int)(l >> 24));
            this._put((int)(l >> 16));
            this._put((int)(l >> 8));
            this._put((int)l);
        } else {
            this._put((int)l);
            this._put((int)(l >> 8));
            this._put((int)(l >> 16));
            this._put((int)(l >> 24));
            this._put((int)(l >> 32));
            this._put((int)(l >> 40));
            this._put((int)(l >> 48));
            this._put((int)(l >> 56));
        }
    }

    @Override
    public void putShort(short s) throws IOException {
        if (this.order == ByteOrder.BIG_ENDIAN) {
            this._put(s >> 8);
            this._put(s);
        } else {
            this._put(s);
            this._put(s >> 8);
        }
    }

    @Override
    public void flush() {
    }

    public static interface ChunkListener {
        public void onChunkComplete(ByteBuffer[] var1, int var2);
    }
}

