/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.utils.bytebuffer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.opcfoundation.ua.utils.bytebuffer.ByteQueue;
import org.opcfoundation.ua.utils.bytebuffer.IBinaryWriteable;

public class ByteBufferArrayWriteable
implements IBinaryWriteable {
    ByteQueue q;
    ByteBuffer tmp = ByteBuffer.allocate(8);

    public ByteBufferArrayWriteable(ByteBuffer[] byteBufferArray) {
        if (byteBufferArray == null) {
            throw new IllegalArgumentException("null");
        }
        this.q = new ByteQueue();
        this.tmp.order(this.q.order());
        for (ByteBuffer byteBuffer : byteBufferArray) {
            this.q.offer(byteBuffer);
        }
    }

    public ByteBufferArrayWriteable(ByteQueue byteQueue) {
        if (byteQueue == null) {
            throw new IllegalArgumentException("null");
        }
        this.q = byteQueue;
        this.tmp.order(byteQueue.order());
    }

    @Override
    public ByteOrder order() {
        return this.q.order();
    }

    @Override
    public void order(ByteOrder byteOrder) {
        this.tmp.order(byteOrder);
        this.q.order(byteOrder);
    }

    @Override
    public void put(byte by) throws IOException {
        this.q.getWriteChunk().put(by);
    }

    @Override
    public void put(ByteBuffer byteBuffer) throws IOException {
        this.q.put(byteBuffer);
    }

    @Override
    public void put(ByteBuffer byteBuffer, int n) throws IOException {
        this.q.put(byteBuffer, n);
    }

    @Override
    public void put(byte[] byArray, int n, int n2) throws IOException {
        this.q.put(byArray, n, n2);
    }

    @Override
    public void put(byte[] byArray) throws IOException {
        this.q.put(byArray);
    }

    @Override
    public void putDouble(double d) throws IOException {
        if (this.q.getWriteChunk().remaining() > 8) {
            this.q.getWriteChunk().putDouble(d);
        } else {
            this.tmp.rewind();
            this.tmp.putDouble(d);
            this.tmp.rewind();
            this.q.put(this.tmp, 8);
        }
    }

    @Override
    public void putFloat(float f) throws IOException {
        if (this.q.getWriteChunk().remaining() > 4) {
            this.q.getWriteChunk().putFloat(f);
        } else {
            this.tmp.rewind();
            this.tmp.putFloat(f);
            this.tmp.rewind();
            this.q.put(this.tmp, 4);
        }
    }

    @Override
    public void putInt(int n) throws IOException {
        if (this.q.getWriteChunk().remaining() > 4) {
            this.q.getWriteChunk().putInt(n);
        } else {
            this.tmp.rewind();
            this.tmp.putInt(n);
            this.tmp.rewind();
            this.q.put(this.tmp, 4);
        }
    }

    @Override
    public void putLong(long l) throws IOException {
        if (this.q.getWriteChunk().remaining() > 8) {
            this.q.getWriteChunk().putLong(l);
        } else {
            this.tmp.rewind();
            this.tmp.putLong(l);
            this.tmp.rewind();
            this.q.put(this.tmp, 8);
        }
    }

    @Override
    public void putShort(short s) throws IOException {
        if (this.q.getWriteChunk().remaining() > 2) {
            this.q.getWriteChunk().putShort(s);
        } else {
            this.tmp.rewind();
            this.tmp.putShort(s);
            this.tmp.rewind();
            this.q.put(this.tmp, 2);
        }
    }

    @Override
    public void flush() {
    }
}

