/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.utils.asyncsocket;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opcfoundation.ua.utils.CurrentThreadExecutor;
import org.opcfoundation.ua.utils.asyncsocket.AsyncSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenableSocketChannel {
    static Logger logger = LoggerFactory.getLogger(ListenableSocketChannel.class);
    Executor executor;
    SocketChannel channel;
    volatile ConnectionListener connectListener;
    volatile ReadableListener readListener;
    volatile WriteableListener writeListener;
    AsyncSelector selector;
    boolean closed = false;
    boolean ownsSelector = false;
    AtomicBoolean readHndLock = new AtomicBoolean(false);
    AtomicBoolean writeHndLock = new AtomicBoolean(false);
    AtomicBoolean connectHndLock = new AtomicBoolean(false);
    AsyncSelector.SelectListener selListener = new AsyncSelector.SelectListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSelected(AsyncSelector asyncSelector, SelectableChannel selectableChannel, int n, int n2) {
            try {
                if ((n & 8) != 0 && !ListenableSocketChannel.this.connectHndLock.get()) {
                    ListenableSocketChannel.this.connectHndLock.set(true);
                    ListenableSocketChannel.this.executor.execute(ListenableSocketChannel.this.connectRun);
                }
                if ((n & 1) != 0 && !ListenableSocketChannel.this.readHndLock.get()) {
                    ListenableSocketChannel.this.readHndLock.set(true);
                    ListenableSocketChannel.this.executor.execute(ListenableSocketChannel.this.readRun);
                }
                if ((n & 4) != 0 && !ListenableSocketChannel.this.writeHndLock.get()) {
                    ListenableSocketChannel.this.writeHndLock.set(true);
                    ListenableSocketChannel.this.executor.execute(ListenableSocketChannel.this.writeRun);
                }
            }
            finally {
                if (ListenableSocketChannel.this.executor == CurrentThreadExecutor.INSTANCE) {
                    asyncSelector.interestOps(selectableChannel, ListenableSocketChannel.this.getInterestOps());
                }
            }
        }
    };
    Runnable connectRun = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block10: {
                assert (ListenableSocketChannel.this.connectHndLock.get());
                ConnectionListener connectionListener = ListenableSocketChannel.this.getConnectListener();
                try {
                    if (connectionListener == null) break block10;
                    try {
                        boolean bl = ListenableSocketChannel.this.channel.finishConnect();
                        if (connectionListener != null && bl) {
                            connectionListener.onConnected(ListenableSocketChannel.this);
                        }
                        if (connectionListener != null && !bl) {
                            connectionListener.onConnectFailed(ListenableSocketChannel.this, new ConnectException());
                        }
                    }
                    catch (IOException iOException) {
                        if (connectionListener != null) {
                            connectionListener.onConnectFailed(ListenableSocketChannel.this, iOException);
                        }
                    }
                }
                finally {
                    ListenableSocketChannel.this.connectHndLock.set(false);
                    if (ListenableSocketChannel.this.executor != CurrentThreadExecutor.INSTANCE) {
                        ListenableSocketChannel.this.attemptUpdateInterestOps();
                    }
                }
            }
        }
    };
    Runnable readRun = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            assert (ListenableSocketChannel.this.readHndLock.get());
            ReadableListener readableListener = ListenableSocketChannel.this.getReadListener();
            try {
                if (readableListener != null) {
                    readableListener.onDataReadable(ListenableSocketChannel.this);
                }
            }
            finally {
                ListenableSocketChannel.this.readHndLock.set(false);
                if (ListenableSocketChannel.this.executor != CurrentThreadExecutor.INSTANCE) {
                    ListenableSocketChannel.this.attemptUpdateInterestOps();
                }
            }
        }
    };
    Runnable writeRun = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            assert (ListenableSocketChannel.this.writeHndLock.get());
            WriteableListener writeableListener = ListenableSocketChannel.this.getWriteListener();
            try {
                if (writeableListener != null) {
                    writeableListener.onDataWriteable(ListenableSocketChannel.this);
                }
            }
            finally {
                ListenableSocketChannel.this.writeHndLock.set(false);
                if (ListenableSocketChannel.this.executor != CurrentThreadExecutor.INSTANCE) {
                    ListenableSocketChannel.this.attemptUpdateInterestOps();
                }
            }
        }
    };

    public ListenableSocketChannel(Executor executor) throws IOException {
        this((SocketChannel)SocketChannel.open().configureBlocking(false), executor);
    }

    public ListenableSocketChannel(SocketChannel socketChannel, Executor executor) throws IOException {
        this(socketChannel, executor, new AsyncSelector());
        this.ownsSelector = true;
    }

    public ListenableSocketChannel(SocketChannel socketChannel, Executor executor, AsyncSelector asyncSelector) throws IOException {
        logger.debug("ListenableSocketChannel: channel={}", (Object)socketChannel);
        if (socketChannel == null || executor == null) {
            throw new IllegalArgumentException();
        }
        if (socketChannel.isBlocking()) {
            throw new IllegalArgumentException("channel arg must be in non-blocking mode. (SocketChannel.configureBlocking(false))");
        }
        this.channel = socketChannel;
        this.executor = executor;
        this.selector = asyncSelector;
        this.selector.register(socketChannel, 0, this.selListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        boolean bl = this.channel.isRegistered();
        boolean bl2 = this.channel.isOpen();
        logger.debug("close: channel.isRegistered()={}", (Object)bl);
        if (bl) {
            this.selector.unregister(this.channel);
        }
        logger.debug("close: channel.isOpen()={}", (Object)bl2);
        if (bl2) {
            try {
                this.channel.close();
                logger.debug("closed");
            }
            catch (IOException iOException) {
                logger.error("close", (Throwable)iOException);
            }
        }
        logger.debug("close: ownsSelector={}", (Object)this.ownsSelector);
        if (this.ownsSelector) {
            try {
                this.selector.close();
            }
            catch (IOException iOException) {
                logger.error("close: selector.close", (Throwable)iOException);
            }
        }
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    public AsyncSelector getSelectorThread() {
        return this.selector;
    }

    void attemptUpdateInterestOps() {
        try {
            int n = this.getInterestOps();
            this.selector.interestOps(this.channel, n);
        }
        catch (CancelledKeyException cancelledKeyException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    int getInterestOps() {
        if (!this.channel.isOpen() || !this.channel.isRegistered()) {
            return 0;
        }
        int n = 0;
        if (this.readListener != null && !this.readHndLock.get() && this.channel.isConnected()) {
            n |= 1;
        }
        if (this.writeListener != null && !this.writeHndLock.get() && this.channel.isConnected()) {
            n |= 4;
        }
        if (this.connectListener != null && !this.connectHndLock.get() && !this.channel.isConnected()) {
            n |= 8;
        }
        return n;
    }

    public void connect(SocketAddress socketAddress) throws IOException {
        this.attemptUpdateInterestOps();
        this.channel.connect(socketAddress);
    }

    public boolean syncConnect(SocketAddress socketAddress, long l) throws IOException {
        final Semaphore semaphore = new Semaphore(0);
        final IOException[] iOExceptionArray = new IOException[1];
        this.setConnectListener(new ConnectionListener(){

            @Override
            public void onConnected(ListenableSocketChannel listenableSocketChannel) {
                semaphore.release();
            }

            @Override
            public void onConnectFailed(ListenableSocketChannel listenableSocketChannel, IOException iOException) {
                iOExceptionArray[0] = iOException;
                semaphore.release();
            }
        });
        this.connect(socketAddress);
        try {
            if (!semaphore.tryAcquire(l, TimeUnit.MILLISECONDS)) {
                return false;
            }
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        if (iOExceptionArray[0] != null) {
            throw iOExceptionArray[0];
        }
        return true;
    }

    public void setConnectListener(ConnectionListener connectionListener) {
        this.connectListener = connectionListener;
        this.attemptUpdateInterestOps();
    }

    public void setReadListener(ReadableListener readableListener) {
        this.readListener = readableListener;
        this.attemptUpdateInterestOps();
    }

    public void setWriteListener(WriteableListener writeableListener) {
        this.writeListener = writeableListener;
        this.attemptUpdateInterestOps();
    }

    public ConnectionListener getConnectListener() {
        return this.connectListener;
    }

    public ReadableListener getReadListener() {
        return this.readListener;
    }

    public WriteableListener getWriteListener() {
        return this.writeListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public static interface WriteableListener {
        public void onDataWriteable(ListenableSocketChannel var1);
    }

    public static interface ReadableListener {
        public void onDataReadable(ListenableSocketChannel var1);
    }

    public static interface ConnectionListener {
        public void onConnected(ListenableSocketChannel var1);

        public void onConnectFailed(ListenableSocketChannel var1, IOException var2);
    }
}

