/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.utils.asyncsocket;

import java.io.IOException;
import java.util.concurrent.Executor;
import org.opcfoundation.ua.utils.AbstractState;
import org.opcfoundation.ua.utils.asyncsocket.BufferMonitorState;

public abstract class BufferMonitor
extends AbstractState<BufferMonitorState, IOException>
implements Comparable<BufferMonitor> {
    long triggerPos;
    Executor eventExecutor;

    BufferMonitor(long l, Executor executor) {
        super(BufferMonitorState.Waiting, BufferMonitorState.Error);
        this.triggerPos = l;
        this.eventExecutor = executor;
    }

    public long getTriggerPos() {
        return this.triggerPos;
    }

    @Override
    public int compareTo(BufferMonitor bufferMonitor) {
        long l = this.triggerPos - bufferMonitor.triggerPos;
        return l == 0L ? 0 : (l < 0L ? -1 : 1);
    }

    public synchronized void cancel() {
        if (this.getState() != BufferMonitorState.Waiting) {
            return;
        }
        this.setState(BufferMonitorState.Canceled, this.eventExecutor, null);
    }

    @Override
    protected synchronized void setError(IOException iOException) {
        super.setError(iOException);
    }

    synchronized void close() {
        if (this.getState() != BufferMonitorState.Waiting) {
            return;
        }
        super.setState(BufferMonitorState.Closed, this.eventExecutor, null);
    }

    synchronized void trigger() {
        if (this.getState() != BufferMonitorState.Waiting) {
            return;
        }
        super.setState(BufferMonitorState.Triggered, this.eventExecutor, null);
    }
}

