/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.utils;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import org.opcfoundation.ua.transport.security.KeyPair;
import org.opcfoundation.ua.utils.CertificateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.AuthorityKeyIdentifierExtension;
import sun.security.x509.BasicConstraintsExtension;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.CertificateIssuerName;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateSubjectName;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.DNSName;
import sun.security.x509.ExtendedKeyUsageExtension;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.GeneralNames;
import sun.security.x509.IPAddressName;
import sun.security.x509.KeyIdentifier;
import sun.security.x509.KeyUsageExtension;
import sun.security.x509.OIDName;
import sun.security.x509.RFC822Name;
import sun.security.x509.SubjectAlternativeNameExtension;
import sun.security.x509.SubjectKeyIdentifierExtension;
import sun.security.x509.URIName;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public class SunJceUtils {
    private static Logger logger = LoggerFactory.getLogger(CertificateUtils.class);
    private static final String KUE_SERVER_AUTH = "1.3.6.1.5.5.7.3.1";
    private static final String KUE_CLIENT_AUTH = "1.3.6.1.5.5.7.3.2";
    private static final String SUBJECT_ALT_NAME_OID = "2.5.29.17";

    public static byte[] base64Decode(String string) {
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        try {
            return bASE64Decoder.decodeBuffer(string);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static String base64Encode(byte[] byArray) {
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        return bASE64Encoder.encode(byArray);
    }

    public static X509Certificate generateIssuerCert(PublicKey publicKey, PrivateKey privateKey, KeyPair keyPair, String string, BigInteger bigInteger, Date date, Date date2) throws GeneralSecurityException, IOException {
        Serializable serializable;
        PrivateKey privateKey2;
        AuthorityKeyIdentifierExtension authorityKeyIdentifierExtension;
        X500Name x500Name;
        X509CertInfo x509CertInfo = new X509CertInfo();
        CertificateExtensions certificateExtensions = new CertificateExtensions();
        CertificateValidity certificateValidity = new CertificateValidity(date, date2);
        X500Name x500Name2 = new X500Name(string);
        KeyIdentifier keyIdentifier = new KeyIdentifier(publicKey);
        if (keyPair == null) {
            x500Name = x500Name2;
            authorityKeyIdentifierExtension = new AuthorityKeyIdentifierExtension(keyIdentifier, null, null);
            privateKey2 = privateKey;
        } else {
            serializable = keyPair.getCertificate().getCertificate();
            x500Name = new X500Name(serializable.getSubjectX500Principal().getName());
            authorityKeyIdentifierExtension = new AuthorityKeyIdentifierExtension(new KeyIdentifier(serializable.getPublicKey()), null, null);
            privateKey2 = keyPair.getPrivateKey().getPrivateKey();
        }
        x509CertInfo.set("validity", certificateValidity);
        x509CertInfo.set("serialNumber", new CertificateSerialNumber(bigInteger));
        x509CertInfo.set("subject", new CertificateSubjectName(x500Name2));
        x509CertInfo.set("key", new CertificateX509Key(publicKey));
        x509CertInfo.set("version", new CertificateVersion(2));
        x509CertInfo.set("issuer", new CertificateIssuerName(x500Name));
        serializable = AlgorithmId.get(CertificateUtils.getCertificateSignatureAlgorithm());
        x509CertInfo.set("algorithmID", new CertificateAlgorithmId((AlgorithmId)serializable));
        boolean bl = false;
        boolean bl2 = true;
        int n = 0;
        certificateExtensions.set("SubjectKeyIdentifier", new SubjectKeyIdentifierExtension(keyIdentifier.getIdentifier()));
        certificateExtensions.set("AuthorityKeyIdentifier", authorityKeyIdentifierExtension);
        certificateExtensions.set("BasicConstraints", new BasicConstraintsExtension(bl, bl2, n));
        boolean[] blArray = new boolean[]{true, false, false, false, false, true, true, false, false, false};
        KeyUsageExtension keyUsageExtension = new KeyUsageExtension(blArray);
        certificateExtensions.set("KeyUsage", keyUsageExtension);
        x509CertInfo.set("extensions", certificateExtensions);
        return SunJceUtils.signCert(x509CertInfo, privateKey2);
    }

    private static X509Certificate signCert(X509CertInfo x509CertInfo, PrivateKey privateKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException, CertificateParsingException, IOException {
        X509CertImpl x509CertImpl = new X509CertImpl(x509CertInfo);
        x509CertImpl.sign(privateKey, CertificateUtils.getCertificateSignatureAlgorithm());
        return x509CertImpl;
    }

    public static X509Certificate generateCertificate(String string, PublicKey publicKey, PrivateKey privateKey, KeyPair keyPair, Date date, Date date2, BigInteger bigInteger, String string2, String ... stringArray) throws GeneralSecurityException, IOException {
        Serializable serializable;
        PrivateKey privateKey2;
        AuthorityKeyIdentifierExtension authorityKeyIdentifierExtension;
        X500Name x500Name;
        X509CertInfo x509CertInfo = new X509CertInfo();
        CertificateExtensions certificateExtensions = new CertificateExtensions();
        CertificateValidity certificateValidity = new CertificateValidity(date, date2);
        X500Name x500Name2 = new X500Name(string);
        KeyIdentifier keyIdentifier = new KeyIdentifier(publicKey);
        if (keyPair == null) {
            x500Name = x500Name2;
            authorityKeyIdentifierExtension = new AuthorityKeyIdentifierExtension(keyIdentifier, null, null);
            privateKey2 = privateKey;
        } else {
            serializable = keyPair.getCertificate().getCertificate();
            x500Name = new X500Name(serializable.getSubjectX500Principal().getName());
            authorityKeyIdentifierExtension = new AuthorityKeyIdentifierExtension(new KeyIdentifier(serializable.getPublicKey()), null, null);
            privateKey2 = keyPair.getPrivateKey().getPrivateKey();
        }
        x509CertInfo.set("validity", certificateValidity);
        x509CertInfo.set("serialNumber", new CertificateSerialNumber(bigInteger));
        x509CertInfo.set("subject", new CertificateSubjectName(x500Name2));
        x509CertInfo.set("key", new CertificateX509Key(publicKey));
        x509CertInfo.set("version", new CertificateVersion(2));
        x509CertInfo.set("issuer", new CertificateIssuerName(x500Name));
        serializable = AlgorithmId.get(CertificateUtils.getCertificateSignatureAlgorithm());
        x509CertInfo.set("algorithmID", new CertificateAlgorithmId((AlgorithmId)serializable));
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        certificateExtensions.set("SubjectKeyIdentifier", new SubjectKeyIdentifierExtension(keyIdentifier.getIdentifier()));
        certificateExtensions.set("AuthorityKeyIdentifier", authorityKeyIdentifierExtension);
        certificateExtensions.set("BasicConstraints", new BasicConstraintsExtension(bl, bl2, n));
        boolean[] blArray = new boolean[]{true, true, true, true, false, true, false, false, false, false};
        KeyUsageExtension keyUsageExtension = new KeyUsageExtension(blArray);
        certificateExtensions.set("KeyUsage", keyUsageExtension);
        Vector<ObjectIdentifier> vector = new Vector<ObjectIdentifier>();
        vector.add(new ObjectIdentifier(KUE_SERVER_AUTH));
        vector.add(new ObjectIdentifier(KUE_CLIENT_AUTH));
        certificateExtensions.set("ExtendedKeyUsage", new ExtendedKeyUsageExtension((Boolean)bl, vector));
        GeneralNames generalNames = SunJceUtils.createAlternativeNames(string2, stringArray);
        certificateExtensions.set("SubjectAlternativeName", new SubjectAlternativeNameExtension((Boolean)bl, generalNames));
        x509CertInfo.set("extensions", certificateExtensions);
        return SunJceUtils.signCert(x509CertInfo, privateKey2);
    }

    private static GeneralNames createAlternativeNames(String string, String ... stringArray) throws IOException {
        Object object;
        GeneralNames generalNames = new GeneralNames();
        generalNames.add(new GeneralName(new URIName(string)));
        boolean bl = false;
        String string2 = null;
        try {
            object = string.split("[:/]");
            if (((String[])object).length > 1) {
                string2 = object[1];
                GeneralName generalName = new GeneralName(new DNSName(string2));
                generalNames.add(generalName);
                if (!string2.matches("^[0-9.]+$")) {
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            logger.warn("Cannot initialize DNS Name to Certificate from ApplicationUri{}", (Object)string);
        }
        object = new GeneralNames();
        if (stringArray != null) {
            for (String string3 : stringArray) {
                boolean bl2 = string3.matches("^[0-9.]+$");
                if (string3.equals(string2) || string3.toLowerCase().equals("localhost")) continue;
                GeneralName generalName = new GeneralName(bl2 ? new IPAddressName(string3) : new DNSName(string3));
                if (bl2) {
                    ((GeneralNames)object).add(new GeneralName(new IPAddressName(string3)));
                    continue;
                }
                generalNames.add(generalName);
                bl = true;
            }
        }
        if (!bl) {
            for (GeneralName generalName : ((GeneralNames)object).names()) {
                generalNames.add(generalName);
            }
        }
        return generalNames;
    }

    private static Collection<List<?>> makeAltNames(GeneralNames generalNames) {
        if (generalNames.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet hashSet = new HashSet();
        for (GeneralName generalName : generalNames.names()) {
            GeneralNameInterface generalNameInterface = generalName.getName();
            ArrayList<Object> arrayList = new ArrayList<Object>(2);
            arrayList.add(generalNameInterface.getType());
            switch (generalNameInterface.getType()) {
                case 1: {
                    arrayList.add(((RFC822Name)generalNameInterface).getName());
                    break;
                }
                case 2: {
                    arrayList.add(((DNSName)generalNameInterface).getName());
                    break;
                }
                case 4: {
                    arrayList.add(((X500Name)generalNameInterface).getRFC2253Name());
                    break;
                }
                case 6: {
                    arrayList.add(((URIName)generalNameInterface).getName());
                    break;
                }
                case 7: {
                    try {
                        arrayList.add(((IPAddressName)generalNameInterface).getName());
                        break;
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException("IPAddress cannot be parsed", iOException);
                    }
                }
                case 8: {
                    arrayList.add(((OIDName)generalNameInterface).getOID().toString());
                    break;
                }
                default: {
                    DerOutputStream derOutputStream = new DerOutputStream();
                    try {
                        generalNameInterface.encode(derOutputStream);
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException("name cannot be encoded", iOException);
                    }
                    arrayList.add(derOutputStream.toByteArray());
                }
            }
            hashSet.add(Collections.unmodifiableList(arrayList));
        }
        return Collections.unmodifiableCollection(hashSet);
    }

    public static Collection<List<?>> getSubjectAlternativeNames(X509Certificate x509Certificate) throws CertificateParsingException {
        try {
            GeneralNames generalNames;
            byte[] byArray = x509Certificate.getExtensionValue(SUBJECT_ALT_NAME_OID);
            if (byArray == null) {
                return null;
            }
            DerValue derValue = new DerValue(byArray);
            byte[] byArray2 = derValue.getOctetString();
            SubjectAlternativeNameExtension subjectAlternativeNameExtension = new SubjectAlternativeNameExtension(Boolean.FALSE, byArray2);
            try {
                generalNames = (GeneralNames)subjectAlternativeNameExtension.get("subject_name");
            }
            catch (IOException iOException) {
                return Collections.emptySet();
            }
            return SunJceUtils.makeAltNames(generalNames);
        }
        catch (IOException iOException) {
            CertificateParsingException certificateParsingException = new CertificateParsingException();
            certificateParsingException.initCause(iOException);
            throw certificateParsingException;
        }
    }
}

