/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.utils;

import java.io.EOFException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Selector;
import java.util.Random;
import java.util.Timer;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.EncodeableSerializer;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.encoding.binary.EncodeableReflectionSerializer;
import org.opcfoundation.ua.encoding.binary.IEncodeableSerializer;
import org.opcfoundation.ua.encoding.utils.EncodeableDesc;
import org.opcfoundation.ua.encoding.utils.EncodeableDescTable;
import org.opcfoundation.ua.transport.AsyncResult;
import org.opcfoundation.ua.transport.ResultListener;
import org.opcfoundation.ua.transport.tcp.impl.Acknowledge;
import org.opcfoundation.ua.transport.tcp.impl.ErrorMessage;
import org.opcfoundation.ua.transport.tcp.impl.Hello;
import org.opcfoundation.ua.utils.TimerUtil;
import org.opcfoundation.ua.utils.asyncsocket.AsyncSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackUtils {
    private static Logger logger = LoggerFactory.getLogger(StackUtils.class);
    public static int blockingWorkerThreadPoolCoreSize = 64;
    public static long blockingWorkerThreadPoolTimeout = 3L;
    public static final int CORES = Runtime.getRuntime().availableProcessors();
    public static Executor NON_BLOCKING_EXECUTOR;
    public static Executor BLOCKING_EXECUTOR;
    private static ExecutorService rejectionExecutor;
    public static AsyncSelector SELECTOR;
    public static Random RANDOM;
    public static final UnsignedInteger CLIENT_TOKEN_LIFETIME_REQUEST;
    public static final UnsignedInteger SERVER_GIVEN_TOKEN_LIFETIME;
    public static final int TCP_PROTOCOL_VERSION = 0;
    private static IEncodeableSerializer DEFAULT_SERIALIZER;
    private static volatile Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean barrierWait(AsyncResult<?>[] asyncResultArray, long l) throws InterruptedException {
        final Semaphore semaphore = new Semaphore(0);
        ResultListener resultListener = new ResultListener(){

            public void onCompleted(Object object) {
                semaphore.release();
            }

            @Override
            public void onError(ServiceResultException serviceResultException) {
                semaphore.release();
            }
        };
        AsyncResult<?>[] asyncResultArray2 = asyncResultArray;
        int n = asyncResultArray2.length;
        for (int i = 0; i < n; ++i) {
            AsyncResult<?> asyncResult;
            AsyncResult<?> asyncResult2 = asyncResult = asyncResultArray2[i];
            synchronized (asyncResult2) {
                if (asyncResult.getStatus() != AsyncResult.AsyncResultStatus.Waiting) {
                    semaphore.release();
                } else {
                    asyncResult.setListener(resultListener);
                }
                continue;
            }
        }
        return semaphore.tryAcquire(asyncResultArray.length, l, TimeUnit.SECONDS);
    }

    public static int cores() {
        return CORES;
    }

    public static synchronized Executor createBlockingWorkExecutor(String string, int n) {
        if (BLOCKING_EXECUTOR == null) {
            final ThreadGroup threadGroup = new ThreadGroup(string);
            final AtomicInteger atomicInteger = new AtomicInteger(0);
            ThreadFactory threadFactory = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(threadGroup, runnable, "Blocking-Work-Executor-" + atomicInteger.incrementAndGet());
                    thread.setDaemon(true);
                    thread.setUncaughtExceptionHandler(uncaughtExceptionHandler);
                    return thread;
                }
            };
            LinkedBlockingQueue<Runnable> linkedBlockingQueue = new LinkedBlockingQueue<Runnable>(Integer.MAX_VALUE);
            BLOCKING_EXECUTOR = new ThreadPoolExecutor(blockingWorkerThreadPoolCoreSize, n, blockingWorkerThreadPoolTimeout, TimeUnit.SECONDS, linkedBlockingQueue, threadFactory);
            ((ThreadPoolExecutor)BLOCKING_EXECUTOR).setRejectedExecutionHandler(new RejectedExecutionHandler(){

                @Override
                public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                    StackUtils.getRejectionExecutor().execute(runnable);
                }
            });
        }
        return BLOCKING_EXECUTOR;
    }

    public static int getBlockingWorkerThreadPoolCoreSize() {
        return blockingWorkerThreadPoolCoreSize;
    }

    public static long getBlockingWorkerThreadPoolTimeout() {
        return blockingWorkerThreadPoolTimeout;
    }

    public static Executor getBlockingWorkExecutor() {
        return StackUtils.createBlockingWorkExecutor("Blocking-Work-Executor", 256);
    }

    public static synchronized IEncodeableSerializer getDefaultSerializer() {
        if (DEFAULT_SERIALIZER == null) {
            EncodeableSerializer encodeableSerializer = EncodeableSerializer.getInstance();
            EncodeableDescTable encodeableDescTable = new EncodeableDescTable();
            encodeableDescTable.addStructureInfo(EncodeableDesc.readFromClass(Acknowledge.class, Acknowledge.getFields()));
            encodeableDescTable.addStructureInfo(EncodeableDesc.readFromClass(Hello.class, Hello.getFields()));
            encodeableDescTable.addStructureInfo(EncodeableDesc.readFromClass(ErrorMessage.class, ErrorMessage.getFields()));
            EncodeableReflectionSerializer encodeableReflectionSerializer = new EncodeableReflectionSerializer(encodeableDescTable);
            encodeableSerializer.addSerializer(encodeableReflectionSerializer);
            DEFAULT_SERIALIZER = encodeableSerializer;
        }
        return DEFAULT_SERIALIZER;
    }

    public static synchronized Executor getNonBlockingWorkExecutor() {
        if (NON_BLOCKING_EXECUTOR == null) {
            final ThreadGroup threadGroup = new ThreadGroup("Non-Blocking-Work-Executor-Group");
            final AtomicInteger atomicInteger = new AtomicInteger(0);
            ThreadFactory threadFactory = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(threadGroup, runnable, "Non-Blocking-Work-Executor-" + atomicInteger.incrementAndGet());
                    thread.setDaemon(true);
                    thread.setUncaughtExceptionHandler(uncaughtExceptionHandler);
                    return thread;
                }
            };
            LinkedBlockingQueue<Runnable> linkedBlockingQueue = new LinkedBlockingQueue<Runnable>(Integer.MAX_VALUE);
            RejectedExecutionHandler rejectedExecutionHandler = new RejectedExecutionHandler(){

                @Override
                public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                    StackUtils.getBlockingWorkExecutor().execute(runnable);
                }
            };
            NON_BLOCKING_EXECUTOR = new ThreadPoolExecutor(CORES, CORES, 3L, TimeUnit.SECONDS, linkedBlockingQueue, threadFactory, rejectedExecutionHandler);
        }
        return NON_BLOCKING_EXECUTOR;
    }

    public static synchronized Executor getRejectionExecutor() {
        if (rejectionExecutor == null) {
            ThreadFactory threadFactory = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable, "RejectedRunnableHanlder");
                    thread.setDaemon(true);
                    thread.setUncaughtExceptionHandler(uncaughtExceptionHandler);
                    return thread;
                }
            };
            rejectionExecutor = Executors.newSingleThreadExecutor(threadFactory);
        }
        return rejectionExecutor;
    }

    public static AsyncSelector getSelector() {
        if (SELECTOR == null) {
            try {
                SELECTOR = new AsyncSelector(Selector.open());
            }
            catch (IOException iOException) {
                throw new Error(iOException);
            }
        }
        return SELECTOR;
    }

    public static Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return uncaughtExceptionHandler;
    }

    public static void logStatus() {
        StackUtils.logExecutor("BLOCKING_EXECUTOR", (ThreadPoolExecutor)BLOCKING_EXECUTOR);
        StackUtils.logExecutor("NON_BLOCKING_EXECUTOR", (ThreadPoolExecutor)NON_BLOCKING_EXECUTOR);
    }

    public static ThreadFactory newNamedThreadFactory(String string) {
        return new NamedThreadFactory(string);
    }

    public static void setBlockingWorkerThreadPoolTimeout(long l) {
        blockingWorkerThreadPoolTimeout = l;
    }

    public static void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        StackUtils.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    public static void shutdown() {
        Timer timer;
        if (BLOCKING_EXECUTOR != null) {
            ((ThreadPoolExecutor)BLOCKING_EXECUTOR).shutdown();
            BLOCKING_EXECUTOR = null;
        }
        if (NON_BLOCKING_EXECUTOR != null) {
            ((ThreadPoolExecutor)NON_BLOCKING_EXECUTOR).shutdown();
            NON_BLOCKING_EXECUTOR = null;
        }
        if (rejectionExecutor != null) {
            rejectionExecutor.shutdown();
        }
        if (SELECTOR != null) {
            try {
                SELECTOR.close();
                SELECTOR = null;
            }
            catch (IOException iOException) {
                logger.debug("SELECTOR.close failed", (Throwable)iOException);
            }
        }
        if ((timer = (Timer)TimerUtil.timer.get()) != null) {
            timer.cancel();
            TimerUtil.timer = null;
        }
    }

    public static ServiceResultException toServiceResultException(Exception exception) {
        if (exception instanceof ServiceResultException) {
            return (ServiceResultException)exception;
        }
        if (exception instanceof ClosedChannelException) {
            return new ServiceResultException(StatusCodes.Bad_ConnectionClosed, (Throwable)exception);
        }
        if (exception instanceof EOFException) {
            return new ServiceResultException(StatusCodes.Bad_ConnectionClosed, (Throwable)exception, "Connection closed (graceful)");
        }
        if (exception instanceof ConnectException) {
            return new ServiceResultException(StatusCodes.Bad_ConnectionRejected, (Throwable)exception);
        }
        if (exception instanceof SocketException) {
            return new ServiceResultException(StatusCodes.Bad_ConnectionClosed, (Throwable)exception, "Connection closed (unexpected)");
        }
        if (exception instanceof IOException) {
            return new ServiceResultException(StatusCodes.Bad_ConnectionClosed, (Throwable)exception);
        }
        return new ServiceResultException(exception);
    }

    private static void logExecutor(String string, ThreadPoolExecutor threadPoolExecutor) {
        logger.debug("{}: ActiveCount={} CompletedTaskCount={} PoolSize={} LargestPoolSize={} TaskCount={}", new Object[]{string, threadPoolExecutor.getActiveCount(), threadPoolExecutor.getCompletedTaskCount(), threadPoolExecutor.getPoolSize(), threadPoolExecutor.getLargestPoolSize(), threadPoolExecutor.getTaskCount()});
    }

    static {
        RANDOM = new Random();
        CLIENT_TOKEN_LIFETIME_REQUEST = new UnsignedInteger(600000);
        SERVER_GIVEN_TOKEN_LIFETIME = UnsignedInteger.getFromBits(600000);
        uncaughtExceptionHandler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                logger.error("Uncaught Exception in Thread " + thread, throwable);
                throwable.printStackTrace();
            }
        };
    }

    static class NamedThreadFactory
    implements ThreadFactory {
        static final AtomicInteger poolNumber = new AtomicInteger(1);
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        NamedThreadFactory(String string) {
            SecurityManager securityManager = System.getSecurityManager();
            this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = string + "-pool-" + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(this.group, runnable, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (thread.isDaemon()) {
                thread.setDaemon(false);
            }
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            thread.setUncaughtExceptionHandler(uncaughtExceptionHandler);
            return thread;
        }
    }
}

