/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.utils;

import java.lang.reflect.Array;

public class SnapshotArray<T> {
    private volatile T[] array;
    private final Class<T> componentType;

    public SnapshotArray(Class<T> clazz) {
        this.componentType = clazz;
        this.array = this.createArray(0);
    }

    public T[] getArray() {
        return this.array;
    }

    public synchronized void add(T t) {
        int n = this.array.length;
        int n2 = n + 1;
        T[] TArray = this.createArray(n2);
        System.arraycopy(this.array, 0, TArray, 0, n);
        TArray[n] = t;
        this.array = TArray;
    }

    public synchronized boolean remove(T t) {
        int n = this.getPos(t);
        if (n < 0) {
            return false;
        }
        int n2 = this.array.length;
        int n3 = n2 - 1;
        T[] TArray = this.createArray(n3);
        if (n > 0) {
            System.arraycopy(this.array, 0, TArray, 0, n);
        }
        if (n < n3) {
            System.arraycopy(this.array, n + 1, TArray, n, n3 - n);
        }
        this.array = TArray;
        return true;
    }

    private synchronized int getPos(T t) {
        for (int i = 0; i < this.array.length; ++i) {
            if (this.array[i] != t) continue;
            return i;
        }
        return -1;
    }

    public int size() {
        return this.array.length;
    }

    public boolean isEmpty() {
        return this.array.length == 0;
    }

    public void clear() {
        this.array = this.createArray(0);
    }

    private T[] createArray(int n) {
        return (Object[])Array.newInstance(this.componentType, n);
    }
}

