/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.utils;

import java.lang.reflect.Array;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.AnonymousIdentityToken;
import org.opcfoundation.ua.core.EndpointDescription;
import org.opcfoundation.ua.core.IssuedIdentityToken;
import org.opcfoundation.ua.core.MessageSecurityMode;
import org.opcfoundation.ua.core.SignatureData;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.core.UserIdentityToken;
import org.opcfoundation.ua.core.UserNameIdentityToken;
import org.opcfoundation.ua.core.UserTokenPolicy;
import org.opcfoundation.ua.core.UserTokenType;
import org.opcfoundation.ua.core.X509IdentityToken;
import org.opcfoundation.ua.encoding.binary.BinaryEncoder;
import org.opcfoundation.ua.transport.UriUtil;
import org.opcfoundation.ua.transport.security.Cert;
import org.opcfoundation.ua.transport.security.SecurityAlgorithm;
import org.opcfoundation.ua.transport.security.SecurityPolicy;
import org.opcfoundation.ua.utils.CryptoUtil;
import org.opcfoundation.ua.utils.ObjectUtils;
import org.opcfoundation.ua.utils.bytebuffer.ByteBufferUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointUtil {
    private static Logger logger = LoggerFactory.getLogger(EndpointUtil.class);

    public static EndpointDescription select(EndpointDescription[] endpointDescriptionArray, String string) throws ServiceResultException {
        EndpointDescription[] endpointDescriptionArray2 = EndpointUtil.select(endpointDescriptionArray, string, null, null, null, null);
        if (endpointDescriptionArray2.length > 0) {
            return EndpointUtil.select(endpointDescriptionArray2);
        }
        String string2 = UriUtil.getTransportProtocol(string);
        EndpointDescription[] endpointDescriptionArray3 = EndpointUtil.select(endpointDescriptionArray, null, string2, null, null, null);
        if (endpointDescriptionArray3.length > 0) {
            return EndpointUtil.select(endpointDescriptionArray3);
        }
        return EndpointUtil.select(endpointDescriptionArray);
    }

    public static EndpointDescription select(EndpointDescription[] endpointDescriptionArray) throws ServiceResultException {
        EndpointDescription[] endpointDescriptionArray2 = EndpointUtil.selectByProtocol(endpointDescriptionArray, "opc.tcp");
        if ((endpointDescriptionArray2 = EndpointUtil.selectByMessageSecurityMode(endpointDescriptionArray2, MessageSecurityMode.SignAndEncrypt)).length != 0) {
            endpointDescriptionArray2 = EndpointUtil.sortBySecurityLevel(endpointDescriptionArray2);
            return endpointDescriptionArray2[endpointDescriptionArray2.length - 1];
        }
        endpointDescriptionArray2 = EndpointUtil.selectByProtocol(endpointDescriptionArray, "https");
        if (endpointDescriptionArray2.length != 0) {
            return endpointDescriptionArray2[0];
        }
        throw new ServiceResultException("No compatible endpoint was found");
    }

    public static EndpointDescription[] select(EndpointDescription[] endpointDescriptionArray, String string, String string2, MessageSecurityMode messageSecurityMode, SecurityPolicy securityPolicy, byte[] byArray) {
        ArrayList<EndpointDescription> arrayList = new ArrayList<EndpointDescription>();
        for (EndpointDescription endpointDescription : endpointDescriptionArray) {
            String string3;
            String string4 = string3 = endpointDescription.getEndpointUrl() == null ? null : endpointDescription.getEndpointUrl().toLowerCase();
            if (string3 == null || string2 != null && !string3.startsWith(string2.toLowerCase()) || string != null && !ObjectUtils.objectEquals(string3, string.toLowerCase()) || messageSecurityMode != null && !ObjectUtils.objectEquals(endpointDescription.getSecurityMode(), messageSecurityMode) || securityPolicy != null && !ObjectUtils.objectEquals(endpointDescription.getSecurityPolicyUri(), securityPolicy.getPolicyUri()) || byArray != null && !Arrays.equals(byArray, endpointDescription.getServerCertificate())) continue;
            arrayList.add(endpointDescription);
        }
        return arrayList.toArray(new EndpointDescription[arrayList.size()]);
    }

    public static EndpointDescription[] select(EndpointDescription[] endpointDescriptionArray, int n, int n2) {
        ArrayList<EndpointDescription> arrayList = new ArrayList<EndpointDescription>();
        for (EndpointDescription endpointDescription : endpointDescriptionArray) {
            try {
                Cert cert = new Cert(endpointDescription.getServerCertificate());
                int n3 = cert.getKeySize();
                if (n3 < n || n3 > n2) continue;
                arrayList.add(endpointDescription);
            }
            catch (ServiceResultException serviceResultException) {
                // empty catch block
            }
        }
        return arrayList.toArray(new EndpointDescription[arrayList.size()]);
    }

    public static EndpointDescription[] selectByProtocol(EndpointDescription[] endpointDescriptionArray, String string) {
        ArrayList<EndpointDescription> arrayList = new ArrayList<EndpointDescription>();
        for (EndpointDescription endpointDescription : endpointDescriptionArray) {
            if (!endpointDescription.getEndpointUrl().toLowerCase().startsWith(string.toLowerCase())) continue;
            arrayList.add(endpointDescription);
        }
        return arrayList.toArray(new EndpointDescription[arrayList.size()]);
    }

    public static EndpointDescription[] selectByMessageSecurityMode(EndpointDescription[] endpointDescriptionArray, MessageSecurityMode messageSecurityMode) {
        ArrayList<EndpointDescription> arrayList = new ArrayList<EndpointDescription>();
        for (EndpointDescription endpointDescription : endpointDescriptionArray) {
            if (endpointDescription.getSecurityMode() != messageSecurityMode) continue;
            arrayList.add(endpointDescription);
        }
        return arrayList.toArray(new EndpointDescription[arrayList.size()]);
    }

    public static EndpointDescription[] selectBySecurityPolicy(EndpointDescription[] endpointDescriptionArray, SecurityPolicy securityPolicy) {
        ArrayList<EndpointDescription> arrayList = new ArrayList<EndpointDescription>();
        for (EndpointDescription endpointDescription : endpointDescriptionArray) {
            if (!ObjectUtils.objectEquals(endpointDescription.getSecurityPolicyUri(), securityPolicy.getPolicyUri())) continue;
            arrayList.add(endpointDescription);
        }
        return arrayList.toArray(new EndpointDescription[arrayList.size()]);
    }

    public static EndpointDescription[] selectByUrl(EndpointDescription[] endpointDescriptionArray, String string) {
        ArrayList<EndpointDescription> arrayList = new ArrayList<EndpointDescription>();
        for (EndpointDescription endpointDescription : endpointDescriptionArray) {
            if (!string.equalsIgnoreCase(endpointDescription.getEndpointUrl())) continue;
            arrayList.add(endpointDescription);
        }
        return arrayList.toArray(new EndpointDescription[arrayList.size()]);
    }

    public static EndpointDescription[] sortBySecurityLevel(EndpointDescription[] endpointDescriptionArray) {
        Comparator<EndpointDescription> comparator = new Comparator<EndpointDescription>(){

            @Override
            public int compare(EndpointDescription endpointDescription, EndpointDescription endpointDescription2) {
                return endpointDescription.getSecurityLevel().intValue() - endpointDescription2.getSecurityLevel().intValue();
            }
        };
        EndpointDescription[] endpointDescriptionArray2 = (EndpointDescription[])endpointDescriptionArray.clone();
        Arrays.sort(endpointDescriptionArray2, comparator);
        return endpointDescriptionArray2;
    }

    public static EndpointDescription selectEndpoint(EndpointDescription[] endpointDescriptionArray) {
        if (endpointDescriptionArray == null) {
            throw new IllegalArgumentException("null arg");
        }
        endpointDescriptionArray = EndpointUtil.selectByProtocol(endpointDescriptionArray, "opc.tcp");
        if ((endpointDescriptionArray = EndpointUtil.selectByMessageSecurityMode(endpointDescriptionArray, MessageSecurityMode.SignAndEncrypt)).length == 0) {
            return null;
        }
        endpointDescriptionArray = EndpointUtil.sortBySecurityLevel(endpointDescriptionArray);
        EndpointUtil.reverse(endpointDescriptionArray);
        return endpointDescriptionArray[0];
    }

    public static void reverse(Object object) {
        int n = Array.getLength(object);
        for (int i = 0; i < n / 2; ++i) {
            Object object2 = Array.get(object, i);
            Object object3 = Array.get(object, n - 1 - i);
            Array.set(object, i, object3);
            Array.set(object, n - i - 1, object2);
        }
    }

    public static UserIdentityToken createUserNameIdentityToken(EndpointDescription endpointDescription, byte[] byArray, String string, String string2) throws ServiceResultException {
        SecurityPolicy securityPolicy;
        UserTokenPolicy userTokenPolicy = endpointDescription.findUserTokenPolicy(UserTokenType.UserName);
        if (userTokenPolicy == null) {
            throw new ServiceResultException(StatusCodes.Bad_IdentityTokenRejected, "UserName not supported");
        }
        String string3 = userTokenPolicy.getSecurityPolicyUri();
        if (string3 == null) {
            string3 = endpointDescription.getSecurityPolicyUri();
        }
        if ((securityPolicy = SecurityPolicy.getSecurityPolicy(string3)) == null) {
            securityPolicy = SecurityPolicy.NONE;
        }
        UserNameIdentityToken userNameIdentityToken = new UserNameIdentityToken();
        userNameIdentityToken.setUserName(string);
        userNameIdentityToken.setPolicyId(userTokenPolicy.getPolicyId());
        SecurityAlgorithm securityAlgorithm = securityPolicy.getAsymmetricEncryptionAlgorithm();
        logger.debug("createUserNameIdentityToken: algorithm={}", (Object)securityAlgorithm);
        byte[] byArray2 = string2.getBytes(BinaryEncoder.UTF8);
        if (securityAlgorithm == null) {
            userNameIdentityToken.setPassword(byArray2);
        } else {
            try {
                byte[] byArray3 = endpointDescription.getServerCertificate();
                Cert cert = byArray3 == null || byArray3.length == 0 ? null : new Cert(byArray3);
                byArray2 = byArray != null ? ByteBufferUtils.concatenate(EndpointUtil.toArray(byArray2.length + byArray.length), byArray2, byArray) : ByteBufferUtils.concatenate(EndpointUtil.toArray(byArray2.length), byArray2);
                byArray2 = CryptoUtil.encryptAsymm(byArray2, cert.getCertificate().getPublicKey(), securityAlgorithm);
                userNameIdentityToken.setPassword(byArray2);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new ServiceResultException(StatusCodes.Bad_CertificateInvalid, "Server certificate in endpoint is invalid: " + invalidKeyException.getMessage());
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                throw new ServiceResultException(StatusCodes.Bad_SecurityPolicyRejected, illegalBlockSizeException.getClass().getName() + ":" + illegalBlockSizeException.getMessage());
            }
            catch (BadPaddingException badPaddingException) {
                throw new ServiceResultException(StatusCodes.Bad_CertificateInvalid, "Server certificate in endpoint is invalid: " + badPaddingException.getMessage());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)noSuchAlgorithmException);
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)noSuchPaddingException);
            }
            userNameIdentityToken.setEncryptionAlgorithm(securityAlgorithm.getUri());
        }
        return userNameIdentityToken;
    }

    public static UserIdentityToken createIssuedIdentityToken(EndpointDescription endpointDescription, byte[] byArray, byte[] byArray2) throws ServiceResultException {
        SecurityPolicy securityPolicy;
        UserTokenPolicy userTokenPolicy = endpointDescription.findUserTokenPolicy(UserTokenType.IssuedToken);
        if (userTokenPolicy == null) {
            throw new ServiceResultException(StatusCodes.Bad_IdentityTokenRejected, "IssuedToken not supported");
        }
        String string = userTokenPolicy.getSecurityPolicyUri();
        if (string == null) {
            string = endpointDescription.getSecurityPolicyUri();
        }
        if ((securityPolicy = SecurityPolicy.getSecurityPolicy(string)) == null) {
            securityPolicy = SecurityPolicy.NONE;
        }
        IssuedIdentityToken issuedIdentityToken = new IssuedIdentityToken();
        issuedIdentityToken.setTokenData(byArray2);
        SecurityAlgorithm securityAlgorithm = securityPolicy.getAsymmetricEncryptionAlgorithm();
        if (securityAlgorithm == null) {
            securityAlgorithm = SecurityAlgorithm.RsaOaep;
        }
        try {
            Cipher cipher = Cipher.getInstance(securityAlgorithm.getStandardName());
            Cert cert = new Cert(endpointDescription.getServerCertificate());
            cipher.init(1, cert.getCertificate());
            byte[] byArray3 = byArray2;
            if (byArray != null) {
                byArray3 = ByteBufferUtils.concatenate(EndpointUtil.toArray(byArray2.length + byArray.length), byArray2, byArray);
            }
            issuedIdentityToken.setTokenData(cipher.doFinal(byArray3));
            issuedIdentityToken.setEncryptionAlgorithm(securityAlgorithm.getUri());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new ServiceResultException(StatusCodes.Bad_CertificateInvalid, "Server certificate in endpoint is invalid: " + invalidKeyException.getMessage());
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new ServiceResultException(StatusCodes.Bad_SecurityPolicyRejected, illegalBlockSizeException.getClass().getName() + ":" + illegalBlockSizeException.getMessage());
        }
        catch (BadPaddingException badPaddingException) {
            throw new ServiceResultException(StatusCodes.Bad_CertificateInvalid, "Server certificate in endpoint is invalid: " + badPaddingException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)noSuchAlgorithmException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)noSuchPaddingException);
        }
        return issuedIdentityToken;
    }

    public static Set<InetAddress> getInetAddresses() throws SocketException {
        return EndpointUtil.getInetAddresses(false);
    }

    public static Set<InetAddress> getInetAddresses(boolean bl) throws SocketException {
        HashSet<InetAddress> hashSet = new HashSet<InetAddress>();
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        while (enumeration.hasMoreElements()) {
            Enumeration<InetAddress> enumeration2 = enumeration.nextElement().getInetAddresses();
            while (enumeration2.hasMoreElements()) {
                InetAddress inetAddress = enumeration2.nextElement();
                if (inetAddress instanceof Inet6Address && !bl) continue;
                hashSet.add(inetAddress);
            }
        }
        return hashSet;
    }

    public static String getHostname() throws SocketException {
        Object object;
        try {
            object = InetAddress.getLocalHost().getHostName();
            if (object != null) {
                return object;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        object = EndpointUtil.getInetAddresses();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            String string;
            InetAddress inetAddress = (InetAddress)iterator.next();
            String string2 = inetAddress.getHostAddress();
            if (string2.equals(string = EndpointUtil.inetAddressToName(inetAddress))) continue;
            return string;
        }
        return "localhost";
    }

    public static Set<String> getInetAddressNames() throws SocketException {
        HashSet<String> hashSet = new HashSet<String>();
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        while (enumeration.hasMoreElements()) {
            Enumeration<InetAddress> enumeration2 = enumeration.nextElement().getInetAddresses();
            while (enumeration2.hasMoreElements()) {
                InetAddress inetAddress = enumeration2.nextElement();
                if (inetAddress instanceof Inet6Address) continue;
                hashSet.add(EndpointUtil.inetAddressToName(inetAddress));
            }
        }
        return hashSet;
    }

    public static String inetAddressToName(InetAddress inetAddress) {
        String string;
        String string2 = inetAddress.getHostName();
        boolean bl = !string2.equals(string = inetAddress.getHostAddress());
        boolean bl2 = inetAddress instanceof Inet6Address;
        if (bl) {
            return string2;
        }
        if (bl2) {
            return "[" + string + "]";
        }
        return string;
    }

    public static List<SocketAddress> toSocketAddresses(String string) throws IllegalArgumentException {
        return EndpointUtil.toSocketAddresses(string, false);
    }

    public static List<SocketAddress> toSocketAddresses(String string, boolean bl) throws IllegalArgumentException {
        ArrayList<SocketAddress> arrayList;
        block14: {
            arrayList = new ArrayList<SocketAddress>();
            if (string == null) {
                throw new IllegalArgumentException("URL not valid.");
            }
            try {
                Object[] objectArray;
                URI uRI = new URI(string);
                String string2 = UriUtil.getTransportProtocol(string);
                String string3 = uRI.getHost();
                int n = uRI.getPort();
                if (string3 == null) {
                    objectArray = string.split("/+");
                    String[] stringArray = objectArray[1].split(":");
                    string3 = stringArray[0];
                    try {
                        n = Integer.parseInt(stringArray[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        n = 0;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        n = 0;
                    }
                }
                string2 = string2.toLowerCase();
                if (n == 0 || n == -1) {
                    n = UriUtil.defaultPort(string2);
                }
                if (string2.equals("opc.tcp") || string2.equals("http") || string2.equals("https")) {
                    try {
                        objectArray = InetAddress.getAllByName(string3);
                        boolean bl2 = false;
                        boolean bl3 = false;
                        for (Object object : objectArray) {
                            bl2 |= object instanceof Inet4Address;
                            bl3 |= object instanceof Inet6Address;
                        }
                        for (Object object : objectArray) {
                            boolean bl4 = object instanceof Inet6Address;
                            if (!bl && bl4 && bl3 && bl2) {
                                logger.warn("Binding of {} to {} was omited. (Workaround)", (Object)string, (Object)((InetAddress)object).getHostAddress());
                                continue;
                            }
                            InetSocketAddress inetSocketAddress = new InetSocketAddress((InetAddress)object, n);
                            arrayList.add(inetSocketAddress);
                        }
                        break block14;
                    }
                    catch (UnknownHostException unknownHostException) {
                        throw new IllegalArgumentException(unknownHostException);
                    }
                }
                throw new IllegalArgumentException("Unsupported protocol " + string2);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalArgumentException("Invalid URL", uRISyntaxException);
            }
        }
        return arrayList;
    }

    public static UserIdentityToken createAnonymousIdentityToken(EndpointDescription endpointDescription) throws ServiceResultException {
        UserTokenPolicy userTokenPolicy = endpointDescription.findUserTokenPolicy(UserTokenType.Anonymous);
        if (userTokenPolicy == null) {
            throw new ServiceResultException(StatusCodes.Bad_IdentityTokenRejected, "Anonymous UserTokenType is not supported");
        }
        return new AnonymousIdentityToken(userTokenPolicy.getPolicyId());
    }

    public static X509IdentityToken createX509IdentityToken(EndpointDescription endpointDescription, byte[] byArray, Cert cert, PrivateKey privateKey, SignatureData signatureData) throws ServiceResultException {
        if (signatureData == null) {
            throw new NullPointerException("signatureData must be defined (will be filled in)");
        }
        UserTokenPolicy userTokenPolicy = endpointDescription.findUserTokenPolicy(UserTokenType.Certificate);
        if (userTokenPolicy == null) {
            throw new ServiceResultException(StatusCodes.Bad_IdentityTokenRejected, "Certificate UserTokenType is not supported");
        }
        X509IdentityToken x509IdentityToken = new X509IdentityToken(userTokenPolicy.getPolicyId(), cert.getEncoded());
        String string = userTokenPolicy.getSecurityPolicyUri();
        if (string == null) {
            string = endpointDescription.getSecurityPolicyUri();
        }
        SecurityPolicy securityPolicy = SecurityPolicy.getSecurityPolicy(string);
        Cert cert2 = new Cert(endpointDescription.getServerCertificate());
        if (securityPolicy != null && cert2 != null) {
            try {
                Signature signature = Signature.getInstance(securityPolicy.getAsymmetricSignatureAlgorithm().getTransformation());
                signature.initSign(privateKey);
                signature.update(cert2.getEncoded());
                signature.update(byArray);
                signatureData.setSignature(signature.sign());
                signatureData.setAlgorithm(securityPolicy.getAsymmetricSignatureAlgorithm().getUri());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed, "Signature generation failed: " + noSuchAlgorithmException.getMessage());
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new ServiceResultException(StatusCodes.Bad_CertificateInvalid, "Server certificate in endpoint is invalid: " + invalidKeyException.getMessage());
            }
            catch (SignatureException signatureException) {
                throw new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed, "Signature generation failed: " + signatureException.getMessage());
            }
        }
        return x509IdentityToken;
    }

    private static byte[] toArray(int n) {
        return new byte[]{(byte)n, (byte)(n >> 8), (byte)(n >> 16), (byte)(n >> 24)};
    }

    public static boolean urlEqualsHostIgnoreCase(URI uRI, URI uRI2) {
        return uRI.getScheme().equalsIgnoreCase(uRI2.getScheme()) && uRI.getPort() == uRI2.getPort() && uRI.getPath().equalsIgnoreCase(uRI2.getPath());
    }

    public static boolean urlEqualsHostIgnoreCase(String string, String string2) {
        try {
            return EndpointUtil.urlEqualsHostIgnoreCase(new URI(string), new URI(string2));
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    public static boolean containsSecureUserTokenPolicy(UserTokenPolicy[] userTokenPolicyArray) {
        if (userTokenPolicyArray != null) {
            for (UserTokenPolicy userTokenPolicy : userTokenPolicyArray) {
                if (userTokenPolicy.getSecurityPolicyUri() == null || userTokenPolicy.getSecurityPolicyUri().equals(SecurityPolicy.NONE)) continue;
                return true;
            }
        }
        return false;
    }
}

