/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ConcurrentBijectionMap<L, R> {
    private Map<L, R> tableLeft = new HashMap<L, R>();
    private Map<R, L> tableRight = new HashMap<R, L>();

    public synchronized void addAll(ConcurrentBijectionMap<L, R> concurrentBijectionMap) {
        for (Map.Entry<L, R> entry : concurrentBijectionMap.tableLeft.entrySet()) {
            this.map(entry.getKey(), entry.getValue());
        }
    }

    public synchronized boolean retainAllLeft(Collection<L> collection) {
        boolean bl = false;
        for (L l : collection) {
            if (this.tableLeft.containsKey(l)) continue;
            this.removeWithLeft(l);
            bl = true;
        }
        return bl;
    }

    public synchronized boolean retainAllRight(Collection<R> collection) {
        boolean bl = false;
        for (R r : collection) {
            if (this.tableRight.containsKey(r)) continue;
            this.removeWithRight(r);
            bl = true;
        }
        return bl;
    }

    public synchronized Set<Map.Entry<L, R>> getEntries() {
        return new HashSet<Map.Entry<L, R>>(this.tableLeft.entrySet());
    }

    public synchronized boolean containsLeft(L l) {
        return this.tableLeft.containsKey(l);
    }

    public synchronized boolean containsRight(R r) {
        return this.tableRight.containsKey(r);
    }

    public synchronized boolean contains(L l, R r) {
        if (l == r) {
            return true;
        }
        if (l == null || r == null) {
            return false;
        }
        R r2 = this.tableLeft.get(l);
        if (r2 == r) {
            return true;
        }
        return this.tableLeft.get(l).equals(r2);
    }

    public synchronized void map(L l, R r) {
        R r2 = this.tableLeft.remove(l);
        if (r2 != null) {
            this.tableRight.remove(r2);
        } else {
            L l2 = this.tableRight.remove(r);
            if (l2 != null) {
                this.tableLeft.remove(l2);
            }
        }
        this.tableLeft.put(l, r);
        this.tableRight.put(r, l);
    }

    public synchronized boolean isEmpty() {
        return this.tableLeft.isEmpty();
    }

    public synchronized int size() {
        return this.tableLeft.size();
    }

    public synchronized L getLeft(R r) {
        return this.tableRight.get(r);
    }

    public synchronized R getRight(L l) {
        return this.tableLeft.get(l);
    }

    public synchronized R removeWithLeft(L l) {
        R r = this.tableLeft.remove(l);
        if (r != null) {
            this.tableRight.remove(r);
        }
        return r;
    }

    public synchronized L removeWithRight(R r) {
        L l = this.tableRight.remove(r);
        if (l != null) {
            this.tableLeft.remove(l);
        }
        return l;
    }

    public synchronized Set<L> getLeftSet() {
        return Collections.unmodifiableSet(this.tableLeft.keySet());
    }

    public synchronized Set<R> getRightSet() {
        return Collections.unmodifiableSet(this.tableRight.keySet());
    }

    public synchronized void clear() {
        this.tableLeft.clear();
        this.tableRight.clear();
    }

    public synchronized String toString() {
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (Map.Entry<L, R> entry : this.tableLeft.entrySet()) {
            if (n++ > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(entry.getKey().toString());
            stringBuilder.append("=");
            stringBuilder.append(entry.getValue().toString());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

