/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.utils;

import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.opcfoundation.ua.utils.CurrentThreadExecutor;
import org.opcfoundation.ua.utils.IStatefulObject;
import org.opcfoundation.ua.utils.SnapshotArray;
import org.opcfoundation.ua.utils.StackUtils;
import org.opcfoundation.ua.utils.StateListener;

public abstract class AbstractState<StateType, ErrorType extends Throwable>
implements IStatefulObject<StateType, ErrorType> {
    private StateType state = null;
    private StateType errorState = null;
    private ErrorType errorCause;
    private SnapshotArray<StateListener<StateType>> listenerList = null;
    private SnapshotArray<StateListener<StateType>> notifiableList = null;
    private Object lock = new Object();

    public AbstractState(StateType StateType) {
        this.state = StateType;
    }

    public AbstractState(StateType StateType, StateType StateType2) {
        this.state = StateType;
        this.errorState = StateType2;
    }

    @Override
    public synchronized StateType getState() {
        return this.state;
    }

    protected StateType attemptSetState(Set<StateType> set, StateType StateType) {
        if (set == null || StateType == null) {
            throw new IllegalArgumentException("null arg");
        }
        return this.setState(StateType, null, set);
    }

    @Override
    public synchronized void addStateNotifiable(StateListener<StateType> stateListener) {
        if (stateListener == null) {
            throw new IllegalArgumentException("null arg");
        }
        if (this.notifiableList == null) {
            this.notifiableList = new SnapshotArray<StateListener>(StateListener.class);
        }
        this.notifiableList.add(stateListener);
    }

    @Override
    public synchronized void removeStateNotifiable(StateListener<StateType> stateListener) {
        if (this.notifiableList != null) {
            this.notifiableList.remove(stateListener);
        }
        if (this.notifiableList.isEmpty()) {
            this.notifiableList = null;
        }
    }

    @Override
    public synchronized void addStateListener(StateListener<StateType> stateListener) {
        if (stateListener == null) {
            throw new IllegalArgumentException("null arg");
        }
        if (this.listenerList == null) {
            this.listenerList = new SnapshotArray<StateListener>(StateListener.class);
        }
        this.listenerList.add(stateListener);
    }

    @Override
    public synchronized void removeStateListener(StateListener<StateType> stateListener) {
        if (stateListener == null) {
            throw new IllegalArgumentException("null arg");
        }
        if (this.listenerList == null) {
            return;
        }
        this.listenerList.remove(stateListener);
        if (this.listenerList.isEmpty()) {
            this.listenerList = null;
        }
    }

    protected boolean setState(StateType StateType) {
        return this.setState(StateType, null, null) == StateType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setError(ErrorType ErrorType) {
        this.errorCause = ErrorType;
        if (this.errorState == null || !this.setState(this.errorState)) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }

    protected void clearError() {
        this.errorCause = null;
    }

    @Override
    public ErrorType getError() {
        return this.errorCause;
    }

    public boolean hasError() {
        return this.errorCause != null;
    }

    protected void assertNoError() throws ErrorType {
        ErrorType ErrorType = this.errorCause;
        if (ErrorType != null) {
            throw ErrorType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StateType setState(StateType StateType, Executor executor, Set<StateType> set) {
        Runnable runnable;
        if (executor != null && executor instanceof CurrentThreadExecutor) {
            executor = null;
        }
        StateListener<StateType>[] stateListenerArray = null;
        StateListener<StateType>[] stateListenerArray2 = null;
        StateType StateType2 = null;
        Object StateType3 = null;
        final Object object = this;
        synchronized (object) {
            StateType2 = this.state;
            StateType3 = StateType;
            if (StateType2 == StateType3) {
                return StateType;
            }
            if (set != null && !set.contains(this.state)) {
                return StateType;
            }
            if (!this.isStateTransitionAllowed(StateType2, StateType3)) {
                return StateType;
            }
            this.state = StateType3;
            if (this.listenerList != null) {
                stateListenerArray = this.listenerList.getArray();
            }
            if (this.notifiableList != null) {
                stateListenerArray2 = this.notifiableList.getArray();
            }
        }
        object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
        this.onStateTransition(StateType2, StateType3);
        object = StateType2;
        final Object StateType4 = StateType3;
        if (stateListenerArray != null && executor == null) {
            for (StateListener<Object> stateListener : stateListenerArray) {
                try {
                    stateListener.onStateTransition(this, object, StateType4);
                }
                catch (RuntimeException runtimeException) {
                    this.onListenerException(runtimeException);
                }
            }
        }
        if (stateListenerArray != null && executor != null) {
            for (final StateListener<StateType> stateListener : stateListenerArray) {
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            stateListener.onStateTransition(AbstractState.this, object, StateType4);
                        }
                        catch (RuntimeException runtimeException) {
                            AbstractState.this.onListenerException(runtimeException);
                        }
                    }
                };
                executor.execute(runnable);
            }
        }
        if (stateListenerArray2 != null) {
            for (final StateListener<StateType> stateListener : stateListenerArray2) {
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            stateListener.onStateTransition(AbstractState.this, object, StateType4);
                        }
                        catch (RuntimeException runtimeException) {
                            AbstractState.this.onListenerException(runtimeException);
                        }
                    }
                };
                StackUtils.BLOCKING_EXECUTOR.execute(runnable);
            }
        }
        return StateType;
    }

    protected boolean isStateTransitionAllowed(StateType StateType, StateType StateType2) {
        return true;
    }

    protected void onStateTransition(StateType StateType, StateType StateType2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StateType waitForState(Set<StateType> set) throws InterruptedException, ErrorType {
        Object object = this.lock;
        synchronized (object) {
            while (!set.contains(this.state)) {
                this.lock.wait();
            }
            ErrorType ErrorType = this.getError();
            if (ErrorType != null) {
                throw ErrorType;
            }
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StateType waitForStateUninterruptibly(Set<StateType> set) throws ErrorType {
        Object object = this.lock;
        synchronized (object) {
            while (!set.contains(this.state)) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            ErrorType ErrorType = this.getError();
            if (ErrorType != null) {
                throw ErrorType;
            }
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StateType waitForState(Set<StateType> set, long l, TimeUnit timeUnit) throws InterruptedException, TimeoutException, ErrorType {
        long l2 = System.currentTimeMillis() + timeUnit.toMillis(l);
        Object object = this.lock;
        synchronized (object) {
            while (!set.contains(this.state)) {
                long l3 = System.currentTimeMillis() - l2;
                if (l3 < 0L) {
                    throw new TimeoutException("timeout");
                }
                this.lock.wait(l3);
                ErrorType ErrorType = this.getError();
                if (ErrorType == null) continue;
                throw ErrorType;
            }
            return this.state;
        }
    }

    protected void onListenerException(RuntimeException runtimeException) {
        runtimeException.printStackTrace();
    }
}

