/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.tcp.nio;

import org.opcfoundation.ua.application.Server;
import org.opcfoundation.ua.builtintypes.ServiceRequest;
import org.opcfoundation.ua.builtintypes.ServiceResponse;
import org.opcfoundation.ua.encoding.IEncodeable;
import org.opcfoundation.ua.transport.AsyncWrite;
import org.opcfoundation.ua.transport.Endpoint;
import org.opcfoundation.ua.transport.ServerSecureChannel;
import org.opcfoundation.ua.transport.endpoint.EndpointServiceRequest;
import org.opcfoundation.ua.transport.tcp.nio.OpcTcpServerSecureChannel;

public class PendingRequest
extends EndpointServiceRequest<ServiceRequest, ServiceResponse> {
    OpcTcpServerSecureChannel channel;
    IEncodeable requestMessage;
    int requestId;
    AsyncWrite write;

    public PendingRequest(OpcTcpServerSecureChannel opcTcpServerSecureChannel, Endpoint endpoint, Server server, int n, ServiceRequest serviceRequest) {
        super(serviceRequest, server, endpoint);
        this.channel = opcTcpServerSecureChannel;
        this.requestId = n;
        this.requestMessage = serviceRequest;
    }

    @Override
    public ServerSecureChannel getChannel() {
        return this.channel;
    }

    @Override
    public void sendResponse(AsyncWrite asyncWrite) {
        this.channel.connection.pendingRequests.remove(this.requestId);
        this.channel.connection.sendSecureMessage(asyncWrite, this.channel.getActiveSecurityToken(), this.requestId, 4674381, this.channel.sendSequenceNumber);
    }

    @Override
    public AsyncWrite sendResponse(ServiceResponse serviceResponse) {
        this.write = new AsyncWrite(serviceResponse);
        this.sendResponse(this.write);
        return this.write;
    }
}

