/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.tcp.io;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.opcfoundation.ua.builtintypes.ServiceRequest;
import org.opcfoundation.ua.builtintypes.ServiceResponse;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.common.ServiceFaultException;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.ChannelSecurityToken;
import org.opcfoundation.ua.core.CloseSecureChannelRequest;
import org.opcfoundation.ua.core.EncodeableSerializer;
import org.opcfoundation.ua.core.EndpointConfiguration;
import org.opcfoundation.ua.core.EndpointDescription;
import org.opcfoundation.ua.core.MessageSecurityMode;
import org.opcfoundation.ua.core.OpenSecureChannelRequest;
import org.opcfoundation.ua.core.OpenSecureChannelResponse;
import org.opcfoundation.ua.core.ResponseHeader;
import org.opcfoundation.ua.core.SecurityTokenRequestType;
import org.opcfoundation.ua.core.ServiceFault;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.encoding.EncoderContext;
import org.opcfoundation.ua.encoding.EncodingException;
import org.opcfoundation.ua.encoding.IEncodeable;
import org.opcfoundation.ua.encoding.binary.IEncodeableSerializer;
import org.opcfoundation.ua.transport.AsyncResult;
import org.opcfoundation.ua.transport.IConnectionListener;
import org.opcfoundation.ua.transport.SecureChannel;
import org.opcfoundation.ua.transport.ServerConnection;
import org.opcfoundation.ua.transport.TransportChannelSettings;
import org.opcfoundation.ua.transport.UriUtil;
import org.opcfoundation.ua.transport.impl.AsyncResultImpl;
import org.opcfoundation.ua.transport.security.SecurityAlgorithm;
import org.opcfoundation.ua.transport.security.SecurityPolicy;
import org.opcfoundation.ua.transport.tcp.io.IConnection;
import org.opcfoundation.ua.transport.tcp.io.ITransportChannel;
import org.opcfoundation.ua.transport.tcp.io.TcpConnection;
import org.opcfoundation.ua.utils.CryptoUtil;
import org.opcfoundation.ua.utils.ObjectUtils;
import org.opcfoundation.ua.utils.StackUtils;
import org.opcfoundation.ua.utils.TimerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureChannelTcp
implements IConnection.IMessageListener,
IConnectionListener,
ITransportChannel,
SecureChannel {
    static Logger logger = LoggerFactory.getLogger(SecureChannelTcp.class);
    private EncoderContext ctx;
    Executor executor = StackUtils.getBlockingWorkExecutor();
    int secureChannelId = -1;
    long tokenIssueTime;
    long tokenLifetime;
    IEncodeableSerializer serializer = EncodeableSerializer.getInstance();
    TransportChannelSettings settings;
    InetSocketAddress addr;
    AtomicInteger requestIdCounter = new AtomicInteger(0);
    AtomicReference<IConnection> transportChannel = new AtomicReference<Object>(null);
    Map<Integer, PendingRequest> requests = new ConcurrentHashMap<Integer, PendingRequest>();
    int errorRecoveryReconnectIndex = 0;
    TimerTask errorRecoveryReconnectTimer;
    boolean errorRecoveryState = false;
    Object errorRecoveryLock = new Object();
    private static final int[] RECONNECT_WAIT_TIME = new int[]{0, 1, 2, 4, 8, 16, 32, 64, 120, 120, 120};
    private static final double TIMEOUT_TOLERANCE = 0.1;
    TimerTask renewSecurityTokenTask;
    AtomicReference<TimerTask> timeoutPendingRequestsTask = new AtomicReference<Object>(null);
    Timer timer;
    Runnable timeoutRun = new Runnable(){

        @Override
        public void run() {
            SecureChannelTcp.this.cancelTimeoutPendingRequestTask();
            long l = System.currentTimeMillis();
            for (PendingRequest pendingRequest : SecureChannelTcp.this.requests.values()) {
                if (l < pendingRequest.timeoutTime) continue;
                logger.warn("Request id={} timeouted {}ms elapsed. timeout at {}ms", new Object[]{pendingRequest.requestId, System.currentTimeMillis() - pendingRequest.startTime, pendingRequest.timeoutTime - pendingRequest.startTime});
                pendingRequest.result.setError(new ServiceResultException(StatusCodes.Bad_Timeout));
                SecureChannelTcp.this.requests.remove(pendingRequest.requestId);
            }
            SecureChannelTcp.this.scheduleTimeoutRequestsTimer();
        }
    };
    private Runnable sendPendingMessagesRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Runnable runnable = SecureChannelTcp.this.sendPendingMessagesRunnable;
            synchronized (runnable) {
                try {
                    SecureChannelTcp.this.sendPendingRequestMessages();
                }
                catch (ServiceResultException serviceResultException) {
                    serviceResultException.printStackTrace();
                }
            }
        }
    };
    Runnable reconnectRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = SecureChannelTcp.this.errorRecoveryLock;
            synchronized (object) {
                if (!SecureChannelTcp.this.errorRecoveryState) {
                    return;
                }
            }
            if (!SecureChannelTcp.this.isOpen()) {
                SecureChannelTcp.this.setErrorRecoveryState(false);
                logger.info("{}: Error recovery failed, security token has expired", (Object)SecureChannelTcp.this.secureChannelId);
                SecureChannelTcp.this.close();
                return;
            }
            try {
                logger.debug("{}: Error recovery reconnect", (Object)SecureChannelTcp.this.secureChannelId);
                SecureChannelTcp.this.getTransportChannel().open();
                SecureChannelTcp.this.createSecureChannel(true);
                SecureChannelTcp.this.setErrorRecoveryState(false);
                SecureChannelTcp.this.executor.execute(SecureChannelTcp.this.sendPendingMessagesRunnable);
            }
            catch (ServiceResultException serviceResultException) {
                if (serviceResultException.getStatusCode().isStatusCode(StatusCodes.Bad_TcpSecureChannelUnknown) || serviceResultException.getStatusCode().isStatusCode(StatusCodes.Bad_SecureChannelTokenUnknown) || serviceResultException.getStatusCode().isStatusCode(StatusCodes.Bad_NotFound)) {
                    logger.info(SecureChannelTcp.this.secureChannelId + ": The secure channel has been closed by the server", (Throwable)serviceResultException);
                    SecureChannelTcp.this.close();
                    return;
                }
                Object object2 = SecureChannelTcp.this.errorRecoveryLock;
                synchronized (object2) {
                    ++SecureChannelTcp.this.errorRecoveryReconnectIndex;
                    long l = System.currentTimeMillis();
                    long l2 = SecureChannelTcp.this.errorRecoveryReconnectIndex >= RECONNECT_WAIT_TIME.length ? (long)(RECONNECT_WAIT_TIME[RECONNECT_WAIT_TIME.length - 1] * 1000) : (long)(RECONNECT_WAIT_TIME[SecureChannelTcp.this.errorRecoveryReconnectIndex] * 1000);
                    long l3 = (long)((double)SecureChannelTcp.this.tokenLifetime * 1.25) + SecureChannelTcp.this.tokenIssueTime;
                    if (l + l2 > l3) {
                        logger.info("{}: Error recovery failed, security token has expired", (Object)SecureChannelTcp.this.secureChannelId);
                        SecureChannelTcp.this.close();
                        return;
                    }
                    SecureChannelTcp.this.errorRecoveryReconnectTimer = TimerUtil.schedule(SecureChannelTcp.this.timer, SecureChannelTcp.this.reconnectRunnable, SecureChannelTcp.this.executor, l + l2);
                }
            }
        }
    };
    private Runnable renewSecurityTokenRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                logger.debug("{} Renewing security token", (Object)SecureChannelTcp.this.secureChannelId);
                SecureChannelTcp.this.createSecureChannel(true);
            }
            catch (ServiceResultException serviceResultException) {
                logger.error(SecureChannelTcp.this.secureChannelId + " Failed to renew security token. ", (Throwable)serviceResultException);
            }
        }
    };

    @Override
    public void initialize(TransportChannelSettings transportChannelSettings, EncoderContext encoderContext) throws ServiceResultException {
        this.initialize(transportChannelSettings.getDescription().getEndpointUrl(), transportChannelSettings, encoderContext);
    }

    @Override
    public void initialize(String string, TransportChannelSettings transportChannelSettings, EncoderContext encoderContext) throws ServiceResultException {
        logger.debug("initialize: url={}", (Object)string);
        if (logger.isTraceEnabled()) {
            logger.trace("initialize: settings={}", (Object)ObjectUtils.printFields(transportChannelSettings));
        }
        InetSocketAddress inetSocketAddress = UriUtil.getSocketAddress(string);
        this.initialize(inetSocketAddress, transportChannelSettings, encoderContext);
    }

    public void initialize(InetSocketAddress inetSocketAddress, TransportChannelSettings transportChannelSettings, EncoderContext encoderContext) throws ServiceResultException {
        if (this.secureChannelId != -1) {
            throw new ServiceResultException(StatusCodes.Bad_InternalError, "Cannot reconfigure already opened secure channel");
        }
        this.settings = transportChannelSettings.clone();
        this.addr = inetSocketAddress;
        this.ctx = encoderContext;
        this.errorRecoveryReconnectTimer = null;
        this.errorRecoveryReconnectIndex = 0;
        this.timer = TimerUtil.getTimer();
        String string = transportChannelSettings.getDescription().getEndpointUrl();
        if (string != null && !string.isEmpty() && !"opc.tcp".equals(UriUtil.getTransportProtocol(string))) {
            throw new ServiceResultException(StatusCodes.Bad_ServerUriInvalid, "The protocol is not supported by the this SecureChannelTcp");
        }
        this.setTransportChannel(new TcpConnection());
        this.getTransportChannel().initialize(inetSocketAddress, transportChannelSettings, encoderContext);
        this.getTransportChannel().addConnectionListener(this);
        this.getTransportChannel().addMessageListener(this);
    }

    protected long getRequestTimeout(ServiceRequest serviceRequest) {
        UnsignedInteger unsignedInteger = serviceRequest.getRequestHeader() != null ? serviceRequest.getRequestHeader().getTimeoutHint() : null;
        long l = unsignedInteger != null ? unsignedInteger.longValue() : (long)this.getOperationTimeout();
        return l;
    }

    @Override
    public ServiceResponse serviceRequest(ServiceRequest serviceRequest) throws ServiceFaultException, ServiceResultException {
        long l = this.getRequestTimeout(serviceRequest);
        return this.serviceRequest(serviceRequest, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceResponse serviceRequest(ServiceRequest serviceRequest, long l) throws ServiceFaultException, ServiceResultException {
        int n = 0;
        while (!this.isOpen()) {
            try {
                if (n++ > 100) {
                    throw new ServiceResultException(StatusCodes.Bad_SecureChannelClosed);
                }
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        PendingRequest pendingRequest = this.newPendingRequest(l);
        pendingRequest.result = new AsyncResultImpl();
        this.requests.put(pendingRequest.requestId, pendingRequest);
        logger.debug("serviceRequest: requests.size={}", (Object)this.requests.size());
        try {
            Object object;
            try {
                object = this.getTransportChannel();
                if (object != null) {
                    object.sendRequest(serviceRequest, this.secureChannelId, pendingRequest.requestId);
                }
                logger.debug("serviceRequest: Message sent, requestId={} secureChannelId={}", (Object)pendingRequest.requestId, (Object)this.secureChannelId);
                logger.trace("serviceRequest: message={}", (Object)serviceRequest);
            }
            catch (ServiceResultException serviceResultException) {
                if (logger.isDebugEnabled()) {
                    logger.debug("serviceRequest: While sending requestId=" + pendingRequest.requestId + ", secureChannelId=" + this.secureChannelId + ", message=" + serviceRequest, (Throwable)serviceResultException);
                }
                if (serviceResultException.getStatusCode().isStatusCode(StatusCodes.Bad_CommunicationError)) {
                    pendingRequest.requestToBeSent = serviceRequest;
                    this.executor.execute(this.sendPendingMessagesRunnable);
                }
                throw serviceResultException;
            }
            if (serviceRequest instanceof CloseSecureChannelRequest) {
                object = null;
                return object;
            }
            if (l == 0L) {
                object = pendingRequest.result.waitForResult();
            } else {
                long l2 = pendingRequest.timeoutTime - System.currentTimeMillis();
                object = pendingRequest.result.waitForResult(l2, TimeUnit.MILLISECONDS);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Response: {}", object);
            } else {
                logger.debug("Response: {}", (Object)object.getClass().getSimpleName());
            }
            ResponseHeader responseHeader = object.getResponseHeader();
            StatusCode statusCode = responseHeader.getServiceResult();
            if (statusCode.isBad()) {
                logger.debug("BAD response: {}", (Object)statusCode);
                throw new ServiceFaultException(new ServiceFault(responseHeader));
            }
            Object object2 = object;
            return object2;
        }
        finally {
            this.requests.remove(pendingRequest.requestId);
        }
    }

    private PendingRequest newPendingRequest(long l) {
        PendingRequest pendingRequest = new PendingRequest();
        pendingRequest.requestId = this.requestIdCounter.incrementAndGet();
        pendingRequest.startTime = System.currentTimeMillis();
        pendingRequest.timeoutTime = l == 0L ? Long.MAX_VALUE : (long)((double)pendingRequest.startTime + (double)l * 1.1);
        return pendingRequest;
    }

    @Override
    public AsyncResult<ServiceResponse> serviceRequestAsync(ServiceRequest serviceRequest) {
        long l = this.getRequestTimeout(serviceRequest);
        return this.serviceRequestAsync(serviceRequest, l);
    }

    @Override
    public AsyncResult<ServiceResponse> serviceRequestAsync(ServiceRequest serviceRequest, long l) {
        AsyncResultImpl<ServiceResponse> asyncResultImpl = new AsyncResultImpl<ServiceResponse>();
        if (!this.isOpen()) {
            asyncResultImpl.setError(new ServiceResultException(StatusCodes.Bad_SecureChannelClosed));
            return asyncResultImpl;
        }
        PendingRequest pendingRequest = this.newPendingRequest(l);
        pendingRequest.result = asyncResultImpl;
        pendingRequest.requestToBeSent = serviceRequest;
        this.requests.put(pendingRequest.requestId, pendingRequest);
        logger.debug("serviceRequestAsync: requests.size={}", (Object)this.requests.size());
        if (l != 0L) {
            this.scheduleTimeoutRequestsTimer();
        }
        this.executor.execute(this.sendPendingMessagesRunnable);
        return asyncResultImpl;
    }

    private void scheduleTimeoutRequestsTimer() {
        PendingRequest pendingRequest = this.getNextTimeoutingPendingRequest();
        if (pendingRequest == null) {
            this.cancelTimeoutPendingRequestTask();
        } else {
            TimerTask timerTask = this.timeoutPendingRequestsTask.get();
            if (timerTask == null || timerTask.scheduledExecutionTime() > pendingRequest.timeoutTime) {
                this.cancelTimeoutPendingRequestTask();
                timerTask = TimerUtil.schedule(this.timer, this.timeoutRun, this.executor, pendingRequest.timeoutTime);
                if (!this.timeoutPendingRequestsTask.compareAndSet(null, timerTask)) {
                    timerTask.cancel();
                }
            }
        }
    }

    private PendingRequest getNextTimeoutingPendingRequest() {
        long l = Long.MAX_VALUE;
        PendingRequest pendingRequest = null;
        logger.debug("getNextTimeoutingPendingRequest: requests.size={}", (Object)this.requests.size());
        for (PendingRequest pendingRequest2 : this.requests.values()) {
            if (l <= pendingRequest2.timeoutTime) continue;
            l = pendingRequest2.timeoutTime;
            pendingRequest = pendingRequest2;
            break;
        }
        return pendingRequest;
    }

    @Override
    public void open() throws ServiceResultException {
        logger.debug("open");
        if (this.secureChannelId == -1) {
            try {
                this.getTransportChannel().open();
            }
            catch (ServiceResultException serviceResultException) {
                logger.warn("Connection failed: {}", (Object)serviceResultException.getMessage());
                if (serviceResultException.getStatusCode().getValue().equals(StatusCodes.Bad_CommunicationError)) {
                    logger.warn("Bad_CommunicationError: Retrying");
                    this.getTransportChannel().open();
                }
                throw serviceResultException;
            }
            this.createSecureChannel(false);
        }
    }

    @Override
    public AsyncResult<SecureChannel> openAsync() {
        final AsyncResultImpl<SecureChannel> asyncResultImpl = new AsyncResultImpl<SecureChannel>();
        if (this.secureChannelId != -1) {
            asyncResultImpl.setResult(this);
            return asyncResultImpl;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    SecureChannelTcp.this.open();
                    asyncResultImpl.setResult(SecureChannelTcp.this);
                }
                catch (ServiceResultException serviceResultException) {
                    asyncResultImpl.setError(serviceResultException);
                }
            }
        });
        return asyncResultImpl;
    }

    private void createSecureChannel(boolean bl) throws ServiceResultException {
        IConnection iConnection = this.getTransportChannel();
        logger.debug("createSecureChannel: renew={} channel={}", (Object)bl, (Object)iConnection);
        if (iConnection == null) {
            throw new ServiceResultException(StatusCodes.Bad_SecureChannelClosed);
        }
        long l = System.currentTimeMillis();
        int n = this.requestIdCounter.incrementAndGet();
        logger.debug("createSecureChannel: requestId={}", (Object)n);
        OpenSecureChannelRequest openSecureChannelRequest = new OpenSecureChannelRequest();
        SecurityPolicy securityPolicy = SecurityPolicy.getSecurityPolicy(this.settings.getDescription().getSecurityPolicyUri());
        SecurityAlgorithm securityAlgorithm = securityPolicy.getSymmetricEncryptionAlgorithm();
        byte[] byArray = CryptoUtil.createNonce(securityAlgorithm);
        Integer n2 = this.settings.getConfiguration().getSecurityTokenLifetime();
        if (n2 == null) {
            n2 = 3600000;
        }
        logger.debug("tokenLifetime: {}", (Object)n2);
        openSecureChannelRequest.setClientNonce(byArray);
        openSecureChannelRequest.setClientProtocolVersion(UnsignedInteger.valueOf(0L));
        openSecureChannelRequest.setRequestedLifetime(UnsignedInteger.valueOf(n2.intValue()));
        openSecureChannelRequest.setRequestType(bl ? SecurityTokenRequestType.Renew : SecurityTokenRequestType.Issue);
        openSecureChannelRequest.setSecurityMode(this.settings.getDescription().getSecurityMode());
        int n3 = bl ? this.secureChannelId : 0;
        final Semaphore semaphore = new Semaphore(0);
        final ServiceResultException[] serviceResultExceptionArray = new ServiceResultException[1];
        final IEncodeable[] iEncodeableArray = new IEncodeable[1];
        final int[] nArray = new int[1];
        final int n4 = n;
        IConnection.IMessageListener iMessageListener = new IConnection.IMessageListener(){

            @Override
            public void onMessage(int n, int n2, IEncodeable iEncodeable) {
                if (n != n4) {
                    return;
                }
                iEncodeableArray[0] = iEncodeable;
                nArray[0] = n2;
                semaphore.release(Integer.MAX_VALUE);
            }
        };
        IConnectionListener iConnectionListener = new IConnectionListener(){

            @Override
            public void onClosed(ServiceResultException serviceResultException) {
                if (serviceResultException == null) {
                    serviceResultException = new ServiceResultException(StatusCodes.Bad_CommunicationError, "Connection Closed");
                }
                serviceResultExceptionArray[0] = serviceResultException;
                semaphore.release(Integer.MAX_VALUE);
            }

            @Override
            public void onOpen() {
            }
        };
        iConnection.addConnectionListener(iConnectionListener);
        iConnection.addMessageListener(iMessageListener);
        try {
            iConnection.sendRequest(openSecureChannelRequest, n3, n);
            try {
                long l2 = this.getOperationTimeout();
                if (l2 > 0L) {
                    long l3 = (System.currentTimeMillis() - l) / 1000L;
                    long l4 = l2 - l3;
                    semaphore.tryAcquire(1, l4, TimeUnit.MILLISECONDS);
                } else {
                    semaphore.acquire();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (serviceResultExceptionArray[0] != null) {
                throw serviceResultExceptionArray[0];
            }
            IEncodeable iEncodeable = iEncodeableArray[0];
            if (iEncodeable == null) {
                throw new ServiceResultException(StatusCodes.Bad_Timeout);
            }
            if (iEncodeable instanceof ServiceFault) {
                ServiceFaultException serviceFaultException = new ServiceFaultException((ServiceFault)iEncodeable);
                logger.error(nArray + ": CreateSecureChannel Fault", (Throwable)serviceFaultException);
                throw serviceFaultException;
            }
            if (!(iEncodeable instanceof OpenSecureChannelResponse)) {
                throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "Unexpected result " + iEncodeable.getClass().getName() + " OpenSecureChannelResponse expected");
            }
            OpenSecureChannelResponse openSecureChannelResponse = (OpenSecureChannelResponse)iEncodeable;
            ChannelSecurityToken channelSecurityToken = openSecureChannelResponse.getSecurityToken();
            this.secureChannelId = channelSecurityToken.getChannelId().intValue();
            if (bl) {
                logger.debug("{} Secure channel renewed, SecureChannelId={}, TokenId={}", new Object[]{this.secureChannelId, this.secureChannelId, channelSecurityToken.getTokenId().longValue()});
            } else {
                logger.debug("{} Secure channel opened, SecureChannelId={}, TokenId={}", new Object[]{this.secureChannelId, this.secureChannelId, channelSecurityToken.getTokenId().longValue()});
            }
            if (bl) {
                this.secureChannelId = n3;
            }
            long l5 = System.currentTimeMillis();
            this.tokenIssueTime = l / 2L + l5 / 2L;
            this.tokenLifetime = channelSecurityToken.getRevisedLifetime().longValue();
            TimerTask timerTask = this.renewSecurityTokenTask;
            this.renewSecurityTokenTask = null;
            if (timerTask != null) {
                timerTask.cancel();
            }
            long l6 = channelSecurityToken.getRevisedLifetime().longValue();
            logger.debug("RevisedLifetime: {}", (Object)l6);
            this.renewSecurityTokenTask = TimerUtil.schedule(this.timer, this.renewSecurityTokenRunnable, this.executor, l5 + (long)((double)l6 * 0.75));
        }
        catch (ServiceResultException serviceResultException) {
            throw serviceResultException;
        }
        finally {
            iConnection.removeConnectionListener(iConnectionListener);
            iConnection.removeMessageListener(iMessageListener);
        }
    }

    private void sendPendingRequestMessages() throws ServiceResultException {
        if (!this.isOpen()) {
            return;
        }
        PendingRequest pendingRequest = null;
        while ((pendingRequest = this.getNextUnsentRequest()) != null) {
            IEncodeable iEncodeable = pendingRequest.requestToBeSent;
            pendingRequest.requestToBeSent = null;
            long l = System.currentTimeMillis();
            long l2 = l - pendingRequest.startTime;
            if (l > pendingRequest.timeoutTime) {
                logger.debug("Request id={} timeouted {}ms elapsed. timeout at {} ms", new Object[]{pendingRequest.requestId, l2, pendingRequest.timeoutTime - pendingRequest.startTime});
                this.requests.remove(pendingRequest.requestId);
                pendingRequest.result.setError(new ServiceResultException(StatusCodes.Bad_Timeout));
                continue;
            }
            if (iEncodeable == null) continue;
            try {
                logger.debug("sendPendingRequestMessages: requestId={}", (Object)pendingRequest.requestId);
                IConnection iConnection = this.getTransportChannel();
                if (iConnection == null) continue;
                iConnection.sendRequest((ServiceRequest)iEncodeable, this.secureChannelId, pendingRequest.requestId);
            }
            catch (EncodingException encodingException) {
                this.requests.remove(pendingRequest.requestId);
                pendingRequest.result.setError(encodingException);
            }
            catch (ServiceResultException serviceResultException) {
                StatusCode statusCode = serviceResultException.getStatusCode();
                if (statusCode.isStatusCode(StatusCodes.Bad_CommunicationError)) {
                    pendingRequest.requestToBeSent = iEncodeable;
                    continue;
                }
                pendingRequest.result.setError(serviceResultException);
            }
        }
    }

    private PendingRequest getNextUnsentRequest() {
        for (PendingRequest pendingRequest : this.requests.values()) {
            if (pendingRequest.requestToBeSent == null) continue;
            return pendingRequest;
        }
        return null;
    }

    @Override
    public void close() {
        Object object;
        this.setErrorRecoveryState(false);
        Object object2 = this.renewSecurityTokenTask;
        this.renewSecurityTokenTask = null;
        if (object2 != null) {
            ((TimerTask)object2).cancel();
        }
        if ((object2 = this.getTransportChannel()) != null) {
            object = new CloseSecureChannelRequest();
            try {
                this.serviceRequest((ServiceRequest)object);
            }
            catch (ServiceResultException serviceResultException) {
                // empty catch block
            }
            if (this.secureChannelId != -1) {
                logger.info("{} Closed", (Object)this.secureChannelId);
            }
            this.secureChannelId = -1;
            object2.close();
            object2.removeMessageListener(this);
            object2.removeConnectionListener(this);
            object2.dispose();
            this.setTransportChannel(null);
        }
        this.cancelTimeoutPendingRequestTask();
        object = new ArrayList<PendingRequest>(this.requests.values());
        logger.debug("requests.clear()");
        this.requests.clear();
        if (!object.isEmpty()) {
            ServiceResultException serviceResultException = new ServiceResultException(StatusCodes.Bad_SecureChannelClosed);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                PendingRequest pendingRequest = (PendingRequest)iterator.next();
                pendingRequest.result.setError(serviceResultException);
            }
        }
    }

    private void cancelTimeoutPendingRequestTask() {
        TimerTask timerTask = this.timeoutPendingRequestsTask.getAndSet(null);
        if (timerTask != null) {
            timerTask.cancel();
        }
    }

    IConnection getTransportChannel() {
        return this.transportChannel.get();
    }

    protected void setTransportChannel(IConnection iConnection) {
        this.transportChannel.set(iConnection);
    }

    @Override
    public AsyncResult<SecureChannel> closeAsync() {
        final AsyncResultImpl<SecureChannel> asyncResultImpl = new AsyncResultImpl<SecureChannel>();
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    SecureChannelTcp.this.close();
                }
                finally {
                    asyncResultImpl.setResult(SecureChannelTcp.this);
                }
            }
        });
        return asyncResultImpl;
    }

    @Override
    public void dispose() {
        this.close();
        this.transportChannel = null;
        this.serializer = null;
        this.settings = null;
        this.addr = null;
        this.requests = null;
        this.timer = null;
    }

    @Override
    public EndpointConfiguration getEndpointConfiguration() {
        if (this.settings == null) {
            return null;
        }
        return this.settings.getConfiguration();
    }

    @Override
    public EndpointDescription getEndpointDescription() {
        if (this.settings == null) {
            return null;
        }
        return this.settings.getDescription();
    }

    @Override
    public EncoderContext getMessageContext() {
        return this.ctx;
    }

    @Override
    public void setOperationTimeout(int n) {
        this.settings.getConfiguration().setOperationTimeout(n);
    }

    @Override
    public int getOperationTimeout() {
        Integer n = this.settings.getConfiguration().getOperationTimeout();
        return n == null ? 0 : n;
    }

    @Override
    public int getSecureChannelId() {
        return this.secureChannelId;
    }

    @Override
    public void onMessage(int n, int n2, IEncodeable iEncodeable) {
        if (n2 != this.secureChannelId) {
            return;
        }
        PendingRequest pendingRequest = this.requests.remove(n);
        if (pendingRequest == null) {
            if (!(iEncodeable instanceof OpenSecureChannelResponse)) {
                ServiceFault serviceFault;
                ServiceFault serviceFault2 = serviceFault = iEncodeable instanceof ServiceFault ? (ServiceFault)iEncodeable : null;
                if (serviceFault != null && serviceFault.getResponseHeader().getServiceResult().equals(StatusCodes.Bad_TooManyPublishRequests)) {
                    logger.info("ServiceFault={}", (Object)serviceFault);
                } else {
                    logger.warn("{} Unidentified message, RequestId={}, type={}!", new Object[]{n2, n, iEncodeable.getClass().getSimpleName()});
                    if (serviceFault != null) {
                        logger.warn("ServiceFault={}", (Object)serviceFault);
                    }
                }
            }
            return;
        }
        if (iEncodeable instanceof ServiceFault) {
            pendingRequest.result.setError(new ServiceFaultException((ServiceFault)iEncodeable));
        } else {
            try {
                pendingRequest.result.setResult((ServiceResponse)iEncodeable);
            }
            catch (ClassCastException classCastException) {
                logger.error("onMessage: Cannot set result", (Throwable)classCastException);
            }
        }
    }

    @Override
    public boolean isOpen() {
        if (this.secureChannelId == -1) {
            return false;
        }
        long l = (long)((double)this.tokenLifetime * 1.25) + this.tokenIssueTime;
        long l2 = System.currentTimeMillis();
        return l > l2;
    }

    @Override
    public void onClosed(ServiceResultException serviceResultException) {
        StatusCode statusCode;
        if (this.secureChannelId == -1) {
            return;
        }
        StatusCode statusCode2 = statusCode = serviceResultException == null ? null : serviceResultException.getStatusCode();
        if (statusCode != null && statusCode.isStatusCode(StatusCodes.Bad_ConnectionClosed)) {
            this.setErrorRecoveryState(true);
        } else {
            if (serviceResultException == null) {
                serviceResultException = new ServiceResultException(StatusCodes.Bad_UnexpectedError);
            }
            while (!this.requests.isEmpty()) {
                ArrayList<PendingRequest> arrayList = new ArrayList<PendingRequest>(this.requests.values());
                for (PendingRequest pendingRequest : arrayList) {
                    pendingRequest.result.setError(serviceResultException);
                }
                this.requests.values().removeAll(arrayList);
            }
            this.setErrorRecoveryState(false);
        }
        if (statusCode != null && statusCode.isStatusCode(StatusCodes.Bad_ConnectionClosed)) {
            this.setErrorRecoveryState(true);
        }
        boolean bl = serviceResultException.getStatusCode().isStatusCode(StatusCodes.Bad_ConnectionClosed);
        this.setErrorRecoveryState(bl);
    }

    @Override
    public void onOpen() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setErrorRecoveryState(boolean bl) {
        Object object = this.errorRecoveryLock;
        synchronized (object) {
            if (this.errorRecoveryState == bl) {
                return;
            }
            if (bl) {
                logger.info("{}: Error recovery = true", (Object)this.secureChannelId);
                this.errorRecoveryState = true;
                this.errorRecoveryReconnectIndex = 0;
                long l = System.currentTimeMillis();
                this.errorRecoveryReconnectTimer = TimerUtil.schedule(this.timer, this.reconnectRunnable, this.executor, l + (long)RECONNECT_WAIT_TIME[0]);
            } else {
                logger.info("{}: Error recovery = false", (Object)this.secureChannelId);
                this.errorRecoveryState = false;
                this.errorRecoveryReconnectIndex = 0;
                this.errorRecoveryReconnectTimer.cancel();
                this.errorRecoveryReconnectTimer = null;
            }
        }
    }

    @Override
    public EnumSet<ITransportChannel.TransportChannelFeature> getSupportedFeatures() {
        return EnumSet.of(ITransportChannel.TransportChannelFeature.open, new ITransportChannel.TransportChannelFeature[]{ITransportChannel.TransportChannelFeature.openAsync, ITransportChannel.TransportChannelFeature.close, ITransportChannel.TransportChannelFeature.closeAync, ITransportChannel.TransportChannelFeature.sendRequest, ITransportChannel.TransportChannelFeature.sendRequestAsync});
    }

    @Override
    public String getConnectURL() {
        return this.getEndpointDescription().getEndpointUrl();
    }

    @Override
    public ServerConnection getConnection() {
        return null;
    }

    @Override
    public MessageSecurityMode getMessageSecurityMode() {
        return this.getEndpointDescription().getSecurityMode();
    }

    @Override
    public SecurityPolicy getSecurityPolicy() {
        try {
            return SecurityPolicy.getSecurityPolicy(this.getEndpointDescription().getSecurityPolicyUri());
        }
        catch (ServiceResultException serviceResultException) {
            return null;
        }
    }

    public String toString() {
        return "SecureChannel " + this.secureChannelId + " " + (this.isOpen() ? "open" : "closed");
    }

    static class PendingRequest {
        long startTime = System.currentTimeMillis();
        long timeoutTime;
        int requestId;
        AsyncResultImpl<ServiceResponse> result;
        IEncodeable requestToBeSent;

        PendingRequest() {
        }
    }
}

