/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.tcp.io;

import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.EnumSet;
import org.opcfoundation.ua.transport.security.Cert;
import org.opcfoundation.ua.transport.security.CertificateValidator;
import org.opcfoundation.ua.transport.security.PrivKey;

public class OpcTcpSettings {
    PrivKey privKey;
    Cert clientCertificate;
    CertificateValidator certificateValidator;
    EnumSet<Flag> flags = EnumSet.noneOf(Flag.class);

    public Cert getClientCertificate() {
        return this.clientCertificate;
    }

    public void setClientCertificate(X509Certificate x509Certificate) throws CertificateEncodingException {
        this.clientCertificate = new Cert(x509Certificate);
    }

    public CertificateValidator getCertificateValidator() {
        return this.certificateValidator;
    }

    public void setCertificateValidator(CertificateValidator certificateValidator) {
        this.certificateValidator = certificateValidator;
    }

    public PrivKey getPrivKey() {
        return this.privKey;
    }

    public void setPrivKey(PrivKey privKey) {
        this.privKey = privKey;
    }

    public void setClientCertificate(Cert cert) {
        this.clientCertificate = cert;
    }

    public EnumSet<Flag> getFlags() {
        return this.flags;
    }

    public void setFlags(EnumSet<Flag> enumSet) {
        this.flags = enumSet;
    }

    public void readFrom(OpcTcpSettings opcTcpSettings) {
        if (opcTcpSettings.clientCertificate != null) {
            this.clientCertificate = opcTcpSettings.clientCertificate;
        }
        if (opcTcpSettings.certificateValidator != null) {
            this.certificateValidator = opcTcpSettings.certificateValidator;
        }
        if (opcTcpSettings.privKey != null) {
            this.privKey = opcTcpSettings.privKey;
        }
        this.flags = opcTcpSettings.flags;
    }

    public OpcTcpSettings clone() {
        OpcTcpSettings opcTcpSettings = new OpcTcpSettings();
        opcTcpSettings.setClientCertificate(this.clientCertificate);
        opcTcpSettings.setCertificateValidator(this.certificateValidator);
        opcTcpSettings.setPrivKey(this.privKey);
        opcTcpSettings.flags = this.flags.clone();
        return opcTcpSettings;
    }

    public static enum Flag {
        MultiThread;

    }
}

