/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.tcp.impl;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.util.GregorianCalendar;
import javax.crypto.Mac;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.MessageSecurityMode;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.transport.security.SecurityConfiguration;
import org.opcfoundation.ua.transport.security.SecurityPolicy;
import org.opcfoundation.ua.utils.CryptoUtil;

public class SecurityToken {
    private static final Charset UTF8 = Charset.forName("utf-8");
    private SecurityConfiguration securityConfiguration;
    private int tokenId;
    private int secureChannelId;
    private long creationTime;
    private long lifetime;
    private byte[] localNonce;
    private byte[] remoteNonce;
    private byte[] localSigningKey;
    private byte[] localEncryptingKey;
    private byte[] localInitializationVector;
    private byte[] remoteSigningKey;
    private byte[] remoteEncryptingKey;
    private byte[] remoteInitializationVector;

    public SecurityToken(SecurityConfiguration securityConfiguration, int n, int n2, long l, long l2, byte[] byArray, byte[] byArray2) throws ServiceResultException {
        if (securityConfiguration == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.secureChannelId = n;
        this.securityConfiguration = securityConfiguration;
        this.tokenId = n2;
        this.lifetime = l2;
        this.creationTime = l;
        this.localNonce = byArray;
        this.remoteNonce = byArray2;
        boolean bl = securityConfiguration.getMessageSecurityMode() == MessageSecurityMode.None;
        int n3 = this.getSecurityPolicy().getSignatureKeySize();
        int n4 = this.getSecurityPolicy().getEncryptionKeySize();
        int n5 = this.getSecurityPolicy().getEncryptionBlockSize();
        this.localSigningKey = bl ? null : this.PSHA(this.getRemoteNonce(), null, this.getLocalNonce(), 0, n3);
        this.localEncryptingKey = bl ? null : this.PSHA(this.getRemoteNonce(), null, this.getLocalNonce(), n3, n4);
        this.localInitializationVector = bl ? null : this.PSHA(this.getRemoteNonce(), null, this.getLocalNonce(), n3 + n4, n5);
        this.remoteSigningKey = bl ? null : this.PSHA(this.getLocalNonce(), null, this.getRemoteNonce(), 0, n3);
        this.remoteEncryptingKey = bl ? null : this.PSHA(this.getLocalNonce(), null, this.getRemoteNonce(), n3, n4);
        this.remoteInitializationVector = bl ? null : this.PSHA(this.getLocalNonce(), null, this.getRemoteNonce(), n3 + n4, n5);
    }

    private byte[] PSHA(byte[] byArray, String string, byte[] byArray2, int n, int n2) throws ServiceResultException {
        Object object;
        byte[] byArray3;
        if (byArray == null) {
            throw new IllegalArgumentException("ArgumentNullException: secret");
        }
        if (n < 0) {
            throw new IllegalArgumentException("ArgumentOutOfRangeException: offset");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("ArgumentOutOfRangeException: offset");
        }
        byte[] byArray4 = byArray3 = string != null && !string.isEmpty() ? string.getBytes(UTF8) : null;
        if (byArray2 != null && byArray2.length > 0) {
            if (byArray3 != null) {
                object = ByteBuffer.allocate(byArray3.length + byArray2.length);
                ((ByteBuffer)object).put(byArray3);
                ((ByteBuffer)object).put(byArray2);
                ((ByteBuffer)object).rewind();
                byArray3 = ((ByteBuffer)object).array();
            } else {
                byArray3 = byArray2;
            }
        }
        if (byArray3 == null) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "The PSHA algorithm requires a non-null seed.");
        }
        object = this.securityConfiguration.getSecurityPolicy();
        Mac mac = CryptoUtil.createMac(((SecurityPolicy)object).getKeyDerivationAlgorithm(), byArray);
        mac.update(byArray3);
        byte[] byArray5 = mac.doFinal();
        byte[] byArray6 = new byte[mac.getMacLength() + byArray3.length];
        System.arraycopy(byArray5, 0, byArray6, 0, byArray5.length);
        System.arraycopy(byArray3, 0, byArray6, byArray5.length, byArray3.length);
        byte[] byArray7 = new byte[n2];
        int n3 = 0;
        do {
            mac.update(byArray6);
            byte[] byArray8 = mac.doFinal();
            if (n < byArray8.length) {
                for (int i = n; n3 < n2 && i < byArray8.length; ++i) {
                    byArray7[n3++] = byArray8[i];
                }
            }
            n = n > byArray8.length ? (n -= byArray8.length) : 0;
            mac.update(byArray5);
            byArray5 = mac.doFinal();
            System.arraycopy(byArray5, 0, byArray6, 0, byArray5.length);
        } while (n3 < n2);
        return byArray7;
    }

    public boolean isValid() {
        return System.currentTimeMillis() < this.creationTime + this.lifetime + this.lifetime / 4L;
    }

    public boolean isTimeToRenew() {
        return this.creationTime + this.lifetime * 3L / 4L < System.currentTimeMillis();
    }

    public boolean isExpired() {
        return System.currentTimeMillis() >= this.creationTime + this.lifetime;
    }

    public SecurityPolicy getSecurityPolicy() {
        return this.securityConfiguration.getSecurityPolicy();
    }

    public SecurityConfiguration getSecurityConfiguration() {
        return this.securityConfiguration;
    }

    public MessageSecurityMode getMessageSecurityMode() {
        return this.securityConfiguration.getMessageSecurityMode();
    }

    public byte[] getLocalSigningKey() {
        return this.localSigningKey;
    }

    public void setLocalSigningKey(byte[] byArray) {
        this.localSigningKey = byArray;
    }

    public byte[] getLocalEncryptingKey() {
        return this.localEncryptingKey;
    }

    public void setLocalEncryptingKey(byte[] byArray) {
        this.localEncryptingKey = byArray;
    }

    public byte[] getLocalInitializationVector() {
        return this.localInitializationVector;
    }

    public void setLocalInitializationVector(byte[] byArray) {
        this.localInitializationVector = byArray;
    }

    public byte[] getRemoteSigningKey() {
        return this.remoteSigningKey;
    }

    public void setRemoteSigningKey(byte[] byArray) {
        this.remoteSigningKey = byArray;
    }

    public byte[] getRemoteEncryptingKey() {
        return this.remoteEncryptingKey;
    }

    public void setRemoteEncryptingKey(byte[] byArray) {
        this.remoteEncryptingKey = byArray;
    }

    public byte[] getRemoteInitializationVector() {
        return this.remoteInitializationVector;
    }

    public void setRemoteInitializationVector(byte[] byArray) {
        this.remoteInitializationVector = byArray;
    }

    public Mac createRemoteHmac() throws ServiceResultException {
        return this.createHmac(this.getRemoteSigningKey());
    }

    public Mac createLocalHmac() throws ServiceResultException {
        return this.createHmac(this.getLocalSigningKey());
    }

    protected Mac createHmac(byte[] byArray) throws ServiceResultException {
        SecurityPolicy securityPolicy = this.securityConfiguration.getSecurityPolicy();
        return CryptoUtil.createMac(securityPolicy.getSymmetricSignatureAlgorithm(), byArray);
    }

    public byte[] getLocalNonce() {
        return this.localNonce;
    }

    public byte[] getRemoteNonce() {
        return this.remoteNonce;
    }

    public int getSecureChannelId() {
        return this.secureChannelId;
    }

    public int getTokenId() {
        return this.tokenId;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getLifeTime() {
        return this.lifetime;
    }

    public long getRenewTime() {
        return this.creationTime + this.lifetime * 3L / 4L;
    }

    public String toString() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(this.creationTime);
        return "SecurityToken(Id=" + this.tokenId + ", secureChannelId=" + this.secureChannelId + ", creationTime=" + DateFormat.getDateTimeInstance().format(gregorianCalendar.getTime()) + ", lifetime=" + this.lifetime + ")";
    }
}

