/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.tcp.impl;

import java.nio.ByteBuffer;
import org.opcfoundation.ua.common.RuntimeServiceResultException;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.MessageSecurityMode;
import org.opcfoundation.ua.transport.security.SecurityPolicy;
import org.opcfoundation.ua.transport.tcp.impl.SecurityToken;
import org.opcfoundation.ua.utils.CryptoUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkSymmEncryptSigner
implements Runnable {
    static Logger logger = LoggerFactory.getLogger(ChunkSymmEncryptSigner.class);
    ByteBuffer chunk;
    ByteBuffer body;
    SecurityToken token;

    public ChunkSymmEncryptSigner(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, SecurityToken securityToken) {
        this.chunk = byteBuffer;
        this.body = byteBuffer2;
        this.token = securityToken;
    }

    @Override
    public void run() throws RuntimeServiceResultException {
        SecurityPolicy securityPolicy = this.token.getSecurityPolicy();
        MessageSecurityMode messageSecurityMode = this.token.getMessageSecurityMode();
        try {
            byte[] byArray;
            int n;
            int n2 = this.chunk.limit();
            int n3 = this.body.limit();
            int n4 = 8;
            int n5 = 8;
            int n6 = 8;
            int n7 = securityPolicy.getSymmetricSignatureSize();
            if (messageSecurityMode == MessageSecurityMode.Sign || messageSecurityMode == MessageSecurityMode.SignAndEncrypt) {
                n = n2 - n7;
                byArray = new byte[n7];
                this.sign(this.token, this.chunk.array(), n, byArray);
                this.chunk.position(n2 - n7);
                this.chunk.put(byArray, 0, n7);
                if (logger.isTraceEnabled()) {
                    logger.trace("signature={}", (Object)CryptoUtil.toHex(byArray));
                }
            }
            n = 0;
            if (messageSecurityMode == MessageSecurityMode.SignAndEncrypt) {
                this.chunk.position(n2 - n7 - 1);
                n = this.chunk.get() + 1;
            }
            this.chunk.position(4);
            this.chunk.putInt(n2);
            if (messageSecurityMode == MessageSecurityMode.SignAndEncrypt) {
                byArray = new byte[n4 + n3 + n + n7];
                this.chunk.position(n5 + n6);
                this.chunk.get(byArray);
                this.encrypt(this.token, byArray, 0, byArray.length, this.chunk.array(), n5 + n6);
            }
        }
        catch (ServiceResultException serviceResultException) {
            throw new RuntimeServiceResultException(serviceResultException);
        }
    }

    private int encrypt(SecurityToken securityToken, byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ServiceResultException {
        return CryptoUtil.getCryptoProvider().encryptSymm(securityToken, byArray, n, n2, byArray2, n3);
    }

    private void sign(SecurityToken securityToken, byte[] byArray, int n, byte[] byArray2) throws ServiceResultException {
        CryptoUtil.getCryptoProvider().signSymm(securityToken, byArray, n, byArray2);
    }
}

