/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.tcp.impl;

import java.nio.ByteBuffer;
import org.opcfoundation.ua.common.RuntimeServiceResultException;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.MessageSecurityMode;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.transport.security.SecurityPolicy;
import org.opcfoundation.ua.transport.tcp.impl.ChunkUtils;
import org.opcfoundation.ua.transport.tcp.impl.SecurityToken;
import org.opcfoundation.ua.utils.CryptoUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkSymmDecryptVerifier
implements Runnable {
    static Logger logger = LoggerFactory.getLogger(ChunkSymmDecryptVerifier.class);
    static final int sequenceHeaderSize = 8;
    static final int messageHeaderSize = 8;
    static final int securityHeaderSize = 8;
    static final int SymmetricHeaders = 16;
    ByteBuffer chunk;
    SecurityToken token;

    public ChunkSymmDecryptVerifier(ByteBuffer byteBuffer, SecurityToken securityToken) {
        this.chunk = byteBuffer;
        this.token = securityToken;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() throws RuntimeServiceResultException {
        SecurityPolicy securityPolicy = this.token.getSecurityPolicy();
        MessageSecurityMode messageSecurityMode = this.token.getMessageSecurityMode();
        int n = this.chunk.limit();
        try {
            int n2;
            int n3 = ChunkUtils.getTokenId(this.chunk);
            if (n3 != this.token.getTokenId()) {
                throw new ServiceResultException(StatusCodes.Bad_UnexpectedError);
            }
            if (messageSecurityMode == MessageSecurityMode.SignAndEncrypt) {
                this.chunk.position(16);
                byte[] byArray = new byte[this.chunk.limit() - 16];
                this.chunk.get(byArray, 0, byArray.length);
                n2 = this.decrypt(this.token, byArray, 0, byArray.length, this.chunk.array(), 16 + this.chunk.arrayOffset());
            } else {
                n2 = this.chunk.limit() - 16;
            }
            int n4 = 0;
            int n5 = securityPolicy.getSymmetricSignatureSize();
            if (messageSecurityMode == MessageSecurityMode.Sign || messageSecurityMode == MessageSecurityMode.SignAndEncrypt) {
                byte[] byArray = new byte[n5];
                this.chunk.position(n - n5);
                this.chunk.get(byArray);
                this.chunk.position(0);
                byte[] byArray2 = new byte[16 + n2 - n5];
                this.chunk.get(byArray2, 0, byArray2.length);
                this.verify(this.token, byArray2, byArray);
            }
            if (messageSecurityMode == MessageSecurityMode.SignAndEncrypt) {
                int n6 = 0;
                n6 = 16 + n2 - n5 - 1;
                n4 = this.chunk.get(n6);
                for (int i = n6 - n4; i < n6; ++i) {
                    if (this.chunk.get(i) == n4) continue;
                    logger.error("Padding does not match");
                    throw new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed, "Could not verify the padding in the message");
                }
                ++n4;
            }
            this.chunk.position(24);
            this.chunk.limit(this.chunk.position() + n2 - 8 - n4 - n5);
            int n7 = this.chunk.limit() - 8 - 8 - 8 - n5 - n4;
            if (n7 >= 0) return;
        }
        catch (ServiceResultException serviceResultException) {
            throw new RuntimeServiceResultException(serviceResultException);
        }
    }

    private int decrypt(SecurityToken securityToken, byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ServiceResultException {
        logger.debug("decrypt: dataToDecrypt.length={} inputOffset={} inputLength={} output.length={} outputOffset={}", new Object[]{byArray.length, n, n2, byArray2.length, n3});
        return CryptoUtil.getCryptoProvider().decryptSymm(securityToken, byArray, n, n2, byArray2, n3);
    }

    private void verify(SecurityToken securityToken, byte[] byArray, byte[] byArray2) throws ServiceResultException {
        CryptoUtil.getCryptoProvider().verifySymm(securityToken, byArray, byArray2);
    }
}

